unit CntTable;


{************************************}
{     TCountTable = class(TTable)    }
{         Giovanni Burzomato         }
{            Luigi Menghini          }
{     e-mail : lume@tn.village.it    }
{************************************}


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, Campi, Common,  DbiTypes, DbiProcs, DbiErrs;



type
  TCountTable = class(TTable)
  private
    FContaRecords : LongInt; { internal counter set to 0 at CreateTable }
    FAutoFieldName: string;  { name of the autoincreasing field         }
    FCurrCountStr : string;
    { FCurrCountStr save the current value of the autoincreasing field  }
    { if state is dsEdit to overwrite it at DoBeforeEdit.               }
    FMaxFileName  : string;  { name of the file counter TableName.MAX   }
    function BuildAutoFieldName : string;
    { BuildAutoFieldName build the name of the autoincresing field }
    function BuildMAXFileName : string;
    { BuildMAXFileName build FMaxFileName }
    Function ReadIncCounter : Boolean;
    { ReadIncCounter verify if exists the file TableName.MAX  }
  protected

    procedure DoBeforePost; override;
    procedure DoBeforeEdit; override;
    { if FAutoFieldName <> '' save the current value in FCurrCountStr }
  public
    Procedure CreateTable;
    Procedure Open; virtual;
  published


  end;

procedure Register;

implementation


procedure Register;
begin
  RegisterComponents('Data Access', [TCountTable]);
end;


function TCountTable.BuildAutoFieldName : string;
var SS : string;
   function GetFileName(FN : string) : string;
   begin
      FN := ExtractFileName(FN);
      if pos('.',FN) > 0 then GetFileName := Copy(FN,1,length(FN) - 4)
      else GetFileName := FN;
   end;
   { set anyway the upperCase }
   function UpString(S : string) : string;
   var c  : word;
   begin
      for c := 1 to length(S) do S[c] := UpCase(S[C]);
      UpString := S;
   end;
begin
   { get the file name without extesion from TableName }
   SS := GetFileName(TableName);
   SS := UpString(SS);
   if length(SS) > 5 then SS := Copy(SS,1,5);
   { add the suffix '_NO' }
   SS := SS + '_NO';
   BuildAutoFieldName := SS;
end;




Procedure TCountTable.CreateTable;
var
   c   : integer;
   FL  : file of LongInt;
   SFL : string;
begin
   TableType := ttDBase;
   { set the counter to 0 }
   FContaRecords := 0;
   { *** Create the file for the counter ***}
   { ---------------------------------------}
   if DataBaseName = '' then
     SFL := ChangeFileExt(TableName, '.MAX')
   else SFL := DataBaseName + '\' + ChangeFileExt(TableName, '.MAX');
   AssignFile(FL, SFL);
   Rewrite(FL);
   write(FL, FContaRecords);
   CloseFile(FL);
   { extracts the name from TableName }
   FAutoFieldName := BuildAutoFieldName;
   { add the counter field }
   FieldDefs.Add(FAutoFieldName, ftString, 10, TRUE);

   { create Lista (COMMON.PAS) }
   Lista := TList.Create;

   FieldEditor := TFieldEditor.Create(self);
   FieldEditor.ShowModal;

   { create the fields selected in CAMPI.PAS }
   for C := 0 to (Lista.Count - 1) do
   begin
      FieldRec := Lista.Items[C];
      with fieldRec do
      begin
         FieldDefs.Add(name, tipo, size, FALSE);
      end;
   end;

   inherited CreateTable;

   { set the index on FAutoFieldName }
   AddIndex(FAutoFieldName, FAutoFieldName, [ixUnique]);

   { search in Lista if there are objects with the attribute idx = true }
   { if any, add the index and then free the object.                    }

   for C := 0 to (Lista.Count - 1) do
   begin
      FieldRec := Lista.Items[C];
      with fieldRec do
      begin
         if Idx then AddIndex(Name, Name, [ixUnique]);
      end;
      FieldRec.Free;
   end;
   Lista.Free;

end;


{ build the name of the file .MAX }
function TCountTable.BuildMAXFileName : string;
var
   Name   : string;
   buf    : array[0..255] of char;
   err    : longInt;
   curDir : string;
   IsPath : boolean;
begin
    if DataBaseName = '' then
      Name := ChangeFileExt(TableName, '.MAX')
    else
    begin
       { check if DataBaseName is a phisical path }
       GetDir(0,CurDir);
       {$I-}
       ChDir(DataBaseName);
       {$I+}
       IsPath := (IoResult = 0);
       if IsPath then
       begin
          { if is a path }
          ChDir(CurDir);
          if DataBaseName[Length(DataBaseName)] = '\' then
             Name := DataBaseName +  ChangeFileExt(TableName, '.MAX')
          else
             name := DataBaseName +  '\' + ChangeFileExt(TableName, '.MAX');
       end
       else
       begin
          { if is an Alias or a link with a TDataBase component }
          fillChar(buf, sizeOf(buf), #0);
          err := DbiGetDirectory (DBHandle, false, @buf);
          case err of
            DBIERR_NONE :
              name := StrPas(@buf) + '\' + ChangeFileExt(TableName, '.MAX');
            DBIERR_INVALIDHNDL	 :
            begin
              ShowMessage('Bad Handle.' + chr(13) +
                          'Application terminate !');
              Application.Terminate;
            end;
          end;
       end;
    end;
    BuildMAXFileName := name;
end;


{ first TCountTable.Open looks for the file FileName.MAX }
{ if it doesn't exist rebuild it.                        }

Procedure TCountTable.Open;
var SS : string;
  procedure RebuildMaxFile;
  var
    FL       : file of LongInt;
    CurIndex : String;
  begin

     if bof and eof then
        FContaRecords := 0
     else
     begin
        { the index (if any) is temporarily removed to obtain the natural }
        { order of records; by a call to the 'Last' method, the cursor is }
        { set on the record that has certainly the highest number and it }
        { becomes the new counter.}

        CurIndex := IndexName;
        IndexName := '';
        last;
        FContaRecords := FieldByName(FAutoFieldName).AsInteger;
        IndexName := CurIndex;
        first;
     end;
     AssignFile(FL, FMaxFileName);
     Rewrite(FL);
     write(FL, FContaRecords);
     CloseFile(FL);
  end;
begin
   inherited Open;
   { build the name of the autoincreasing field }
   SS := BuildAutoFieldName;
   { looks for that name in the table, if doesn't exists exit }
   if FindField(SS) <> NIL then
      FAutoFieldName := SS  { imposta il nome del campo automatico }
   else
   begin
      FAutoFieldName := '';
      exit;
   end;
   FMaxFileName := BuildMaxFileName;
   { looks for the file .MAX }
    if not FileExists(FMaxFileName) then RebuildMaxFile;
end;


Function TCountTable.ReadIncCounter : Boolean;
var
  retries  : longInt;
  risult   : integer;
  DosError : integer;
  FL       : file of LongInt;
begin
    AssignFile(FL, FMaxFileName);
    { in case of a Client/Server application tries to open exclusive }
    { the .MAX file.                                                 }
    retries := 0;
    repeat
    begin
       DosError := SetErrorMode(SEM_FAILCRITICALERRORS);
       {$I-}
       Reset(FL);
       {$I+}
       SetErrorMode(DosError);
       risult := IoResult;
       if risult <> 0 then inc(retries);
       if retries > 10 then
       begin
          if MessageDlg('Can''t open ' + TableName + '.' +
                        chr(13) + 'Try again ?',
             mtInformation, [mbYes, mbNo], 0) = mrYes then retries := 0
             else
             begin
                ReadIncCounter := FALSE;
                EXIT;
             end;
       end;
    end;
    until risult = 0;
    Read(FL, FContaRecords);
    Inc(FContaRecords);
    Seek(FL,0);
    write(FL,FContaRecords);
    CloseFile(FL);
    ReadIncCounter := True;
end;




procedure TCountTable.DoBeforePost;
var
   S   : string;
begin
   if FAutoFieldName <> '' then
   begin
      if State = dsInsert then
      begin

         { get the counter from the file .MAX }

         if ReadIncCounter then
         begin
            Str(FContaRecords, S);
            FieldByName(FAutoFieldName).AsString := S;
         end
         else
         begin
             Cancel;
             raise EAbort.Create('Insert a new record failed');
         end;
      end;

      { if the table is in dsEdit get the value saved by DoBeforeEdit }
      { into FCurrCountStr. Restore the value in the field and then   }
      { execute Post.                                                 }

      if State = dsEdit then
         FieldByName(FAutoFieldName).AsString := FCurrCountStr;
   end;
   inherited DoBeforePost;
end;

{ If the xxx_NO field exists save the current value into FCurrCountStr }
procedure TCountTable.DoBeforeEdit;
begin
   if FAutoFieldName <> '' then
      FCurrCountStr := FieldByName(FAutoFieldName).AsString;
   inherited DoBeforeEdit;
end;



end.
