{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{                                                       }
{       Shareware of modified TDBNavigator              }
{       Claus Mller 08.95                              }
{       E-mail - Claus_Moeller@dk-online.dk             }
{*******************************************************}
{ Give the programmer free access to overwrite the      }
{ button functions or to keep the normal function of    }
{ the DBNavigator.                                      }
{*******************************************************}
{ Normal disclaimers go here. I hold no responsibility  }
{ for any damage caused using this component.           }
{ Use at your own risk.                                 }
{*******************************************************}

unit Clmdbnav;

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Controls, Forms,
  Graphics, Menus, StdCtrls, ExtCtrls, DB, DBTables, Mask, Buttons,
  DBCtrls, Grids, DBLookup;

type
  { TCLMDBNavigator }
  TCLMDBNavigator = class(TDBNavigator)
  private
    FOnNavClick : ENavClick;
    FOnBtnPrior : TNotiFyEvent;
    FOnBtnNext : TNotiFyEvent;
    FOnBtnFirst : TNotiFyEvent;
    FOnBtnLast : TNotiFyEvent;
    FOnBtnInsert : TNotiFyEvent;
    FOnBtnEdit : TNotiFyEvent;
    FOnBtnCancel : TNotiFyEvent;
    FOnBtnPost : TNotiFyEvent;
    FOnBtnRefresh : TNotiFyEvent;
    FOnBtnDelete : TNotiFyEvent;
    FConfirmDelete : Boolean;
    procedure NewClick(Sender: TObject);
  protected
  public
    constructor create(AOwner: TComponent); override;
    procedure NewBtnClick(Index: TNavigateBtn); virtual;
  published
    property OnBtnPrior : TNotifyEvent read FOnBtnPrior write FOnBtnPrior;
    property OnBtnNext : TNotifyEvent read FOnBtnNext write FOnBtnNext;
    property OnBtnFirst : TNotifyEvent read FOnBtnFirst write FOnBtnFirst;
    property OnBtnLast : TNotifyEvent read FOnBtnLast write FOnBtnLast;
    property OnBtnInsert : TNotifyEvent read FOnBtnInsert write FOnBtnInsert;
    property OnBtnEdit : TNotifyEvent read FOnBtnEdit write FOnBtnEdit;
    property OnBtnCancel : TNotifyEvent read FOnBtnCancel write FOnBtnCancel;
    property OnBtnPost : TNotifyEvent read FOnBtnPost write FOnBtnPost;
    property OnBtnRefresh : TNotifyEvent read FOnBtnRefresh write FOnBtnRefresh;
    property OnBtnDelete : TNotifyEvent read FOnBtnDelete write FOnBtnDelete;
  end;


  procedure Register;

implementation

Uses Dialogs;

{Is normally placed in the LIB directory $R DBCTRLS}

{ TCLMDBNavigator }

constructor TCLMDBNavigator.Create(AOwner: TComponent);
Var I   : TNavigateBtn;
begin
  inherited Create(Aowner);
  { Well - a few bytes are now wasted - but who cares....}
  For I := low(buttons) to High(Buttons) do
  begin
    Buttons[i].Onclick := NewClick;
  end;
end;

procedure TCLMDBNavigator.NewClick(Sender: TObject);
begin
  NewBtnClick(TNavButton (Sender).Index);
end;


procedure TCLMDBNavigator.NewBtnClick(Index: TNavigateBtn);
begin
  if (DataSource <> nil) and (DataSource.State <> dsInactive) then
  begin
    with DataSource.DataSet do
    begin
      case Index of
        nbPrior:  If assigned(FOnBtnPrior) then FOnBtnPrior(Self)
                  Else Prior;
        nbNext:   If assigned(FOnBtnNext) then FOnBtnNext(Self)
                  Else Next;
        nbFirst:  If assigned(FOnBtnFirst) then FOnBtnFirst(Self)
                  Else First;
        nbLast:   If assigned(FOnBtnLast) then FOnBtnLast(Self)
                  Else Last;
        nbInsert: If assigned(FOnBtnInsert) then FOnBtnInsert(Self)
                  Else Insert;
        nbEdit:   If assigned(FOnBtnEdit) then FOnBtnEdit(Self)
                  Else Edit;
        nbCancel: If assigned(FOnBtnCancel) then FOnBtnCancel(Self)
                  Else Cancel;
        nbPost:   If assigned(FOnBtnPost) then FOnBtnPost(Self)
                  Else Post;
        nbRefresh:If assigned(FOnBtnRefresh) then FOnBtnRefresh(Self)
                  Else Refresh;
        nbDelete: If assigned(FOnBtnDelete) then FOnBtnDelete(Self)
                  Else Delete;
      end;
    end;
  end;
  if not (csDesigning in ComponentState) and Assigned(FOnNavClick) then
    FOnNavClick(Self, Index);
end;

{ Register }
procedure Register;
begin
  RegisterComponents('Data Controls', [TCLMDBNavigator]);
end;


end.
