PROGRAM test4;
{$I unzip.Inc}

{$ifdef windows}
USES
wintypes,
winprocs,
{$ifdef Delphi}sysutils, {$else}windos, strings, {$endif Delphi}
unzip,
ziptypes,
wincrt;
{$else}
USES
dos,
crt,
strings,
unzip,
ziptypes;
{$endif}

VAR rc : integer;
    r : tziprec;
    buf, thename, target : ARRAY [ 0..tFsize ] of char;
    i : word;

BEGIN
  Writeln ( 'Supported ZIP unzipmethods:' );
  FOR i := 0 TO 8 DO     {8 because of array above}
    IF ( ( 1 SHL i ) AND GetSupportedMethods ) <> 0
      THEN writeln ( unzipmethods [ i ] );

  Writeln;

  write ( 'Please enter ZIP filename:' );
  readln ( thename );
  IF strlen ( thename ) = 0 THEN halt;

  write ( 'Please enter target directory:' );
  readln ( target );
  IF strlen ( target ) = 0 THEN halt;

  IF ( target [ 0 ] <> #0 ) AND ( target [ strlen ( target ) -1 ] <> '\' )
    THEN strcat ( target, '\' );
  IF NOT iszip ( thename ) THEN writeln ( 'The specified file is not found or not a ZIP file!' )
  ELSE BEGIN
    writeln ( 'Press ESC to abort!' );
    rc := getfirstinzip ( thename, r );
    WHILE rc = unzip_ok DO BEGIN
      write ( r.filename );
      write ( ' ... ' );
      FOR i := strlen ( r.filename ) TO 20 DO write ( ' ' );
      write ( unzipactions [ r.packmethod ], ' ... ' );
      strcopy ( buf, target );
      strcat ( buf, r.filename );
      rc := unzipfile ( thename, buf, r.headeroffset, 0,
      {$ifdef windows}vk_escape{$else}27{$endif} ); {Escape interrupts}
      IF rc = unzip_ok THEN
        writeln ( 'Ok' )
      ELSE CASE rc of
        unzip_CRCErr : writeln ( 'CRC-Error!' );
        unzip_WriteErr : writeln ( 'Write error!' );
        unzip_ReadErr : writeln ( 'Read error!' );
        unzip_ZipFileErr : writeln ( 'Error in Zip file structure!' );
        unzip_UserAbort : writeln ( 'Aborted by user!' );
        unzip_NotSupported : IF r.packmethod <= 8 THEN
          writeln ( 'Format ', unzipmethods [ r.packmethod ], ' not supported!' )
        ELSE
          writeln ( 'Unknown pack method ', r.packmethod, '!' );
        unzip_Encrypted : writeln ( 'File encrypted, skipped!' );
        unzip_InUse : writeln ( 'DLL already in use, try later or use pkunzip!' );
      END;
      IF ( rc = unzip_ReadErr ) OR ( rc = unzip_Userabort ) OR
         ( rc = unzip_InUse )   OR ( rc = unzip_ZipFileErr ) THEN
        rc := unzip_SeriousError   {Serious error, force abort}
      ELSE
        rc := getnextinzip ( r );
    END;
    closezipfile ( r );               {Free memory used for central directory info}
    CASE rc of
      unzip_FileError : writeln ( 'Error reading Zipfile!' );
      unzip_InternalError : writeln ( 'Error in Zip file structure!' );
      unzip_SeriousError : writeln ( 'Unzipping aborted!' );
    END;
  END;
END.
