{
Test program for unzip, using Delphi component/Pascal object
}
PROGRAM Test3;
{$i unzip.inc}

USES
{$ifdef Windows}
Winprocs,
Wincrt,
{$endif Windows}
{$ifdef Delphi}
Sysutils,
{$else}
Strings,
{$endif Delphi}
ZipTypes,
ChfUnzip;


{/////////////////////////////////////////////////////}
PROCEDURE Report ( Retcode : longint;R : pReportRec );
{$ifdef Windows}{$ifdef win32}STDCALL;{$else}EXPORT;{$endif}{$endif}
BEGIN
  WITH r^ DO
  CASE Status of
  file_completed :
   Writeln
   ( 
   UnzipMethods [ packmethod ] : 9,
   '  ', Size : 9,
   '  ', CompressSize : 9,
   '  ', Ratio : 5, '%',
   '  ', filename
   );
   unzip_completed :
   Writeln
   ( 
   'Archived' : 9,
   '  ', Size : 9,
   '  ', CompressSize : 9,
   '  ', Ratio : 5, '%',
   '  ', filename
   );

 END {case}
END; {Report}
{/////////////////////////////////////////////////////}
PROCEDURE Report2 ( Retcode : longint;R : pReportRec );
{$ifdef Windows}{$ifdef win32}STDCALL;{$else}EXPORT;{$endif}{$endif}
BEGIN
   WITH r^ DO
   Writeln
   ( 
   UnzipMethods [ packmethod ] : 9,
   '  ', Size : 9,
   '  ', CompressSize : 9,
   '  ', Ratio : 5, '%',
   '  ', filename
   );
END; {Report2}
{/////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////}
VAR
Zip : TChiefUnzip;
i : integer;
p : pchar;
BEGIN
  IF ( paramcount < 2 )
  THEN BEGIN
    getmem ( p, 512 );
    strcopy ( p, 'Syntax=TEST3 <filename.ZIP> <[target dir] or [/v]> [specs]'#13#10#13#10 );
    Strcat ( p, 'Examples: '#13#10 );
    Strcat ( p, '    TEST3 TEST.ZIP C:\TEMP'#13#10 );
    Strcat ( p, '    TEST3 TEST.ZIP C:\TEMP *.PAS'#13#10 );
    Strcat ( p, '    TEST3 TEST.ZIP C:\TEMP ZIP*.*'#13#10 );
    Strcat ( p, '    TEST3 TEST.ZIP /V'#13#10 );
    Strcat ( p, '    TEST3 TEST.ZIP /V *.EXE'#13#10 );

  {$ifdef Windows}
     Messagebox ( 0, p, 'Chief''s UNZIP', 0 );
  {$else}
     Writeln ( p );
  {$endif}
     freemem ( p, 512 );
     halt;
  END;

  {$ifdef Windows}
   WITH ScreenSize DO BEGIN
        x := 75;
        y := 500;
   END;
   WITH WindowOrg DO BEGIN
        x := 1;
        y := 1
   END;
  {$endif}

  Zip{$ifndef ver70} := TChiefUnzip{$endif}.Create{$ifdef Delphi} ( NIL ) {$endif};
  WITH Zip DO BEGIN
     {$ifdef Delphi}
       FileName := ParamStr ( 1 );
       DirectoryName := ParamStr ( 2 );
       FileSpecs := ParamStr ( 3 );
       ReportProc := Report;
     {$else}
       SetFileName ( ParamStr ( 1 ) );
       SetDirectoryName ( ParamStr ( 2 ) );
       SetFileSpecs ( ParamStr ( 3 ) );
       SetReportProc ( Report );
     {$endif}
       IF ( upper ( paramstr ( 2 ) ) = '/V' ) OR ( upper ( paramstr ( 2 ) ) = '-V' )
       THEN BEGIN
          SetReportProc ( Report2 );
          i := View
       END
       ELSE i := Unzip;
       Destroy;
  END; {With Zip}
END.

