{
test program for unzip, using a simple Pascal object
}
PROGRAM test2;
{$I unzip.Inc}

{$ifdef windows}
USES
wintypes,
winprocs,
{$ifdef Delphi}sysutils, {$else}windos, strings, {$endif Delphi}
unzip,
ziptypes,
wincrt;
{$else}
USES
dos,
crt,
strings,
unzip,
ziptypes;
{$endif}

TYPE
UnZipObject = OBJECT
   CONSTRUCTOR Init ( CONST ZipFile, Directory, FileSpecs : String;Report : UnzipReportProc );
   DESTRUCTOR  Done;virtual;
   FUNCTION    Run : integer;virtual;
   FUNCTION    View : integer;virtual;
   PRIVATE
      aName,
      aDir,
      aSpec : String;
      ZipReport : UnzipReportProc;
END;

{/////////////////////////////////////////////////////}
PROCEDURE Report ( Retcode : longint;R : pReportRec );
{$ifdef Windows}{$ifdef win32}STDCALL;{$else}EXPORT;{$endif}{$endif}
BEGIN
  WITH r^ DO
  CASE Status of
  file_completed :
   Writeln
   ( 
   UnzipMethods [ packmethod ] : 9,
   '  ', Size : 9,
   '  ', CompressSize : 9,
   '  ', Ratio : 5, '%',
   '  ', filename
   );
   unzip_completed :
   Writeln
   ( 
   'Archived' : 9,
   '  ', Size : 9,
   '  ', CompressSize : 9,
   '  ', Ratio : 5, '%',
   '  ', filename
   );

 END {case}
END; {Report}
{/////////////////////////////////////////////////////}
PROCEDURE Report2 ( Retcode : longint;R : pReportRec );
{$ifdef Windows}{$ifdef win32}STDCALL;{$else}EXPORT;{$endif}{$endif}
BEGIN
   WITH r^ DO
   Writeln
   ( 
   UnzipMethods [ packmethod ] : 9,
   '  ', Size : 9,
   '  ', CompressSize : 9,
   '  ', Ratio : 5, '%',
   '  ', filename
   );
END; {Report2}
{/////////////////////////////////////////////////////}
CONSTRUCTOR UnZipObject.Init;
BEGIN
  aName := ZipFile;
  adir  := Directory + #0;
  aSpec := FileSpecs + #0;
  ZipReport := Report;
  IF pos ( '.', aName ) = 0 THEN aName := aName + '.ZIP';
  aName := aName + #0;
END;

DESTRUCTOR  UnZipObject.Done;
BEGIN
END;

FUNCTION    UnZipObject.Run : integer;
BEGIN
  Run := FileUnzip ( @aName [ 1 ], @aDir [ 1 ], @aSpec [ 1 ], ZipReport, NIL );
END;

FUNCTION    UnZipObject.View : integer;
BEGIN
  View := ViewZip ( @aName [ 1 ], @aSpec [ 1 ], Report2 );
END;

VAR
Zip : UnZipObject;
i : integer;
p : pchar;
BEGIN
  IF ( paramcount < 2 )
  THEN BEGIN
    getmem ( p, 512 );
    strcopy ( p, 'Syntax=TEST2 <filename.ZIP> <[target dir] or [/v]> [specs]'#13#10#13#10 );
    Strcat ( p, 'Examples: '#13#10 );
    Strcat ( p, '    TEST2 TEST.ZIP C:\TEMP'#13#10 );
    Strcat ( p, '    TEST2 TEST.ZIP C:\TEMP *.PAS'#13#10 );
    Strcat ( p, '    TEST2 TEST.ZIP C:\TEMP ZIP*.*'#13#10 );
    Strcat ( p, '    TEST2 TEST.ZIP /V'#13#10 );
    Strcat ( p, '    TEST2 TEST.ZIP /V *.EXE'#13#10 );

  {$ifdef Windows}
     Messagebox ( 0, p, 'Chief''s UNZIP', 0 );
  {$else}
     Writeln ( p );
  {$endif}
     freemem ( p, 512 );
     halt;
  END;

  {$ifdef Windows}
   WITH ScreenSize DO BEGIN
        x := 75;
        y := 500;
   END;
   WITH WindowOrg DO BEGIN
        x := 1;
        y := 1
   END;
  {$endif}

  WITH Zip DO BEGIN
      Init ( ParamStr ( 1 ), ParamStr ( 2 ), ParamStr ( 3 ), Report );
      IF ( upper ( paramstr ( 2 ) ) = '/V' ) OR ( upper ( paramstr ( 2 ) ) = '-V' )
      THEN i := View
      ELSE i := Run;
      Done;
  END;
END.
