{
Test program for UNZIP;
  Under Windows, it uses the DLL (in UNZIPDLL.PAS), which must be
  compiled first
}

PROGRAM Test1;
{$I unzip.Inc}

{$ifdef windows}
USES
wintypes,
winprocs,
{$ifdef Delphi}sysutils, {$else}windos, strings, {$endif Delphi}
zipinter,
Ziptypes,
wincrt;
{$else}
USES
dos,
crt,
strings,
Ziptypes,
unzip;
{$endif}

VAR
SkipAll : Boolean;

PROCEDURE Report ( Retcode : longint;R : pReportRec );
{$ifdef Windows}{$ifdef win32}STDCALL;{$else}EXPORT;{$endif}{$endif}
BEGIN
  WITH r^ DO
  CASE Status of
  file_completed :
   Writeln
   ( 
   UnzipMethods [ packmethod ] : 9,
   '  ', Size : 9,
   '  ', CompressSize : 9,
   '  ', Ratio : 5, '%',
   '  ', filename
   );
   unzip_completed :
   Writeln
   ( 
   'Archived' : 9,
   '  ', Size : 9,
   '  ', CompressSize : 9,
   '  ', Ratio : 5, '%',
   '  ', filename
   );

 END {case}
END; {Report}
{/////////////////////////////////////////////////////}
FUNCTION Ask ( R : pReportRec ) : Boolean;
{$ifdef Windows}{$ifdef win32}STDCALL;{$else}EXPORT;{$endif}{$endif}
VAR
s : string [ 1 ];
BEGIN
   IF SkipAll THEN BEGIN
      Ask := False;
      Exit;
   END;

   WITH r^
   DO BEGIN
     {$ifdef Windows}
       Ask := Messagebox
       ( 0,
       'The above file already exists! Should I overwrite it?',
       filename,
       mb_YESNO ) = id_Yes;

     {$else}
      Ask := False;
      Writeln ( filename, ': (', Size, ' bytes)' );
      Write ( 'This file already exists! Overwrite? ([Y]es [N]o [S]kip all): ' );
      Readln ( s );
      CASE Upcase ( s [ 1 ] ) of
       'Y' : Ask := True;
       'S' : BEGIN
              Ask := True;
              Skipall := True;
            END;
       END; {Case}
     {$endif Windows}
   END;
END; {Report}
{/////////////////////////////////////////////////////}
VAR
thename, target : ARRAY [ 0..TFSize ] of char;
DLLVersion, i : word;

BEGIN
   {$ifdef Windows}
   WITH ScreenSize DO BEGIN
        x := 75;
        y := 500;
   END;
   WITH WindowOrg DO BEGIN
        x := 1;
        y := 1
   END;
   WITH WindowSize DO BEGIN
        {x:=1;}
        y := 20;
   END;
  {$endif}
  SkipAll := False;
 {$ifdef windows}
  DLLVersion := GetUnzipDLLVersion;
  write ( 'DLL Version ', Hi ( DLLVersion ), '.' );
  IF lo ( DLLVersion ) < 10 THEN write ( '0' );
  writeln ( LO ( DLLVersion ) );
  {$endif}
  Writeln ( 'Supported ZIP Unzipmethods:' );
  FOR i := 0 TO 8 DO     {8 because of array above}
    IF ( ( 1 SHL i ) AND GetSupportedmethods ) <> 0
      THEN writeln ( Unzipmethods [ i ] );
  Writeln ( '--------------------------' );
  IF paramcount = 2 THEN BEGIN
      Strpcopy ( thename, paramstr ( 1 ) );
      Strpcopy ( target, paramstr ( 2 ) );
  END ELSE BEGIN
      Writeln;
      write ( 'Please enter ZIP filename:' );
      readln ( thename );
      IF strlen ( thename ) = 0 THEN halt;
      write ( 'Please enter target directory:' );
      readln ( target );
      IF strlen ( target ) = 0 THEN Halt;
  END;
  FileUnzip ( thename, target, '*.*', Report, Ask );
END.
