UNIT Chfunzip;
{
Simple Delphi Component for UNZIP
 * by Dr Abimbola Olowofoyeku (The African Chief)
 Homepage: http://ourworld.compuserve.com/homepages/African_Chief
}

{$I unzip.Inc}

{.$define UseDLL}   { /// uncomment this line to use the DLL /// }

INTERFACE
USES
{$ifdef Delphi}
Classes,
{$endif Delphi}
{$ifdef UseDLL}
zipinter,
{$else UseDLL}
unzip,
{$endif UseDLL}
ziptypes;

TYPE
TChiefUnzip = {$ifdef ver70}OBJECT{$else}CLASS{$ifdef Delphi} ( TComponent ) {$endif}{$endif}
   PRIVATE
      FName,                       {source ZIP file name}
      FDir,                        {target directory}
      FSpec : String;                {file specifications to process in ZIP file}
      FReport : UnzipReportProc;    {points to callback procedure}
      FQuestion : UnzipQuestionProc; {points to callback procedure}
      CompSize : longint;            {compressed size}

  PUBLIC
   CONSTRUCTOR Create{$ifdef Delphi} ( aOwner : TComponent );override{$endif};
   DESTRUCTOR  Destroy;{$ifdef ver70}virtual;{$else}override;{$endif}
   FUNCTION    Unzip : integer;virtual;  {unzip the archive}
   FUNCTION    View : integer;virtual;   {view the archive;must provide callback procedure}
   FUNCTION    Size : longint;virtual;   {uncompressed size of the archive}
   FUNCTION    CompressedSize : longint;  {compressed size}

   PROCEDURE   SetFileName ( CONST aName : String );
   PROCEDURE   SetDirectoryName ( CONST aName : String );
   PROCEDURE   SetFileSpecs ( CONST Spec : String );
   PROCEDURE   SetReportProc ( aProc : UnzipReportProc );
   PROCEDURE   SetQuestionProc ( aProc : UnzipQuestionProc );
  {$ifdef Delphi}
   PROPERTY      ReportProc : UnzipReportProc     Read FReport Write SetReportProc;
   PROPERTY      QuestionProc : UnzipQuestionProc Read FQuestion Write SetQuestionProc;
  PUBLISHED
   PROPERTY      FileName : String            Read FName   Write SetFileName;
   PROPERTY      DirectoryName : String       Read FDir    Write SetDirectoryName;
   PROPERTY      FileSpecs : string           Read FSpec   Write SetFileSpecs;
  {$endif Delphi}
END;

{$ifdef Delphi}
PROCEDURE Register;
{$endif Delphi}

{/////////////////////////////////////////////////////}
IMPLEMENTATION
{/////////////////////////////////////////////////////}
{$ifdef Delphi}
PROCEDURE Register;
BEGIN
   RegisterComponents ( 'Unzip', [ TChiefUnZip ] );
END;
{$endif Delphi}


CONSTRUCTOR TChiefUnzip.Create;
BEGIN
  {$ifndef ver70}INHERITED Create{$Ifdef Delphi} ( aOwner ) {$endif Delphi};{$endif ver70}
  FName := '';
  FDir  := '';
  FSpec := '*.*';
  FReport := NIL;
  FQuestion := NIL;
  CompSize := 0;
END;

DESTRUCTOR  TChiefUnzip.Destroy;
BEGIN
  SetUnZipReportProc ( NIL );
  SetUnZipQuestionProc ( NIL );
  {$ifndef ver70}INHERITED Destroy;{$endif}
END;

FUNCTION    TChiefUnzip.Unzip : integer;
BEGIN
  Unzip := unzip_MissingParameter; {no zipfilename or target directory}
  IF ( FName = '' ) OR ( FDir = '' ) THEN exit;
  Unzip := FileUnzip ( @FName [ 1 ], @FDir [ 1 ], @FSpec [ 1 ], FReport, FQuestion );
END;

FUNCTION    TChiefUnzip.View : integer;
BEGIN
  View := unzip_MissingParameter;
  IF ( FName = '' ) OR ( @FReport = NIL ) THEN exit;
  View := ViewZip ( @FName [ 1 ], @FSpec [ 1 ], FReport );
END;

FUNCTION    TChiefUnzip.Size;
BEGIN
  Size := UnZipSize ( @FName [ 1 ], Compsize );
END;

FUNCTION    TChiefUnzip.CompressedSize;
BEGIN
  CompressedSize := CompSize;
END;

PROCEDURE   TChiefUnzip.SetFileName ( CONST aName : String );
BEGIN
   FName := aName + #0;
END;

PROCEDURE   TChiefUnzip.SetDirectoryName ( CONST aName : String );
BEGIN
    FDir := aName + #0;
END;

PROCEDURE   TChiefUnzip.SetFileSpecs ( CONST Spec : String );
BEGIN
    FSpec := Spec + #0;
END;

PROCEDURE   TChiefUnzip.SetReportProc ( aProc : UnzipReportProc );
BEGIN
   FReport := aProc;
END;

PROCEDURE   TChiefUnzip.SetQuestionProc ( aProc : UnzipQuestionProc );
BEGIN
   FQuestion := aProc;
END;

END.
