unit Volume;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Slider, ExtCtrls, mmsystem;

const AuxDev:byte=2;
      Step : integer = 1000; {volume step}

type
  TChangeVol = (cvUp, cvDown);
  TVolType = (vtLeft, vtRight);
  TVol = array[vtLeft..vtRight] of word;
  TVolumeDlg = class(TForm)
    OKBtn: TBitBtn;
    Bevel1: TBevel;
    LeftSlider: TSlider;
    RightSlider: TSlider;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    MainSlider: TSlider;
    Label4: TLabel;
    ComboBox1: TComboBox;
    Panel1: TPanel;
    Help: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure RightSliderValueChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MainSliderValueChange(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure RightSliderMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RightSliderKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LeftSliderKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LeftSliderMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MainSliderMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure MainSliderKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
    Vol : TVol;
    procedure GetVolume;
    procedure SetVolume;
    procedure initActivate;
    procedure GetVolumes(DevId : word;
                         var VolLeft, VolRight : word);
  end;

var
  VolumeDlg: TVolumeDlg;

implementation

{$R *.DFM}

procedure TVolumeDlg.GetVolume;
var myvolume:longint;
begin
  auxgetvolume(AuxDev,addr(myvolume));
  LeftSlider.value:=myvolume mod 65536;
  RightSlider.value:=myvolume div 65536;
end;

procedure TVolumeDlg.initActivate;
var s:string;
begin
  GetVolumes(auxdev, Vol[vtLeft], Vol[vtRight]);
{  ChangeVol(cvup);
  ChangeVol(cvdown);}
  LeftSlider.value:=vol[vtLeft];
  RightSlider.value:=vol[vtRight];
  ComboBox1.itemindex:=AuxDev;
  str(auxdev:1,s);
  Caption:='Volume aux'+s;
end;


procedure TVolumeDlg.FormActivate(Sender: TObject);
begin
  InitActivate;
end;

procedure TVolumeDlg.SetVolume;
begin
  auxsetvolume(AuxDev,longint(RightSlider.value)*65536+longint(LeftSlider.value));
end;

procedure TVolumeDlg.RightSliderValueChange(Sender: TObject);
begin
 with sender as TSlider do
 begin
  SetVolume;
  if MainSlider.Value<value then
  MainSlider.Value:=value;
  if (MainSlider.Value>LeftSlider.value) and
      (MainSlider.Value>RightSlider.value) then
    if RightSlider.value>LeftSlider.value then
    MainSlider.Value:=RightSlider.value else
     MainSlider.Value:=LeftSlider.value;
 end;
end;

procedure TVolumeDlg.FormCreate(Sender: TObject);
begin
  GetVolume;
end;

procedure TVolumeDlg.MainSliderValueChange(Sender: TObject);
var previous,diff:longint;
    RG:boolean;
begin
  RG:=RightSlider.value>LeftSlider.Value;
  if RG then
  previous:=RightSlider.value else
  previous:=LeftSlider.Value;
  diff:=MainSlider.value-previous;
  RightSlider.value:=RightSlider.value+diff;
  LeftSlider.value:=LeftSlider.value+diff;
end;

procedure TVolumeDlg.ComboBox1Change(Sender: TObject);
begin
  AuxDev:=ComboBox1.itemindex;
  InitActivate;
end;

procedure TVolumeDlg.RightSliderMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  RightSliderValueChange(Self);
end;

procedure TVolumeDlg.RightSliderKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  RightSliderValueChange(Self);
end;

procedure TVolumeDlg.LeftSliderKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  RightSliderValueChange(Self);
end;

procedure TVolumeDlg.LeftSliderMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  RightSliderValueChange(Self);
end;

procedure TVolumeDlg.MainSliderMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  MainSliderValueChange(Self);
end;

procedure TVolumeDlg.MainSliderKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  MainSliderValueChange(Self);
end;

procedure TVolumeDlg.GetVolumes(DevId : word;
                            var VolLeft, VolRight : word);
{volume is returned as a pointer to a DWord with the most
 significant word for the left channel. The channels are
 extracted by treating the DWord as a two element  array and
 accessing the two array elements for the Lt and Rt volumes}
var
  Error : integer;
  TempVol : TVol;
begin
  Error := AuxGetVolume(DevId, @TempVol);
  if Error <> 0 then begin
    Exit;
  end;
  VolLeft := TempVol[vtLeft];
  VolRight := TempVol[vtRight];
end;

end.
