unit Utils;

interface

uses Classes,SysUtils, WinTypes, WinProcs, Dialogs, messages, StdCtrls;

const
  numStyles:integer=3;

var
  Styles:TStringlist;

{ Get the line number and column number the cursor is positioned at in the
memo}

Procedure GetMemoLineCol (Memo: TCustomMemo; var MemoLine, MemoCol:
Integer);

{ Set the cursor position in a memo to the specified line and column }

Procedure MemoCursorTo (Memo: TCustomMemo; MemoLine, MemoCol: Integer);

function iif(b:boolean;s1,s2:string):string;
procedure keepwindowsalive;
function trim(s:string):string;
function ltrim(s:string):string;
function xstr(s:real;a,b:byte):string;
function calctime(s:string):integer;
function strtime(l:longint):string;
procedure SetStyles(var Style:TComboBox);

implementation

procedure SetStyles(var Style:TComboBox);
var i:integer;
begin
  Style.clear;
  For i:=0 to Styles.count-1 do
  Style.Items.add(Styles[i]) ;{tcombobox}
end;

function iif(b:boolean;s1,s2:string):string;
begin
  if b then iif:=s1 else iif:=s2
end;

procedure keepwindowsalive;
var i:word;
    msg:tmsg;
begin
  i:=0;
      while (i<20) and peekmessage(msg,0,0,0,pm_remove)do
      begin
        inc(i);
        if msg.message=wm_quit then halt(msg.wparam);
	translatemessage(msg);
	dispatchmessage(msg);
      end;
end;

function trim(s:string):string;
begin
  while (length(s)>0) and (s[length(s)]=' ') do
  s:=copy(s,1,length(s)-1);
  trim:=s;
end;

function ltrim(s:string):string;
begin
  while (length(s)>0) and (s[1]=' ') do
  s:=copy(s,2,length(s));
  ltrim:=s;
end;

function xstr(s:real;a,b:byte):string;
var h:string;
begin
  str(s:a:b,h);
  xstr:=h
end;

function calctime(s:string):integer;
var m,hs:byte;
    p,hi:integer;
begin
  p:=pos(':',s);
  if p>0 then
  begin
    val(copy(s,1,p-1),m,hi);
    val(copy(s,p+1,length(s)),hs,hi);
  end else
  begin
    val(s,m,hi);
    hs:=0;
  end;
  calctime:=m*60+hs;
end;

function strtime(l:longint):string;
var s:string;
    i:integer;
begin
  s:=xstr(l mod 60,2,0);
  l:=l div 60;
  s:=xstr(l,2,0)+':'+s;
  for i:=1 to length(s) do
  if s[i]=' ' then s[i]:='0';
  strtime:=s;
end;

Procedure GetMemoLineCol;
begin
   WITH Memo DO
      BEGIN
         MemoLine := SendMessage (Handle, EM_LINEFROMCHAR, SelStart, 0);
         MemoCol  := SelStart - SendMessage (Handle, EM_LINEINDEX, MemoLine,
                      0) + 1;
      END;
end;

Procedure MemoCursorTo;
begin
   Memo.SelStart := SendMessage (Memo.Handle, EM_LINEINDEX, MemoLine, 0) +
                   MemoCol - 1;
end;

begin
  Styles:=TStringlist.create;
end.
