{
 Modified UDigit Component
 By Paul Leung
 Date: April 7, 96

 Changes:
 Add Thickness property
 Add Separation property
}

{
 Original Source:
 (C) 1996 Alberto Garcia Alvarez
 agarcia@etsiig.uniovi.es
 Escuela Tcnica Superior de Ingenieros Industriales e Informticos
 Centro de Inteligencia Artificial. Campus de Viesques. Gijn.
 Universidad de Oviedo. Asturias. Espaa.

 Este ejemplo implementa TDIGIT un sencillo display de un digito.
 Programa de uso pblico (Freeware) siempre que se cite la fuente.

}

unit Udigit;

interface

uses WinTypes, Messages, Classes, Graphics, Controls, Forms, StdCtrls;

type
  TOverflow = Procedure (Sender:TObject) of object;
  TDigit = class(TGraphicControl)
  private
    FVal : Integer;
    FByte: Byte;
    FOnOverflow : TOverflow;
    FBorderStyle: TBorderStyle;
    FColorOff,
    FColorOn: TColor;
    FSeparation: integer;   {added by Paul Leung}
    FThickness: integer;    {added by Paul Leung}
    { metodos miembro que utilizaremos para actualizar las propiedades }
    procedure SetBorderStyle(Value: TBorderStyle);
    procedure SetColorOff(Value: TColor);
    procedure SetColorOn(Value: TColor);
    procedure SetValue(Value: Integer);
    procedure SetValueBinary(Value: Byte);
    procedure SetThickness(value: integer);
    procedure SetSeparation(Value: integer);
  protected
    { Sobreescritura del metodo por defecto para "pintar", sera llamado
      cada vez que se produzca un VM_PAINT por parte de Windows }
    procedure Paint; override;
    procedure Overflow;
  public
    { Constructor para la componente }
    constructor Create(AOwner: TComponent); override;
    procedure Incrementa;
  published
    { Lista de propiedades accesibles para el editor }
    property Align;   { Usa por defecto la de la clase base }
    property Color;   { Usa por defecto la de la clase base }
    property Enabled; { Usa por defecto la de la clase base }
    property BorderStyle: TBorderStyle read FBorderStyle
                                       write SetBorderStyle
                                       default bsSingle;
    property ColorOff: TColor          read FColorOff
                                       write SetColorOff
                                       default clGray;
    property ColorOn: TColor           read FColorOn
                                       write SetColorOn
                                       default clRed;
    { Value y ValueBinary van a modificar el aspecto de nuestro digito }
    property Value: Integer            read FVal
                                       write SetValue
                                       default 0;
    property ValueBinary : Byte        read FByte
                                       write SetValueBinary
                                       default 0;
    property OnOverflow : TOverflow read FOnOverflow write FOnOverflow;
    property ParentColor;    { Usa por defecto la de la clase base }
    property ParentFont;     { Usa por defecto la de la clase base }
    property ParentShowHint; { Usa por defecto la de la clase base }
    property ShowHint;       { Usa por defecto la de la clase base }
    property Visible;        { Usa por defecto la de la clase base }
    property Tag;            { Usa por defecto la de la clase base }
    property Thickness: integer read FThickness write SetThickness;
    property Separation: integer read FSeparation write SetSeparation;
                            { Thinkness of the line }
      property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
end;

procedure Register; { Procedimiento estandar para registro de componentes }

implementation

uses WinProcs, SysUtils;

{ TDigit }
constructor TDigit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csFramed, csOpaque];
  { valores por defecto }
  FVal := 0;
  FByte:=125; { Digito 0 }
  FBorderStyle := bsSingle;
  FColorOn := clYellow; { Colores por defecto }
  FColorOff := clBlack;
  Color:=clBlack;
  Width := 16; { Ancho y alto por defecto }
  Height := 32;
  { Por defecto sin asignar }
  FOnOverflow:=nil;
  Separation := 1;
  Thickness := 2;
end;

procedure TDigit.Paint;

Var
 Idy,
 Idx, { Indices para bucles }
   w, { w ancho y h largo del canvas donde dibujamos }
   h,
   g, { grosor del trazo que utilizaremos }
   x, { Coordenada x-base }
  dp, { distancia entre segmentos }
   y : Integer; { Coordenada y-base }
  ca : byte ; { Variable auxiliar para determinar el encendido,
                tomara valores 1,2,4,8,..,256 }

procedure brushcolor(hcolor:tcolor;change:boolean);
begin
    Canvas.Brush.Color := hcolor;
    if change then
    Canvas.Pen.Color:=hcolor else
    Canvas.Pen.Color:=color;
end;

begin
 w:=Width-1;
 h:=Height-1;
 if not ParentColor then
 begin
   Canvas.Brush.Color:=Color;
   Canvas.FillRect(Canvas.ClipRect);
 end;
 g := Thickness;
 { El orden de dibujo de los vertices es
     2__________3
  1 /            \4
    \____________/
   6            5 }

 ca:=1; { Incializamos la variable con la primera potencia entera de dos }
 dp:=Separation; { Por defecto dos puntos de separacion entre segmentos }
 For Idy:=0 To 2 Do { Para cada tramo horizontal }
 Begin
      Case Idy of
           0 : y:=0;          { Primer tramo horizontal }
           1 : y:=H Div 2 -g; { Segundo tramo horizontal }
           2 : y:=H-2*g;      { Tercer Tramo Horizontal }
        else
           y:=0;
      End;
 If (FByte and ca)=ca { Comprobacion de la condicion de encendido }
    Then  brushcolor(FColorOn,false)
    Else brushcolor(FColorOff,true);
 Canvas.Polygon([Point(0+g+dp,   g+y),
                 Point(2*g+dp,   0+y),
                 Point(W-2*g-dp, 0+y),
                 Point(W-g-dp,   g+y),
                 Point(W-2*g-dp, 2*g+y),
                 Point(2*g+dp,   2*g+y)]);
 ca:=ca*2; { Actualizamos para determinar el segmento a encender }
 End;
 {  Orden de dibujo de los puntos
     2
   1/ \3
   |   |
  6|   | 4
    \ /
     5
 }
 For Idy:=0 To 1 do { Para los horizontales }
 For Idx:=0 To 1 do { Para los verticales }
 Begin
 Case Idx Of { Calculo de la coordenada horizontal }
    0 : x:=0;
    1 : x:=w-2*g;
  else
     x:=0;
 End;
 Case Idy of  { Calculo de la coordenada vertical }
    0 : y:=0;
    1 : y:=h div 2-g;
 end;
 If (FByte and ca)=ca { Comprobacion de la condicion de encendido }
    Then  brushcolor(FColorOn,false)
    Else brushcolor(FColorOff,true);
 Canvas.Polygon([Point(0+x,   2*g+y+dp),
                 Point(g+x,   g+y+dp),
                 Point(2*g+x, 2*g+y+dp),
                 Point(2*g+x, H div 2-g+y-dp),
                 Point(g+x,   H div 2+y-dp),
                 Point(0+x,   H div 2-g+y-dp)]);
 Ca:=Ca*2; { Actualizamos para determinar el segmento a encender }
 End;
 { Falta el punto por dibujar }
 {   3
    /|    orden de dibujado del punto
   / |
  2--+1
 }
 If (FByte and ca)=ca  { Comprobacion de la condicion de encendido }
    Then brushcolor(FColorOn,false)
    Else brushcolor(FColorOff,true);
 Canvas.Polygon([Point(w,        h),
                 Point(w-2*g+dp, h),
                 Point(w,        h-2*g+dp)]);
end;

procedure TDigit.SetBorderStyle(Value: TBorderStyle);
begin
  if Value <> FBorderStyle then
  begin
    FBorderStyle := Value;
    Refresh;
  end;
end;

procedure TDigit.SetColorOff(Value: TColor);
begin
  if Value <> FColorOff then
  begin
    FColorOff := Value;
    Refresh;
  end;
end;

procedure TDigit.SetColorOn(Value: TColor);
begin
  if Value <> FColorOn then
  begin
    FColorOn := Value;
    Refresh;
  end;
end;

procedure TDigit.SetValue(Value: Integer);
{
 Codificacion de los bits para "encender" los segmentos del display

    012345678 bits       0
  -+---------------   /--------\
  0|1011111*-  125    |        |
  1|0000101*-   80   3|        |4
  2|1110110*-   55    |    1   |
  3|1110101*-   87    >--------<
  4|0101101*-   90    |        |
  5|1111001*-   79   5|        |6
  6|1111011*-  111    |    2   |
  7|1000101*-   81    \--------/ * 7(punto)
  8|1111111*-  127
  9|1111101*-   95    * si vale 1 entonces enciende el punto
  E|1111010*-   47    - Indiferente
}

Const
     V : Array [0..10] Of byte =(125,80,55,87,90,79,111,81,127,95,47);

begin
  if (Value <> FVal) then
  begin
    If (Value>=0) And (Value<10)
       Then FVal := Value
       Else Begin Fval := 0;Overflow;end;
    FByte:=V[FVal];
    Refresh;
  end;
end;

procedure TDigit.SetValueBinary(Value: Byte);
begin
  if (Value <> FByte) then
  begin
    FByte:=Value;
    FVal:=200;
    Refresh;
  end;
end;

Procedure TDigit.Overflow;
Begin
     if Assigned(FOnOverflow) Then FOnOverflow(self);
End;

Procedure TDigit.Incrementa;
Begin
     SetValue(Value+1);
end;

procedure TDigit.SetThickness(Value: integer);
begin
  if (Value > Width div 2) or (Value > Height div 2) then exit;
  FThickness := Value;
  Invalidate;
end;


procedure TDigit.SetSeparation(Value: integer);
begin
  FSeparation := Value;
  Invalidate;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TDigit]);
end;

end.
