unit Printfrm;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs, Menus, Clipbrd, EditFld, utils;

const
  ReportOutline:string='Report dd. %Date %Time, %B CDs';
  TrackOutline:string='%N %I(%T)';
  RecordOutline:string='%A : %C(%O)(%Y) style:%S (%R tracks)';

type
  TPrintDB = class(TForm)
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Filename1: TEdit;
    FileOpen: TBitBtn;
    SaveDialog2: TSaveDialog;
    SelectionGroupBox: TGroupBox;
    ListPopupMenu: TPopupMenu;
    SelectionEdit: TEdit;
    SortExpressionEdit: TEdit;
    Label5: TLabel;
    Label7: TLabel;
    DestinationGroupBox: TGroupBox;
    FileRadioButton: TRadioButton;
    PrinterRadioButton: TRadioButton;
    ScreenRadioButton: TRadioButton;
    FileNameGroupBox: TGroupBox;
    Panel1: TPanel;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Help: TBitBtn;
    MaskGroupBox: TGroupBox;
    ReportPanel: TPanel;
    ReportHeaderMemo: TMemo;
    ReportLabel: TLabel;
    MaskPanel: TPanel;
    Label3: TLabel;
    CDHeaderMemo: TMemo;
    GroupBox2: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Label4: TLabel;
    TrackMemo: TMemo;
    DefaultButton: TButton;
    FilterPanel: TPanel;
    SelComboBox: TComboBox;
    Label6: TLabel;
    procedure TrackInfoClick(Sender: TObject);
    procedure TrackInfoKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FileRadioButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure test1Click(Sender: TObject);
    procedure CDHeaderMemoEnter(Sender: TObject);
    procedure ReportHeaderMemoEnter(Sender: TObject);
    procedure TrackMemoEnter(Sender: TObject);
    procedure CDHeaderMemoMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ReportHeaderMemoMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure TrackMemoMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SelectionEditEnter(Sender: TObject);
    procedure SortExpressionEditEnter(Sender: TObject);
    procedure SelectionEditMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SortExpressionEditMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SelComboBoxChange(Sender: TObject);
    procedure DefaultButtonClick(Sender: TObject);
  private
    procedure SetButtons;
    procedure SetEnabled;
    procedure InsertVariable(s:string);
    { Private declarations }
  public
    { Public declarations }
    AskFilename:boolean;
  end;

var
  PrintDB: TPrintDB;
  CurrMemo:TMemo;
  CurrEdit:TEdit;

procedure SetPopup(var popup:TPopupMenu;DisplayItems:boolean);

implementation

{$R *.DFM}

procedure SetPopup(var popup:TPopupMenu;DisplayItems:boolean);
var i:integer;
procedure addpopup(s:string);
begin
  popup.items.add(TMenuItem.Create(popup));
  with popup.items[popup.items.count-1] do
  begin
    tag:=popup.items.count-1;
    caption:=s;
  end;
end;
begin
  addpopup('%A=Artist-Name');
  addpopup('%F=Artist-Name, sort');
  addpopup('%C=CD-Name');
  addpopup('%O=Total Time CD');
  addpopup('%Y=Year');
  addpopup('%S=Style');
  addpopup('%R=Number of Tracks');
  addpopup('%N=TrackNumber');
  addpopup('%I=TrackTitle');
  addpopup('%T=TrackTime');
  addpopup('%id=cd-id');
  addpopup('/e=print empty line');
    for i:=0 to StringFieldNames.count-1 do
    begin
      addpopup('%'+StringFieldNames[i]+'='+'field '+xstr(i+1,1,0));
    end;
  if DisplayItems then
  begin
    addpopup('%B=Number of CDs');
    addpopup('%Date=Current date');
    addpopup('%Time=Current Time');
    addpopup('%Day=Current day');
    addpopup('%DayOfWeek=Current weekday');
    addpopup('%Month=Current month');
    addpopup('%Year=Current year');
    addpopup('|B=Start/Stop bold');
    addpopup('|I=Start/Stop italic');
    addpopup('|U=Start/Stop underline');
    addpopup('|S=Start/Stop strikeover');
    addpopup('|1=size font 1');
    addpopup('|2=size font 2');
    addpopup('|3=size font 3');
  end;
end;

procedure TPrintDB.SetButtons;
begin
{  TrackTime.enabled:=TrackInfo.checked;
  Tracknr.enabled:=TrackInfo.checked;}
end;

procedure TPrintDB.TrackInfoClick(Sender: TObject);
begin
  SetButtons;
end;

procedure TPrintDB.TrackInfoKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  SetButtons;
end;

procedure TPrintDB.Button1Click(Sender: TObject);
var f:textfile;
    s:string;
begin
  if OpenDialog1.Execute then
  begin
    CDHeaderMemo.Lines.Clear;
    TrackMemo.Lines.Clear;
    assignfile(f,OpenDialog1.FileName);
    reset(f);
    TrackMemo.Lines.Clear;
    ReportHeaderMemo.Lines.Clear;
    CDHeaderMemo.Lines.Clear;
    while not eof(f) do
    begin
      readln(f,s);
      if copy(s,1,2)='/t' then TrackMemo.Lines.add(copy(s,3,length(s))) else
      if copy(s,1,2)='/r' then ReportHeaderMemo.Lines.add(copy(s,3,length(s))) else
      if copy(s,1,2)='/f' then SelectionEdit.text:=copy(s,3,length(s)) else
      if copy(s,1,2)='/s' then SortExpressionEdit.text:=copy(s,3,length(s)) else
      CDHeaderMemo.Lines.add(s);
    end;
    closefile(f);
    SaveDialog1.Filename := OpenDialog1.FileName;
  end;
end;

procedure TPrintDB.Button2Click(Sender: TObject);
var f:textfile;
    i:integer;
begin
  if SaveDialog1.Execute then
  begin
    assignfile(f,SaveDialog1.FileName);
    rewrite(f);
    for i:=0 to ReportHeaderMemo.Lines.Count-1 do
    writeln(f,'/r'+ReportHeaderMemo.Lines[i]);
    for i:=0 to CDHeaderMemo.Lines.Count-1 do
    writeln(f,CDHeaderMemo.Lines[i]);
    for i:=0 to TrackMemo.Lines.Count-1 do
    writeln(f,'/t'+TrackMemo.Lines[i]);
    writeln(f,'/f'+SelectionEdit.text);
    writeln(f,'/s'+SortExpressionEdit.text);
    closefile(f);
    OpenDialog1.Filename := SaveDialog1.FileName;
  end;
end;

procedure TPrintDB.FileRadioButtonClick(Sender: TObject);
begin
  SetEnabled;
end;

procedure TPrintDB.FormActivate(Sender: TObject);
begin
  SetEnabled;
end;

procedure TPrintDB.SetEnabled;
begin
  FileName1.enabled:=FileRadioButton.checked;
  FileOpen.enabled:=FileRadioButton.checked;
end;

procedure TPrintDB.FileOpenClick(Sender: TObject);
begin
  SaveDialog2.filename:=Filename1.text;
  if SaveDialog2.Execute then
  begin
    filename1.text:=SaveDialog2.FileName;
  end;
end;

procedure TPrintDB.FormShow(Sender: TObject);
begin
  if not AskFilename then
  begin
{    filename1.visible:=false;
    fileopen.visible:=false;}
    FileNameGroupBox.visible:=false;
    DestinationGroupBox.visible:=false;
    SelectionGroupBox.visible:=false;
    ReportPanel.visible:=false;
    ClientHeight:=MaskGroupBox.height+Panel1.height+10;
  end;
end;

procedure TPrintDB.FormCreate(Sender: TObject);
var i:integer;
begin
  AskFilename:=true;
  SetPopup(ListPopupMenu,true);
  for i:=1 to ListPopupMenu.Items.count do
  begin
    ListPopupMenu.Items[i-1].onclick:=test1Click;
    SelComboBox.Items.add(ListPopupMenu.Items[i-1].caption);
  end;
  Currmemo:=CDHeaderMemo;
  CurrEdit:=nil;
end;

procedure TPrintDB.InsertVariable(s:string);
var p:integer;
begin
    s:=copy(s,1,pos('=',s)-1);
    if CurrMemo<>nil then
    with CurrMemo do
    begin
      p:=selstart;
      text:=copy(text,1,selstart)+s+copy(text,selstart+1,256);
      setfocus;
      selstart:=p+length(s);
      sellength:=0;
    end else
    with CurrEdit do
    begin
      p:=selstart;
      text:=copy(text,1,selstart)+s+copy(text,selstart+1,256);
      setfocus;
      selstart:=p+length(s);
      sellength:=0;
    end;
end;

procedure TPrintDB.test1Click(Sender: TObject);
begin
  with sender as TMenuItem do
    InsertVariable(ListPopupMenu.Items[tag].caption);
end;

procedure TPrintDB.CDHeaderMemoEnter(Sender: TObject);
begin
  Currmemo:=CDHeaderMemo;
  CurrEdit:=nil;
end;

procedure TPrintDB.ReportHeaderMemoEnter(Sender: TObject);
begin
  Currmemo:=ReportHeaderMemo;
  CurrEdit:=nil;
end;

procedure TPrintDB.TrackMemoEnter(Sender: TObject);
begin
  Currmemo:=TrackMemo;
  CurrEdit:=nil;
end;

procedure TPrintDB.CDHeaderMemoMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  CDHeaderMemoEnter(sender);
end;

procedure TPrintDB.ReportHeaderMemoMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  ReportHeaderMemoEnter(Sender);
end;

procedure TPrintDB.TrackMemoMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  TrackMemoEnter(Sender);
end;

procedure TPrintDB.SelectionEditEnter(Sender: TObject);
begin
  CurrEdit:=SelectionEdit;
  CurrMemo:=nil;
end;

procedure TPrintDB.SortExpressionEditEnter(Sender: TObject);
begin
  CurrEdit:=SortExpressionEdit;
  CurrMemo:=nil;
end;

procedure TPrintDB.SelectionEditMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SelectionEditEnter(Sender);
end;

procedure TPrintDB.SortExpressionEditMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SortExpressionEditEnter(Sender);
end;

procedure TPrintDB.SelComboBoxChange(Sender: TObject);
begin
  InsertVariable(SelComboBox.Items[SelComboBox.ItemIndex]);
end;

procedure TPrintDB.DefaultButtonClick(Sender: TObject);
begin
  SelectionEdit.text:='';
  SortExpressionEdit.text:='';
  TrackMemo.Lines.clear;
  CDHeaderMemo.Lines.clear;
  ReportHeaderMemo.Lines.clear;
  TrackMemo.Lines.add(TrackOutline);
  CDHeaderMemo.Lines.add(RecordOutline);
  ReportHeaderMemo.Lines.add(ReportOutline);
end;

end.
