unit Param;
{Component to handle start-up-parameters}
{based on an idea by Tom Moore ( Dagger@provalue.net)}
{Of coarse I know that there are ParamStr and ParamCount
to handle these, but when you use this component you can
enter the exact value at design-time, and look for the code very fast}
{it handles one parameter at a time}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Forms, Dialogs;


type
  TParamMatch = procedure(Sender: Tobject) of object;
  TNextMatch = procedure(Sender: Tobject; NextItem:string) of object;
  TRestMatch = procedure(Sender: Tobject; RestItem:string) of object;
  TParameter = class(TComponent)
  private
    { Private declarations }
    FParamString:pchar;
    FCheck:boolean;
    FParamMatch: TParamMatch;
    FNextMatch: TNextMatch;
    FRestMatch: TRestMatch;
    FFirstMatch: TRestMatch;
    FIsSwitch:boolean;
    FMatchCase:boolean;
    FMatchStart:boolean;
    FStartPos:byte;
  protected
    { Protected declarations }
    Procedure Loaded; Override;
    Procedure GetParameterList;
    Procedure NoWrite(value: TStringlist);
    Procedure WriteParamString(Value: String);
    function GetParamString:string;
    procedure SetCheck(b:boolean);
    procedure SetMatchStart(val:boolean);
    function compare(s1,s2:string):boolean;
  public
    { Public declarations }
    Constructor Create(AOwner : TComponent); override;
    destructor done;
  published
    { Published declarations }
    property Check:boolean read FCheck write SetCheck default true;
    {you can delay evaluating the parameter, e.i. because you need the value
     after the Formcreate}
    property IsSwitch:boolean read FIsSwitch write FIsSwitch default false;
    {if true, looks for '/' or '-' before the string}
    property MatchCase:boolean read FMatchCase write FMatchCase default false;
    {match uppercase yse/no}
    property MatchStart:boolean read FMatchStart write SetMatchStart default false;
    {look for value as part of the parameter yes/no}
    property StartPos:byte read FStartPos write FStartPos default 1;
    {if matchstart: set the starting position of the substring to look for}
    property ParamString:string read GetParamString write WriteParamString;
    {value of the parameter to look for}

    {mostly only one of the next procedures is assigned}
    property OnMatch: TParamMatch read FParamMatch write FParamMatch;
    {the simplest: if a parameter equals the value do this}
    property OnNext: TNextMatch read FNextMatch write FNextMatch;
    {when a match occurs, return the next parameter, if available.
    Use this for things like: program.. /open file_to_open}
    property OnRest: TRestMatch read FRestMatch write FRestMatch;
    {returns the rest of the parameter, after the part that matches
     Of coarse you should have MatchStart set to true to use this.
     use this for something like: program.. /open:file_to_open}
    property OnFirst: TRestMatch read FFirstMatch write FFirstMatch;
    {same as onrest, but it returns the starting characters, before
     the matching string.
     example:
       program.. f:\
       program.. d:\
     when you want to know the value before the ':\", use this onfirst}
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('System', [TParameter]);
end;

procedure TParameter.SetMatchStart(val:boolean);
begin
  FMatchStart:=val;
end;

function TParameter.GetParamString:string;
begin
  if FParamString<>nil then
  GetParamString:=strpas(FParamString) else
  GetParamString:='';
end;

procedure TParameter.SetCheck(b:boolean);
begin
  FCheck:=b;
  if csDesigning in ComponentState then exit;
  if FCheck then GetParameterList;
end;

function TParameter.compare(s1,s2:string):boolean;
begin
  if not fmatchcase then
  begin
    s1:=ansiuppercase(s1);
    s2:=Ansiuppercase(s2);
  end;
  if matchstart then s2:=copy(s2,FStartPos,length(s1));
  compare:=s1=s2;
end;

Procedure TParameter.GetParameterList;
var i: integer;
    s,tempstr,nr: string;
    startparm: boolean;
    inr,j:integer;
    FParamlist: TStringlist;
    FSwitchList: TStringlist;

    procedure DoMatch;
              begin
                if assigned(FParamMatch) then
                FParamMatch(Self);
                if assigned(FNextMatch) then
                if inr<paramcount then
                FNextMatch(Self, paramstr(inr+1));
                if assigned(FRestMatch) then
                begin
                  if length(nr)>length(s)+2 then
                  FRestMatch(Self, copy(nr,3+length(s)+FStartPos-1,length(nr)));
                end;
                if assigned(FFirstMatch) then
                begin
                  if length(nr)>length(s)+2 then
                  FFirstMatch(Self, copy(nr,3,FStartPos-1));
                end;
              end;

begin
 if not Fcheck then exit;
 FSwitchList:=TStringlist.create;
 FSwitchlist.sorted := False;
 fParamList:=TStringlist.Create;
 FParamlist.sorted := False;
 s:=GetParamString;
 if length(s)=0 then exit;
     Fparamlist.clear;
     startparm := False;
     for i := 1 to paramcount do
     begin
       str(i:2,nr);
          if (copy(paramstr(i), 1, 1) = '"') and
             (not startparm) then
          begin
               startparm := True;
               tempstr := '';
               tempstr := copy(paramstr(i), 2, length(paramstr(i)));
          end
          else if (copy(paramstr(i), length(paramstr(i)), 1) = '"') and
                    (startparm) then
          begin
               if length(paramstr(i)) > 1 then
                 tempstr := tempstr + ' ' +
                   copy(paramstr(i), 1, length(paramstr(i)) - 1)
               else tempstr := tempstr + ' ';
               if (copy(tempstr, 1, 1) = '-') or
                  (copy(tempstr, 1, 1) = '/') then
                    FSwitchlist.add(nr+copy(tempstr, 2, length(tempstr)))
               else
                    Fparamlist.add(nr+tempstr);
               startparm := False;
          end
          else if startparm then
               tempstr := tempstr + paramstr(i)
          else if (copy(Paramstr(i), 1, 1) = '-') or
                  (copy(Paramstr(i), 1, 1) = '/') then
                    FSwitchlist.add(nr+copy(Paramstr(i), 2, length(Paramstr(i))))
          else
                    Fparamlist.add(nr+Paramstr(i));
     end;
     begin
       if not FIsSwitch then
       for i := 0 to FParamlist.count - 1 do
          begin
                nr:=FParamList.Strings[i];
                val(copy(nr,1,2),inr,j);
             if compare(s,copy(nr,3,length(nr))) then
             DoMatch;
             end else
       for i := 0 to FSwitchlist.count - 1 do
          begin
            nr:=FSwitchList.Strings[i];
            val(copy(nr,1,2),inr,j);
            if compare(s,copy(nr,3,length(nr))) then
             DoMatch;
          end;
     end;
 FSwitchList.free;
 fParamList.free;
end;

Procedure TParameter.Loaded;
begin
 inherited Loaded;
 GeTParameterlist;
end;

Destructor TParameter.Done;
begin
 if FParamString<>nil then
 freemem(FParamString,strlen(FParamString)+1);
end;

Constructor TParameter.Create(AOwner : TComponent);
Begin
 inherited Create(AOwner);

 FCheck:=true;
 FParamString:=nil;
 FIsSwitch:=false;
 FMatchCase:=false;
 FMatchStart:=false;
 StartPos:=1;
End;

Procedure TParameter.WriteParamString(Value: String);
begin
  if FParamString<>nil then
  freemem(FParamString,strlen(FParamString)+1);
  getmem(FParamString,length(value)+1);
  strpcopy(FParamString,Value);
end;

procedure TParameter.NoWrite(value: TStringlist);
begin
  raise Exception.Create('Can''t modify a read-only property');
end;

end.
