unit Multlist;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Dialogs, ExtCtrls, Utils, Menus;

type
  TMultiListDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    MultiListListBox: TListBox;
    SaveButton: TButton;
    ReadButton: TButton;
    AddButton: TButton;
    PllOpenDialog: TOpenDialog;
    PllSaveDialog: TSaveDialog;
    ClearButton: TButton;
    PlayButton: TButton;
    DelButton: TButton;
    PopupMenu1: TPopupMenu;
    Del1: TMenuItem;
    Help: TBitBtn;
    procedure SaveButtonClick(Sender: TObject);
    procedure ReadButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure MultiListListBoxMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MultiListListBoxMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MultiListListBoxMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure PlayButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure MultiListListBoxDblClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    CDIds:TStringList;
    CurrentPlaylist:tstringlist;
    action:byte;
    mousedown:boolean;
    posidrag:integer;
    procedure EditCaption;
  end;

var
  MultiListDlg: TMultiListDlg;

function MultiTracknr(cdnr,trnr:byte;MultiList:TStringList):byte;
procedure MultiTotalTime(MultiList:TStringList;var min,sec:byte);
procedure MultiRestTime(cdnr,tr:byte;MultiList:TStringList;var min,sec:byte);
procedure MultiElapsedTime(cdnr,tr:byte;MultiList:TStringList;var min,sec:byte);

implementation

{$R *.DFM}

function MultiTracknr(cdnr,trnr:byte;MultiList:TStringList):byte;
var i,hcd,htr:byte;
    code:integer;
    out:byte;
begin
  out:=0;
  for i:=0 to MultiList.Count-1 do
  begin
    val(copy(MultiList[i],1,1),hcd,code);
    val(copy(MultiList[i],3,2),htr,code);
    if (cdnr=hcd) and (htr=trnr) then
    out:=i;
  end;
  MultiTracknr:=out+1;
end;

procedure addtime(s:string;var min,sec:byte);
var code:integer;
    ssec,smin:byte;
begin
  val(copy(s,length(s)-2,2),ssec,code);
  val(copy(s,length(s)-5,2),smin,code);
  min:=min+smin;
  sec:=sec+ssec;
  min:=min+sec div 60;
  sec:=sec mod 60;
end;

procedure MultiTotalTime(MultiList:TStringList;var min,sec:byte);
var i:integer;
begin
  min:=0;
  sec:=0;
  for i:=0 to MultiList.Count-1 do
  addtime(MultiList[i],min,sec);
end;

procedure MultiRestTime(cdnr,tr:byte;MultiList:TStringList;var min,sec:byte);
var i:integer;
begin
  tr:=MultiTracknr(cdnr,tr,MultiList);
  min:=0;
  sec:=0;
  for i:=tr to MultiList.Count-1 do
  addtime(MultiList[i],min,sec);
end;

procedure MultiElapsedTime(cdnr,tr:byte;MultiList:TStringList;var min,sec:byte);
var i:integer;
begin
  tr:=MultiTracknr(cdnr,tr,MultiList);
  min:=0;
  sec:=0;
  for i:=0 to tr-2 do
  addtime(MultiList[i],min,sec);
end;

procedure TMultiListDlg.SaveButtonClick(Sender: TObject);
var f:textfile;
    i:integer;
    s:string;
begin
  with PllSaveDialog do
  if Execute then
  begin
    assignfile(f,filename);
    rewrite(f);
    for i:=1 to CDIds.count do
    begin
      str(i:1,s);
      writeln(f,'-'+s+CDIds[i-1]);
    end;
    with MultiListListBox do
    for i:=1 to Items.count do
    writeln(f,Items[i-1]);
    closefile(f);
  end;
end;

procedure TMultiListDlg.ReadButtonClick(Sender: TObject);
var f:textfile;
    s:string;
begin
  with PllOpenDialog do
  if Execute then
  begin
    MultiListListbox.Items.clear;
    CDIds.clear;
    assignfile(f,filename);
    reset(f);
    while not eof(f) do
    begin
      readln(f,s);
      if s[1]='-' then CDIds.add(copy(s,3,length(s))) else
      MultiListListBox.Items.add(s);
    end;
    EditCaption;
  end;
end;

procedure TMultiListDlg.FormCreate(Sender: TObject);
begin
  CDIds:=TStringList.create;
  CurrentPlaylist:=tstringlist.create;
  mousedown:=false;
  action:=0;
end;

procedure TMultiListDlg.AddButtonClick(Sender: TObject);
var i:integer;
begin
  for i:=1 to CurrentPlaylist.count do
  MultiListListBox.Items.add(CurrentPlaylist[i-1]);
  EditCaption;
end;

procedure TMultiListDlg.ClearButtonClick(Sender: TObject);
begin
  MultiListListBox.Items.clear;
  EditCaption;
end;

procedure TMultiListDlg.MultiListListBoxMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  mousedown:=true;
    with Sender as TlistBox do
    begin
      posidrag:=ItemAtPos(Point(X, Y), True);
      setcapture(MultiListListBox.handle);
    end;
end;

procedure TMultiListDlg.MultiListListBoxMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  mousedown:=false;
  releasecapture;
end;

procedure TMultiListDlg.MultiListListBoxMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var s:string;
    hp:integer;
begin
  with Sender as TlistBox do
  if mousedown then
  if posidrag<>ItemAtPos(Point(X, Y), True) then
  begin
    if posidrag>=items.count then exit;
    s:=items[posidrag];
    hp:=ItemAtPos(Point(X, Y), True);
    if hp>=0 then
    begin
      items.delete(posidrag);
      items.insert(hp,s);
      posidrag:=hp;
      ItemIndex:=hp;
    end;
  end;
end;

procedure TMultiListDlg.PlayButtonClick(Sender: TObject);
begin
  action:=1;
  close;
end;

procedure TMultiListDlg.FormActivate(Sender: TObject);
begin
  EditCaption;
end;
procedure TMultiListDlg.EditCaption;
var min,sec:byte;
    h:TStringList;
    i:integer;
begin
  h:=TStringList.Create;
  for i:=0 to MultiListListBox.Items.Count-1 do
  h.add(MultiListListBox.Items[i]);
  MultiTotalTime(h,min,sec);
  Caption:='MultiList edit '+strtime(min*60+sec);
  h.free;
end;

procedure TMultiListDlg.MultiListListBoxDblClick(Sender: TObject);
begin
  action:=2;
  close;
end;

procedure TMultiListDlg.DelButtonClick(Sender: TObject);
var h:integer;
begin
  with MultiListListBox do
  begin
    h:=ItemIndex;
    if h>=0 then
    begin
      Items.delete(h);
      if Items.count<h-1 then dec(h);
      if h>0 then ItemIndex:=h;
    end;
  end;
end;

procedure TMultiListDlg.FormDestroy(Sender: TObject);
begin
  CDIds.free;
  CurrentPlaylist.free;
end;

end.
