unit Mmmain;

interface

uses
  SysUtils, WinTypes, WinProcs,  DbiProcs, DbiTypes, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, MPlayer, StdCtrls, mmSystem,DBTables, Gauges,
  IniFiles, Menus, Udigit, Lightchk, Slider, PrintFrm, DataBase,
  ShowDlg, Printers, DB, ExtCtrls, Captdisp, DispColr, Buttons
  ,Volume, MultList, Param, DdeMan ,Editfld , EdFldCnt,
  HelpUnit, Preview
  {$IFDEF trayicon}
  ,TrayIcn                         
  {$endif}
;

const
  NumDigits=14;
  StartDrive='d';
  MaxDrives=4;
  NumDrives:byte=0;
  PanelTopExtra=20;
  IntroTime=10;
  MinFormWidth:integer=104;
  FormWidth:integer=306;
  FormHeight:integer=252;
  StandardCaption:string='Cd Player';
type
  TrackLine=
  record
    track:Longint;
    TrackName:string;
    TrackLen:Longint;
  end;
    TMediaplus=class (TMediaplayer)
    end;
  TTrackInfo = class(tComponent)
  private
    stl:tstringlist;
    function GetRecord(Index:Integer):TrackLine;
    procedure WriteRecord(Index:integer;Rstl:TrackLine);
    function GetName(Index:Integer):string;
    procedure WriteName(Index:integer;Name:string);
    constructor create(AOwner: TComponent);
    destructor destroy; virtual;
  public
    property TrackInfo[Index:integer]:TrackLine read GetRecord
       write WriteRecord;
    property TrackName[Index:integer]:string read GetName
      write writeName;
  end;

  ExtraLine=
  record
    track:Longint;
    TrackName:string;
    TrackStart,TrackEnd:integer;
  end;
  TExtraInfo = class(tComponent)
  private
    stl:tstringlist;
    function GetRecord(Index:Integer):ExtraLine;
    procedure WriteRecord(Index:integer;Rstl:ExtraLine);
    function GetName(Index:Integer):string;
    procedure WriteName(Index:integer;Name:string);
    constructor create(AOwner: TComponent);
    destructor destroy; virtual;
    procedure SetCOunt(c:integer);
    function ReadCount:integer;
    procedure SetStart(Index:integer;i:integer);
    function GetStart(Index:integer):integer;
    procedure SetEnd(Index:integer;i:integer);
    function GetEnd(Index:integer):integer;
    function GetTrackLen(Index:integer):longint;
    function GetTrack(Index:integer):integer;
  public
    procedure clear;
    procedure add(htrack:byte;hTrackName:string;hTrackStart,hTrackEnd:integer);
    property TrackStart[Index:integer]:integer read GetStart write SetStart;
    property TrackEnd[Index:integer]:integer read GetEnd write SetEnd;
    property TrackInfo[Index:integer]:ExtraLine read GetRecord
       write WriteRecord;
    property TrackName[Index:integer]:string read GetName
      write writeName;
    property Count:integer read ReadCount write SetCount;
    property TrackLen[Index:integer]:longint read GetTrackLen;
    property Track[Index:integer]:integer read GetTrack;
  end;

type
  TDeviceInfo = Class(tObject)
  public
    Tracce  : tStringList;
    FDeviceId   : LongInt;
    CDName      : String;
    Style       : integer;
    year        : string;
    TrackCount  : LongInt;
    TInfo  : TTrackInfo;
    EInfo  : TExtraInfo;
    CDPlayerCode:string255;
    CdUniqueCode: String;
    constructor Create(wDeviceId: LongInt);
    destructor Destroy; override;
  end;

type
  TCdPlay = class(TForm)
    Panel1: TPanel;
    TrackLabel: TLabel;
    ElapsedTimeLabel: TLabel;
    TimeLabel: TLabel;
    Panel2: TPanel;
    Timer1: TTimer;
    TitleLabel: TLabel;
    MainMenu1: TMainMenu;
    View: TMenuItem;
    TrackList: TMenuItem;
    About1: TMenuItem;
    Programs: TMenuItem;
    TrackDigit1: TDigit;
    TrackDigit2: TDigit;
    ElapDigit1: TDigit;
    ElapDigit2: TDigit;
    ElapDigit3: TDigit;
    ElapDigit4: TDigit;
    TimeDigit1: TDigit;
    TimeDigit2: TDigit;
    TimeDigit3: TDigit;
    TimeDigit4: TDigit;
    TotTracksDigit1: TDigit;
    TotTracksDigit2: TDigit;
    PowerLightCheck: TLightCheck;
    PowerLabel: TLabel;
    SliderPanel: TPanel;
    PositionSlider: TSlider;
    PosLabel: TLabel;
    File1: TMenuItem;
    Save1: TMenuItem;
    Reread1: TMenuItem;
    EraseCD: TMenuItem;
    PopupMenu1: TPopupMenu;
    Table1: TTable;
    Exit1: TMenuItem;
    Current1: TMenuItem;
    EraseTextfile1: TMenuItem;
    ListPopup: TPopupMenu;
    Play1: TMenuItem;
    Delete1: TMenuItem;
    Settings1: TMenuItem;
    AutoSave: TMenuItem;
    N2: TMenuItem;
    ElapsedTime: TMenuItem;
    TotalTime: TMenuItem;
    AutoPlay: TMenuItem;
    ContinuePlaying: TMenuItem;
    N1: TMenuItem;
    Database1: TMenuItem;
    N3: TMenuItem;
    Track1: TMenuItem;
    DeleteTrack1: TMenuItem;
    N8: TMenuItem;
    NextTrack1: TMenuItem;
    PreviousTrack: TMenuItem;
    PlayTrack1: TMenuItem;
    N9: TMenuItem;
    RepeatTrack1: TMenuItem;
    RepeatLightCheck: TLightCheck;
    IntroLightCheck: TLightCheck;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    PowerWindowOnLabel: TLabel;
    N10: TMenuItem;
    MediumWindow: TMenuItem;
    LargeWindow: TMenuItem;
    TrackDisplayOnLabel: TLabel;
    TimeVisibleLabel: TLabel;
    SmallWindow: TMenuItem;
    N11: TMenuItem;
    CaptionDisplay1: TMenuItem;
    CloursDisplay1: TMenuItem;
    PauseTrack1: TMenuItem;
    StopTrack1: TMenuItem;
    N13: TMenuItem;
    EjectTray1: TMenuItem;
    Minimum1: TMenuItem;
    MinimizeLabel: TLabel;
    PlayBitBtn: TBitBtn;
    PauseBitBtn: TBitBtn;
    PreviousBitBtn: TBitBtn;
    EjectBitBtn: TBitBtn;
    StopBitBtn: TBitBtn;
    NextBitBtn: TBitBtn;
    HalfTitleLabel1: TLabel;
    HalfTitleLabel2: TLabel;
    PlaylistNumber1: TMenuItem;
    BottomLabel1: TLabel;
    BottomLabel2: TLabel;
    MainPopupMenu: TPopupMenu;
    Minimum1pop: TMenuItem;
    Small1pop: TMenuItem;
    Medium1pop: TMenuItem;
    Large1pop: TMenuItem;
    N14: TMenuItem;
    N16: TMenuItem;
    Selecttrack1: TMenuItem;
    Window1: TMenuItem;
    Shuffle1: TMenuItem;
    IntroScan: TMenuItem;
    Select1: TMenuItem;
    N15: TMenuItem;
    Volumecontrol1: TMenuItem;
    Alternate1: TMenuItem;
    N4: TMenuItem;
    INIfile1: TMenuItem;
    Save2: TMenuItem;
    Read1: TMenuItem;
    IniOpenDialog: TOpenDialog;
    IniSaveDialog: TSaveDialog;
    ResetInifile: TMenuItem;
    N18: TMenuItem;
    Autoswitch1: TMenuItem;
    CDdrive1: TMenuItem;
    Clocktotal1: TMenuItem;
    N19: TMenuItem;
    Hide1: TMenuItem;
    Multilist1: TMenuItem;
    ElapDigit0: TDigit;
    TimeDigit0: TDigit;
    DriveParameter: TParameter;
    CDPlayer: TDdeServerConv;
    N17: TMenuItem;
    Pack1: TMenuItem;
    AutoAsk1: TMenuItem;
    EnterDataTimer: TTimer;
    MyToolBar: TPanel;
    DatabaseSpeedButton: TSpeedButton;
    N20: TMenuItem;
    Toolbar1: TMenuItem;
    SaveSpeedButton: TSpeedButton;
    PrintSpeedButton: TSpeedButton;
    ShuffleSpeedButton: TSpeedButton;
    DelTrackSpeedButton: TSpeedButton;
    VolumeSpeedButton: TSpeedButton;
    CaptionSpeedButton: TSpeedButton;
    Ignore1trackCD: TMenuItem;
    Help1: TMenuItem;
    Help: TMenuItem;
    TrackChangedTimer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AutoSaveClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ProgramsClick(Sender: TObject);
    procedure Mediaplay1Notify(Sender: TObject);
    procedure Mediaplay1Click(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
    procedure FormActivate(Sender: TObject);
    procedure SelectTrackComboBoxChange(Sender: TObject);
    procedure TrackListClick(Sender: TObject);
    procedure PowerLightCheckKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ElapsedTimeClick(Sender: TObject);
    procedure TotalTimeClick(Sender: TObject);
    procedure PositionSliderMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PositionSliderKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PositionSliderMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PositionSliderKeydown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PositionSliderValueChange(Sender: TObject);
    procedure Shuffle1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Reread1Click(Sender: TObject);
    procedure EraseCDClick(Sender: TObject);
    procedure TrackDigit1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PopupMenuClick(Sender: TObject);
    procedure AutoPlayClick(Sender: TObject);
    procedure ContinuePlayingClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Current1Click(Sender: TObject);
    procedure EraseTextFile1Click(Sender: TObject);
    procedure IntroScanClick(Sender: TObject);
    procedure Database1Click(Sender: TObject);
    procedure Play1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure DeleteTrackClick(Sender: TObject);
    procedure NextTrack1Click(Sender: TObject);
    procedure PreviousTrackClick(Sender: TObject);
    procedure PlayTrack1Click(Sender: TObject);
    procedure RepeatTrack1Click(Sender: TObject);
    procedure PowerWindowOnLabelClick(Sender: TObject);
    procedure MediumWindowClick(Sender: TObject);
    procedure LargeWindowClick(Sender: TObject);
    procedure TimeVisibleLabelClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Shape2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TrackDisplayOnLabelClick(Sender: TObject);
    procedure CaptionDisplay1Click(Sender: TObject);
    procedure CloursDisplay1Click(Sender: TObject);
    procedure PauseTrack1Click(Sender: TObject);
    procedure StopTrack1Click(Sender: TObject);
    procedure EjectTray1Click(Sender: TObject);
    procedure Minimum1Click(Sender: TObject);
    procedure PlaylistNumber1Click(Sender: TObject);
    procedure BottomLabel1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PlayIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PauseIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure StopIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure NextIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PreviousIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure EjectIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MainIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MainPopupMenuPopup(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure ElapDigit1Click(Sender: TObject);
    procedure Shape4MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Panel1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RepeatLightCheckClick(Sender: TObject);
    procedure IntroLightCheckClick(Sender: TObject);
    procedure PowerLightCheckClick(Sender: TObject);
    procedure Volumecontrol1Click(Sender: TObject);
    procedure Alternate1Click(Sender: TObject);
    procedure AutoSwitch1Click(Sender: TObject);
    procedure SetDeviceType(MyDeviceType: TMPDeviceTypes);
    procedure Device11Click(Sender: TObject);
    procedure Read1Click(Sender: TObject);
    procedure Save2Click(Sender: TObject);
    procedure ResetInifileClick(Sender: TObject);
    procedure Clocktotal1Click(Sender: TObject);
    procedure Hide1Click(Sender: TObject);
    procedure Apply1Click(Sender: TObject);
    procedure Multilist1Click(Sender: TObject);
    procedure DriveParameterFirst(Sender: TObject; RestItem: String);
    procedure CDPlayerExecuteMacro(Sender: TObject; Msg: TStrings);
    procedure Pack1Click(Sender: TObject);
    procedure AutoAsk1Click(Sender: TObject);
    procedure EnterDataTimerTimer(Sender: TObject);
    procedure Toolbar1Click(Sender: TObject);
    procedure Ignore1trackCDClick(Sender: TObject);
    procedure HelpClick(Sender: TObject);
    procedure HelpContextClick(Sender: TObject);
    function MyHelp(Command: Word; Data: Longint;   var CallHelp: Boolean): Boolean;
    procedure TrackChangedTimerTimer(Sender: TObject);
  private
    DriveLetters:string;
    CurrentDrive:byte;
    MyVolumeDlg: TVolumeDlg;
  {$IFDEF trayicon}
    TrayIcon:TTrayIconForm;
   {$ENDIF}
    MyDigits:array[1..NumDigits] of TDigit;
    SurfaceColour,BackGroundColour,TrackTitleColour,LabelColour,DigitsColour:TColor;
    DeviceInfo   : TDeviceInfo;
    DriveLetter:array[1..maxDrives] of char;
    DeviceOpened : Boolean;
    DeviceExist  : Boolean;
    SpentCount   : Longint;
    MainHalfTitle: string;
    DisplayBottomItems:byte;
    Procedure WMGetDlgCode(var Msg:TWMGetDlgCode);
	      message wm_GetDlgCode;
    procedure SetDisplayColours(SColour,bgColour,TTColour,DGColour,LBColour:TColor);
    procedure PlayMultiTrack(cdnr1,prognr1,trnr:integer);
    procedure PlayMultiItem(ItemIndex:integer);
    procedure PickupPlaying(tr:integer);
    procedure ContrIntro(tr:integer);
    procedure DeviceOpen;
    procedure DeviceInfoFree;
    procedure ContinueTrack;
    procedure DeviceClose;
    procedure GetDeviceInfo(DeviceInfo:TDeviceInfo);
    procedure SaveDeviceInfo(DeviceInfo:TDeviceInfo);
    Function FindNextTrack : Boolean;
    Function FindPrevTrack : Boolean;
    function CalcTotalTime:longint;
    procedure calcextratime(tr:integer;var min2,sec2:byte);
    procedure SelectTrackProc(n:byte);
    procedure SetErase(b:boolean);
    procedure SelectPopupTrack(var MI:TMenuItem);
    procedure SetMenuOptions(b:boolean);
    procedure ReadSettings(s:string);
    procedure WriteSettings(s:string);
    procedure SetMediaButtons;
    procedure SetCheckMarks;
    procedure CalcExtra;
    function badtrack(tr:integer):boolean;
    function PlayListAt(i:integer):integer;
    procedure SetCurrentTime(tr:integer);
    function playtrack:boolean;
    procedure ReactSlider;
    procedure setcaption;
    procedure setbottom;
    procedure SetTitle(t:string);
    procedure checkpower;
    procedure SetTotalTime;
    procedure StartSlider;
    function CalcRunningTime:longint;
    function CurrentMediaplayer:TMediaPlus;
    procedure setpointon;
    { Private declarations }
   Procedure KeyDown(var Key:Word;
		   Shift:TShiftState);override;
   procedure wmHandleMessages(var Msg:TMsg;var Handled:Boolean);
   procedure SetSelectTrack;
   procedure CopyMainToPop;
   procedure GetPlayTime(i:integer;var min2,sec2:byte);
   function GetTrackName(i:integer):string;
  public
    { Public declarations }
    pointon:boolean;
    newitem,playing,paused:boolean;
    CurrentExtraTrack:boolean;
    ExtraStart,ExtraEnd:integer;
    ExtraTitle:string;
    posilistbox:integer;
    lightsoff:boolean;
    PlayList,programlist,MultiPlayList,MultiList:tstringlist;
    currenttrack,prevtrack:integer;
    Mediaplay1:TMediaplus;
    procedure CheckForAvailableCDROMS;
    procedure ShowWindows;
    procedure DispTimeVisible;
    procedure ChangeTimeVisible;
    procedure dopause(Button: TMPBtnType);
    function HasDisk:boolean;
    procedure Minimum1Set(BNew:boolean);
    procedure clearbottom;
    procedure SmallWindowChecked(b:boolean);
    procedure MediumWindowChecked(b:boolean);
    procedure LargeWindowChecked(b:boolean);
    procedure  DisplaySettings;
  end;

var
  CdPlay: TCdPlay;

implementation
Uses GetTrack, CdAbout, CdProgr,utils;
{$R *.DFM}

function TCdPlay.MyHelp(Command: Word; Data: Longint ;  var CallHelp: Boolean): Boolean;
begin
  HelpForm.ShowMyHelp(xstr(data,1,0));
end;

destructor TTrackInfo.destroy;
begin
   stl.free;
   inherited destroy;
end;
constructor TTrackInfo.create(AOwner: TComponent);
begin
  inherited create(AOwner);
  stl:=tstringlist.create;
end;
function TTrackInfo.GetName(Index:Integer):string;
begin
  GetName:=TrackInfo[Index].Trackname;
end;
procedure TTrackInfo.WriteName(Index:integer;Name:string);
var TLine:TrackLine;
begin
  TLine:=TrackInfo[Index];
  TLine.TrackName:=Name;
  TrackInfo[Index]:=TLine;
end;
function TTrackInfo.GetRecord(Index:Integer):TrackLine;
var hi:integer;
    htr:TrackLine;
begin
  If (Index<=stl.Count) and (Index>0) then
  with htr do
  begin
    val(copy(stl[Index-1],1,2),Track,hi);
    val(copy(stl[Index-1],3,7),TrackLen,hi);
    TrackName:=copy(stl[Index-1],10,255);
  end else
{  ShowMessage('Index too large for array')};
  GetRecord:=htr;
end;
procedure TTrackInfo.WriteRecord(Index:integer;Rstl:TrackLine);
var i:integer;
begin
  for i:=stl.Count to Index-1 do stl.add('');
  with rstl do
  stl[Index-1]:=xstr(Track,2,0)+xstr(TrackLen,7,0)+TrackName;
end;

destructor TExtraInfo.destroy;
begin
   stl.free;
   inherited destroy;
end;
constructor TExtraInfo.create(AOwner: TComponent);
begin
  inherited create(AOwner);
  stl:=tstringlist.create;
end;
function TExtraInfo.GetName(Index:Integer):string;
begin
  GetName:=TrackInfo[Index].Trackname;
end;
procedure TExtraInfo.WriteName(Index:integer;Name:string);
var TLine:ExtraLine;
begin
  TLine:=TrackInfo[Index];
  TLine.TrackName:=Name;
  TrackInfo[Index]:=TLine;
end;
function TExtraInfo.ReadCount:integer;
begin
  ReadCount:=stl.Count;
end;
function TExtraInfo.GetRecord(Index:Integer):ExtraLine;
var hi:integer;
    htr:ExtraLine;
begin
  If Index<=stl.Count then
  with htr do
  begin
    val(copy(stl[Index-1],1,2),Track,hi);
    val(copy(stl[Index-1],3,4),TrackStart,hi);
    val(copy(stl[Index-1],7,4),TrackEnd,hi);
    TrackName:=copy(stl[Index-1],11,255);
  end else
  ShowMessage('Index too large for array');
  GetRecord:=htr;
end;
procedure TExtraInfo.add(htrack:byte;hTrackName:string;hTrackStart,hTrackEnd:integer);
var r:ExtraLine;
begin
  with r do
  begin
    Track:=htrack;
    TrackName:=hTrackName;
    TrackStart:=hTrackStart;
    TrackEnd:=hTrackEnd;
  end;
  WriteRecord(Count+1,r);
end;

procedure TExtraInfo.WriteRecord(Index:integer;Rstl:ExtraLine);
var i:integer;
begin
  for i:=stl.Count to Index-1 do stl.add('');
  with rstl do
  stl[Index-1]:=xstr(Track,2,0)+xstr(TrackStart,4,0)+xstr(TrackEnd,4,0)+TrackName;
end;

procedure TExtraInfo.clear;
begin
  stl.clear;
end;

function TExtraInfo.GetTrackLen(Index:integer):longint;
var r:ExtraLine;
begin
  r:=TrackInfo[Index];
  with r do
  begin
    GetTrackLen:=(TrackEnd-TrackStart)
  end;
end;

procedure TExtraInfo.SetCOunt(c:integer);
var i:integer;
begin
  for i:=stl.Count-1 downto c do
  stl.delete(i);
end;
function TExtraInfo.GetTrack(Index:integer):integer;
begin
  GetTrack:=TrackInfo[Index].Track;
end;
procedure TExtraInfo.SetStart(Index:integer;i:integer);
var TLine:ExtraLine;
begin
  TLine:=TrackInfo[Index];
  TLine.TrackStart:=i;
  TrackInfo[Index]:=TLine;
end;
function TExtraInfo.GetStart(Index:integer):integer;
var TLine:ExtraLine;
begin
  TLine:=TrackInfo[Index];
  GetStart:=TLine.TrackStart;
end;
procedure TExtraInfo.SetEnd(Index:integer;i:integer);
var TLine:ExtraLine;
begin
  TLine:=TrackInfo[Index];
  TLine.TrackEnd:=i;
  TrackInfo[Index]:=TLine;
end;
function TExtraInfo.GetEnd(Index:integer):integer;
var TLine:ExtraLine;
begin
  TLine:=TrackInfo[Index];
  GetEnd:=TLine.TrackEnd;
end;

function valstr(s:string):integer;
var h,hi:integer;
begin
  val(s,h,hi);
  valstr:=h;
end;

function posparamstr(titel:string):byte;
var i,j:byte;
begin
  j:=0;
  titel:=uppercase(titel);
  for i:=1 to paramcount do
  if pos(titel,uppercase(paramstr(i)))>0 then j:=i;
  posparamstr:=j;
end;

function rname(diskname:string):string;
var p,p2:integer;
    hs:string;
begin
  p:=pos(';',diskname);
  if p>0 then
  begin
    hs:=copy(diskname,p+1,length(diskname));
    p2:=pos(':',hs);
    if p2>0 then
    hs:=ltrim(trim(copy(hs,1,p2-1)))+' '+trim(copy(diskname,1,p-1))+
	' : '+ltrim(copy(hs,p2+1,length(hs)))
    else hs:=trim(hs)+' '+trim(copy(diskname,1,p-1));
  end else hs:=diskname;
  p2:=pos(':',hs);
  if p2>0 then
  hs:=trim(copy(hs,1,p2-1))+' : '+ltrim(copy(hs,p2+1,length(hs)));
  rname:=hs;
end;

{$IFDEF ver80}
function IsCDROM(Drive:{integer}word):boolean;assembler;
asm
  mov ax,1500h{look for MSCDEX}
  xor bx,bx
  int 2fh
  or bx,bx
  jz @finish
  mov ax,150Bh {check for using CD driver}
  mov cx,Drive
  int 2fh
  or ax,ax
  @finish:
end;
{$endif}

function MciTime(TrackLen:longint):string;
begin
  MciTime:=strtime(60*mci_MSF_Minute(TrackLen)+mci_MSF_Second(TrackLen))
end;

function CalcTrackLen(wDeviceId, CurrTrack :LongInt):Longint;
Var  StatusParm: TMCI_Status_Parms;
     FFlags    : Longint;
     FError    : Longint;

Begin
  FFlags := mci_Wait or mci_Status_Item or mci_Track;
  StatusParm.dwItem  := mci_Status_Length;
  StatusParm.dwTrack := CurrTrack;
  FError             := mciSendCommand( wDeviceID, mci_Status, FFlags, Longint(@StatusParm));
  if FError <> 0 then
    raise EMCIDeviceError.Create(Format('Cannot read information on track nr. %2d',[CurrTrack]));
  CalcTrackLen       := StatusParm.dwReturn;
End;
{ Delphi sample  Edy Hinzen 1997 }
type
  tMSFRec = record
    Minutes : Byte;     {least significant byte}
    Seconds : Byte;
    Frames  : Byte;
    NotUsed : Byte;     {most significant byte}
  end;

const
  FRAME_PER_SEC   = 75;

function MilliSecsToFrames(milliSecs:LongInt):LongInt;
begin
  Result := millisecs * FRAME_PER_SEC DIV 1000;
  { did the division have a reminder? then inc result by 1 }
  if millisecs <> (Result * 1000 DIV FRAME_PER_SEC) then inc(Result);
end;

function GetCdplayerid(Mediaplayer1:TMediaplus):string;
var
  tracknumb     : Integer;
  magicNumb     : Byte;
  dwTemp,
  dwID          : LongInt;
  minutes,seconds:longint;
begin
  { activate MediaPlayer1 to get the DeviceID }

  With MediaPlayer1 do
  begin
    timeFormat := tfMSF;                    {set time format}
    dwID := 0;
    For tracknumb := 1 To Tracks do
    begin
      dwTemp := TrackPosition[tracknumb];
      begin
	  Minutes := mci_MSF_Minute(dwTemp);
	  Seconds := mci_MSF_Second(dwTemp);
	  Frames  := mci_MSF_Frame(dwTemp);
	dwID := dwID +
	(Minutes  SHL 16)+
	(Seconds SHL 8)+
	(Frames);
	if trackNumb = 1 then magicNumb := Frames;
      end;
    end;
    if Tracks < 3 then
    begin
      { this should work: added 09/97}
      dwID := dwID + magicNumb;
      timeFormat := tfMilliseconds;
      dwID := dwID + MilliSecsToFrames(Length);
    end;
    end;{with}
    Mediaplayer1.TimeFormat := tfTMSF;
    if MediaPlayer1.Tracks < 3 then
      if dwid>$FFFFF then dwid:=dwid-$21;{added by anton bil, because
	some CD's with large playtime show a difference}
    { Set text to unique value: }
    GetCdplayerid := IntToHex(dwID,1);
end;

constructor TDeviceInfo.Create(wDeviceId: LongInt);
Var i         : Longint;
    FFlags    : Longint;
    StatusParm: TMCI_Status_Parms;
    SetParm   : TMCI_Set_Parms;
    FError    : Longint;
    tl,htl:longint;
    s:string;
    TLine:TrackLine;
begin
  inherited Create;
  Tracce := tStringList.Create;
  TInfo := TTrackInfo.create(nil);
  EInfo := TExtraInfo.create(nil);
  FDeviceId         := wDeviceId;
  CDName            := '';
  {Setta il tempo in minuti, secondi, frame}
  FFlags               := mci_Notify or mci_Set_Time_Format;
  SetParm.dwTimeFormat := Longint(tfMSF);
  FError               := mciSendCommand( FDeviceID, mci_Set, FFlags, Longint(@SetParm) );
  if FError <> 0 then
    raise EMCIDeviceError.Create('Cannot change time to MSF');

  {Conta le tracce}
  FFlags            := mci_Wait or mci_Status_Item;
  StatusParm.dwItem := mci_Status_Number_Of_Tracks;
  FError            := mciSendCommand( FDeviceId, mci_Status, FFlags, Longint(@StatusParm));
  if FError <> 0 then
{    raise EMCIDeviceError.Create('Cannot count device tracks');}exit;

  TrackCount        := StatusParm.dwReturn;
  tl:=0;
  CdUniqueCode:='';
  For i := 1 to TrackCount do
  Begin
    TLine.TrackName:= Format('Track %2d',[i]);;
    Tline.Track:=i;
    TLine.Tracklen:=CalcTrackLen(FDeviceId,i);
    TInfo.TrackInfo[i]:=TLine;
    With TInfo.TrackInfo[i] do
    Begin
      htl:=60*mci_MSF_Minute(TrackLen)+mci_MSF_Second(TrackLen);
      tl:=tl+htl;
      s:=xstr(htl,4,0);
      while s[1]=' ' do s:=copy(s,2,length(s));
      if i<=10 then
      CdUniqueCode:=CdUniqueCode+s;
    End
  End;
  tl:=tl+(TrackCount div 2);
  s:=xstr(tl,4,0);
  while s[1]=' ' do s:=copy(s,2,length(s));
  CdUniqueCode:=s+CdUniqueCode;

  {Setta il tempo in tracce, minuti, secondi, frame}
  FFlags               := mci_Notify or mci_Set_Time_Format;
  SetParm.dwTimeFormat := Longint(tfTMSF);
  FError               := mciSendCommand( FDeviceID, mci_Set, FFlags, Longint(@SetParm) );
  if FError <> 0 then
    raise EMCIDeviceError.Create('Cannot change time to TMSF');
End;

destructor TDeviceInfo.Destroy;
Begin
  Tracce.destroy;
  TInfo.Destroy;
  EInfo.Destroy;
End;

Procedure TCdPlay.KeyDown(var Key:Word;Shift:TShiftState);
begin
inherited KeyDown(Key,Shift);
if NextTrack1.enabled then
Case Key Of
     vk_End:begin
	      currenttrack:=PlayList.count-1;
	      playtrack;
	    end;
     vk_Home:begin
	      currenttrack:=0;
	      playtrack;
	    end;
     vk_Left:PreviousTrackClick(Self);
     vk_Right:NextTrack1Click(Self);
    end;
end;

Procedure TCdPlay.WMGetDlgCode(var Msg:TWMGetDlgCode);
begin
inherited;
  Msg.Result:=dlgc_WantArrows;
end;

procedure TCdPlay.SetErase(b:boolean);
begin
  EraseCD.Enabled:=b;
  Reread1.enabled:=b;
end;

procedure DeleteItems(var Tracce:TStringList);
var i:integer;
function BeginSt(tekst:string):boolean;
begin
  BeginSt:=tekst=copy(Tracce[i],1,length(tekst));
end;
function BeginLt(s:string):boolean;
var h:boolean;
    j:integer;
begin
  h:=false;
  for j:=1 to 50 do
  if BeginSt(s+xstr(j,1,0)+'=') then h:=true;
  BeginLt:=h;
end;
begin
  for i:=Tracce.count-1 downto 0 do
  begin
    if BeginSt('Program=') or BeginLt('T') or
      BeginLt('X') or BeginLt('P') then
    Tracce.delete(i);
  end;
end;

procedure TCdPlay.GetDeviceInfo(DeviceInfo:TDeviceInfo);
var I  : Integer;
    s,hs:string;
    FoundIt:boolean;
begin
  DeviceInfo.CDPlayerCode:=GetCdplayerid(Mediaplay1);
  newitem:=true;
  Deviceinfo.Tracce.clear;
  with Table1 do
  if Findkey([DeviceInfo.CDPlayerCode]) or Findkey([DeviceInfo.CDUniqueCode])
  then
  begin
    FoundIt:=true;
    with DeviceInfo do
    begin
      GetRecord(Table1,CDUniqueCode,CDName,year,Style,Tracce);
    end;
  end else
    FoundIt:=false;
{  DeviceInfo.CDUniqueCode:=DeviceInfo.CDPlayerCode;}
  PlayList.clear;
  clearbottom;
  DeviceInfo.EInfo.clear;
  programlist.clear;
  MainHalfTitle:='';
  If DeviceInfo.Tracce.Count = 0 then
  Begin
    with DeviceInfo do
    begin
      CDName := 'Unknown:New CD';
      year:='    ';
      Style:=0;
    end;
    for i:=1 to StringFieldNames.count do
    begin
      if DefaultValues[i-1]<>'' then
      DeviceInfo.Tracce.add(StringFieldNames[i-1]+'='+
      GetDefaults(DefaultValues[i-1]));
    end;
    DeviceExist := False;
  End
  Else
  Begin
    DeviceExist := True;
    For i := 1 to DeviceInfo.TrackCount do
    begin
      DeviceInfo.TInfo.TrackName[i]:=before(DeviceInfo.Tracce.Values['T'+xstr(i,1,0)]);
    end;
    s:=DeviceInfo.Tracce.Values['Program'];
    s:=copy(s,pos('-',s)+1,255);
    for i:=1 to length(s) div 2 do
    begin
      hs:=copy(s,(i-1)*2+1,2);
      if hs<>'  ' then PlayList.add(hs);
    end;
    i:=1;
    repeat
      s:=DeviceInfo.Tracce.Values['P'+xstr(i,1,0)];
      s:=copy(s,pos('-',s)+1,255);
      if s<>'' then
      ProgramList.add(s);
      inc(i);
    until s='';
    i:=1;
    repeat
      s:=DeviceInfo.Tracce.Values['X'+xstr(i,1,0)];
      s:=copy(s,pos('-',s)+1,255);
      if s<>'' then
      with DeviceInfo do
      begin
	hs:=behind(s);
	EInfo.add(valstr(copy(s,1,2)),copy(before(s),3,255),
	  calctime(copy(hs,1,5)),calctime(copy(hs,6,5)));
    end;
      inc(i);
    until s='';
  End;
  SetErase(DeviceExist);
  DeleteItems(DeviceInfo.Tracce);
  setcaption;
  if PlayList.count=0 then
  For i := 1 to DeviceInfo.TrackCount do
    PlayList.add(xstr(i,2,0));
  SetSelectTrack;
  If not FoundIt and AutoAsk1.checked then
  EnterDataTimer.enabled:=true;
end;

procedure TCdPlay.SetSelectTrack;
begin
  SelectPopupTrack(Select1);
end;

function TCDPlay.CalcRunningTime:longint;
{calculates the time of the current running track.
 It also determines the (string-)title of the running track}
var sec2,min2:longint;
    tr:byte;
begin
      tr  := mci_TMSF_Track(Mediaplay1.Position);
      if not CurrentExtraTrack then
      with DeviceInfo.TInfo.TrackInfo[tr] do
      begin
	sec2 := mci_MSF_Second(TrackLen);
	min2 := mci_MSF_Minute(TrackLen);
	ExtraEnd := (Sec2 + (Min2*60));
	SetTitle(TrackName);
      end;
      CalcRunningTime:=ExtraEnd-ExtraStart;
end;

procedure TCDPlay.setbottom;
procedure setbottompart(var l:TLabel;i:integer;code:string);
var s:string255;
begin
  if deviceopened then
  with l,deviceinfo do
  begin
    Caption:='';
    s:=code;
    if s='' then exit;
    s:=GetDefaults(s);
    ChangeOutline(s,DeviceInfo.CDPlayerCode,DeviceInfo.CDName,
    DeviceInfo.year,
  DeviceInfo.style,PlayList.count,CalcTotalTime,ExtraTitle,
  strtime(CalcRunningTime),
	currenttrack+1,DeviceInfo.Tracce,false);
    Caption:=copy(s,1,255);
  end else caption:='';
  if l.caption='' then l.visible:=false;
end;
begin
  case DisplayBottomItems of
    1:begin
	BottomLabel1.visible:=false;
	BottomLabel2.visible:=false;
	PositionSlider.visible:=true;
      end;
    2,3:
    begin
	BottomLabel1.visible:=true;
	BottomLabel2.visible:=true;
	PositionSlider.visible:=false;
        setbottompart(BottomLabel1,1,BottomLine1);
        setbottompart(BottomLabel2,2,BottomLine2);
    end;
  end;
  if DisplayBottomItems=2 then
  begin
    if not BottomLabel1.visible and not BottomLabel2.visible
    then PositionSlider.visible:=true;
  end;
end;

procedure TCDPlay.setcaption;
var s:string255;
procedure CaptionAdd(s:string);
begin
  Self.Caption:=Self.Caption+' '+s;
end;
begin
  if not deviceopened then
  Self.Caption := StandardCaption+' - Unknown' else
  if not playing then
  Self.Caption := rname(DeviceInfo.CDName) else
  begin
    Caption:='';
    s:=CaptionDefine;
    s:=GetDefaults(s);
    ChangeOutline(s,DeviceInfo.CDPlayerCode,DeviceInfo.CDName,
    DeviceInfo.year,
  DeviceInfo.style,PlayList.count,CalcTotalTime,ExtraTitle,
  strtime(CalcRunningTime),
	currenttrack+1,DeviceInfo.Tracce,false);
    Caption:=copy(s,1,255);
{    for i:=1 to NumButtons do
    if length(CaptionLine)>=i then
    case CaptionLine[i]of
      '1':CaptionAdd(rname(DeviceInfo.CDName));
      '2':CaptionAdd(strtime(CalcTotalTime));
      '3':CaptionAdd(
	xstr(ElapDigit1.Value,1,0)+
	xstr(ElapDigit2.Value,1,0)+
	':'+
	xstr(ElapDigit3.Value,1,0)+
	xstr(ElapDigit4.Value,1,0));
      '4':CaptionAdd(ExtraTitle);
      '5':CaptionAdd(strtime(CalcRunningTime));
      '6':CaptionAdd(xstr(PlayListAt(currenttrack),1,0));
      '7':CaptionAdd(xstr(currenttrack+1,2,0));
      '8':CaptionAdd(xstr(DeviceInfo.TrackCount,2,0));
      '9':CaptionAdd(xstr(PlayList.count,2,0));
    end;}
    Caption:=ltrim(Caption);
    if length(Caption)=0 then
    Caption:=StandardCaption;
  end;
  setbottom;
end;

procedure TCdPlay.SaveDeviceInfo(DeviceInfo:TDeviceInfo);
Var I: Integer;
    s:string;
    outstring: TstringList;
begin
  OutString:=TstringList.Create;
  OutString.assign(DeviceInfo.Tracce);
  For i := 1 to DeviceInfo.TrackCount do
  Begin
    with DeviceInfo.TInfo.TrackInfo[i] do
      OutString.add('T'+xstr(i,1,0)+'='+TrackName+'|'+mcitime(Tracklen));
  End;
  s:='-';
  for i:=1 to PlayList.count do
  s:=s+PlayList[i-1];
  with DeviceInfo do
  OutString.add('Program='+s);
  For i := 1 to ProgramList.count do
  Begin
    with DeviceInfo do
    OutString.add('P'+xstr(i,1,0)+'=-'+ProgramList[i-1]);
  End;
  with DeviceInfo.EInfo do
  For i := 1 to count do
  Begin
    with TrackInfo[i] do
    OutString.add('X'+xstr(i,1,0)+'=-'+
    xstr(track,2,0)+TrackName+'|'+strtime(TrackStart)+
      strtime(TrackEnd));
  End;
  with DeviceInfo,Table1 do 
  begin
    if not FindKey([CDPlayerCode]) and not FindKey([CDUniqueCode]) then append else edit;
    FieldByName('CDID').AsString := CDPlayerCode;
    FieldByName('CDName').AsString := CDName;
    FieldByName('year').AsString := year;
    FieldByName('Style').AsString := xstr(Style,1,0);
    FieldByName('DATA').Assign(OutString);
    post;
  end;
  OutString.Free;
end;

procedure TCdPlay.SmallWindowChecked(b:boolean);
begin
  SmallWindow.checked:=b;
  Small1pop.checked:=b;
end;

procedure TCdPlay.MediumWindowChecked(b:boolean);
begin
  MediumWindow.checked:=b;
  Medium1pop.checked:=b;
end;

procedure TCdPlay.LargeWindowChecked(b:boolean);
begin
  LargeWindow.checked:=b;
  Large1pop.checked:=b;
end;

procedure ReadIniStringList(inifile:TiniFile;section:string;name:string;
  var sl:TStringList;empty:boolean);
var i,j:integer;
    IsFirst:boolean;
    s1:string;
begin
  IsFirst:=true;
  For i:=0 to 50 do
  begin
    s1:=IniFile.ReadString(section, name+xstr(i,1,0) , '');
    if s1<>'' then
    begin
	if IsFirst then
	begin
	  IsFirst:=false;
	  sl.clear;
	end;
        if empty then
        for j:=sl.count to i-1 do sl.add('');
	sl.add(s1);
    end;
  end;
end;

procedure TCdPlay.ReadSettings(s:string);
var IniFile : tIniFile;
    i:integer;
begin
  IniFile := tIniFile.Create(s);
  AutoSave.checked:=IniFile.ReadBool('Common', 'AutoSave' , true);
  ElapsedTime.checked:=IniFile.ReadBool('Common', 'Show Elapsed Time' , true);
  Clocktotal1.checked:=IniFile.ReadBool('Common', 'Clock Shows Total Time' , false);
  PlaylistNumber1.checked:=IniFile.ReadBool('Common', 'PlayList Number' , false);
  Toolbar1.checked:=IniFile.ReadBool('Common', 'Toolbar' , true);
  AutoAsk1.checked:=IniFile.ReadBool('Common', 'AutoAsk' , false);
  Ignore1trackCD.checked:=IniFile.ReadBool('Common', 'Ignore 1-track CD' , false);
  AutoPlay.checked:=IniFile.ReadBool('Common', 'AutoPlay' , false);
  ContinuePlaying.checked:=IniFile.ReadBool('Common', 'Continue Playing' , true);
  TotalTime.checked:=IniFile.ReadBool('Common', 'Show Total Time' , false);
  Minimum1Set(IniFile.ReadBool('WindowSize', 'Minimal' , false));
  MediumWindowchecked(IniFile.ReadBool('WindowSize', 'Medium' , true));
  LargeWindowchecked(IniFile.ReadBool('WindowSize', 'Large' , true));
  SmallWindowchecked(IniFile.ReadBool('WindowSize', 'Small' , true));
  BackGroundColour:=IniFile.ReadInteger('Colours Display', 'BackGround' , clBlack);
  TrackTitleColour:=IniFile.ReadInteger('Colours Display', 'Track Title' , clRed);
  BarTop:=IniFile.ReadInteger('Layout Edit', 'SlideBar' , BarTop);
  BottomLine1:=IniFile.ReadString('Bottom', 'Line 1' , BottomLine1);
  BottomLine2:=IniFile.ReadString('Bottom', 'Line 2' , BottomLine2);
  CaptionDefine:=IniFile.ReadString('Caption', 'DisplayLine' , CaptionDefine);
  SurfaceColour:=IniFile.ReadInteger('Colours Display', 'Surface' , clBtnFace);
  LabelColour:=IniFile.ReadInteger('Colours Display', 'Labels' , clBlue);
  DigitsColour:=IniFile.ReadInteger('Colours Display', 'Digits' , clLime);
  DisplayBottomItems:=IniFile.ReadInteger('Bottom Display', 'What' , 1);
  AuxDev:=IniFile.ReadInteger('Volume', 'Line' , 2);
  DriveLetters:=IniFile.ReadString('Multi-drive', 'DriveLetters' , 'defghijklmnopq');
  Autoswitch1.checked:=IniFile.ReadBool('Multi-drive', 'Auto Switch Drives' , false);
  BooleanExtraTracksVisible:=IniFile.ReadBool('Layout Edit', 'XTracks Visible' , true);
  FontColor:=IniFile.ReadInteger('DatabaseWindow','FontColor',0);
  FontName:=IniFile.ReadString('DatabaseWindow','FontName','');
  FontSize:=IniFile.ReadInteger('DatabaseWindow','FontSize',8);
  {$IFDEF trayicon}
    Hide1.checked:=IniFile.ReadBool('Window', 'Hide Application' , false);
    with TrayIcon do
    begin
      MainIcon.enabled:=true;
      PlayIcon.enabled:=IniFile.ReadBool('Tray', 'Play Icon' , true);
      PauseIcon.enabled:=IniFile.ReadBool('Tray', 'Pause Icon' , true);
      StopIcon.enabled:=IniFile.ReadBool('Tray', 'Stop Icon' , true);
      NextIcon.enabled:=IniFile.ReadBool('Tray', 'Next Icon' , true);
      PreviousIcon.enabled:=IniFile.ReadBool('Tray', 'Previous Icon' , true);
      EjectIcon.enabled:=IniFile.ReadBool('Tray', 'Eject Icon' , true);
    end;
  {$ENDIF}
    ReadIniStringList(inifile,'Fields','Field',StringFieldNames,false);
    ReadIniStringList(inifile,'Fields','Value',DefaultValues,true);
    for i:=DefaultValues.count+1 to StringFieldNames.count do DefaultValues.add('');
    ReadIniStringList(inifile,'Display Database','Trackline',MyTrackMemo,false);
    ReadIniStringList(inifile,'Display Database','CDline',MyCdHeaderMemo,false);
    Styles.add('Pop');
    Styles.add('Compilation');
    Styles.add('Other');
    ReadIniStringList(inifile,'Styles','Style',Styles,false);
  IniFile.Free;
  if (length(DriveLetters)=0) or (DriveLetters[1]<StartDrive) then
  begin
   DriveLetters:='';
   for i:=0 to 15 do
   DriveLetters:=DriveLetters+chr(ord(StartDrive)+i);
  end;
end;

procedure TCdPlay.DisplaySettings;
begin
  SetDisplayColours(SurfaceColour,BackGroundColour,
     TrackTitleColour,DigitsColour,
	LabelColour);
  ShowWindows;
  SetCheckMarks;
end;

procedure WriteIniStringList(var inifile:TInifile;section,name:string;
  sl:TStringList);
var i:integer;
begin
    for i:=0 to sl.count-1 do
    begin
      IniFile.WriteString(section, name+xstr(i,1,0) , sl[i]);
    end;
end;

procedure TCdPlay.WriteSettings(s:string);
var IniFile : tIniFile;
begin
  IniFile := tIniFile.Create(s);
  IniFile.WriteBool('Common', 'AutoSave' , AutoSave.checked);
  IniFile.WriteBool('Common', 'PlayList Number' , PlaylistNumber1.checked);
  IniFile.WriteBool('Common', 'Show Elapsed Time' , ElapsedTime.checked);
  IniFile.WriteBool('Common', 'Clock Shows Total Time' , Clocktotal1.checked);
  IniFile.WriteBool('Common', 'Show Total Time' , TotalTime.checked);
  IniFile.WriteBool('Common', 'AutoPlay' , AutoPlay.checked);
  IniFile.WriteBool('Common', 'Ignore 1-track CD' , Ignore1trackCD.checked);
  IniFile.WriteBool('Common', 'AutoAsk' , AutoAsk1.checked);
  IniFile.WriteBool('Common', 'Toolbar' , Toolbar1.checked);
  IniFile.WriteBool('Common', 'Continue Playing' , ContinuePlaying.checked);
  IniFile.WriteBool('WindowSize', 'Minimal' , Minimum1.checked);
  IniFile.WriteBool('WindowSize', 'Small' , SmallWindow.checked);
  IniFile.WriteBool('WindowSize', 'Medium' , MediumWindow.checked);
  IniFile.WriteBool('WindowSize', 'Large' , LargeWindow.checked);
  IniFile.WriteString('Caption', 'DisplayLine' , CaptionDefine);
  IniFile.WriteInteger('Colours Display', 'BackGround' , BackGroundColour);
  IniFile.WriteInteger('Colours Display', 'Track Title' , TrackTitleColour);
  IniFile.WriteInteger('Colours Display', 'Surface' , SurfaceColour);
  IniFile.WriteInteger('Colours Display', 'Labels' , LabelColour);
  IniFile.WriteInteger('Colours Display', 'Digits' , DigitsColour);
  IniFile.WriteInteger('Bottom Display', 'What' , DisplayBottomItems);
  IniFile.WriteInteger('Volume', 'Line' , AuxDev);
  IniFile.WriteString('Multi-drive', 'DriveLetters' , DriveLetters);
  IniFile.WriteBool('Multi-drive', 'Auto Switch Drives' , Autoswitch1.checked);
  IniFile.WriteInteger('Volume', 'Right Channel' , MyVolumeDlg.RightSlider.value);
  IniFile.WriteInteger('Volume', 'Left Channel' , MyVolumeDlg.LeftSlider.value);
  IniFile.WriteBool('Layout Edit', 'XTracks Visible' , BooleanExtraTracksVisible);
  IniFile.WriteString('Bottom', 'Line 1' , BottomLine1);
  IniFile.WriteString('Bottom', 'Line 2' , BottomLine2);
  IniFile.WriteInteger('Layout Edit', 'SlideBar' , BarTop);
  if FontName<>'' then
  begin
    IniFile.WriteInteger('DatabaseWindow','FontColor',FontColor);
    IniFile.WriteString('DatabaseWindow','FontName',FontName);
    IniFile.WriteInteger('DatabaseWindow','FontSize',FontSize);
  end;
  {$IFDEF trayicon}
    IniFile.WriteBool('Window', 'Hide Application' , Hide1.checked);
    with TrayIcon do
    begin
      IniFile.WriteBool('Tray', 'Play Icon' , PlayIcon.enabled);
      IniFile.WriteBool('Tray', 'Pause Icon' , PauseIcon.enabled);
      IniFile.WriteBool('Tray', 'Stop Icon' , StopIcon.enabled);
      IniFile.WriteBool('Tray', 'Next Icon' , NextIcon.enabled);
      IniFile.WriteBool('Tray', 'Previous Icon' , PreviousIcon.enabled);
      IniFile.WriteBool('Tray', 'Eject Icon' , EjectIcon.enabled);
    end;
  {$ENDIF}
    IniFile.EraseSection('Fields');
    WriteIniStringList(inifile,'Fields','Field',StringFieldNames);
    WriteIniStringList(inifile,'Fields','Value',DefaultValues);
    IniFile.EraseSection('Styles');
    WriteIniStringList(inifile,'Styles','Style',Styles);
    IniFile.EraseSection('Display Database');
    WriteIniStringList(inifile,'Display Database','Trackline',MyTrackMemo);
    WriteIniStringList(inifile,'Display Database','CDline',MyCDHeaderMemo);
  IniFile.Free;
end;

procedure TCdPlay.CopyMainToPop;
procedure AddItems(FromMenu:TMenuItem;var ToMenu:TMenuItem);
var hm:TMenuItem;
    i:integer;
begin
  with ToMenu do
  begin
    Caption:=FromMenu.Caption;
    enabled:=FromMenu.enabled;
    checked:=FromMenu.checked;
    Tag:=FromMenu.tag;
  end;
  if FromMenu.count=0 then
  begin
    ToMenu.onclick:=FromMenu.onclick;
  end else
  for i:=0 to FromMenu.count-1 do
  begin
    with FromMenu.Items[i] do
    begin
      ToMenu.add(TMenuItem.Create(ToMenu));
      hm:=ToMenu[ToMenu.Count-1];
      AddItems(FromMenu.Items[i],hm);
    end;
  end;
end;

var mh1,mh2:TMenuItem;
    i:integer;
begin
  with MainPopupMenu.Items do
  For i:=Count-1 downto 0 do
  delete(i);
  with MainPopupMenu do
  for i:=MainMenu1.Items.Count-1 downto 0 do
  begin
    mh1:=MainMenu1.Items[i];
    Items.add(TMenuItem.Create(MainPopupMenu));
    mh2:=Items[Items.count-1];
    additems(mh1,mh2);
  end;
end;

procedure TCdPlay.CheckForAvailableCDROMS;
{$IFDEF ver80}
{$ELSE}
function GetToken(var S: ansistring; Token: Char): string ; 
var sTemp: string ;
    Index: integer ;
     Size: integer ; 
begin
      Index := Pos(Token, S) ;
      if Index < 1 then
      begin
           Result := s ;
           s := '' ;
           Exit ;
      end ;
      Dec(Index) ;
      SetLength(sTemp, Index) ;
      Move(S[1], sTemp[1], Index) ;

      Size := (Length(S) - Index);                                            
      Move(S[Index + 2], S[1], Size);
      SetLength(S, Size);

      Result := sTemp ; 
end;
{$ENDIF}
var ch:char;
    i:integer;
  {$IFDEF ver80}
  {$ELSE}
const
	cLength = 64 ;
var s:ansistring;
    sDrives: ansistring;
  {$ENDIF}
begin
  {$IFDEF ver80}
  {$ELSE}
  {scan for valid drive-letters; thanks Terry Brooking!}
  DriveLetters:='';
  SetLength(sDrives, cLength) ;
  GetLogicalDriveStrings(cLength, PChar(sDrives)) ;
  s:=sdrives;
  Repeat
    s := GetToken(sDrives, #0) ;
    if s <> '' then
    DriveLetters:=DriveLetters+s[1];
   until s = '' ;
  {$ENDIF}
  {now scan which drive is a cd-rom}
  DriveLetters:=LowerCase(DriveLetters);
    for i:=1 to length(DriveLetters) do
    begin
      ch:=DriveLetters[i];

  {$IFDEF ver80}
      if IsCDROM(ord(ch)-ord('a'))
  {$ELSE}
    {check for valid CD-ROM-drives, using the WIN32 API-call GetDriveType}
    {thanks to Terry Brooking for his suggestion}
      s := ch + ':\';
      if (GetDriveType(PChar(s)) = Drive_CDRom)
  {$ENDIF}
	and (NumDrives<MaxDrives) then
      begin
	inc( NumDrives);
	DriveLetter[NumDrives]:=ch;
      end;
    end;
end;

procedure TCdPlay.FormCreate(Sender: TObject);
procedure DoubleOpen;
var m:TMenuItem;
    i:integer;
begin
    application.OnHelp:=MyHelp;
    MyDigits[1]:=TrackDigit1;
    MyDigits[2]:=TrackDigit2;
    MyDigits[3]:=ElapDigit1;
    MyDigits[4]:=ElapDigit2;
    MyDigits[5]:=ElapDigit3;
    MyDigits[6]:=ElapDigit4;
    MyDigits[7]:=TimeDigit1;
    MyDigits[8]:=TimeDigit2;
    MyDigits[9]:=TimeDigit3;
    MyDigits[10]:=TimeDigit4;
    MyDigits[11]:=TotTracksDigit1;
    MyDigits[12]:=TotTracksDigit2;
    MyDigits[13]:=ElapDigit0;
    MyDigits[14]:=TimeDigit0;

    for i:=1 to NumDrives do
    begin
      m:=TMenuItem.Create(MainMenu1);
      CDdrive1.add(m);
      with CDdrive1.Items[CDdrive1.Count-1] as TMenuItem do
      begin
	Caption:='CD ROM '+DriveLetter[i]+':';
	OnClick:=Device11Click;
	tag:=i;
	ShortCut:=16496+i-1;{CTRL_F1}
      end;
    end;
    Mediaplay1:=TMediaplus.Create(self);{tmediaplayer}
    with Mediaplay1 do
    begin
      DeviceType := dtCDAudio;
      shareable := true;
      CurrentDrive:=1;
    end;
    DriveParameter.check:=true;
    AutoSwitch1.enabled:=NumDrives>1;
    CDdrive1.enabled:=AutoSwitch1.enabled;
    Multilist1.enabled:=AutoSwitch1.enabled;
    Alternate1.enabled:=AutoSwitch1.enabled;
end;
procedure DoDDE;
begin
    CDPlayer.destroy;
    Application.Title:='destroy me';
end;
var path,filename:string;
begin
  DisplayBottomItems:=1;
  FormHeight:=clientheight;
  pointon:=true;
  lightsoff:=false;
  DeviceOpened := False;
  MyVolumeDlg:= TVolumeDlg.create(Self);
  {$IFDEF trayicon}
  TrayIcon:=TTrayIconForm.create(Self);
  with TrayIcon do
  begin
    PlayIcon.OnMouseUp:=PlayIconMouseUp;
    PauseIcon.OnMouseUp:=PauseIconMouseUp;
    StopIcon.OnMouseUp:=StopIconMouseUp;
    NextIcon.OnMouseUp:=NextIconMouseUp;
    PreviousIcon.OnMouseUp:=PreviousIconMouseUp;
    EjectIcon.OnMouseUp:=EjectIconMouseUp;
    MainIcon.OnMouseUp:=MainIconMouseUp;
  end;
   {$ENDIF}
  MyTrackMemo:=TStringList.create;
  MyCDHeaderMemo:=TStringList.create;
  MyTrackMemo.add(TrackOutline);
  MyCDHeaderMemo.add(RecordOutline);
  StringFieldnames:=TStringList.Create;
  DefaultValues:=TStringList.Create;
   ReadSettings(changefileext(paramstr(0),'.INI'));
   CheckForAvailableCDROMS;
  DoubleOpen;
  DeviceOpen;
  DisplaySettings;
  PlayList:=tstringlist.create;
  programlist:=tstringlist.create;
  MultiPlayList:=tstringlist.create;
  playing:=false;
  paused:=false;
  newitem:=true;
  SetMenuOptions(false);
  CurrentExtraTrack:=false;
  filename:=changefileext(paramstr(0),'.DBF');
  path:=ExtractFilePath(filename);
  filename:=ExtractFileName(filename);
  with Table1 do
  begin
    Exclusive:=false;
    DataBaseName:=path;
    TableName:=filename;
    Active:=true;
    IndexName:='CDID';
  end;
  ActiveControl:=PowerLightCheck;
  MultiList:=tstringlist.create;
end;

procedure TCdPlay.DeviceOpen;
procedure StopFoutMCI;
var p:pchar;
begin
  Halt(0);
  getmem(p,length(MediaPlay1.ErrorMessage)+1);
  strpcopy(p,MediaPlay1.ErrorMessage);
  Application.MessageBox(p, 'Aborting Program',IDABORT);
  freemem(p,length(MediaPlay1.ErrorMessage)+1);
end;
var i:integer;
begin
    currenttrack:=-1;
    with Mediaplay1 do
    begin
      visible:=false;
      parent:=Panel2;
      Left := 96;
      Top := 19;
      Width := 169;
      Height := 30;
      VisibleButtons := [btPlay, btPause, btStop, btNext, btPrev, btEject];
      TabOrder := 1;
      TabStop := True;
      OnClick := Mediaplay1Click ;
      OnNotify := Mediaplay1Notify;
      shareable := true;
      Filename:=DriveLetter[CurrentDrive]+':';
    end;
    Mediaplay1.Wait := True;
    Mediaplay1.TimeFormat := tfTMSF;
  Try
    Mediaplay1.Open;
    if MediaPlay1.error<>0 then
    StopFoutMCI;
    PowerLightCheck.checked:=true;
  except
    StopFoutMCI;
  End;
  Mediaplay1.Wait := False;
  for i:=1 to Numdrives do
  with CDdrive1.Items[i-1] as TMenuItem do
  enabled:=true;
  with CDdrive1.Items[CurrentDrive-1] as TMenuItem do
  enabled:=false;
end;

procedure TCdPlay.SetMenuOptions(b:boolean);
begin
  IntroScan.enabled:=b;
  Shuffle1.enabled:=b;
  Current1.enabled:=b;
  Save1.enabled:=b;
  Reread1.enabled:=b;
  EraseCD.enabled:=b;
  TrackList.Enabled  := b;
  Programs.enabled:=b;
  PlayTrack1.enabled:=b;
  NextTrack1.enabled:=b;
  PreviousTrack.enabled:=b;
  DeleteTrack1.enabled:=b;
end;

procedure TCdPlay.DeviceClose;
begin
  Mediaplay1.Close;
  SetMenuOptions(false);
end;

function TCdPlay.PlayListAt(i:integer):integer;
var hi:integer;
    s:string;
begin
  s:=PlayList[i];
  while s[length(s)]=' ' do s:=copy(s,1,length(s)-1);
  val(s,i,hi);
  PlayListAt:=i;
end;

procedure TCdPlay.GetPlayTime(i:integer;var min2,sec2:byte);
var j:integer;
begin
	j:=PlayListAt(i);
	if j<=DeviceInfo.TrackCount then
	begin
	  sec2 := mci_MSF_Second(DeviceInfo.TInfo.TrackInfo[j].TrackLen);
	  min2 := mci_MSF_Minute(DeviceInfo.TInfo.TrackInfo[j].TrackLen);
	end else
	calcextratime(j-DeviceInfo.Trackcount,min2,sec2);
end;

procedure TCdPlay.SetCurrentTime(tr:integer);
var  sec,min,i:integer;
     sec2,min2:byte;
     TheLength : LongInt;
     TheElaps  : LongInt;
     TheRemain : LongInt;
begin
  if badtrack(tr) then exit;
    sec := mci_TMSF_Second(Mediaplay1.Position);
    min := mci_TMSF_Minute(Mediaplay1.Position);
    TheElaps  := (Sec + (Min*60));
      TheElaps:=TheElaps-ExtraStart;
    min:=TheElaps div 60;
    sec:=TheElaps mod 60;
    if not positionslider.hasmousedown then
    PositionSlider.value:=TheElaps;
    TheLength:=ExtraEnd-ExtraStart;
    TheRemain := TheLength - TheElaps;
    if not ElapsedTime.checked then
    begin
      min := TheRemain div 60;
      sec := TheRemain - (min * 60);
      if Clocktotal1.checked then
      if alternate1.checked then
      begin
	MultList.MultiRestTime(currentdrive,playlistat(currenttrack),
	  MultiList,min2,sec2);
	min:=min+min2;sec:=sec+sec2;
      end else
       for i:=CurrentTrack+1 to PlayList.count-1 do
      begin
	GetPlayTime(i,min2,sec2);
	sec:=sec2+sec;
	min:=min2+min;
      end;
   end else
      if Clocktotal1.checked then
      if alternate1.checked then
      begin
	MultList.MultiElapsedTime(currentdrive,playlistat(currenttrack),
	  MultiList,min2,sec2);
	min:=min+min2;sec:=sec+sec2;
      end else
       for i:=0 to CurrentTrack-1 do
      begin
	GetPlayTime(i,min2,sec2);
	sec:=sec2+sec;
	min:=min2+min;
      end;
    min:=min+sec div 60;
    sec:=sec mod 60;
    ElapDigit0.visible:=(min div 60)>0;
    ElapDigit0.Value:=(min div 60);
    ElapDigit1.Value:=(min mod 60) div 10;
    ElapDigit2.Value:=(min mod 60) mod 10;
    ElapDigit3.Value:=sec div 10;
    ElapDigit4.Value:=sec mod 10;
end;{SetCurrentTime}

procedure TCdPlay.calcextra;
var i,pl:integer;
begin
    CurrentExtraTrack:=true;
    i:=PlayListAt(currenttrack);
    pl:=i-DeviceInfo.Trackcount;
    with DeviceInfo.EInfo do
    begin
      SetTitle(TrackName[pl]);
      ExtraStart:=TrackStart[pl];
      ExtraEnd:=TrackEnd[pl];
    end;
end;

function TCdPlay.CurrentMediaplayer:TMediaPlus;
begin
  CurrentMediaPlayer:=MediaPlay1;
end;

procedure TCdPlay.PickupPlaying(tr:integer);
{pick up place of track that's playing, and display it}
begin
	settotalTime;
	SetCurrentTime(tr);
	ReactSlider;
end;

procedure TCdPlay.setpointon;
begin
  shape1.visible:=true;
  shape2.visible:=true;
  pointon:=true;
end;

procedure TCdPlay.DeviceInfoFree;
begin
  alternate1.checked:=false;
  If AutoSave.Checked then
  Begin
    SaveDeviceInfo(DeviceInfo);
  End;
  DeviceInfo.Free;
  paused:=false;
  playing:=false;
  deviceopened:=false;
  SetSelectTrack;
end;

procedure TCdPlay.Timer1Timer(Sender: TObject);
var tr,i,j:integer;
    newdevice:boolean;
begin
  if hide1.checked and visible then
  hide else
  if not hide1.checked and not visible then show;
  SpentCount:=SpentCount+1;
  if playing then
  begin
    if pointon then
    begin
      shape1.visible:=false;
      shape2.visible:=false;
      pointon:=false;
      exit;
    end else
    begin
      setpointon;
    end;
  end;
  tr  := mci_TMSF_Track(CurrentMediaplayer.Position);
  if newitem then prevtrack:=tr;
  newitem:=false;
  Mediaplay1.Notify := True;
  If CurrentMediaplayer.Error <> 0 then
  Begin
    If DeviceOpened then
    Begin
      DeviceInfoFree;
    End;
    if not lightsoff then
    begin
      lightsoff:=true;
      PowerLightCheck.checked:=false;
      DeviceOpened := False;
      playing:=false;
      clearbottom;
      for i:=1 to NumDigits do MyDigits[i].ValueBinary:=2;
      Self.Caption       := StandardCaption;
      TitleLabel.visible     := true;
      TitleLabel.Caption     := 'Unknown';
      HalfTitleLabel1.Caption     := '';
      HalfTitleLabel2.Caption     := '';
      SetMenuOptions(false);
      IntroScan.checked:=false;
      SetMediaButtons;
      SetSelectTrack;
{      Timer1.enabled:=false;}
    end;
  End  {if error <> 0}
  else
  Begin
    newdevice:=false;
    if not DeviceOpened then
    Begin
      if Ignore1trackCD.checked then
      if MediaPlay1.tracks=1 then exit;
      newdevice:=true;
      DeviceOpened := True;
      PowerLightCheck.checked:=true;
      DeviceInfo := TDeviceInfo.Create(Mediaplay1.DeviceID);
      GetDeviceInfo(DeviceInfo);
      tr  := mci_TMSF_Track(Mediaplay1.Position);
      SetMenuOptions(true);
      {start playing first song from the start}
{      MCISendCommand(Mediaplay1.DeviceID,MCI_SEEK,MCI_SEEK_TO_START,0);}
      {--}
      {find out what track is playing, and see if it's
       on the playlist}
      playing:=Mediaplay1.mode=mpPlaying;
      currenttrack:=-1;
      if playing then
      begin
	for i:=0 to PlayList.count-1 do
	with DeviceInfo do
	if PlayListAt(i)<=Trackcount then
	begin
	  if PlayListAt(i)=tr then currenttrack:=i;
	end else
	if tr=
	  EInfo.Track[PlayListAt(i)-TrackCount]
	then
	begin
	  currenttrack:=i;
	  calcextra;
	  break;
	end;
	if currenttrack=-1 then
	begin
	  prevtrack:=tr;
	  findnexttrack;
	end else
	begin
	  PickupPlaying(tr);
	end;
	Timer1.enabled:=true;
      end else
      begin
	if AutoPlay.checked then
	begin
	  playing:=true;
	end;
	findnexttrack;
	prevtrack:=PlayListAt(currenttrack);
	tr:=prevtrack;
      end;{if playing}
      settotalTime;
    End;{if not DeviceOpened }
      j:=-1;
    if TrackChangedTimer.enabled then exit;
    if newitem {or (tr<>prevtrack)} then
    begin
      for i:=0 to PlayList.count-1 do
      with DeviceInfo do
      if PlayListAt(i)<=Trackcount then
      begin
      if PlayListAt(i)=tr then
      begin
	j:=i;
	currentextratrack:=false;
	break;
      end;
      end else
	if tr=
	  EInfo.Track[PlayListAt(i)-TrackCount]
	then
	begin
	  currentextratrack:=true;
	  j:=i;
	  if currenttrack=i then
	  begin
	    break;
	  end;
	end;
      if j=-1 then
      begin
	findnexttrack;
	exit;
      end else
      begin
	currenttrack:=j;
	if currentextratrack then calcextra;
{        PickupPlaying(tr);}
      end;
     settotalTime;
    if playing then
    if not newdevice then
    if Mediaplay1.mode<>mpPlaying then
    begin
      playtrack;
    end;
      SpentCount:=0;
    end;
    if playing then
    begin
      SetCurrentTime(tr);
    end;
    lightsoff:=false;
    if tr<>prevtrack then
    ContinueTrack;
  end;  {if error <> 0}
End;


procedure TCdPlay.FormDestroy(Sender: TObject);
begin
 if deviceopened then
 begin
  if playing then
  with Mediaplay1,DeviceInfo do
  if ContinuePlaying.checked then
  begin
    startpos:=position;
    with TInfo.TrackInfo[TrackCount] do
    EndPos := mci_Make_TMSF(TrackCount-1, mci_MSF_Minute(TrackLen),
     mci_MSF_Second(TrackLen), 0);
    play;
  end else stop;
 end;
  WriteSettings(changefileext(paramstr(0),'.INI'));
  Mediaplay1.close;
  DeviceClose;
  If DeviceOpened then
  Begin
    DeviceOpened := False;
    DeviceInfoFree;
    SetMenuOptions(false);
  End;
  PlayList.free;
  MultiList.free;
  programlist.free;
  MultiPlayList.free;
  MyVolumeDlg.free;
  StringFieldnames.free;
  DefaultValues.free;
  MyTrackMemo.free;
  MyCDHeaderMemo.free;
  Styles.free;
 {$IFDEF trayicon}
 TrayIcon.Free;
 {$ENDIF}
end;

procedure TCdPlay.AutoSaveClick(Sender: TObject);
begin
  AutoSave.Checked := not AutoSave.Checked;
end;

procedure TCdPlay.About1Click(Sender: TObject);
var
  AboutBox: TAboutBox;
begin
  Try
    AboutBox := TAboutBox.Create(Self);
    AboutBox.ShowModal;
    AboutBox.Free
  Finally
  End;
end;

function TCdPlay.HasDisk:boolean;
var h:boolean;
begin
  h:=NextTrack1.enabled;
  if not h then
  begin
    ShowMessage('Option not available, no disk inserted');
  end;
  HasDisk:=h;
end;

procedure TCdPlay.ProgramsClick(Sender: TObject);
Var Modal : TPlayList;
    i,j,k  : Integer;
    currtr:string;

function TitleExtra(i:integer):string;
begin
  with DeviceInfo do
  TitleExtra:=xstr(i+1+DeviceInfo.TrackCount,2,0)+' '+
    EInfo.TrackName[i+1];
end;
begin
  if not HasDisk then exit;
  Try
    Modal := TPlayList.Create(Self);
    for i:=1 to ProgramList.Count do
    Modal.ProgramListBox.Items.add(programlist[i-1]);
    for i:=1 to PlayList.count do
    with DeviceInfo do
    begin
      if PlayListAt(i-1)<=Trackcount then
      Modal.DstList.Items.Add(xstr(PlayListAt(i-1),2,0)+' '+TInfo.TrackName[PlayListAt(i-1)])
      else
      begin
	Modal.DstList.Items.Add(TitleExtra(PlayListAt(i-1)-Trackcount-1));
      end;
    end;
    For i := 1 to DeviceInfo.TrackCount do
    Begin
      Modal.TimeArr[i]:=mci_MSF_Minute(DeviceInfo.TInfo.TrackInfo[i].TrackLen)*60+
			 mci_MSF_Second(DeviceInfo.TInfo.TrackInfo[i].TrackLen);
      k:=99;
      for j:=1 to PlayList.count do
      begin
	if PlayListAt(j-1)=i then k:=i;
      end;
      if k=99 then
	Modal.SrcList.Items.Add(xstr(i,2,0)+' '+DeviceInfo.TInfo.TrackName[i]);
    End;
    For i := 1 to DeviceInfo.EInfo.Count do
    Begin
      Modal.TimeArr[i+DeviceInfo.TrackCount]:=
	DeviceInfo.EInfo.Tracklen[i];
      k:=99;
      for j:=1 to PlayList.count do
      begin
	if PlayListAt(j-1)=i+DeviceInfo.Trackcount then k:=i;
      end;
      if k=99 then
	Modal.SrcList.Items.Add(
	TitleExtra(i-1));
    end;
    Modal.SetButtons;
    if currenttrack>=0 then
    currtr:=PlayList[currenttrack];
   Modal.ShowModal;
   if Modal.result=mrok then
   Begin
      programlist.clear;
      for i:=1 to Modal.ProgramListBox.Items.Count do
      programlist.add(Modal.ProgramListBox.Items[i-1]);
      PlayList.clear;
      for i:=1 to Modal.DstList.Items.Count do
      Begin
	PlayList.add(
	copy(Modal.dstList.items[i-1],1,2));
      End;
      j:=99;
      if currenttrack>=0 then
      begin
	for i:=0 to PlayList.count-1 do
	if PlayList[i]=currtr then j:=i;
	if j<99 then currenttrack:=j else
	begin
	  currenttrack:=-1;
	  findnexttrack;
	end;
      end else findnexttrack;
      SetSelectTrack;
      SetTotalTime;
    End;
    Modal.Free
  Finally
  End;
  Mediaplay1.Tag := 0;
end;

procedure TCdPlay.Mediaplay1Notify(Sender: TObject);
begin
  if TrackChangedTimer.enabled then exit;
  If (Mediaplay1.NotifyValue = nvSuccessful) then
  Begin
    ContinueTrack;
  end;
end;
procedure TCdPlay.ContinueTrack;
Var Found : Boolean;
begin
    Timer1.enabled:=false;
    if playing then
    if SpentCount>4 then
    begin
      if not RepeatTrack1.checked then
      begin
      Found := FindNextTrack;
      If Found then
      Begin
	if playing then
	begin
	  ContrIntro(PlayListAt(currenttrack));
	  SetTotalTime;
	  Mediaplay1.Play;
	end;
      End else exit;
      end else
      begin
	playtrack;
      end;
      Mediaplay1.autoenable:=false;
      Mediaplay1.EnabledButtons := [btPlay,btPause, btStop, btNext, btPrev,
	btEject];
    end;
  Timer1Timer(self);
    Timer1.enabled:=true;
end;

procedure RetractCD(wDeviceId: LongInt);
var
  Info   : TMCI_Set_Parms;
  Flags   : LongInt;

begin
  FillChar(Info, SizeOf(TMCI_Set_Parms), 0);
  Flags := mci_Set_Door_Closed;
  mciSendCommand( wDeviceId, MCI_SET, Flags, Longint(@Info));
end;

procedure TCDPlay.dopause(Button: TMPBtnType);
begin
    IntroScan.checked:=false;
    if button=btstop then paused:=false else
    begin
      if not playing then paused :=false else
      paused:=not paused;
    end;
    playing:=false;
    if Button=btPause then
    begin
      if not paused then
      begin
	Timer1.enabled:=true;
	Mediaplay1.play;
	playing:=true;
      end else Mediaplay1.pause
    end
    else
    begin
      MediaPlay1.notify:=true;
      MediaPlay1.Stop;
{      MediaPlay1.notify:=true;}
      PlayTrack;
    end;
    SetCaption;
    SetMediaButtons;
end;

procedure TCdPlay.Mediaplay1Click(Sender: TObject; Button: TMPBtnType;
  var DoDefault: Boolean);
begin
  DoDefault := False;
  MediaPlay1.notify:={false}true;
  If Button = btNext then
  Begin
    NextTrack1Click(Self);
  End else

  If Button = btPrev then
  Begin
    PreviousTrackClick(Self);
  End else
  If Button = btPlay then
  begin
      PlayTrack1Click(Self);
  end else
  If Button = btStop then
  begin
    dopause(btStop);
  end else
  If Button = btPause then
  begin
    dopause(button);
  end else
  If Button = btEject then EjectTray1Click(Self)
else
  begin
    DoDefault:=true;
    playing:=false;
  end;
  SetTotalTime;
end;

Function TCdPlay.FindNextTrack : Boolean;
Var i     : Integer;
Begin
  if PlayList.count=0 then
  begin
    FindNextTrack:=false;
    exit;
  end;
  if (currenttrack=-1) or (currenttrack=PlayList.count-1) then
    if currenttrack=PlayList.count-1 then
     if alternate1.checked then
     begin
       i:=MultList.MultiTracknr(currentdrive,playlistat(currenttrack),MultiList)-1;
       if i=MultiList.Count-1 then
       i:=0
       else inc(i);
       PlayMultiItem(i);
       SpentCount:=0;
       FindNextTrack:=true;
       exit;
     end else
      if AutoSwitch1.checked then
      begin
	{switch}
	inc(CurrentDrive);
	if CurrentDrive>NumDrives then CurrentDrive:=1;
	SetDeviceType(dtCDAudio);
	FindNextTrack:=false;
	exit;
      end
      else currenttrack:=0
    else
  begin
    currenttrack:=0;
  end else inc(currenttrack);
  MediaPlay1.Notify:=true;
  FindNextTrack:=playtrack;
  SpentCount:=0;
End;

procedure TCDPlay.ContrIntro(tr:integer);
var m,s:integer;
begin
  if IntroScan.checked then
  with Mediaplay1 do
  if ExtraEnd>ExtraStart+IntroTime then
  begin
    ExtraEnd:=ExtraStart+IntroTime;
    m:=ExtraEnd;
    s:=m mod 60;
    m:=m div 60;
    Mediaplay1.EndPos := mci_Make_TMSF(tr, m, s, 0);
  end;
end;

function TCDPlay.playtrack:boolean;
Var i    : Integer;
    pl:integer;
    m,s,tr:integer;
begin
  if (currenttrack=-1) or (PlayList.count=0) then
  begin
    result:=false;
    exit;
  end;
  TrackChangedTimer.enabled:=true;
  result:=true;
  i:=PlayListAt(currenttrack);
  with deviceinfo do
  if i<=DeviceInfo.Trackcount then
  with deviceinfo.TInfo.TrackInfo[i] do
  begin
    ExtraStart:=0;
    SetTitle(TrackName);
   CurrentExtraTrack:=false;
   tr:=i;
    Mediaplay1.StartPos := mci_Make_TMSF(tr, 0, 0, 0);
    If tr < DeviceInfo.TrackCount then
      Mediaplay1.EndPos := mci_Make_TMSF(tr+1, 0, 0, 0);
    ExtraEnd:=60*mci_MSF_Minute(TrackLen)+mci_MSF_Second(TrackLen);
  end else
  begin
    calcextra;
    s:=ExtraStart mod 60;
    m:=ExtraStart div 60;
    pl:=i-DeviceInfo.Trackcount;
    tr:=EInfo.Track[pl];
    Mediaplay1.StartPos := mci_Make_TMSF(tr, m, s, 0);
    m:=ExtraEnd;
    s:=m mod 60;
    m:=m div 60;
    Mediaplay1.EndPos := mci_Make_TMSF(tr, m, s, 0);
  end;
  prevtrack:=tr;
  ContrIntro(PlayListAt(currenttrack));
{  Mediaplay1.Notify:= True;}
  Mediaplay1.Tag := i;

  SetTotalTime;
  Mediaplay1.Notify:= True{false};
  if playing then
  Mediaplay1.play
  else MediaPlay1.Position:=MediaPlay1.StartPos;
end;

Function TCdPlay.FindPrevTrack : Boolean;
var i:integer;
Begin
  if PlayList.count=0 then
  begin
    FindPrevTrack:=false;
    exit;
  end;
  if (currenttrack=-1) or (currenttrack=0) then
  if alternate1.checked then
  begin
    i:=MultList.MultiTracknr(currentdrive,playlistat(currenttrack),MultiList)-1;
    if i=0 then i:=MultiList.Count-1 else dec(i);
    PlayMultiItem(i);
    FindPrevTrack:=true;
    exit;
  end else
  begin
    currenttrack:=PlayList.count-1;
  end else dec(currenttrack);
  FindPrevTrack:=playtrack;
End;

procedure TCdPlay.FormActivate(Sender: TObject);
begin
  PowerLightCheck.checked:=false;
  SetCheckMarks;
  Mediaplay1.autoenable:=false;
end;

procedure TCdPlay.SelectTrackComboBoxChange(Sender: TObject);
var playing:boolean;
begin
  playing:=Mediaplay1.mode=mpPlaying;
  if findnexttrack then ;
  if playing then
  begin
    SetTotalTime;
    Mediaplay1.play;
    Timer1.enabled:=true;
  end;
end;

procedure TCDPlay.checkpower;
begin
  if not PowerLightCheck.checked then
  begin
    Mediaplay1.Notify := False;
    DeviceOpen;
    DeviceOpened := False;
    PowerLightCheck.checked:=false;
    Timer1Timer(Self);
  end else
  begin
    playing:=false;
    DeviceClose;
    Timer1Timer(Self);
  end;
end;

procedure TCdPlay.TrackListClick(Sender: TObject);
function goodtime(s:string):string;
var m,hs:byte;
    p,hi:integer;
begin
  p:=pos(':',s);
  if p>0 then
  begin
    val(copy(s,1,p-1),m,hi);
    val(copy(s,p+1,length(s)),hs,hi);
  end else
  begin
    val(s,m,hi);
    hs:=0;
  end;
  goodtime:=strtime(m*60+hs);
end;
Var Modal : TEditTrack;
    i,p   : Integer;
begin
  if not HasDisk then exit;
  Try
    Modal := TEditTrack.Create(Self);
    p:=pos(':',DeviceInfo.CDName);
    Modal.Artist.Text := copy(DeviceInfo.CDName,1,p-1);
    Modal.CdName.Text := copy(DeviceInfo.CDName,p+1,255);
    SetStyles(Modal.Style);
    Modal.year.Text := DeviceInfo.year;
    EditNamesStringList:=DeviceInfo.Tracce;
    EditNameStringGrid(Modal.FieldStringGrid,EditNamesStringList);
    Modal.Style.ItemIndex := DeviceInfo.Style;
    Modal.EleTrack.RowCount := DeviceInfo.TrackCount+1;
    with Modal.EleTrack do
    Begin
      Cells[0,0] := 'nr';
      Cells[1,0] := 'time';
      Cells[3,0] := 'TrackName';
    End;
    with Modal.EleTrack do
    begin
      For i := 1 to DeviceInfo.TrackCount do
      with DeviceInfo.TInfo.TrackInfo[i] do
      Begin
	Cells[0,i] := xstr(i,2,0);
	Cells[1,i] := MciTime(TrackLen);
	Cells[3,i] := TrackName;
      End;
      for i:=0 to PlayList.count-1 do
      cells[2,PlayListAt(i)]:='*';
    end;
    Modal.DstList.RowCount := 1;
    with Modal.DstList do
    Begin
      rowcount:=1;
      Cells[0,0] := 'nr';
      Cells[1,0] := 'track';
      Cells[2,0] := 'start';
      Cells[3,0] := 'end';
      with DeviceInfo.EInfo do
      begin
	for i:=1 to Count do
	begin
	  rowcount:=i+1;
	  FixedRows:=1;
	  Cells[0,i]:=xstr(Track[i],2,0);
	  Cells[1,i]:=TrackName[i];
	  Cells[2,i]:=strtime(TrackStart[i]);
	  Cells[3,i]:=strtime(TrackEnd[i]);
	end;
      end;
      Modal.SetButtons;
    if (Modal.ShowModal = mrOk){ or (Modal.Selected<99) }then
    with Modal.DstList do
    Begin
      DeviceInfo.EInfo.clear;
      ReturnNameStringGrid(Modal.FieldStringGrid,EditNamesStringList);
      for i:=1 to rowcount-1 do
      with DeviceInfo do
      begin
	EInfo.add(valstr(Cells[0,i]),Cells[1,i],
	  calctime(goodtime(Cells[2,i])),calctime(goodtime(Cells[3,i])));
      end;
      for i:=PlayList.Count downto 1 do
      with DeviceInfo do
      if PlayListAt(i-1)>Trackcount+Einfo.Count then
      PlayList.delete(i-1);
      DeviceInfo.CDName :=
	trim(Modal.Artist.Text)+':'+ltrim(trim(Modal.CdName.Text));
      DeviceInfo.year:=Modal.year.Text;
      DeviceInfo.Style:=Modal.Style.ItemIndex;
      For i := 1 to DeviceInfo.TrackCount do
      Begin
	DeviceInfo.TInfo.TrackName[i] := Modal.EleTrack.Cells[3,i];
      End;
      setcaption;
{      if Modal.selected<99 then
      begin
	for i:=0 to PlayList.count-1 do
	if PlayListAt(i)=Modal.selected then
	currenttrack:=i;
	playing:=true;
	playtrack;
	SetTotalTime;
      end;}
      SetSelectTrack;
    end;
  end;
    Modal.Free
  Finally
  End;
end;

procedure TCdPlay.PowerLightCheckKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  cdplay.keydown(Key,Shift);
  if key=vk_space then
  begin
    PowerLightCheck.checked:=not PowerLightCheck.checked;
    checkpower;
  end;
end;

procedure TCdPlay.SetCheckMarks;
begin
    If not ElapsedTime.checked then
    ElapsedTimeLabel.caption:='Remain' else
    ElapsedTimeLabel.caption:='Elapsed';
    if TotalTime.checked then TimeLabel.caption:='Total Time' else
    TimeLabel.caption:='Time';
    with TrackLabel do
    if PlaylistNumber1.checked then
    caption:='Playlist' else caption:='Track';
    If Numdrives>1 then
    with ElapsedTimeLabel do
    caption:=caption+' '+DriveLetter[CurrentDrive]+':';
end;

procedure TCdPlay.ElapsedTimeClick(Sender: TObject);
begin
  if not HasDisk then exit;
  with ElapsedTime do
  begin
    checked:=not checked;
  end;
  SetCheckMarks;
  SetCurrentTime(prevtrack);
end;

function TCDPlay.badtrack(tr:integer):boolean;
begin
  badtrack:=(tr>deviceinfo.trackcount) or (tr<=0);
end;

procedure TCDPlay.calcextratime(tr:integer;var min2,sec2:byte);
var hlen:integer;
begin
  with DeviceInfo.EInfo.TrackInfo[tr] do
  begin
    hlen:=TrackEnd-TrackStart;
  min2:=hlen div 60;
  sec2:=hlen mod 60;
  end;
end;

procedure TCDPlay.SetMediaButtons;
var buttonset: TButtonSet;
begin
  if deviceopened then
  begin
    if playing then
    buttonset := [btPause, btStop, btNext, btPrev,
    btEject] else
    begin
      buttonset := [btPlay, btNext, btPrev,btEject];
      if paused then buttonset:=buttonset+[btPause,btStop];
    end;
  end else buttonset:=[bteject];
  Mediaplay1.ColoredButtons := buttonset;
  Mediaplay1.EnabledButtons :=buttonset;
  PlayTrack1.enabled:=btPlay in Buttonset;
  PauseTrack1.enabled:=btPause in Buttonset;
  StopTrack1.enabled:=btStop in Buttonset;
  PlayBitBtn.enabled:=btPlay in Buttonset;
  PauseBitBtn.enabled:=btPause in Buttonset;
  StopBitBtn.enabled:=btStop in Buttonset;
  NextBitBtn.enabled:=btNext in Buttonset;
  PreviousBitBtn.enabled:=btPrev in Buttonset;
end;

function TCDPlay.CalcTotalTime:longint;
var min2,sec2:longint;
    i:integer;
    min,sec:byte;
begin
  if alternate1.checked then
  begin
    MultList.MultiTotalTime(MultiList,min,sec);
    min2:=min;sec2:=sec;
  end else
  begin
      sec2:=0;
      min2:=0;
      for i:=0 to PlayList.count-1 do
      begin
	GetPlayTime(i,min,sec);
	sec2:=sec2+sec;
	min2:=min2+min;
      end;
  end;
  CalcTotalTime:=(Sec2 + (Min2*60));
end;

procedure TCDPlay.SetTitle(t:string);
var p,i:integer;
begin
  ExtraTitle:=ltrim(t);
  p:=pos(':',ExtraTitle);
  if p=0 then
  begin
  if Length(MainHalfTitle)<> 0 then
  begin
    ExtraTitle:=MainHalfTitle+' : '+ExtraTitle;
    p:=pos(':',ExtraTitle);
  end;
  end else
  if p=1 then
  begin
    ExtraTitle:=Ltrim(copy(ExtraTitle,2,length(ExtraTitle)));
    MainHalfTitle:='';
  end;
  if p=0 then
  begin
    TitleLabel.Visible:=true;
    HalfTitleLabel1.Visible:=false;
    HalfTitleLabel2.Visible:=false;
    TitleLabel.Caption:=ExtraTitle;
  end else
  begin
    MainHalfTitle:=trim(copy(ExtraTitle,1,p-1));
    TitleLabel.Visible:=false;
    if not minimum1.checked then
    begin
      HalfTitleLabel1.Visible:=true;
      HalfTitleLabel2.Visible:=true;
    end;
    HalfTitleLabel1.Caption:=MainHalfTitle;
    HalfTitleLabel2.Caption:=ltrim(copy(ExtraTitle,p+1,256));
  end;
  with select1 do
  begin
    for i:=0 to count-1 do
    with items[i] as TMenuItem do checked:=false;
    if alternate1.checked then
    begin
      i:=MultList.MultiTracknr(currentdrive,playlistat(currenttrack),MultiList)-1;
      with items[i] as TMenuItem do checked:=true;
    end else
    if (currenttrack>-1) and (count>0) then
    with items[CurrentTrack] as TMenuItem do checked:=true;
  end;
end;

procedure TCDPlay.SetTotalTime;
var htr,htl,tr:byte;
    sec2,min2:longint;
    TheLength:longint;
begin
  setpointon;
  SetMediaButtons;
  if not deviceopened or not NextTrack1.enabled then exit;
  tr  := mci_TMSF_Track(Mediaplay1.Position);
  if badtrack(tr) then exit;
  prevtrack:=tr;
  with positionslider do
    begin
      maximum:=CalcRunningTime;
      minimum:=0;
      value:=0;
    end;
    if TotalTime.checked then
    begin
      TheLength := CalcTotalTime;
    end else
	TheLength:=CalcRunningTime;
    min2:=TheLength div 60;
    sec2:=TheLength mod 60;
    TimeDigit0.visible:=(min2 div 60)>0;
    TimeDigit0.Value:=(min2 div 60);
    TimeDigit1.Value:=(min2 mod 60) div 10;
    TimeDigit2.Value:=(min2 mod 60) mod 10;
    TimeDigit3.Value:=sec2 div 10;
    TimeDigit4.Value:=sec2 mod 10;
    SetTitle(ExtraTitle);
    if not PlaylistNumber1.checked then
    begin
      htr:=tr;
      htl:=DeviceInfo.Trackcount;
    end else
    if alternate1.checked then
    begin
      htr:=MultList.MultiTracknr(currentdrive,playlistat(currenttrack),MultiList);
      htl:=MultiList.Count;
    end else
    begin
      htr:=currenttrack+1;
      htl:=PlayList.count;
    end;
    TrackDigit1.Value:=htr div 10;
    TrackDigit2.Value:=htr mod 10;
    TotTracksDigit1.Value:=htl div 10;
    TotTracksDigit2.Value:=htl mod 10;
  SetCurrentTime(tr);
  SetCaption;
  SetBottom;
end;

procedure TCdPlay.TotalTimeClick(Sender: TObject);
begin
  if not HasDisk then exit;
  with TotalTime do
  begin
    checked:=not checked;
    SetCheckMarks;
    SetTotalTime;
  end;
end;

procedure TCDPlay.StartSlider;
begin
  PosLabel.visible:=true;
end;

procedure TCDPlay.ReactSlider;
var m,s,hf:longint;
    tr:byte;
begin
  if DeviceOpened then
  with Mediaplay1 do
  begin
    tr  := mci_TMSF_Track(Mediaplay1.Position);
    hf := PositionSlider.value+ExtraStart;
    s:=hf mod 60;
    hf:=hf div 60;
    m:=hf;
    StartPos := mci_Make_TMSF(tr, m, s, 0);
    if CurrentExtraTrack then
    Mediaplay1.EndPos := mci_Make_TMSF(tr, ExtraEnd div 60, ExtraEnd mod 60, 0)
    else
    If tr < DeviceInfo.TrackCount then
    Mediaplay1.EndPos := mci_Make_TMSF(tr+1, 0, 0, 0);
    if playing then
    begin
      notify:=true;
      play;
    end else
    position:=startpos;
    poslabel.visible:=false;
  end;
end;

procedure TCdPlay.PositionSliderMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  ReactSlider;
end;

procedure TCdPlay.PositionSliderKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ReactSlider;
end;

procedure TCdPlay.PositionSliderMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button=mbright then
  begin
    CaptionDisplay1Click(Sender);
    exit;
  end;
  if button=mbLeft then
  StartSlider;
  TrackDigit1MouseDown(self,button,shift,x,y);
end;

procedure TCdPlay.PositionSliderKeydown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  StartSlider;
end;

procedure TCdPlay.PositionSliderValueChange(Sender: TObject);
begin
  with PositionSlider do
  if hasmousedown then
  begin
    PosLabel.caption:=strtime(value);
  end;
end;

procedure TCdPlay.Shuffle1Click(Sender: TObject);
var i,p,tr:integer;
    s:string;
begin
  if PlayList.count = 0 then exit;
  randomize;
  with PlayList do
  begin
    if currenttrack<>-1 then
    tr:=PlayListAt(currenttrack) else tr:=0;
    for i:=count downto 2 do
    begin
      p:=random(i);
      s:=PlayList[p];
      delete(p);
      add(s);
    end;
    s:=PlayList[0];
    delete(0);
    add(s);
    if currenttrack<>-1 then
    begin
      currenttrack:=-1;
      for i:=0 to PlayList.count-1 do
      if PlayListAt(i)=tr then currenttrack:=i;
    end;
  end;
  SetSelectTrack;
end;

procedure TCdPlay.Save1Click(Sender: TObject);
begin
  If DeviceOpened then
  begin
    DeviceExist:=true;
    SetErase(true);
    SaveDeviceInfo(DeviceInfo);
  end;
end;

procedure TCdPlay.Reread1Click(Sender: TObject);
begin
  If DeviceOpened then
  GetDeviceInfo(DeviceInfo);
  settotaltime;
end;

procedure TCdPlay.EraseCDClick(Sender: TObject);
begin
    if Application.MessageBox('OK to erase CD-definition from File?',
      'Erase CD', mb_YesNo)= idYes then
    with DeviceInfo,Table1 do {TTable}
    begin
      if FindKey([CDUniqueCode]) or FindKey([CDPlayerCode]) then delete;
    SetErase(false);
  end;
end;

procedure TCdPlay.TrackDigit1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button=mbRight then
  begin              {tpopupmenu}
    popupmenu1.popup(Left+x-10,top+y);
  end;
end;

procedure TCdPlay.SelectPopupTrack(var MI:TMenuItem);
var nr,i:integer;
begin
  nr:=PlayList.count;
  For i:=MI.Count-1 downto 0 do
  MI.delete(i);
  if deviceopened then
  if alternate1.checked then
  begin
    for i:=1 to MultiList.Count do
    begin
      MI.add(TMenuItem.Create(PopupMenu1));
      MI[i-1].onclick:=PopupMenuClick;
      MI[i-1].Caption :='&'+copy(MultiList[i-1],6,length(MultiList[i-1]));
      MI[i-1].Tag:=i;
    end;
  end else
  begin
    with DeviceInfo do
    for i:=1 to nr do
    begin
      MI.add(TMenuItem.Create(PopupMenu1));
      MI[i-1].onclick:=PopupMenuClick;
      MI[i-1].Caption :='&'+GetTrackName(i-1);
      MI[i-1].Tag:=i;
    end;
  end;
  MI.enabled:=MI.Count>0;
end;

function TCdPlay.GetTrackName(i:integer):string;
var pl:integer;
    min,sec:byte;
begin
  with DeviceInfo do
      with TInfo.TrackInfo[PlayListAt(i)] do
      if PlayListAt(i)<=Trackcount then
      begin
	GetTrackName :=TrackName+' ('+MciTime(TrackLen)+')';
      end else
      begin
	pl:=PlayListAt(i)-Trackcount;
	CalcExtraTime(pl,min,sec);
	GetTrackName :=
	  EInfo.TrackName[pl]+' ('+
	  StrTime(EInfo.TrackLen[pl])+')';
      end;
end;

procedure TCdPlay.SelectTrackProc(n:byte);
begin
  if alternate1.checked then
  begin
    PlayMultiItem(n-1);
  end else
  begin
    currenttrack:=n-1;
    if playtrack then
    SetTotalTime;
  end;
end;
procedure TCdPlay.PopupMenuClick(Sender: TObject);
begin
  with sender as TMenuItem do
  begin
      SelectTrackProc(tag);
  end;
end;

procedure TCdPlay.AutoPlayClick(Sender: TObject);
begin
  AutoPlay.checked:=not AutoPlay.Checked;
end;

procedure TCdPlay.ContinuePlayingClick(Sender: TObject);
begin
  ContinuePlaying.checked:=not ContinuePlaying.Checked;
end;

procedure TCdPlay.Exit1Click(Sender: TObject);
begin
  close;
end;

procedure TCdPlay.Current1Click(Sender: TObject);
var f:textfile;
    i,pl:integer;
    c:integer;
    min,sec:byte;
    Modal : TPrintDB;
begin
  Try
    Modal := TPrintDB.Create(Self);
    with Modal do
    begin
      Filename1.text:=OutputFilename;
      FileRadioButton.checked:=DestPrintFileChecked=1;
      PrinterRadioButton.checked:=DestPrintFileChecked=2;
      ScreenRadioButton.checked:=DestPrintFileChecked=3;
      with SaveDialog2 do
      options:=options-[ofOverwritePrompt];
      MaskGroupBox.visible:=false;
      SelectionGroupBox.visible:=false;
      FilterPanel.visible:=false;
      ClientHeight:=64+panel1.height;
    end;
    if Modal.ShowModal = mrOk then
      with Modal do
      begin
         if FileRadioButton.checked then
	 DestPrintFileChecked:=1 else
         if PrinterRadioButton.checked then
	 DestPrintFileChecked:=2 else
         if ScreenRadioButton.checked then
	 DestPrintFileChecked:=3;
	 OutputFilename:=Filename1.text;
	 if DestPrintFileChecked=1 then
	 begin
           AssignTextFile(f,OutputFilename);
	   append(f);
	 end else
	 if DestPrintFileChecked=2 then
	 begin
	   AssignPrn(f);
	   Rewrite(f);
	 end else
         Showmessage('On screen print not allowed here');
	 c:=0;
	 writeln(f,rname(DeviceInfo.CDName)+' ('+strtime(CalcTotalTime)+')');
	 for i:=1 to PlayList.count do
	 begin
	    inc(c);
	     write(f,xstr(c,2,0)+'('+
	       xstr(PlayListAt(i-1),2,0)+') ');
	     with DeviceInfo,DeviceInfo.TInfo.TrackInfo[PlayListAt(i-1)] do
	     if PlayListAt(i-1)<=DeviceInfo.Trackcount then
	     begin
	       writeln(f,TrackName+' ('+MciTime(TrackLen)+')');
	     end else
	     begin
	       pl:=PlayListAt(i-1)-DeviceInfo.Trackcount;
	       CalcExtraTime(pl,min,sec);
	       writeln(f,
		 EInfo.TrackName[pl]+' ('+
		     StrTime(EInfo.Tracklen[pl]{ div 1000})+')');
	     end;
	 end;
	 closefile(f);
	 if DestPrintFileChecked=1 then
	 ShowMessage('Current CD appended to '+OutputFilename);
      end;
    Modal.Free
  Finally
  End;
end;

function possible(b:boolean):boolean;
begin
  if not b then messagebeep(0);
  possible:=b;
end;

procedure TCdPlay.EraseTextFile1Click(Sender: TObject);
var f:textfile;
    p:pchar;
    s:string;
begin
  s:='OK to erase textfile '+
     OutputFilename+' from disk?';
  getmem(p,length(s)+1);
  strpcopy(p,s);
  if Application.MessageBox(p,
      'Erase TextFile', mb_YesNo)= idYes then
  begin
    AssignTextFile(f,OutputFilename);
    erase(f);
  end;
  freemem(p,length(s)+1);
end;

procedure TCdPlay.IntroScanClick(Sender: TObject);
begin
  IntroScan.checked:=not IntroScan.checked;
  IntroLightCheck.checked:=IntroScan.checked;
  if IntroScan.Checked then
  begin
    playing:=true;
    FindNextTrack;
  end else
  playtrack;
end;

procedure TCdPlay.Database1Click(Sender: TObject);
var DataBaseDlg:TDataBaseDlg;
begin
  Try
    DataBaseDlg := TDataBaseDlg.Create(Self);
    with DataBaseDlg do
    begin
     WindowState:=wsNormal;
     showmodal; {TForm}
     Free
    end;
  Finally
  End;
end;

procedure TCdPlay.Play1Click(Sender: TObject);
begin
  CurrentTrack:=PosiListBox;
  playTrack;
end;

function minimum(i,j:integer):integer;
begin
  if i<j then minimum:=i else minimum:=j;
end;

procedure TCdPlay.Delete1Click(Sender: TObject);
begin
  PlayList.delete(PosiListBox);
  SetSelectTrack;
  if PosiListBox<=CurrentTrack then
  begin
    if PosiListBox=CurrentTrack then
    begin
      if CurrentTrack>PlayList.count-1 then
      dec(CurrentTrack);
      playtrack;
    end else dec(CurrentTrack);
  end;
  SetTotalTime;
end;

procedure TCdPlay.DeleteTrackClick(Sender: TObject);
begin
  if CurrentTrack>=0 then
  begin
    PosiListBox:=CurrentTrack;
    Delete1Click(Sender);
  end;
end;

procedure TCdPlay.NextTrack1Click(Sender: TObject);
begin
  paused:=false;
  FindNextTrack;
  SetTotalTime;
end;

procedure TCdPlay.PreviousTrackClick(Sender: TObject);
begin
  paused:=false;
  FindPrevTrack;
  SetTotalTime;
end;

procedure TCdPlay.PlayTrack1Click(Sender: TObject);
begin
  playing:=true;
  paused:=false;
  if playtrack then
  begin
    Timer1.enabled:=true;
  end ;
  IntroScan.checked:=false;
end;

procedure TCdPlay.RepeatTrack1Click(Sender: TObject);
begin
  with RepeatTrack1 do
  begin
    checked:=not checked;
    RepeatLightCheck.checked:=checked;
  end;
end;

procedure TCdPlay.PowerWindowOnLabelClick(Sender: TObject);
begin
  with MediumWindow do
  begin
    LargeWindowchecked(false);
    MediumWindowchecked(not checked);
    ShowWindows;
  end;
end;

procedure TCdPlay.MediumWindowClick(Sender: TObject);
begin
  with MediumWindow do
  begin
    LargeWindowchecked(false);
    MediumWindowchecked(true);
    ShowWindows;
  end;
end;

procedure TCDPlay.ShowWindows;
procedure settabstop(b:boolean);
begin
  PlayBitBtn.Tabstop:=b;
  PauseBitBtn.Tabstop:=b;
  StopBitBtn.Tabstop:=b;
  NextBitBtn.Tabstop:=b;
  PreviousBitBtn.Tabstop:=b;
  EjectBitBtn.Tabstop:=b;
end;
begin
  if minimum1.checked then Toolbar1.checked:=false;
  if Toolbar1.checked then Mytoolbar.height:=25 else
  MyToolbar.height:=0;
  Panel1.top:=MyToolbar.top+MyToolbar.height+4;
  PositionSlider.Tabstop:=false;
  settabstop(false);
  if LargeWindow.checked then
  begin
    MediumWindowchecked(false);
    SmallWindowchecked(false);
    PositionSlider.Tabstop:=true;
    settabstop(true);
  end;
  if LargeWindow.checked then Clientheight:={FormHeight}SliderPanel.top+
   SliderPanel.height+7 else
  if MediumWindow.checked then
  begin
    Clientheight:={FormHeight-46}SliderPanel.top;
    settabstop(true);
  end else
  begin
    if Minimum1.checked then
    ClientHeight:={Panel2.top-PanelTopExtra}Panel1.height+5+6 else
    Clientheight:={FormHeight-110}Panel2.top;
    ActiveControl:=PowerLightCheck;
  end;
  if MediumWindow.checked or LargeWindow.checked then
  begin
    if SmallWindow.checked then
    ChangeTimeVisible;
    ActiveControl:=PowerLightCheck;
    PositionSlider.Tabstop:=false;
    settabstop(false);
  end;
  PowerWindowOnLabel.Top:=Panel1.Top+Panel1.Height;
  Panel2.Top:=PowerWindowOnLabel.Top+PowerWindowOnLabel.Height;
  TrackDisplayOnLabel.Top:=Panel2.Top+Panel2.Height;
  SliderPanel.Top:=TrackDisplayOnLabel.Top+TrackDisplayOnLabel.Height;
  Mytoolbar.width:=width-10;
  setbottom;
  DispTimeVisible;
end;

procedure TCdPlay.LargeWindowClick(Sender: TObject);
begin
  with LargeWindow do
  begin
    LargeWindowchecked(true);
    ShowWindows;
  end;
end;

procedure TCdPlay.ChangeTimeVisible;
  begin
    SmallWindowchecked(not SmallWindow.checked);
    if SmallWindow.checked then
    begin
      LargeWindowchecked(false);
      MediumWindowchecked(false);
    end;
    ShowWindows;
  end;

procedure TCdPlay.TimeVisibleLabelClick(Sender: TObject);
begin
  ChangeTimeVisible;
end;

procedure TCdPlay.DispTimeVisible;
procedure setwidth(wi:integer);
begin
    CDPlay.Width:=wi;
    Panel1.Width:=CDPlay.Width-2*(Panel1.Left+3);
    TimeVisibleLabel.Left:=CDPlay.Width-18;
end;
begin
  if SmallWindow.checked then
  begin
    setwidth(FormWidth-MinFormWidth);
    Help1.Visible:=false;
  end else
  begin
    setwidth(FormWidth);
    Help1.Visible:=true;
  end;
  Minimum1Set(minimum1.checked);
  if deviceopened then
  SetTotalTime;
end;

procedure TCdPlay.FormResize(Sender: TObject);
begin
  showwindows;
end;

procedure TCdPlay.Shape2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (button=mbLeft) then
  begin
    if not hasdisk then exit;
    ElapDigit1Click(Sender)
  end;
end;

procedure TCdPlay.TrackDisplayOnLabelClick(Sender: TObject);
begin
  with LargeWindow do
  begin
    LargeWindowchecked(not checked);
    if not checked then MediumWindowchecked(true);
    ShowWindows;
  end;
end;

procedure TCdPlay.CaptionDisplay1Click(Sender: TObject);
Var Modal : TCaptionDisplayDlg;
begin
  Try
    Modal := TCaptionDisplayDlg.Create(Self);
    with modal do
    begin
      case DisplayBottomItems of
	1:SliderRadioButton.checked:=true;
	2:AutoRadioButton.checked:=true;
	3:TextRadioButton.checked:=true;
      end;
      if ShowModal=id_ok then
      begin
	if SliderRadioButton.checked then DisplayBottomItems:=1;
	if AutoRadioButton.checked then DisplayBottomItems:=2;
	if TextRadioButton.checked then DisplayBottomItems:=3;
      end;
      Free;
    end;
    setcaption;
    setbottom;
  Finally
  End;
end;

procedure TCdPlay.SetDisplayColours(SColour,bgColour,TTColour,DGColour,LBColour:TColor);
var i:integer;
begin
  BackGroundColour:=bgColour;
  TrackTitleColour:=TTColour;
  SurfaceColour:=SColour;
  DigitsColour:=DGColour;
  LabelColour:=LBColour;
  CDPlay.Color:=SurfaceColour;
  TrackLabel.Font.Color:=LBColour;
  ElapsedTimeLabel.Font.Color:=LBColour;
  TimeLabel.Font.Color:=LBColour;
      Panel1.Color:=bgColour;
  for i:=1 to NumDigits do
  with MyDigits[i] do
  begin
    Color:=bgColour;
    Coloroff:=bgColour;
    ColorOn:=DGColour;
  end;
      Shape1.Brush.Color:=DGColour;
      Shape2.Brush.Color:=DGColour;
      Shape3.Brush.Color:=DGColour;
      Shape4.Brush.Color:=DGColour;
      Shape1.Pen.Color:=DGColour;
      Shape2.Pen.Color:=DGColour;
      Shape3.Pen.Color:=DGColour;
      Shape4.Pen.Color:=DGColour;
      TitleLabel.Font.Color:=TTColour;
      HalfTitleLabel1.Font.Color:=TTColour;
      HalfTitleLabel2.Font.Color:=TTColour;
end;

procedure TCdPlay.CloursDisplay1Click(Sender: TObject);
Var Modal : TDisplayColour;
begin
  Try
    Modal := TDisplayColour.Create(Self);
    with Modal do
    begin
      Surface.Brush.Color:=SurfaceColour;
      MyLabel.Brush.Color:=LabelColour;
      TrackTitle.Brush.Color:=TrackTitleColour;
      BackGround.Brush.Color:=BackGroundColour;
      Digits.Brush.Color:=DigitsColour;
    end;
    if (Modal.ShowModal = mrOk) then
    with Modal do
    begin
      SetDisplayColours(Surface.Brush.Color,BackGround.Brush.Color,TrackTitle.Brush.Color,
	 Digits.Brush.Color, MyLabel.Brush.Color);
    end;
    Modal.Free
  Finally
  End;
end;

procedure TCdPlay.PauseTrack1Click(Sender: TObject);
begin
  dopause(btpause)
end;

procedure TCdPlay.StopTrack1Click(Sender: TObject);
begin
  dopause(btStop);
  SetTotalTime;
end;



procedure TCdPlay.EjectTray1Click(Sender: TObject);
begin
    Timer1.enabled:=true;
    with MediaPlay1 do
    if DeviceOpened then
    begin
      deviceopened:=false;
      DeviceInfoFree;
      notify:=true;
      eject;
    end else
    begin
      retractcd(Mediaplay1.DeviceID);
    end;
end;

procedure TCdPlay.Minimum1Click(Sender: TObject);
begin
  Minimum1Set(not Minimum1.checked);
end;

procedure TCdPlay.Minimum1Set(BNew:boolean);
var
  SystemMenu:HMenu;
  I: Integer;
begin
  if BNew=Minimum1.checked then exit;
  Minimum1.checked:=BNew;
  Minimum1pop.checked:=BNew;
  if Minimum1.checked then
  begin
    TrackLabel.Visible:=false;
    ElapsedTimeLabel.Visible:=false;
    TimeLabel.Visible:=false;
    HalfTitleLabel1.Visible:=false;
    HalfTitleLabel2.Visible:=false;
    TitleLabel.Visible:=false;
    for I:= 0 to Panel1.ControlCount -1 do
       Panel1.Controls[I].top := Panel1.Controls[I].top -PanelTopExtra;
    Panel1.Height:=Panel1.Height-+PanelTopExtra-TitleLabel.Height;
    BorderStyle:=bsDialog;
    SystemMenu:=GetSystemMenu(Handle,false);
    insertmenu(systemmenu,7,mf_separator,901,'');
    insertmenu(systemmenu,8,mf_byposition+mf_string,1000,'Show &Menu');
    insertmenu(systemmenu,9,mf_byposition+mf_string,1001,'M&aximize');
    Application.OnMessage:=wmHandleMessages;
  end else
  begin
    TrackLabel.Visible:=true;
    ElapsedTimeLabel.Visible:=true;
    TimeLabel.Visible:=true;
    TitleLabel.Visible:=true;
    for I:= 0 to Panel1.ControlCount -1 do
       Panel1.Controls[I].top := Panel1.Controls[I].top +PanelTopExtra;
    Panel1.Height:=Panel1.Height+PanelTopExtra+TitleLabel.Height;
    BorderStyle:=bsSizeable;
{    SystemMenu:=GetSystemMenu(Handle,true);}
  end;
  ShowWindows;
end;

procedure TCdPlay.wmHandleMessages(var Msg:TMsg;var Handled:Boolean);
begin
  if Msg.Message=WM_SYSCOMMAND then begin
    case Msg.wParam of
      1000:begin
	Minimum1Set(not Minimum1.checked)
      end;
      1001:begin
	Minimum1Set(not Minimum1.checked);
	LargeWindowClick(Self);
      end;
    end;
  end
end;

procedure TCdPlay.PlaylistNumber1Click(Sender: TObject);
begin
  if not HasDisk then exit;
  PlaylistNumber1.checked:=not PlaylistNumber1.checked;
  SetTotalTime;
  SetCheckMarks;
end;

procedure TCdPlay.clearbottom;
begin
      BottomLabel1.Caption:='';
      BottomLabel2.Caption:='';
end;

procedure TCdPlay.BottomLabel1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button=mbright then
    CaptionDisplay1Click(Sender);
end;

procedure TCdPlay.PlayIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button<>mbRight then
  if possible(PlayBitBtn.enabled) then
  PlayTrack1Click(Sender)
end;

procedure TCdPlay.PauseIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button<>mbRight then
  if possible(PauseBitBtn.enabled) then
  PauseTrack1Click(Sender);
end;

procedure TCdPlay.StopIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button<>mbRight then
  if possible(StopBitBtn.enabled) then
  StopTrack1Click(Sender);
end;

procedure TCdPlay.NextIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button<>mbRight then
  if possible(NextBitBtn.enabled) then
  NextTrack1Click(Sender);
end;

procedure TCdPlay.PreviousIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button<>mbRight then
  if possible(PreviousBitBtn.enabled) then
  PreviousTrackClick(Sender);
end;

procedure TCdPlay.EjectIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button<>mbRight then
  EjectTray1Click(Sender);
end;

procedure TCdPlay.MainIconMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button<>mbRight then
  MainPopupMenu.popup(x-10,y);
end;

procedure TCdPlay.MainPopupMenuPopup(Sender: TObject);
begin
  CopyMainToPop;
end;

procedure TCdPlay.PopupMenu1Popup(Sender: TObject);
var hm:TMenuItem;
begin
  hm:=popupmenu1.Items;
  SelectPopupTrack(hm);
end;

procedure TCdPlay.ElapDigit1Click(Sender: TObject);
begin
  if not HasDisk then exit;
  dopause(btpause);
end;

procedure TCdPlay.Shape4MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (button=mbLeft) then
  begin
    if not HasDisk then exit;
    TotalTimeClick(self);
  end;
end;

procedure TCdPlay.Panel1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if not HasDisk then exit;
  if button=mbRight then
  begin
    if (minimum1.checked) then
    MainPopupMenu.popup(Left+x-10,top+y) else
    TrackDigit1MouseDown(Sender,Button,Shift,X, Y);
  end;
end;

procedure TCdPlay.RepeatLightCheckClick(Sender: TObject);
begin
  RepeatTrack1Click(self);
end;

procedure TCdPlay.IntroLightCheckClick(Sender: TObject);
begin
  IntroScanClick(self);
end;

procedure TCdPlay.PowerLightCheckClick(Sender: TObject);
begin
  checkpower;
end;

procedure TCdPlay.Volumecontrol1Click(Sender: TObject);
begin
    MyVolumeDlg.Show;
end;

procedure TCdPlay.SetDeviceType(MyDeviceType: TMPDeviceTypes);
begin
  with MediaPlay1 do
  begin
    if AutoPlay.checked or playing then stop;
    if deviceopened then
    checkpower;
    Close;
    DeviceType := MyDeviceType;
    Open;
    checkpower;
    SetCheckMarks;
  end;
end;

procedure TCdPlay.Device11Click(Sender: TObject);
var i:integer;
begin
  with sender as TmenuItem do
  if CurrentDrive<>tag then
  begin
    i:=tag;
    CurrentDrive:=i;
    SetDeviceType(dtCDAudio);
  end;
end;

procedure TCdPlay.AutoSwitch1Click(Sender: TObject);
begin
  with AutoSwitch1 do
  checked:=not checked;
end;

procedure TCdPlay.Alternate1Click(Sender: TObject);
begin
  with Alternate1 do checked:=not checked;
end;

procedure TCdPlay.Read1Click(Sender: TObject);
begin
  with IniOpenDialog do
  if Execute then
  begin
    ReadSettings(filename);
    DisplaySettings;
  end;
end;

procedure TCdPlay.Save2Click(Sender: TObject);
begin
  with IniSaveDialog do
  if Execute then
  WriteSettings(filename);
end;

procedure TCdPlay.ResetInifileClick(Sender: TObject);
begin
  ReadSettings('');
  DisplaySettings;
end;

procedure TCdPlay.Clocktotal1Click(Sender: TObject);
begin
  with Clocktotal1 do checked:=not checked;
end;

procedure TCdPlay.Hide1Click(Sender: TObject);
begin
  with hide1 do
  begin
    checked:=not checked;
    if checked then
    hide else
    begin
      show;
      SetTotalTime;
    end;
  end;
end;

procedure TCdPlay.Apply1Click(Sender: TObject);
var i,np:integer;
    s:string;
    cd:char;
begin
    MultiPlayList.Clear;
    i:=1;
    np:=0;
    s:=xstr(CurrentDrive,1,0);
    cd:=s[1];
    while i<=MultiList.Count do
    begin
      inc(np);
      s:='Mult'+xstr(np,2,0);
      while (i<=MultiList.Count) and (MultiList[i-1][1]<>
	cd) do inc(i);
      while (i<=MultiList.Count) and (MultiList[i-1][1]=
	cd) do
      begin
	if true{not greater than number of tracks} then
	s:=s+copy(MultiList[i-1],3,2);
	inc(i);
      end;
      if length(s)>6 then
      MultiPlayList.add(s);
    end;
end;

procedure TCdPlay.Multilist1Click(Sender: TObject);
var i:integer;
begin
    with MultiListDlg do
    begin
      CurrentPlaylist.clear;
      with CDIds do
      begin
	for i:=count+1 to NumDrives do
	add('');
	CDIds[Currentdrive-1]:=DeviceInfo.CDPlayerCode;
      end;
      For i:=1 to Playlist.count do
      begin
	CurrentPlaylist.add(xstr(CurrentDrive,1,0)+' '+
	  xstr(PlayListAt(i-1),2,0)+' '+GetTrackName(i-1));
      end;
      MultiListListBox.Items.clear;
      for i:=1 to MultiList.count do
      MultiListListBox.Items.add(MultiList[i-1]);
    end;
    if (MultiListDlg.ShowModal=mrok) or (MultiListDlg.action>0) then
    with MultiListDlg do
    begin
      MultiList.clear;
      for i:=1 to MultiListListBox.Items.count do
      MultiList.add(MultiListListBox.Items[i-1]);
      if action=1 then
      PlayMultiItem(0);
      if action=2 then PlayMultiItem(MultiListListBox.ItemIndex);
    end;
end;

procedure TCdPlay.PlayMultiItem(ItemIndex:integer);
var cdnr1:byte;
    code,i:integer;
    prognr1:integer;
    prevnr:boolean;
    trnr:byte;
begin
  val(copy(MultiList[ItemIndex],1,1),cdnr1,code);
  prognr1:=-1;
  prevnr:=false;
  trnr:=0;
  for i:=0 to ItemIndex do
  begin
    if copy(MultiList[i],1,1)=xstr(cdnr1,1,0) then
    begin
      if not prevnr then
      begin
	prevnr:=true;
	inc(prognr1);
	trnr:=0;
      end else
      begin
	inc(trnr);
      end;
    end else
    prevnr:=false;
  end;
  PlayMultiTrack(cdnr1,prognr1,trnr);
end;

procedure TCdPlay.PlayMultiTrack(cdnr1,prognr1,trnr:integer);
procedure CopyMultProg(j:integer);
var s:string;
    i:integer;
begin
  PlayList.clear;
  Apply1Click(Self);
  if j>=MultiPlayList.count then j:=0;
  s:=copy(MultiPlayList[j],7,length(MultiPlayList[j]));
  for i:=1 to length(s) div 2 do
  PlayList.add(copy(s,(i-1)*2+1,2));
end;
procedure ErrorSwitch;
begin
    alternate1.checked:=false;
    ShowMessage('Wrong CD in drive '+DriveLetter[currentdrive]);
end;
begin
  {set alternate, playing off}
  if MultiList.Count=0 then exit;
  timer1.enabled:=false;
  if playing then
  StopTrack1Click(Self);
  autoplay.checked:=false;
  autosave.checked:=false;
{  alternate1.checked:=false;}
  if currentdrive<>cdnr1 then
  begin
    {select cd cdnr1}
    currentdrive:=cdnr1;
    SetDeviceType(dtCDAudio);
  end;
  with MediaPlay1 do
  if mode in [mpNotReady,mpOpen] then
  begin
    ErrorSwitch;
    exit;
  end;
  if MultiListDlg.CDIds[currentdrive-1]<>DeviceInfo.CDPlayerCode then
  begin
    ErrorSwitch;
    exit;
  end;
  {set playing off}
  with MediaPlay1 do
  if mode=mpPlaying then stop;
  {apply}
  Apply1Click(Self);
  {copy multprog prognr1}
  CopyMultProg(prognr1);
  with MediaPlay1 do
  if mode=mpPlaying then stop;
  lightsoff:=false;
  {play track trnr}
  alternate1.checked:=true;
  SetSelectTrack;
  autoswitch1.checked:=true;
  {start playing}
  currenttrack:=trnr;
  playing:=true;
  playtrack;
  timer1.enabled:=true;
  settotaltime;
  SetCheckMarks;
end;

procedure TCdPlay.DriveParameterFirst(Sender: TObject; RestItem: String);
var j:integer;
begin
  for j:=1 to Numdrives do
  if Upcase(DriveLetter[j])=Upcase(RestItem[1]) then
  CurrentDrive:=j;
end;

procedure TCdPlay.CDPlayerExecuteMacro(Sender: TObject; Msg: TStrings);
var j:integer;
    prevdrive:integer;
begin
  if playing then exit;
  PrevDrive:=CurrentDrive;
  for j:=1 to Numdrives do
  if Upcase(DriveLetter[j])=Upcase(msg[0][1]) then
  CurrentDrive:=j;
  if PrevDrive<>CurrentDrive then
  SetDeviceType(dtCDAudio);
end;

procedure TCdPlay.Pack1Click(Sender: TObject);
begin
  Table1.cancel;
  Table1.active:=false;
  Table1.exclusive:=true;
  Table1.active:=true;
  Check(DbiPackTable(Table1.DbHandle,Table1.Handle, Nil, szDBASE, TRUE));
  Table1.active:=false;
  Table1.exclusive:=false;
  Table1.active:=true;
end;

procedure TCdPlay.AutoAsk1Click(Sender: TObject);
begin
  AutoAsk1.checked:=not AutoAsk1.Checked;
end;

procedure TCdPlay.EnterDataTimerTimer(Sender: TObject);
begin
  EnterDataTimer.enabled:=false;
  TrackListClick(Self);
end;

procedure TCdPlay.Toolbar1Click(Sender: TObject);
begin
  Toolbar1.checked:=not Toolbar1.checked;
  ShowWindows;
  ShowWindows;{twice, otherwise height of main window is not correct}
end;

procedure TCdPlay.Ignore1trackCDClick(Sender: TObject);
begin
  Ignore1trackCD.checked:=not Ignore1trackCD.checked;
end;

procedure TCdPlay.HelpClick(Sender: TObject);
begin
  HelpForm.show;
end;

procedure TCdPlay.HelpContextClick(Sender: TObject);
begin
    Helpform.showhelp(sender);
end;

procedure TCdPlay.TrackChangedTimerTimer(Sender: TObject);
begin
  TrackChangedTimer.enabled:=false;
end;

end.
