unit Lightchk;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  tshape=(tsLed,tsCircle,tsRectangle,tsBar, tsRightArrow, tsLeftArrow,
    tsDownArrow, tsUpArrow);
  TLightCheck = class(TCustomControl)
  private
    PFState: TCheckBoxState;
    PFShape:tshape;
    FOnColor,
    FOffColor  : TColor;
    hBar:byte;
    function GetChecked: Boolean;
    procedure SetChecked(Value: Boolean);
    procedure SetOnColor(Value: TColor);
    procedure SetOffColor(Value: TColor);
    procedure SetShape (value : TShape);
    Procedure WMGetDlgCode(var Msg:TWMGetDlgCode);
              message wm_GetDlgCode;
  protected
    procedure Paint; override;
    procedure Toggle; virtual;
    procedure Click; override;
  public
    constructor Create(aOwner: TComponent); override;
    procedure CreateParams(var Params: TCreateParams); override;
    property State: TCheckBoxState read PFState;
  published
    property Shape : Tshape read PFShape write SetShape;
    property Checked: Boolean read GetChecked write SetChecked;
    property OnColor: TColor read FOnColor write SetOnColor default clLime;
    property OffColor: TColor read FOffColor write SetOffColor default clRed;
    property OnClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnEnter;
    property Visible;
    property ShowHint;
    property ParentShowHint;
    property Tag;
    property OnExit;
    property OnKeyPress;
    property OnKeyDown;
    property OnKeyUp;
    property TabStop;
    property TabOrder;
  end;



procedure Register;



implementation

uses
    ExtCtrls;


constructor TLightCheck.Create;
begin
  inherited Create(aOwner);
  ControlStyle := [csCaptureMouse, csClickEvents, csDesignInteractive];
  FOnColor := clLime;
  FOffColor := clRed;
  Width := 7;
  Height := 7;
  hBar:=4;
end;

procedure TLightCheck.SetShape (value : TShape);
begin
  if PFShape <> value then
  begin
    PFShape := value;
    Invalidate
  end
end;

procedure TLightCheck.CreateParams(var Params: TCreateParams);
begin
  { call the create of the params }
  inherited CreateParams(Params);
  { and then add our twist, transparency }
  Params.ExStyle := Params.ExStyle + WS_EX_Transparent;
end;

Procedure TLightCheck.WMGetDlgCode(var Msg:TWMGetDlgCode);
begin
inherited;
Msg.Result:=dlgc_WantArrows;
end;



procedure TLightCheck.Paint;
var
   X,
   Y        : Integer;
   TheColor : TColor;
   hw,hh:integer;
   mc:TColor;
begin
  X := (Width div 2) - 3;
  Y := (Height div 2) - 3;

  if Checked then
    TheColor := FOnColor
  else
    TheColor := FOffColor;

  with Canvas do
  case PFShape of
  tsLed:
  begin
{  7x7 }
    Pixels[X+2, Y] := clBtnShadow;
    Pixels[X+3, Y] := clBtnShadow;
    Pixels[X+4, Y] := clBtnShadow;
    Pixels[X+1, Y+1] := clBtnShadow;
    Pixels[X, Y+2] := clBtnShadow;
    Pixels[X, Y+3] := clBtnShadow;
    Pixels[X, Y+4] := clBtnShadow;
    Pixels[X+1, Y+5] := clBtnShadow;

    Pixels[X+6, Y+2] := clBtnHighLight;
    Pixels[X+6, Y+3] := clBtnHighLight;
    Pixels[X+6, Y+4] := clBtnHighLight;
    Pixels[X+5, Y+1] := clBtnHighLight;
    Pixels[X+2, Y+6] := clBtnHighLight;
    Pixels[X+3, Y+6] := clBtnHighLight;
    Pixels[X+4, Y+6] := clBtnHighLight;
    Pixels[X+5, Y+5] := clBtnHighLight;
    Pixels[X+2, Y+3] := clBtnHighLight;

    Pixels[X+2, Y+1] := TheColor;
    Pixels[X+3, Y+1] := TheColor;
    Pixels[X+4, Y+1] := TheColor;
    Pixels[X+1, Y+2] := TheColor;
    Pixels[X+2, Y+2] := TheColor;
    Pixels[X+3, Y+2] := TheColor;
    Pixels[X+4, Y+2] := TheColor;
    Pixels[X+5, Y+2] := TheColor;
    Pixels[X+1, Y+3] := TheColor;
    Pixels[X+3, Y+3] := TheColor;
    Pixels[X+4, Y+3] := TheColor;
    Pixels[X+5, Y+3] := TheColor;
    Pixels[X+1, Y+4] := TheColor;
    Pixels[X+2, Y+4] := TheColor;
    Pixels[X+3, Y+4] := TheColor;
    Pixels[X+4, Y+4] := TheColor;
    Pixels[X+5, Y+4] := TheColor;
    Pixels[X+2, Y+5] := TheColor;
    Pixels[X+3, Y+5] := TheColor;
    Pixels[X+4, Y+5] := TheColor;
{  7x7 }
  end;
  tsRightArrow,tsLeftArrow,tsDownArrow,tsUpArrow:
  begin
    for hw:=1 to 2 do
    begin
      if Pixels[width div 2,height div 2]=clBlack
      then mc:=clWhite else mc:=clBlack;
      Pen.Color := mc;
      Brush.Color := TheColor;
      case PFShape of
        tsRightArrow:PolyLine([Point(2, 2), Point(2, height -2),
          Point(width -2, height div 2),Point(2, 2)]);
        tsLeftArrow:PolyLine([Point(width-2, 2), Point(width-2, height -2),
          Point(2, height div 2),Point(width-2, 2)]);
        tsDownArrow:PolyLine([Point(2, 2), Point(width - 2, 2),
          Point(width div 2, height - 2),Point(2, 2)]);
        tsUpArrow:PolyLine([Point(2, height-2), Point(width-2, height -2),
          Point(width div 2, 2),Point(2, height-2)]);
      end;
      FloodFill(width div 2, Height div 2, mc, fsBorder);
      if mc=clBlack then break;
    end;
  end;
  tsRectangle,tsCircle,tsBar:
  begin

    x:=x+3;
    y:=y+3;
    hw:=width div 2 -3;
    hh:=height div 2 -3;
      Pen.Color := clBtnHighlight;
      Brush.Color := TheColor;
   case PFShape of
    tsBar:
    begin
      hh:=hBar div 2;
      Rectangle (x-hw, y-hh, x+hw, y+hh);
    end;
    tsCircle:
    begin
      if hw>hh then hw:=hh else hh:=hw;
      Ellipse (x+1-hw, y+1-hh, x+1+hw, y+1+hh);
      Pen.Color := clBtnShadow;
      Ellipse (x-hw, y-hh, x+hw, y+hh);
      Pen.Color := clBtnHighlight;
      Brush.Color := clBtnHighlight;
      Ellipse (x-2, y-1, x+1, y+2);
    end;
    tsRectangle:
    begin
      Rectangle (x+1-hw, y+1-hh, x+1+hw, y+1+hh);
      Pen.Color := clBtnShadow;
      Rectangle (x-hw, y-hh, x+hw, y+hh);
      Pen.Color := clBtnHighlight;
      Brush.Color := clBtnHighlight;
      hw:=width div 3 -3;
      hh:=height div 7 -3;
      Rectangle (x-hw, y-hh, x+hw, y+hh);
    end;
    end;{case}
  end;
  end;{case}
end;


function TLightCheck.GetChecked;
begin
  Result := not(State = cbUnChecked);
end;


procedure TLightCheck.SetChecked;
begin
  if Value then
    PFState := cbChecked
  else
    PFState := cbUnChecked;

  Paint;
end;


procedure TLightCheck.Toggle;
begin
  Checked := not Checked;
end;


procedure TLightCheck.Click;
begin
  inherited click;
{  Toggle;}
end;


procedure TLightCheck.SetOnColor;
begin
  FOnColor := Value;
  if Checked then
    Paint;
end;


procedure TLightCheck.SetOffColor;
begin
  FOffColor := Value;
  if not Checked then
    Paint;
end;






procedure Register;
begin
  RegisterComponents('Standard', [TLightCheck]);
end;

end.
