unit Helpunit;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, IniFiles, utils, sysutils;

type
  THelpForm = class(TForm)
    Panel1: TPanel;
    Bevel1: TBevel;
    HelpMemo: TMemo;
    OKBtn: TBitBtn;
    HelpComboBox: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure HelpComboBoxChange(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    HelpList:TStringList;
    procedure DisplayItem(s:string);
    procedure ShowHelp(Sender: TObject);
    procedure ShowMyHelp(s:string);
  end;

var
  HelpForm: THelpForm;

implementation

{$R *.DFM}

procedure THelpForm.FormCreate(Sender: TObject);
var IniFile : tIniFile;
    var i:integer;
begin
  IniFile := tIniFile.Create(changefileext(paramstr(0),'.ASC'));
  HelpList:=TStringList.create;
  IniFile.ReadSection ('main',HelpList);
  for i:=1 to HelpList.count do
  helpcombobox.items.add(IniFile.ReadString('main', HelpList[i-1] , '1'));
  IniFile.free;
  If HelpList.count>0 then
  begin
    HelpComboBox.ItemIndex:=0;
    DisplayItem(HelpList[0]);
  end;
end;

procedure THelpForm.ShowMyHelp(s:string);
var i,nr:integer;
begin
  nr:=0;
    for i:=0 to helplist.count-1 do
    if s=helplist[i] then nr:=i;
    HelpComboBox.ItemIndex:=nr;
    DisplayItem(s);
  show;
end;

procedure THelpForm.ShowHelp(Sender: TObject);
begin
  with sender as twinControl do
  begin
    ShowMyHelp(xstr(helpcontext,1,0));
  end;
end;

procedure THelpForm.DisplayItem(s:string);
var MyFile : TextFile;
    s1:string;
begin
  {$I-}
  AssignFile(Myfile,changefileext(paramstr(0),'.ASC'));
  Reset(MyFile);
  if IOResult<>0 then exit;
  if not eof(MyFile) then
  begin
    s:='['+ltrim(trim(s))+']';
    readln(MyFile,s1);
    while not eof(MyFile) and (trim(ltrim(s1))<>s) do
    begin
      readln(MyFile,s1);
    end;
    if not eof(MyFile) then
    begin
      HelpMemo.visible:=false;
      HelpMemo.lines.clear;
      readln(MyFile,s1);
      while not eof(MyFile) and (copy(s1,1,1)<>'[') do
      begin
        HelpMemo.Lines.add(s1);
        readln(MyFile,s1);
      end;
      HelpMemo.visible:=true;
    end;
  end;
  CloseFile(MyFile);
end;

procedure THelpForm.HelpComboBoxChange(Sender: TObject);
begin
  DisplayItem(HelpList[HelpComboBox.ItemIndex]);
end;

procedure THelpForm.OKBtnClick(Sender: TObject);
begin
   hide;
end;

procedure THelpForm.FormDestroy(Sender: TObject);
begin
  HelpList.free;
end;

end.
