unit Gettrack;
{form to edit data of current CD, or record in database}

interface

uses WinTypes, WinProcs, SysUtils,Classes, Messages,Dialogs,Graphics, Forms, Controls, Buttons,
  StdCtrls, Grids, ExtCtrls, Edfldcnt, EditFld, Clipbrd, Cus_Bas, Barsize;
const BarTop:integer=248;
      MinSize=30;
type
  TEditTrack = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    EleTrack: TStringGrid;
    CdName: TEdit;
    Label1: TLabel;
    DstList: TStringGrid;
    Label2: TLabel;
    Year: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Artist: TEdit;
    Style: TComboBox;
    FloatEdit: TEdit;
    FieldStringGrid: TStringGrid;
    Help: TBitBtn;
    BarreResize1: TBarreResize;
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    CopySpeedButton: TSpeedButton;
    PasteSpeedButton: TSpeedButton;
    CommentButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SetButtons;
    procedure CommentButtonClick(Sender: TObject);
    procedure StyleKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EleTrackSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure EleTrackEnter(Sender: TObject);
    procedure EleTrackDrawCell(Sender: TObject; Col, Row: Longint;
      Rect: TRect; State: TGridDrawState);
    procedure FloatEditExit(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure CopyButtonClick(Sender: TObject);
    procedure PasteButtonClick(Sender: TObject);
    procedure FieldStringGridEnter(Sender: TObject);
    procedure FieldStringGridDrawCell(Sender: TObject; Col, Row: Longint;
      Rect: TRect; State: TGridDrawState);
    procedure FieldStringGridSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure ArtistKeyPress(Sender: TObject; var Key: Char);
    procedure CdNameKeyPress(Sender: TObject; var Key: Char);
    procedure YearKeyPress(Sender: TObject; var Key: Char);
    procedure FloatEditKeyPress(Sender: TObject; var Key: Char);
    procedure FloatEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BarreResize1NewPosition(Sender: TObject);
    procedure BarreResize1Sliding(Sender: TObject; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
{    selected:integer;}
    acol,arow:longint;
    vkup,vkdown:boolean;
    procedure OverlayGrid(Col, Row: Longint);
    procedure SetExtraTracksVisible(SetVisible:boolean);
    procedure FillEditTrack(memo1:TStringList);
    procedure ReturnEditTrack(var memo1:TStringList);
  end;
    var CurrStringGrid:TStringGrid;
    function ExtraTrackCount(Memo1:tstringlist):integer;
    procedure GetStringTokenExtra(Memo1:tstringlist;i:integer;var s:string;var p:integer);
    function ExtraTrackTracknr(Memo1:tstringlist;i:integer):string;
    function ExtraTrackTrackName(Memo1:tstringlist;i:integer):string;
    function ExtraTrackStartTime(Memo1:tstringlist;i:integer):string;
    function ExtraTrackEndTime(Memo1:tstringlist;i:integer):string;
    function TrackTime(Memo1:tstringlist;i:integer):string;
    function TrackName(Memo1:tstringlist;i:integer):string;
    function TrackCount(Memo1:tstringlist):integer;

const BooleanExtraTracksVisible:boolean=true;

implementation

uses utils;

{$R *.DFM}

function ExtraTrackCount(Memo1:tstringlist):integer;
var i,hCount:integer;
    s:string;
begin
  hCount:=0;
  for i:=1 to 50 do
  begin
    s:=Memo1.Values['X'+xstr(i,1,0)];
    if s<>'' then hCount:=i;
  end;
  ExtraTrackCount:=hCount;
end;

function ExtraTrackTracknr(Memo1:tstringlist;i:integer):string;
var s:string;
begin
      s:=Memo1.Values['X'+xstr(i,1,0)];
      if s<>'' then
      begin
        ExtraTrackTracknr := copy(s,2,2);
      end else ExtraTrackTracknr:='';
end;

procedure GetStringTokenExtra(Memo1:tstringlist;i:integer;var s:string;var p:integer);
begin
  s:=Memo1.Values['X'+xstr(i,1,0)];
  p:=pos('|',s);
end;

function ExtraTrackTrackName(Memo1:tstringlist;i:integer):string;
var s:string;
    p:integer;
begin
  GetStringTokenExtra(memo1,i,s,p);
  ExtraTrackTrackName := copy(s,4,p-4);
end;
function ExtraTrackStartTime(Memo1:tstringlist;i:integer):string;
var s:string;
    p:integer;
begin
  GetStringTokenExtra(memo1,i,s,p);
  ExtraTrackStartTime := copy(s,p+1,5);
end;

function ExtraTrackEndTime(Memo1:tstringlist;i:integer):string;
var s:string;
    p:integer;
begin
  GetStringTokenExtra(memo1,i,s,p);
  ExtraTrackEndTime := copy(s,p+6,5);
end;

function MyValues(Memo1:TStringList;i:integer):string;
var s:string;
begin
  s:=Memo1.Values['T'+xstr(i,1,0)];
  if s='' then s:=Memo1.Values[xstr(i-1,1,0)];
  MyValues:=s;
end;

function TrackTime(Memo1:tstringlist;i:integer):string;
var s:string;
    p:integer;
begin
  s:=MyValues(Memo1,i);
  p:=pos('|',s);
  if p>0 then
  TrackTime:=copy(s,p+1,5) else TrackTime:='';
end;

function TrackName(Memo1:tstringlist;i:integer):string;
var s:string;
    p:integer;
begin
  s:=MyValues(Memo1,i);
  p:=pos('|',s);
  if p>0 then
  TrackName:=copy(s,1,p-1) else TrackName:=s;
end;

function TrackCount(Memo1:tstringlist):integer;
var i:integer;
    s:string;
    hTrack:integer;
begin
  hTrack:=0;
    for i:=1 to 50 do
    begin
      s:=MyValues(Memo1,i);
      if s<>'' then
        hTrack:=i;
    end;
    TrackCount:=hTrack;
end;

procedure TEditTrack.ReturnEditTrack(var memo1:TStringList);
var i:integer;
begin
      ReturnNameStringGrid(FieldStringGrid,memo1);
      with Eletrack do
      For i:=1 to RowCount-1 do
      begin
        Memo1.Values['T'+xstr(i,1,0)]:=cells[3,i]+'|'+cells[1,i];
      end;
      for i:=Memo1.count-1 downto 0 do
      if copy(Memo1[i],1,1)='X' then
      Memo1.delete(i);
      with DstList do
      For i:=1 to RowCount-1 do
      begin
        Memo1.add('X'+xstr(i,1,0)+'=-'+Cells[0,i]+Cells[1,i]+'|'+
        Cells[2,i]+Cells[3,i]);
      end;
end;

procedure TEditTrack.FillEditTrack(memo1:TStringList);
var i:integer;
begin
    EditNameStringGrid(FieldStringGrid,memo1);
    EleTrack.RowCount := TrackCount(memo1)+1;
    For i:=1 to TrackCount(memo1) do
    with EleTrack do
    begin
        Cells[0,i] := xstr(i,2,0);
        Cells[1,i] := TrackTime(memo1,i);
        Cells[3,i] := TrackName(memo1,i);
    end;
    DstList.RowCount := ExtraTrackCount(memo1)+1;
    If ExtraTrackCount(memo1)>0 then
    DstList.FixedRows:=1;
    For i:=1 to ExtraTrackCount(memo1) do
    with DstList do
    begin
        Cells[0,i] := ExtraTrackTracknr(memo1,i);
        Cells[1,i] := ExtraTrackTrackName(memo1,i);
        Cells[2,i] := ExtraTrackStartTime(memo1,i);
        Cells[3,i] := ExtraTrackEndTime(memo1,i);
    end;
    SetButtons;
end;

procedure TEditTrack.FormCreate(Sender: TObject);
begin
  EleTrack.Rowheights[0]:=1;
  EleTrack.ColWidths[0]:=30;
  EleTrack.ColWidths[1]:=50;
  EleTrack.ColWidths[2]:=20;
  EleTrack.ColWidths[3]:=280;
{  selected:=99;}
  with DstList do
  begin
    ColWidths[0]:=20;
    ColWidths[1]:=280;
    ColWidths[2]:=40;
    ColWidths[3]:=40;
  end;
  ActiveControl:=Artist;
  BarreResize1.Top:=BarTop;
  BarreResize1NewPosition(Self);
  with FieldStringGrid do
  begin
    Rowheights[0]:=1;
    top:=DstList.top;
    left:=DstList.left;
    width:=DstList.width;
    height:=DstList.height;
    parent:=EleTrack.parent;
  end;
end;

procedure TEditTrack.SetButtons;
begin
  SpeedButton1.Enabled:=EleTrack.RowCount>=1;
  SpeedButton2.Enabled:=DstList.RowCount>1;
end;

procedure TEditTrack.SpeedButton1Click(Sender: TObject);
var index:integer;
begin
  index:=EleTrack.row;
  if index>=1 then
  with DstList do
  begin
    rowcount:=rowcount+1;
    cells[0,rowcount-1]:=xstr(EleTrack.row,2,0);
    cells[1,rowcount-1]:='Extra Track';
    cells[2,rowcount-1]:='00:00';
    cells[3,rowcount-1]:=EleTrack.cells[1,EleTrack.row];
    row:=rowcount-1;
    FixedRows:=1;
  end;
  SetButtons;
end;

procedure TEditTrack.SpeedButton2Click(Sender: TObject);
var i,j:integer;
begin
  with DstList do
  begin
    if row>0 then
    begin
      for i:=row to rowcount-2 do
      begin
        for j:=0 to colcount do
        begin
          cells[j,i]:=cells[j,i+1];
        end;
      end;
      rowcount:=rowcount-1;
    end;
  end;
  SetButtons;
end;


procedure TEditTrack.CommentButtonClick(Sender: TObject);
begin
  SetExtraTracksVisible(not BooleanExtraTracksVisible);
end;

procedure TEditTrack.SetExtraTracksVisible(SetVisible:boolean);
  begin
    BooleanExtraTracksVisible:=SetVisible;
    FieldStringGrid.visible:=not SetVisible;
    DstList.visible:=SetVisible;
    SpeedButton1.visible:=SetVisible;
    SpeedButton2.visible:=SetVisible;
  if FieldStringGrid.visible then
  begin
    CommentButton.caption:='e&Xtra tracks';
    FieldStringGrid.col:=1;FieldStringGrid.row:=1;
  end else
    CommentButton.caption:='e&Xtra fields';
  end;

procedure TEditTrack.StyleKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key=13 then
  with EleTrack do
  begin
    setfocus;
    row:=1;col:=3;
  end;
end;

procedure TEditTrack.OverlayGrid(Col, Row: Longint);
var r:TRect;
    pt:TPoint;
begin
    with CurrStringGrid do
    begin
      FloatEdit.Text:=CurrStringGrid.Cells[col,row];
    end;
    r:=CurrStringGrid.CellRect(col,row);
    pt:=CurrStringGrid.ClientToScreen(r.TopLeft);
    pt:=ScreenToClient(pt);
    if (r.Right<=r.Left) or (r.Bottom<=r.Top) then exit;
    FloatEdit.Top:=pt.Y;
    FloatEdit.Left:=pt.X;
    FloatEdit.Width:=r.Right-r.Left;
    FloatEdit.Height:=r.Bottom-r.Top;
    if FloatEdit.visible then
    begin
      FloatEdit.SetFocus;
      CurrStringGrid.SendToBack;
      with FloatEdit do
      begin
        selstart:=0;
        sellength:=length(TEXT);
      end;
    end;
end;


procedure TEditTrack.EleTrackSelectCell(Sender: TObject; Col, Row: Longint;
  var CanSelect: Boolean);
begin
  if (row>0) and (col>2) then
  OverLayGrid(EleTrack.col,EleTrack.row);
end;

procedure TEditTrack.EleTrackEnter(Sender: TObject);
begin
  CurrStringGrid:=EleTrack;
  FloatEdit.visible:=true;
end;

procedure TEditTrack.EleTrackDrawCell(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
begin
  OverLayGrid(EleTrack.col,EleTrack.Row);
end;

procedure TEditTrack.FloatEditExit(Sender: TObject);
begin
  with CurrStringGrid do
  Cells[col,row]:=FloatEdit.text;
end;

procedure TEditTrack.FormShow(Sender: TObject);
begin
  Artist.setfocus;
  CommentButton.visible:=StringFieldnames.count>0;
end;

procedure TEditTrack.FormActivate(Sender: TObject);
begin
  CurrStringGrid:=EleTrack;
  if StringFieldNames.count=0 then
  begin
    SetExtraTracksVisible(true);
    CommentButton.visible:=false;
  end else
  SetExtraTracksVisible(BooleanExtraTracksVisible);
end;
procedure TEditTrack.CopyButtonClick(Sender: TObject);
var i:integer;
    p:array[0..4000] of char;
    hp:array[0..255] of char;
var MyClipBoard:TStringList;
begin
  MyClipBoard:=TStringList.create;
  MyClipBoard.clear;
  ReturnEditTrack(MyClipBoard);
  with MyClipBoard do
  begin
    add('artist='+artist.text);
    add('title='+CDName.text);
    add('year='+year.text);
    add('style='+style.text);
  end;
  strcopy(p,'');
  for i:=0 to MyClipBoard.count-1 do
  begin
    strpcopy(hp,MyClipBoard[i]+chr(vk_return)+chr(10));
    strcat(p,hp);
  end;
  ClipBoard.SetTextBuf(p);
  MyClipBoard.free;
end;

procedure TEditTrack.PasteButtonClick(Sender: TObject);
var MyClipBoard:TStringList;
procedure FillField(s:string;var f:TEdit);
var hs:string;
begin
  hs:=MyClipBoard.Values[s];
  if s<>'' then f.text:=hs;
end;
var mcount,cl,pos:integer;
    s:string;
    p:array[0..4000] of char;
begin
  if not Clipboard.HasFormat(CF_TEXT) then exit;
  MyClipBoard:=TStringList.create;
  Clipboard.GetTextBuf(p,4000);
  s:=Clipboard.astext;
  mYClipBoard.clear;
  cl:=0;
  MyClipBoard.add('');
  for pos:=0 to strlen(p)-1 do
  begin
    if p[pos]=#13 then
    begin
      MyClipBoard.add('');
      inc(cl);
    end else
    if ((ord(p[pos])>20)) then MyClipboard[cl]:=MyClipBoard[cl]+p[pos];
  end;
  mcount:=EleTrack.rowcount;
  FillEditTrack(MyClipBoard);
  EleTrack.RowCount:=mcount;
  FillField('artist',artist);
  FillField('title',CDName);
  FillField('year',year);
  if MyClipBoard.Values['style']<>'' then;
  style.text:=MyClipBoard.Values['style'];
  MyClipBoard.free;
end;

procedure TEditTrack.FieldStringGridEnter(Sender: TObject);
begin
  CurrStringGrid:=FieldStringGrid;
  FloatEdit.visible:=true;
end;

procedure TEditTrack.FieldStringGridDrawCell(Sender: TObject; Col,
  Row: Longint; Rect: TRect; State: TGridDrawState);
begin
  if (col>0) and (row>0) then
  OverLayGrid(FieldStringGrid.col,FieldStringGrid.Row);
end;

procedure TEditTrack.FieldStringGridSelectCell(Sender: TObject; Col,
  Row: Longint; var CanSelect: Boolean);
begin
  if (row>0) and (col>0) then
  OverLayGrid(FieldStringGrid.col,FieldStringGrid.row);
end;

procedure TEditTrack.ArtistKeyPress(Sender: TObject; var Key: Char);
begin
  if key=#13 then
  begin
    key:=#0;
    CdName.setfocus;
  end;
end;

procedure TEditTrack.CdNameKeyPress(Sender: TObject; var Key: Char);
begin
  if key=#13 then
  begin
    key:=#0;
    Year.setfocus;
  end;
end;

procedure TEditTrack.YearKeyPress(Sender: TObject; var Key: Char);
begin
  if key=#13 then
  begin
    key:=#0;
    Style.setfocus;
  end;
end;

procedure TEditTrack.FloatEditKeyPress(Sender: TObject; var Key: Char);
begin
  if vkup
{     or (key=#40)}
     or vkdown
        or (key=#13) then
  begin
    FloatEditExit(sender);
    if vkup then
    begin
      with CurrStringGrid do
      begin
        if row=1 then {Year.setfocus }else
        begin
          row:=row-1;
          OverLayGrid(col,Row);
        end;
      end;
    end else
    with CurrStringGrid do
    begin
        if (row=rowcount-1) then
        begin
          if key=#13 then
          begin
            if CurrStringGrid=EleTrack then
            if FieldStringGrid.visible then
            begin
              FieldStringGrid.row:=1;
              FieldStringGrid.setfocus;
              FieldStringGrid.row:=1;
            end else
            Artist.setfocus;
            if CurrStringGrid=FieldStringGrid then
            Artist.setfocus;
          end;
        end else
        begin
          row:=row+1;
          OverLayGrid(col,Row);
        end;
    end;
    key:=#0;
  end;
end;

procedure TEditTrack.FloatEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
{preview to see if up or down is pressed, in KeyPress these keys
 are not recognized anymore, and the scancodes are different there...}
var mykey:char;
begin
  mykey:=#0;
  vkup:=false;
  vkdown:=false;
  if (key=vk_up) then
  begin
    vkup:=true;
    FloatEditKeyPress(Sender,mykey)
  end else
     if (key=vk_down) then
     begin
       vkdown:=true;
       FloatEditKeyPress(Sender,myKey)
     end;
end;

procedure TEditTrack.BarreResize1NewPosition(Sender: TObject);
var y,bott:integer;
begin
  y:=BarreResize1.top;
  bott:=DstList.Top+DstList.Height;
  BarreResize1Sliding(Sender,BarreResize1.Left,y);
  if (y<eletrack.top+MinSize) or (y>bott-MinSize) then
  if y<eletrack.top+MinSize then BarreResize1.top:=eletrack.top+MinSize else
  if y>bott-MinSize then BarreResize1.top:=bott-MinSize;
end;

procedure TEditTrack.BarreResize1Sliding(Sender: TObject; X, Y: Integer);
var bott:integer;
begin
  bott:=DstList.Top+DstList.Height;
  if (y<eletrack.top+MinSize) or (y>bott-MinSize) then exit;
  eletrack.height:=y-eletrack.Top;
  DstList.Top:=y+BarreResize1.Height;
  DstList.Height:=bott-DstList.Top;
  FieldStringGrid.Top:=DstList.Top;
  FieldStringGrid.Height:=DstList.Height;
  BarTop:=BarreResize1.Top;
end;

end.
