unit Editfld;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Grids, ExtCtrls, utils;

type
  TEditFieldnames = class(TForm)
    OKBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    FieldNames: TStringGrid;
    AddButton: TButton;
    DelButton: TButton;
    CancelBtn: TBitBtn;
    Help: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  EditFieldnames: TEditFieldnames;
  StringFieldnames: TStringList;
  DefaultValues: TStringList;

implementation

{$R *.DFM}

procedure TEditFieldnames.FormCreate(Sender: TObject);
var i:integer;
begin
  with FieldNames do
  begin
    Cells[0,0]:='Field-names';
    Cells[1,0]:='Default value';
    RowCount:=1;
    for i:=0 to 1 do
    ColWidths[i]:=(width div 2)-8;
  end;
end;

function xstr(i:real;w,n:integer):string;
var s:string;
begin
  str(i:w:n,s);
  xstr:=s;
end;

procedure TEditFieldnames.AddButtonClick(Sender: TObject);
begin
  with FieldNames do
  begin
    RowCount:=RowCount+1;
    Cells[0,RowCount-1]:='Field'+xstr(RowCount-1,1,0);
    FixedRows:=1;
  end;
end;

procedure TEditFieldnames.DelButtonClick(Sender: TObject);
var i:integer;
begin
  with FieldNames do
  if Row>0 then
  begin
    for i:=row to rowcount-2 do
    cells[0,i]:=cells[0,i+1];
    rowcount:=rowcount-1;
  end;
end;

procedure TEditFieldnames.OKBtnClick(Sender: TObject);
var i:integer;
begin
  StringFieldnames.clear;
  DefaultValues.clear;
  with fieldNames do
  For i:=1 to rowcount-1 do
  begin
    StringFieldnames.add(cells[0,i]);
    DefaultValues.add(cells[1,i]);
  end;
  hide;
end;

procedure TEditFieldnames.FormShow(Sender: TObject);
var i:integer;
begin
  with Fieldnames do
  begin
    RowCount:=StringFieldNames.Count+1;
    for i:=1 to RowCount-1 do
    begin
      Cells[0,i]:=StringFieldNames[i-1];
      Cells[1,i]:=DefaultValues[i-1];
    end;
    FixedRows:=1;
  end;
end;

procedure TEditFieldnames.CancelBtnClick(Sender: TObject);
begin
  FormShow(Self);
  hide;
end;

end.
