unit Edfldcnt;

interface

uses WinTypes, WinProcs, Classes, SysUtils, Graphics, Forms, Controls, Buttons,
  StdCtrls, Grids, ExtCtrls, EditFld, utils;

type
  TEditFieldContent = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    FieldStringGrid: TStringGrid;
    procedure FormShow(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  EditFieldContent: TEditFieldContent;
  EditNamesStringList:TStringList;

procedure EditNameStringGrid(var MyStringGrid:TStringGrid;slist:TStringList);

procedure ReturnNameStringGrid(var MyStringGrid:TStringGrid;var slist:TStringList);

function GetFieldContent(var Field:string;FieldList:TStringList):boolean;

implementation

{$R *.DFM}

function GetFieldContent(var Field:string;FieldList:TStringList):boolean;
var hb:boolean;
    i:integer;
begin
  hb:=false;
  for i:=0 to StringFieldNames.count-1 do
  if uppercase(field)=uppercase(StringFieldNames[i]) then
  begin
    hb:=true;
    field:=FieldList.Values[field];
    break;
  end;
  GetFieldContent:=hb;
end;

procedure ReturnNameStringGrid(var MyStringGrid:TStringGrid;var slist:TStringList);
var i,j:integer;
    s:string;
begin
      for i:=1 to StringFieldNames.count do
      with MyStringGrid do
      begin
        s:=trim(StringFieldNames[i-1]);
        for j:=slist.count-1 downto 0 do
        if copy(slist[j],1,length(s)+1)=s+'=' then
        slist.delete(j);
        if length(trim(Cells[1,i]))>0 then
        slist.add(s+'='+Cells[1,i]);
      end;
end;

procedure EditNameStringGrid(var MyStringGrid:TStringGrid;slist:TStringList);
var i:integer;
begin
  if StringFieldNames.count=0 then
  begin
    MyStringGrid.visible:=false;
  end else
  begin
    with MyStringGrid do
    begin
      ColWidths[0]:=50;
      ColWidths[1]:=width-50;
      RowCount:=StringFieldNames.count+1;
      visible:=true;
      for i:=1 to StringFieldNames.count do
      begin
        Cells[0,i]:=StringFieldNames[i-1];
        Cells[1,i]:=slist.Values[StringFieldNames[i-1]];
      end;
    end;
  end;
end;

procedure TEditFieldContent.FormShow(Sender: TObject);
begin
  EditNameStringGrid(FieldStringGrid,EditNamesStringList);
end;

procedure TEditFieldContent.OKBtnClick(Sender: TObject);
begin
  ReturnNameStringGrid(FieldStringGrid,EditNamesStringList);
  Hide;
end;

procedure TEditFieldContent.CancelBtnClick(Sender: TObject);
begin
  EditNameStringGrid(FieldStringGrid,EditNamesStringList);
  Hide;
end;

end.
