unit Database;

interface

uses WinTypes, WinProcs, DbiProcs, DbiTypes, DBConsts,SysUtils, Dialogs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, DBCtrls, Mask, DB, DBTables, ExtCtrls, Grids, Menus,
  res1data,ShowDlg, printers,PrintFRM, Cdprogr, Gettrack, EdFldCnt, EditFld,
  BrwsUnit, Stylunit, Cus_Bas, Barsize, Preview;

const
  FontName:TFontName='';
  FontSize:integer=8;
  FontColor:TColor=$02FFFFFF;
  DispOnScreen:boolean=false;
  maxtracks=36;
  DestPrintFileChecked:integer=1;
  PrintStyle:byte=0;
  OutputFilename:string='CDPlayer.txt';

type
  TMyprinter=class(TPrinter)
     CurrentLine:integer;
     MaxLines,HText:integer;
     Header:TStringList;
     constructor create;
     procedure PrintLine(s:string);
     destructor free;
  end;
  TDataBaseDlg = class(TForm)
    Table1: TTable;
    CDNameEdit: TDBEdit;
    YearEdit: TDBEdit;
    StyleBox: TComboBox;
    DBText1: TDBText;
    PopupMenu1: TPopupMenu;
    Goto1: TMenuItem;
    Global1: TMenuItem;
    MainMenu1: TMainMenu;
    Print1: TMenuItem;
    Order1: TMenuItem;
    Artist1: TMenuItem;
    Style1: TMenuItem;
    Id1: TMenuItem;
    N1: TMenuItem;
    Natural1: TMenuItem;
    Display1: TMenuItem;
    Statistics1: TMenuItem;
    Options1: TMenuItem;
    Tracksincluded1: TMenuItem;
    Exit1: TMenuItem;
    File1: TMenuItem;
    Current1: TMenuItem;
    PrintAll1: TMenuItem;
    PrintRest1: TMenuItem;
    N5: TMenuItem;
    CDBox1: TMenuItem;
    Duplicates1: TMenuItem;
    SearchResults: TMenuItem;
    GotoSearch: TMenuItem;
    N6: TMenuItem;
    Import1: TMenuItem;
    Export1: TMenuItem;
    N2: TMenuItem;
    ImportDialog: TOpenDialog;
    ExportDialog: TSaveDialog;
    Update1: TMenuItem;
    Append1: TMenuItem;
    FieldNames1: TMenuItem;
    DisplaySettings1: TMenuItem;
    Edit1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N4: TMenuItem;
    Browse1: TMenuItem;
    N3: TMenuItem;
    Styles1: TMenuItem;
    Panel2: TPanel;
    Label7: TLabel;
    FindLabel: TLabel;
    SearchLabel: TLabel;
    RecNumLabel: TLabel;
    DBNavigator1: TDBNavigator;
    FindEdit: TMaskEdit;
    SearchEdit: TMaskEdit;
    DataSource1: TDataSource;
    Panel3: TPanel;
    Panel4: TPanel;
    BarreResize1: TBarreResize;
    Panel1: TPanel;
    BrowseSpeedButton: TSpeedButton;
    ProgramSpeedButton: TSpeedButton;
    EditSpeedButton: TSpeedButton;
    GotoSpeedButton: TSpeedButton;
    SortSpeedButton: TSpeedButton;
    CopySpeedButton: TSpeedButton;
    PasteSpeedButton: TSpeedButton;
    StatisticsSpeedButton: TSpeedButton;
    NoSortSpeedButton: TSpeedButton;
    DisplaySpeedButton: TSpeedButton;
    PrintSpeedButton: TSpeedButton;
    TracksMemo: TMemo;
    OKButton: TButton;
    BitBtn1: TBitBtn;
    TracksMemo3: TMemo;
    TracksMemo2: TMemo;
    BarreResize2: TBarreResize;
    FontSpeedButton: TSpeedButton;
    FontDialog1: TFontDialog;
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FindEditChange(Sender: TObject);
    procedure Table1BeforePost(DataSet: TDataset);
    procedure Table1BeforeEdit(DataSet: TDataset);
    procedure DataSource1UpdateData(Sender: TObject);
    procedure DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
    procedure StyleBoxChange(Sender: TObject);
    procedure GotoButtonClick(Sender: TObject);
    procedure TracksIncludeClick(Sender: TObject);
    procedure Global1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure PrintButtonClick(Sender: TObject);
    procedure StatisticsButtonClick(Sender: TObject);
    procedure Artist1Click(Sender: TObject);
    procedure Style1Click(Sender: TObject);
    procedure Id1Click(Sender: TObject);
    procedure Natural1Click(Sender: TObject);
    procedure Tracksincluded1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure Current1Click(Sender: TObject);
    procedure PrintAll1Click(Sender: TObject);
    procedure PrintRest1Click(Sender: TObject);
    procedure ProgramButtonClick(Sender: TObject);
    procedure Table1AfterPost(DataSet: TDataset);
    procedure EditButtonClick(Sender: TObject);
    procedure Duplicates1Click(Sender: TObject);
    procedure SearchEditKeyPress(Sender: TObject; var Key: Char);
    procedure SearchResultsClick(Sender: TObject);
    procedure GotoSearchClick(Sender: TObject);
    procedure Export1Click(Sender: TObject);
    procedure Append1Click(Sender: TObject);
    procedure Update1Click(Sender: TObject);
    procedure FieldNames1Click(Sender: TObject);
    procedure DisplaySettings1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Browse1Click(Sender: TObject);
    procedure Styles1Click(Sender: TObject);
    procedure BarreResize1NewPosition(Sender: TObject);
    procedure BarreResize2NewPosition(Sender: TObject);
    procedure FontSpeedButtonClick(Sender: TObject);
  private
    { Private declarations }
    procedure UpdateMemo;
    procedure ScanRecord(s:string;var i:longint;var ts:TStringList;
       var foundit:boolean);
    procedure ScanDataBase(stat:boolean);
    procedure DefineEditTrack(Var Modal : TEditTrack);
    procedure ReturnEditTrack(Var Modal : TEditTrack);
    procedure DoubleSave;
  public
    { Public declarations }
    Memo1:tstringlist;
    redisplay:boolean;
    procedure CreateParams(var Params:TCreateParams);override;
    procedure DrawAngleText(aCanvas:TCanvas;
       x,y:integer;aAngle:Integer;aTxt:String);
    function GetPrintInfo(var MyTrack,MyCDHeader,MyReportHeader:TStringList;
      var bTrackInfo:boolean;var DestPrintFileChecked:integer;var OutputFilename:string;
      AskForOverwrite,AskForFileName,ClearIt:boolean;var Selection,SortExpression:string):boolean;
    procedure PrintAll(all:boolean);
    procedure SetMemo;
    procedure ImportIt(AppendIt:boolean);
  end;

type string255=string[255];

procedure change(var outline:string255;s:string;code:string);

function GetDefaults(s:string255):string255;
{changes string s to default-values, depending on the variables used in s}

procedure ChangeOutline(var outline:string255;id,CDName,year:string;
  style,tcount:integer;ttime:longint;tracktitle,tracktime:string;
    tracknr:integer;MyList:TstringList;fillit:boolean);
{changes the string 'outline' with its corresponding variables}

procedure writelnf(var f:text;s:string);
procedure ReadAndWrite(var Table1:TTable;var f:text;var MyTrackMemo,MyCDHeaderMemo,MyReportHeaderMemo:TStringList;
    var bTrackInfo:boolean;selection:string);
procedure GetRecord(var Table1:TTable;var DiskId,CDName,year:string;var Style:integer;
       var Tracce:TstringList);
function behind(s:string):string;
function before(s:string):string;
function Artistname(diskname:string255):string255;
function CeeDeename(diskname:string255):string255;
procedure assignTextFile(var f:textfile;var outname:string);
procedure DisplayRecord(var Table1:TTable;CDName,Id,year:string;Style:integer;
  var MyList:TstringList;var f:text;var MyTrackMemo,MyCDHeaderMemo,MyReportHeaderMemo:TStringList;
    bTrackInfo:boolean);

var
  ScreenStringList:TStringList;
  DataBaseDlg: TDataBaseDlg;
    MyPrinter:TMyPrinter;
    MyTrackMemo,MyCDHeaderMemo:TStringList;

implementation

uses Utils;

{$R *.DFM}

    function RecordNumber(Dataset: {TDataset}TTable): Longint;
    var
      CursorProps: CurProps;
      RecordProps: RECProps;
    begin
      { Return 0 if dataset is not Paradox or dBASE }
      Result := 0;

      with Dataset do
      begin
        { Is the dataset active? }
        if State = dsInactive then {DBError(SDataSetClosed)};

        { We need to make this call to grab the cursor's iSeqNums }
        Check(DbiGetCursorProps(Handle, CursorProps));

        { Synchronize the BDE cursor with the Dataset's cursor }
        UpdateCursorPos;

        { Fill RecordProps with the current record's properties }
        Check(DbiGetRecord(Handle, dbiNOLOCK, nil, @RecordProps));
        { What kind of dataset are we looking at? }
        case CursorProps.iSeqNums of
          0: Result := RecordProps.iPhyRecNum;  { dBASE   }
          1: Result := RecordProps.iSeqNum;     { Paradox }
        end;
      end;
    end;

procedure TDataBaseDlg.CreateParams(var Params:TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  Style:=(WS_OVERLAPPEDWINDOW or  WS_CAPTION or ws_sysmenu );
end;

function replicate(s:string;cnt:integer):string;
var i:integer;
    hs:string;
begin
  hs:='';
  for i:=1 to cnt do hs:=hs+s;
  replicate:=hs;
end;

procedure TDataBaseDlg.SetMemo;
var i:integer;
    hId:array[0..255] of char;
    f:textfile;
    MyReportHeaderMemo:TStringList;
    empty:TStringList;
    hsize:integer;
begin
  MyReportHeaderMemo:=TStringList.create;
  TracksMemo.visible:=false;
  TracksMemo.Lines.Clear;
  ScreenStringList.clear;
  DispOnScreen:=true;
  empty:=TStringList.create;
  with DBText1 do
  GetTextBuf(hId,GetTextLen+1);
  DisplayRecord(Table1,CDNameEdit.Text,strpas(hId),YearEdit.Text,
    StyleBox.ItemIndex,Memo1,
    f,empty,MyCDHeaderMemo,MyReportHeaderMemo,true);
  for i:=0 to ScreenStringList.count-1 do
  TracksMemo.Lines.add(ScreenStringList[i]);
  hsize:=abs(TracksMemo.font.height)+3;
  BarreResize1.left:=0;
  BarreResize1.Top:=hsize*ScreenStringList.count+panel1.height+10;
  BarreResize2.left:=TracksMemo.width div 2;
  TracksMemo2.Height:=Panel4.height;
  TracksMemo3.Height:=Panel4.height;
  BarreResize1NewPosition(Self);
  MyReportHeaderMemo.free;
  TracksMemo.visible:=true;
  DispOnScreen:=faLse;
  empty.clear;
end;

procedure TDataBaseDlg.DataSource1DataChange(Sender: TObject;
  Field: TField);
var i:integer;
    TTime:longint;
begin
  if Table1.recordcount=0 then exit;
  if not redisplay then exit;
  try
    StyleBox.ItemIndex:=Table1.FieldByName('STYLE').asinteger;
  except
  end;
  memo1.clear;
  with Table1 do
    Memo1.assign(FieldByName('DATA'));
  ttime:=0;
  for i:=1 to TrackCount(memo1) do
        ttime:=ttime+calctime(TrackTime(memo1,i));
  SetMemo;
  Label7.Caption:=strtime(ttime);
  RecNumLabel.Caption:=xstr(RecordNumber(Table1),1,0);
    SetMemo;
end;

procedure TDataBaseDlg.FormCreate(Sender: TObject);
var filename,path:string;
begin
  if FontName<>'' then
  begin
    with TracksMemo.font do
    begin
      Name:=FontName;
      Size:=FontSize;
      Color:=FontColor;
    end;
    TracksMemo2.font:=TracksMemo.font;
    TracksMemo3.font:=TracksMemo.font;
  end;
  ScreenStringList:=TStringList.create;
  OutputFilename:=ChangeFileExt(paramstr(0),'.TXT');
  filename:=changefileext(paramstr(0),'.DBF');
  path:=ExtractFilePath(filename);
  filename:=ExtractFileName(filename);
  with Table1 do
  begin
    ReadOnly:=false;
    Exclusive:=false;
    DataBaseName:=path;
    TableName:=filename;
    Active:=true;
    IndexName:='CDNAME';
    first;
  end;
  redisplay:=true;
  memo1:=TStringList.create;
  SetStyles(StyleBox);
end;

procedure TDataBaseDlg.FormDestroy(Sender: TObject);
begin
  memo1.free;
  ScreenStringList.free;
end;

procedure TDataBaseDlg.FindEditChange(Sender: TObject);
begin
  with table1 do
  if IndexName<>'' then
  findnearest([FindEdit.text]) else
  showmessage('No sort-index selected');
end;

procedure TDataBaseDlg.UpdateMemo;
begin
  redisplay:=false;
end;

procedure TDataBaseDlg.Table1BeforePost(DataSet: TDataset);
begin
  updatememo;
end;

procedure TDataBaseDlg.Table1BeforeEdit(DataSet: TDataset);
begin
  redisplay:=false;
end;

procedure TDataBaseDlg.DataSource1UpdateData(Sender: TObject);
begin
  UpdateMemo;
end;

procedure TDataBaseDlg.DBNavigator1Click(Sender: TObject;
  Button: TNavigateBtn);
begin
{  EditButton.SetFocus;}
end;

procedure TDataBaseDlg.StyleBoxChange(Sender: TObject);
begin
  Table1.edit;
  redisplay:=false;
  Table1.FieldByName('STYLE').asstring:=xstr(StyleBox.ItemIndex,1,0);
  redisplay:=true;
end;

procedure TDataBaseDlg.ScanRecord(s:string;var i:longint;var ts:TStringList;
  var foundit:boolean);
var list:Tstringlist;
    j:integer;
function CheckDuplo(ts:TStringList;s:string):boolean;
function strip(s:string):string;
var p:integer;
begin
  p:=pos('=',s);
  if p>0 then s:=copy(s,p+1,length(s));
  p:=pos('|',s);
  if p>0 then s:=copy(s,1,p-1);
  strip:=s;
end;
var i:integer;
    hb:boolean;
begin
  hb:=true;
  for i:=0 to ts.count-1 do
  if strip(ts[i])=strip(s)
  then hb:=false;
  CheckDuplo:=hb;
end;

begin
  list:=TStringList.create;
  with Table1 do
  begin
    if Table1.eof then Table1.first else
    table1.next;
    if not table1.eof then
    begin
      i:=i+1;
      foundit:=(pos(s,uppercase(FieldByName('CDNAME').asstring))<>0);
      if foundit then ts.add(FieldByName('CDNAME').asstring+'-|'+xstr(i,1,0));
      if TracksIncluded1.checked then
      begin
        List.Clear;
        List.assign(FieldByName('DATA'));
        for j:=0 to List.count-1 do
        if pos(s,Uppercase(List.Strings[j]))>0 then
        if Duplicates1.checked or (not Duplicates1.checked and
          CheckDuplo(ts,List.Strings[j])) then
        begin
          ts.add(List.Strings[j]+'-|'+xstr(i,1,0));
          foundit:=true;
        end;
      end;
    end;
  end;{with}
  List.Free;
end;

procedure TDataBaseDlg.GotoButtonClick(Sender: TObject);
var i:longint;
    s:string;
    foundit:boolean;
    ts:Tstringlist;
    hIndex:string;
begin
  dbnavigator1.enabled:=false;
  ts:=TStringList.create;
  DataSource1.Enabled:=false;{ttable}
  HIndex:=Table1.IndexName;
  Table1.IndexName:='';
  i:=0;
  s:=trim(SearchEdit.text);
  repeat
    ScanRecord(s,i,ts,foundit);
  until (i>Table1.Recordcount) or foundit;
  Table1.IndexName:=hIndex;
  DataSource1.Enabled:=true;
  dbnavigator1.enabled:=true;
  ts.free;
end;

procedure TDataBaseDlg.TracksIncludeClick(Sender: TObject);
begin
  TracksIncluded1.checked:=not TracksIncluded1.checked;
end;

procedure TDataBaseDlg.FormActivate(Sender: TObject);
begin
  Table1.refresh;
end;

procedure TDataBaseDlg.DrawAngleText(aCanvas:TCanvas;x,y:integer;
  aAngle:Integer;aTxt:String);
{==========================================================================}
{ Draw text with FontIndirect (angle -> escapement)                        }
{--------------------------------------------------------------------------}
var LFont             : TLogFont;
    hOldFont, hNewFont: HFont;
begin
{  CalcTextPos(aRect,aAngle,aTxt);}

  GetObject(aCanvas.Font.Handle,SizeOf(LFont),Addr(LFont));
  LFont.lfEscapement := aAngle*10;
  hNewFont := CreateFontIndirect(LFont);
  hOldFont := SelectObject(aCanvas.Handle,hNewFont);

  aCanvas.TextOut(x,y,aTxt);

  hNewFont := SelectObject(aCanvas.Handle,hOldFont);
  DeleteObject(hNewFont);
end;
{==========================================================================}


procedure TDataBaseDlg.PrintButtonClick(Sender: TObject);
Var sizelab,wlab,hlab,th,i,numlines:integer;
    s:string;
    hs:string;
    clickedok:boolean;
    NewString:
{$ifdef ver80}
    string;
{$else}
    ansistring;
{$endif}
    hz,hr,vz,vr:integer;
    Memo1:tstringlist;

function mmh(w:integer):integer;
begin
  mmh:=(round(w*(hr/hz)*(200/2358)));
end;

function mmv(h:integer):integer;
begin
  mmv:=round(h*(vr/vz)*(288/3407));
end;

procedure MakeTitle;
var i:integer;
begin
   s:=CDNameEdit.Text;
   i:=pos(':',s);
   if i>0 then
   begin
     hs:=copy(s,i+1,length(s));
     s:=copy(s,1,i-1);
   end else
   begin
     hs:='';
   end;
   i:=pos(';',s);
   if i>0 then
   begin
     s:=copy(s,i+1,length(s))+' '+copy(s,1,i-1);
   end;
 end;

begin
  Printer.BeginDoc;
  NewString:='';
  ClickedOK := InputQuery('Text to display at bottom of form:', '', NewString);
  numlines:=20;
  {Get Device Capabilities}
  hz:= GetDeviceCaps(Printer.Canvas.Handle,HORZSIZE);
  hr:= GetDeviceCaps(Printer.Canvas.Handle,HORZRES);
  vz:= GetDeviceCaps(Printer.Canvas.Handle,VERTSIZE);
  vr:= GetDeviceCaps(Printer.Canvas.Handle,VERTRES);
  {Calculate pixels for printing}
  sizelab:=mmh(72);
  wlab:=mmh(1644);
  hlab:=mmv(1419);
  th:=mmv(51);
  {end calculate pixels}
  with Printer.Canvas do
  begin
    rectangle(sizelab,mmv(24),(wlab+sizelab),hlab);
    moveto(0,mmv(24));
    lineto(0,hlab);
    moveto((wlab+2*sizelab),mmv(24));
    lineto((wlab+2*sizelab),hlab);
   MakeTitle;
   s:=s+' : '+hs;
   Printer.Canvas.Font.Style:=[fsBold];
   TextOut(2*sizelab,th,s);
   DrawAngleText(Printer.Canvas,(wlab+2*sizelab-mmh(12)),mmv(75),270,s);
   DrawAngleText(Printer.Canvas,(sizelab div 6),(hlab-mmv(40)),90,s);
   Printer.Canvas.Font.Style:=[];
   TextOut(mmh(1320),th,Label7.Caption);
   TextOut(mmh(1488),th,YearEdit.Text);
   For i:=0 to TrackCount(memo1)-1 do
   begin
     TextOut((sizelab+mmh(120)+(wlab div 2)*(i div numlines)),
       ((i mod numlines)+3)*th,xstr(i+1,2,0));
     TextOut((sizelab+mmh(120+60)+(wlab div 2)*(i div numlines)),
       ((i mod numlines)+3)*th,TrackTime(memo1,i+1));
     TextOut((sizelab+mmh(120+180)+(wlab div 2)*(i div numlines)),
       ((i mod numlines)+3)*th,TrackName(memo1,i));
   end;               {tmemo}
   memo1:=TStringList.create;
   for i:=0 to Memo1.Count-1 do
   TextOut(2*sizelab,(23+i)*th,Memo1[i]);
   if clickedok then TextOut(2*sizelab,(23+Memo1.Count)*th,
   NewString);
   memo1.free;
  end;
   {Print Front-page}
  MakeTitle;
  with Printer.Canvas do
  begin
   rectangle(sizelab,hlab+mmv(24),(sizelab+mmh(1450)),hlab+hlab);
   Font.Size:=Font.Size*3;
   TextOut(2*sizelab,hlab+mmv(250),s);
   TextOut(2*sizelab,hlab+mmv(500),hs);
   Font.Size:=Font.Size div 3;
  end;
   {end front-page}
  Printer.EndDoc;
end;

procedure TDataBaseDlg.StatisticsButtonClick(Sender: TObject);
begin
  ScanDataBase(true);
end;

procedure TDataBaseDlg.ScanDataBase(stat:boolean);
var i:longint;
    s:string;
    foundit:boolean;
    ts:Tstringlist;
    Modal : TResData1;
    j,hi:integer;
    tottime:longint;
function CalcStat(time:longint;gt:boolean;s:string;name:string;i:integer)
 :string;
var hb:boolean;
begin
  if gt then hb:=time>calctime(copy(s,1,5))else
  hb:=time<calctime(copy(s,1,5));
    if hb then
    begin
      CalcStat:=strtime(time)+' '+copy(s,7,
        pos('%',s)-7)+'%'+ name+'-|'+xstr(i,1,0);
    end else CalcStat:=s;
end;
procedure ScanStat(var i:longint;var ts:TStringList);
var list:Tstringlist;
    time,htime:longint;
    j:integer;
begin
    list:=TStringList.create;
    table1.next;
      i:=i+1;
      List.Clear;
      List.assign(Table1.FieldByName('DATA'));
      time:=0;
      for j:=0 to List.count-1 do
      if List.Strings[j][1]='T' then
      begin
        with List do
        begin
          htime:=calctime(copy(Strings[j],pos('|',Strings[j])+1,5));
          time:=time+htime;
          ts[2]:=CalcStat(htime,true,ts[2],Strings[j],i);
          ts[3]:=CalcStat(htime,false,ts[3],Strings[j],i);
        end;
      end;
      ts[0]:=CalcStat(time,true,ts[0],table1.FieldByName('CDNAME').asstring,i);
      ts[1]:=CalcStat(time,false,ts[1],table1.FieldByName('CDNAME').asstring,i);
      tottime:=tottime+time;
  List.free;
end;
var HIndex:string;
    MyBookmark: TBookmark;
begin
  dbnavigator1.enabled:=false;
  HIndex:=Table1.IndexName;
  Table1.IndexName:='';
{ Save the current record position in MyBookmark }
  MyBookmark := Table1.GetBookmark;
  ts:=TStringList.create;
  if stat then
  begin
    ts.add('00:00 Longest CD%New CD');
    ts.add('99:99 Shortest CD%New CD');
    ts.add('00:00 Longest Track%New Track');
    ts.add('99:99 Shortest Track%New Track');
  end;
  DataSource1.Enabled:=false;{ttable}
  Table1.first;
  i:=0;
  s:=trim(SearchEdit.text);
  with SShowDlg do
  begin
    Caption:='Scanning database';
    Show;
    Gauge1.MaxValue:=Table1.RecordCount;
    Gauge1.Progress:=0;
  end;
  tottime:=0;
  repeat
    SShowDlg.Gauge1.Progress:=SShowDlg.Gauge1.Progress+1;
    KeepWindowsAlive;
    if stat then
    ScanStat(i,ts) else
    ScanRecord(s,i,ts,foundit);
  until Table1.eof or SShowDlg.docancel;
  SShowDlg.Hide;
  if stat then
  begin
    ts.add('Average time CD''s:'+strtime(tottime div i)+'%');
    ts.add('Total number of CD''s:'+xstr(i,1,0)+'%');
  end;
  DataSource1.Enabled:=true;
  dbnavigator1.enabled:=true;
{ Return to the record associated with MyBookmark }
  Table1.GotoBookmark(MyBookmark);
{ Release the resources for MyBookmark }
  Table1.FreeBookmark(MyBookmark);
  Try
    Modal := TResData1.Create(Self);
    with modal do
    if ts.count>0 then
    begin
      if stat then
      Caption:='Statistics' else
      Caption:=xstr(ts.count,1,0)+' matches for:'+SearchEdit.text;
      for j:=0 to ts.count-1 do
      InsLine(ts[j]);
      with StringGrid1 do
      begin
        if stat then
        begin
          ColWidths[0]:=130;
          ColWidths[1]:=110;
        end else
        begin
          ColWidths[0]:=0;
          ColWidths[1]:=235;
        end;
        FixedRows:=1;
      end;
    end;
    if ts.Count>0 then
    repeat
      with Modal do
      if ShowModal=mrok then
      begin
        with StringGrid1 do
        if cells[2,row]<>'' then
        begin
          val(cells[2,row],j,hi);
          Table1.first;
          Table1.MoveBy(j);
        end;
        foundit:=true;
      end else foundit:=false;
    until not foundit
    else ShowMessage('No records matching criterium');
    Modal.Free
  Finally
  End;
  Table1.IndexName:=HIndex;
  ts.free;
end;

procedure TDataBaseDlg.Global1Click(Sender: TObject);
begin
  ScanDataBase(false);
end;

procedure TDataBaseDlg.Artist1Click(Sender: TObject);
begin
  Table1.IndexName:='CDNAME';
end;

procedure TDataBaseDlg.Style1Click(Sender: TObject);
begin
  Table1.IndexName:='STYLENAME';
end;

procedure TDataBaseDlg.Id1Click(Sender: TObject);
begin
  Table1.IndexName:='CDID';
end;

procedure TDataBaseDlg.Natural1Click(Sender: TObject);
begin
  Table1.IndexName:='';
end;

procedure TDataBaseDlg.Tracksincluded1Click(Sender: TObject);
begin
  TracksIncluded1.checked:=not TracksIncluded1.checked;
end;

procedure TDataBaseDlg.Exit1Click(Sender: TObject);
begin
  Hide;
end;

procedure TDataBaseDlg.OKBtnClick(Sender: TObject);
begin
  close;
end;

procedure writelnf(var f:text;s:string);
begin
  if length(trim(s))=0 then exit;
  if copy(ltrim(s),1,2)='/e' then
  s:=copy(ltrim(s),3,length(s));
  if DispOnScreen then
  ScreenStringList.add(s) else
  if DestPrintFileChecked=1 then
  writeln(f,s) else
  if DestPrintFileChecked=2 then
  MyPrinter.PrintLine(s) else
  PreviewDlg.memo1.lines.add(s);
end;

procedure change(var outline:string255;s:string;code:string);
var p:integer;
begin
  if (length(outline)=0) then exit;
  p:=pos('%'+code,uppercase(outline));
  while p>0 do
  begin
    delete(outline,p,1+length(code));
    insert(s,outline,p);
    p:=pos('%'+code,uppercase(outline));
  end;
end;

procedure ChangeOutline(var outline:string255;id,CDName,year:string;
  style,tcount:integer;ttime:longint;tracktitle,tracktime:string;
    tracknr:integer;MyList:TstringList;fillit:boolean);
{changes the string 'outline' with its corresponding variables}
var i:integer;
    hs:string255;
    hcd:string255;

function FillZero(s:string255):string255;
var i:integer;
begin
  for i:=1 to length(s) do
  if s[i]=' ' then s[i]:='0';
  FillZero:=s;
end;

begin
    hcd:=copy(cdname,1,255);
    hs:=copy(outline,1,255);
    if length(hs)=0 then exit;
    for i:=0 to StringFieldNames.count-1 do
    begin
      change(hs,MyList.Values[StringFieldNames[i]],Uppercase(StringFieldNames[i]));
    end;
    change(hs,Id,'ID');
    if fillit then
    change(hs,fillzero(xstr(tracknr,2,0)),'N')
    else change(hs,xstr(tracknr,2,0),'N');
    change(hs,tracktitle,'I');
    change(hs,tracktime,'T');
    change(hs,trim(copy(hcd,1,pos(':',hcd)-1)),'F');
    change(hs,ArtistName(hcd),'A');
    change(hs,CeeDeeName(hcd),'C');
    if fillit then
    change(hs,FillZero(xstr(tcount,2,0)),'R')
    else change(hs,xstr(tcount,1,0),'R');
    change(hs,strtime(ttime),'O');
    change(hs,year,'Y');
    if (style>=0) and (style<Styles.count) then
    change(hs,Styles[Style],'S');
    outline:=copy(hs,1,255);
end;

procedure CalcTotalTracks(MyList:TStringList;var tcount:integer;var ttime:longint);
var i:integer;
    s:string;
begin
    i:=1;
    ttime:=0;
    tcount:=0;
    repeat
      s:=MyList.Values['T'+xstr(i,1,0)];
      if s<>'' then
      begin
        s:=behind(s);
        if length(s)>0 then
        begin
          s:=copy(s,1,5);
          ttime:=ttime+calctime(s);
        end;
        inc(tcount);
      end;
      inc(i);
    until i>maxtracks;
end;

procedure DisplayRecord(var Table1:TTable;CDName,Id,year:string;Style:integer;
  var MyList:TstringList;var f:text;var MyTrackMemo,MyCDHeaderMemo,MyReportHeaderMemo:TStringList;
    bTrackInfo:boolean);
var tcount,i:integer;
    ttime:longint;
    outline:string255;
procedure DispTrackInfo(s:string;i:integer);
var hs:string;
    j:integer; 
begin
      if s<>'' then
      begin
        hs:=behind(s);
        if length(hs)>0 then
        begin
          hs:=copy(hs,1,length(s));
          s:=before(s);
          if length(hs)>5 then
          begin {extra track}
            s:='('+copy(s,2,2)+')'+copy(s,4,length(s));
            hs:=copy(hs,1,5)+'-'+copy(hs,6,5);
          end;
        end;
        for j:=0 to MyTrackMemo.Count-1 do
        begin
          outline:=MyTrackMemo[j];
          ChangeOutline(outline,id,CDName,year,
  style,tcount,ttime,s{tracktitle},hs{tracktime},i{tracknr},MyList,false);
          writelnf(f,outline);
        end;
      end;
end;

begin
  CalcTotalTracks(MyList,tcount,ttime);
  if PrintStyle>0 then
  if PrintStyle-1<>Style then exit;
  for i:=0 to MyCDHeaderMemo.Count-1 do
  begin
    outline:=MyCDHeaderMemo[i];
    ChangeOutline(outline,id,CDName,year,
  style,tcount,ttime,'','',0,MyList,false);
    writelnf(f,outline);
  end;
  if bTrackInfo then
  begin
    i:=1;
    repeat
      DispTrackInfo(MyList.Values['T'+xstr(i,1,0)],i);
      inc(i);
    until i>maxtracks;
    i:=1;
    repeat
      DispTrackInfo(MyList.Values['X'+xstr(i,1,0)],i);
      inc(i);
    until i>maxtracks;
  end;
end;

procedure ReadCDExp(var Table1:TTable;var f:text;var MyTrackMemo,MyCDHeaderMemo,MyReportHeaderMemo:TStringList;
    var bTrackInfo:boolean;var expression:string255);
{reads cd from table1 and calculates expression}
var Mylist:TStringList;
    CDName,year,DiskId:string;
    Style:integer;
    tcount:integer;
    ttime:longint;
begin
  mylist:=TStringlist.create;
  GetRecord(Table1,DiskId,CDName,year,Style,Mylist);
  keepwindowsalive;
  CalcTotalTracks(MyList,tcount,ttime);
  ChangeOutline(expression,Diskid,CDName,year,
    style,tcount,ttime,'','',0,MyList,true);
end;

function GoodSelection(Table1:TTable;selection:string255):boolean;
var b:boolean;
    ExpA,ExpB:string;
    Mylist:TStringList;
    CDName,year,DiskId:string;
    Style:integer;
    SelectMe:boolean;
    tcount:integer;
    ttime:longint;
function Recurs(selection:string255):boolean;
var b:boolean;
    p:integer;
function IsSelect(e:string):boolean;
var p:integer;
begin
  p:=pos(e,selection);
  if p>0 then
  begin
    ExpA:=trim(ltrim(copy(selection,1,p-1)));
    ExpB:=trim(ltrim(copy(selection,p+length(e),255)));
    IsSelect:=true;
  end else
  IsSelect:=false;
end;
function mypos(expr:string255):boolean;
begin
  p:=pos(expr,selection);
  if p>0 then mypos:=true else
  mypos:=false;
end;
begin
  b:=true;
  if mypos(' OR ') then
  begin
    b:=Recurs(copy(selection,1,p-1)) or
      Recurs(copy(selection,p+4,length(selection)));
  end else
  if mypos(' AND ') then
  begin
    b:=Recurs(copy(selection,1,p-1)) and
       Recurs(copy(selection,p+5,length(selection)));
  end else
  if IsSelect('>=') then
    b:=ExpA>=ExpB else
  if IsSelect('<=') then
    b:=ExpA<=ExpB else
  if IsSelect('>') then
    b:=ExpA>ExpB else
  if IsSelect('<') then
    b:=ExpA<ExpB else
  if IsSelect('=') then
    b:=ExpA=ExpB;
  Recurs:=b;
end;
begin
  SelectMe:=length(trim(selection))>0;
  if not SelectMe then
  begin
    GoodSelection:=true;
    exit;
  end;
  mylist:=TStringlist.create;
  GetRecord(Table1,DiskId,CDName,year,Style,Mylist);
  keepwindowsalive;
  CalcTotalTracks(MyList,tcount,ttime);
  ChangeOutline(selection,Diskid,CDName,year,
    style,tcount,ttime,'','',0,MyList,true);
  selection:=Uppercase(selection);
  b:=Recurs(selection);
  GoodSelection:=b;
  mylist.free;
end;

procedure ReadAndWrite(var Table1:TTable;var f:text;var MyTrackMemo,MyCDHeaderMemo,MyReportHeaderMemo:TStringList;
    var bTrackInfo:boolean;selection:string);
var Mylist:TStringList;
    CDName,year,DiskId:string;
    Style:integer;

begin
  if GoodSelection(Table1,selection) then
  begin
    mylist:=TStringlist.create;
    GetRecord(Table1,DiskId,CDName,year,Style,Mylist);
    keepwindowsalive;
    DisplayRecord(Table1,CDName,DiskId,year,Style,Mylist,
      f,MyTrackMemo,MyCDHeaderMemo,MyReportHeaderMemo,bTrackInfo);
    mylist.free;
  end;
end;{ReadAndWrite}

procedure GetRecord(var Table1:TTable;var DiskId,CDName,year:string;var Style:integer;
  var Tracce:TstringList);
var hi:integer;
begin
  Tracce.clear;
  with Table1 do
  begin
    DiskId := FieldByName('CDID').asstring;
    CDName := FieldByName('CDName').asstring;
    year := FieldByName('year').asstring;
    Val(FieldByName('Style').asstring,Style,hi);
    Tracce.assign(FieldByName('DATA'));
  end;
end;

function behind(s:string):string;
var p:integer;
begin
  p:=pos('|',s);
  if p>0 then behind:=copy(s,p+1,length(s)) else
  behind:='';
end;

function before(s:string):string;
var p:integer;
begin
  p:=pos('|',s);
  if p>0 then before:=copy(s,1,p-1) else
  before:=s;
end;

function Artistname(diskname:string255):string255;
var p,p2:integer;
    hs:string255;
begin
  if length(diskname)=0 then
  begin
    artistname:='';
    exit;
  end;
  p:=pos(';',diskname);
  if p>0 then
  begin
    hs:=copy(diskname,p+1,length(diskname));
    p2:=pos(':',hs);
    if p2>0 then
    hs:=ltrim(trim(copy(hs,1,p2-1)))+' '+trim(copy(diskname,1,p-1))+
	' : '+ltrim(copy(hs,p2+1,length(hs)))
    else hs:=trim(hs)+' '+trim(copy(diskname,1,p-1));
  end else hs:=diskname;
  p2:=pos(':',hs);
  if p2>0 then
  hs:=trim(copy(hs,1,p2-1));
  ArtistName:=hs;
end;

function CeeDeename(diskname:string255):string255;
var p,p2:integer;
    hs:string255;
begin
  if length(diskname)=0 then
  begin
    CeeDeename:='';
    exit;
  end;
  p:=pos(';',diskname);
  if p>0 then
  begin
    hs:=copy(diskname,p+1,length(diskname));
    p2:=pos(':',hs);
    if p2>0 then
    hs:=ltrim(trim(copy(hs,1,p2-1)))+' '+trim(copy(diskname,1,p-1))+
	' : '+ltrim(copy(hs,p2+1,length(hs)))
    else hs:=trim(hs)+' '+trim(copy(diskname,1,p-1));
  end else hs:=diskname;
  p2:=pos(':',hs);
  if p2>0 then
  hs:=ltrim(copy(hs,p2+1,length(hs)));
  CeeDeeName:=hs;
end;

procedure assignTextFile(var f:textfile;var outname:string);
begin
  assignfile(f,outname);
  if not fileexists(outname) then
  begin
    rewrite(f);
    closefile(f);
  end;
end;

function TDataBaseDlg.GetPrintInfo(var MyTrack,MyCDHeader,MyReportHeader:TStringList;
    var bTrackInfo:boolean;var DestPrintFileChecked:integer;var OutputFilename:string;
    AskForOverwrite,AskForFileName,Clearit:boolean;var Selection,SortExpression:string):boolean;
var Modal : TPrintDB;
    i:integer;

procedure CopyMemo(var ToMemo:TStringList;FromMemo:TMemo);
var i:integer;
    s:string;
begin
  if clearit then
  ToMemo:=TStringlist.Create else ToMemo.clear;
  for i:=0 to FromMemo.Lines.Count-1 do
  begin
    s:=FromMemo.Lines[i];
    ToMemo.Add(s);
  end;
end;

procedure CopyToMemo(FromMemo:TStringList;var ToMemo:TMemo);
var i:integer;
    s:string;
begin
  for i:=0 to FromMemo.Count-1 do
  begin
    s:=FromMemo[i];
    ToMemo.Lines.Add(s);
  end;
end;

begin
  Try
    Modal := TPrintDB.Create(Self);
    with Modal do
    begin
      selection:='';
      SortExpression:='';
      AskFilename:=AskForFileName;
      Modal.SelectionEdit.text:=Selection;
      Modal.SortExpressionEdit.text:=SortExpression;
      Filename1.text:=OutputFilename;
      TrackMemo.Lines.clear;
      CDHeaderMemo.Lines.clear;
      ReportHeaderMemo.Lines.clear;
      if clearit then
      begin
        TrackMemo.Lines.add(TrackOutline);
        CDHeaderMemo.Lines.add(RecordOutline);
        ReportHeaderMemo.Lines.add(ReportOutline);
      end else
      begin
        CopyToMemo(MyTrack,TrackMemo);
        CopyToMemo(MyCDHeader,CDHeaderMemo);
        CopyToMemo(MyReportHeader,ReportHeaderMemo);
      end;
      FileRadioButton.checked:=DestPrintFileChecked=1;
      PrinterRadioButton.checked:=DestPrintFileChecked=2;
      ScreenRadioButton.checked:=DestPrintFileChecked=3;
      with SaveDialog2 do
      if AskForOverwrite then
      options:=options+[ofOverwritePrompt] else
      options:=options-[ofOverwritePrompt];
    end;
    if Modal.ShowModal = mrOk then
      with Modal do
      begin
        SortExpression:=Modal.SortExpressionEdit.text;
        Selection:=Modal.SelectionEdit.text;
        CopyMemo(MyTrack,TrackMemo);
        with MyTrack do
        begin
          for i:=0 to Count-1 do
          MyTrack[i]:=trim(MyTrack[i]);
          i:=Count-1;
          while (i>=0) and (length(MyTrack[i])=0) do
          begin
            delete(i);
            dec(i);
          end;
          bTrackInfo:=MyTrack.Count<>0;
          CopyMemo(MyCDHeader,CDHeaderMemo);
          CopyMemo(MyReportHeader,ReportHeaderMemo);
          if FileRadioButton.checked then
          DestPrintFileChecked:=1 else
          if PrinterRadioButton.checked then
          DestPrintFileChecked:=2 else
          if ScreenRadioButton.checked then
          DestPrintFileChecked:=3;
          OutputFilename:=Filename1.text;
          PrintStyle:=StyleBox.ItemIndex;
        end;
        GetPrintInfo:=true;
      end else
      begin
         GetPrintInfo:=false;
      end;
    Modal.Free
  Finally
  End;
end;

procedure TDataBaseDlg.Current1Click(Sender: TObject);
var f:textfile;
    bTrackInfo:boolean;
    MyTrack,MyCDHeader,MyReportHeader:TStringList;
    selection:string;
    SortExpression:string;
begin
  if GetPrintInfo(MyTrack,MyCDHeader,MyReportHeader,
    bTrackInfo,DestPrintFileChecked,OutputFilename,false,true,true,selection,SortExpression) then
  begin
    if DestPrintFileChecked=1 then
    begin
      AssignTextFile(f,OutputFilename);
      Append(f);
    end
    else
    if DestPrintFileChecked=2 then
    begin
      MyPrinter:=TMyPrinter.create;
    end else
    PreviewDlg.Memo1.Lines.clear;
    ReadAndWrite(Table1,f,MyTrack,MyCDHeader,MyReportHeader,
        bTrackInfo,'');
    if DestPrintFileChecked=1 then
    CloseFile(f) else
    if DestPrintFileChecked=2 then
    with MyPrinter do
    begin
      EndDoc;
    end else
    PreviewDlg.showModal;
    MyTrack.Free;
    MyCDHeader.Free;
    MyReportHeader.Free;
  end;
end;

function GetDefaults(s:string255):string255;
begin
  change(s,TimeToStr(time),'TIME');
  change(s,DatetoStr(date),'DATE');
  change(s,ShortDayNames[dayofweek(date)],'DAYOFWEEK');
  change(s,copy(DatetoStr(date),1,2),'DAY');
  change(s,copy(DatetoStr(date),4,2),'MONTH');
  change(s,copy(DatetoStr(date),7,4),'YEAR');
  GetDefaults:=s;
end;

procedure TDataBaseDlg.PrintAll(all:boolean);
procedure prchange(var s1:string;s2:string;ch:char);
var h1:string255;
begin
  h1:=copy(s1,1,255);
          change(h1,s2,ch);
  s1:=copy(h1,1,255);
end;
var f:textfile;
    i,j,CntCD,hi:integer;
    outline,s:string;
    hs:string255;
    bTrackInfo,descending:boolean;
    p:Integer;
    MyTrack,MyCDHeader,MyReportHeader:TStringList;
    selection:string;
    hs2,SortExpression:string255;
    SortMe,SelectMe:boolean;
    SortList:TStringList;
    HIndex:string;

procedure PrintSortItem(i:integer);
{print record for item in sorted list}
var j:integer;
begin
  j:=pos('||',SortList[i]);
    val(copy(SortList[i],j+2,4),j,hi);
    Table1.first;
    Table1.MoveBy(j-1);
  SShowDlg.Gauge1.Progress:=SShowDlg.Gauge1.Progress+1;
  ReadAndWrite(Table1,f,MyTrack,MyCDHeader,MyReportHeader,
    bTrackInfo,selection);
end;

begin
  if GetPrintInfo(MyTrack,MyCDHeader,MyReportHeader,
    bTrackInfo,DestPrintFileChecked,OutputFilename,true,true,true,selection,SortExpression) then
  begin
    SortMe:=length(trim(SortExpression))>0;
    SelectMe:=length(trim(selection))>0;
    if sortme and not all then
    begin
      showmessage('Only sort when printing entire database');
      exit;
    end;
{    dbnavigator1.enabled:=false;}
    DataSource1.Enabled:=false;
    SortList:=TStringList.create;
    SortList.sorted:=true;
    if DestPrintFileChecked=1 then
    begin
      AssignTextFile(f,OutputFilename);
      Rewrite(f);
    end
    else
    if DestPrintFileChecked=2 then
    begin
      MyPrinter:=TMyPrinter.create;
    end else
    PreviewDlg.Memo1.Lines.clear;
    with Table1 do
    begin
      p:=0;
      while not eof do
      begin
        inc(p);
        next
      end;
    if all then
    begin
      first;
      CntCD:=RecordCount;
    end else
    begin
      CntCD:=p;
      moveby(-(j-1));
    end;
    descending:=false;
    if SortMe then
    begin
      i:=pos('/D',uppercase(sortexpression));
      descending:=i>0;
      if descending then system.delete(sortexpression,i,2);
      HIndex:=Table1.IndexName;
      Table1.IndexName:='';
    end;
    if (not SortMe) and (SelectMe) then
    begin
      SortList.sorted:=false;
    end;
    if SortMe or SelectMe then
    begin
      SShowDlg.Caption:='Scanning database';
      SShowDlg.Show;
      SShowDlg.Gauge1.MaxValue:=Cntcd;
      SShowDlg.Gauge1.Progress:=0;
      Table1.first;
      i:=1;
      while not Table1.eof and not SShowDlg.docancel do
      begin
        SShowDlg.Gauge1.Progress:=SShowDlg.Gauge1.Progress+1;
        if GoodSelection(Table1,selection) then
        begin
          if Sortme then
          begin
            hs2:=SortExpression;
            ReadCDExp(Table1,f,MyTrack,MyCDHeader,MyReportHeader,
              bTrackInfo,hs2);
            SortList.add(hs2+'||'+xstr(i,1,0));
          end else
          SortList.add('||'+xstr(i,1,0));
        end;
        Table1.next;
        inc(i);
      end;
      SShowDlg.Gauge1.Progress:=SShowDlg.Gauge1.Progress+1;
      CntCD:=SortList.count;
    end;
      with MyPrinter do
      begin
        for i:=1 to MyReportHeader.Count do
        begin
          hs:=MyReportHeader[i-1];
          str(CntCD:1,s);
          change(hs,s,'B');
          hs:=GetDefaults(hs);
          outline:=copy(hs,1,255);
          if DestPrintFileChecked=1 then
          writelnf(f,outline)
          else
          if DestPrintFileChecked=2 then
          header.add(outline) else
          PreviewDlg.Memo1.Lines.add(outline);
        end;
      end;
    end;
    SShowDlg.Caption:='Write database to textfile';
    SShowDlg.Show;
    SShowDlg.Gauge1.MaxValue:=CntCD;
    SShowDlg.Gauge1.Progress:=0;
    if SortMe or SelectMe then
    begin
      SShowDlg.Gauge1.MaxValue:=SortList.count;
      if descending then
      for i:=SortList.count-1 downto 0 do
      begin
        PrintSortItem(i);
        if SShowDlg.docancel then break;
      end else
      for i:=0 to SortList.count-1 do
      begin
        PrintSortItem(i);
        if SShowDlg.docancel then break;
      end;
{      Table1.last;
      Table1.moveby((p-1));}
    end else
    begin
      while not Table1.eof and not SShowDlg.docancel do
      begin
        SShowDlg.Gauge1.Progress:=SShowDlg.Gauge1.Progress+1;
        ReadAndWrite(Table1,f,MyTrack,MyCDHeader,MyReportHeader,
          bTrackInfo,selection);
        Table1.next;
      end;
    end;
    SShowDlg.Hide;
    MyTrack.Free;
    MyCDHeader.Free;
    MyReportHeader.Free;
    if DestPrintFileChecked=1 then
    CloseFile(f) else
    if DestPrintFileChecked=2 then
    with MyPrinter do
    begin
      EndDoc;
{      Free;}
    end else
    PreviewDlg.showmodal;
    if SortMe then
    begin
      Table1.IndexName:=HIndex
    end;
    SortList.free;
{    dbnavigator1.enabled:=true;}
{    Table1.active:=false;}
    {$IFDEF VER80}
    close; {due to an error the previous command halts the system...}
    {$ELSE}
{    Table1.active:=true;}
    DataSource1.Enabled:=true;
    Table1.last;
    Table1.moveby(-(p-1));
    {$ENDIF}
  end;
end;

procedure TDataBaseDlg.PrintAll1Click(Sender: TObject);
begin
  PrintAll(True);
end;
procedure TDataBaseDlg.PrintRest1Click(Sender: TObject);
begin
  PrintAll(False);
end;

constructor TMyprinter.create;
begin
  inherited create;
  CurrentLine:=0;
  MaxLines:=72;
{  HText:=Canvas.Font.Size;}
  HText:=PageHeight div MaxLines;
  Header:=TStringlist.create;
  BeginDoc;
end;

procedure TMyPrinter.PrintLine(s:string);
var i:integer;
    s1:string;
    SText:integer;
procedure drukregel(bx,by:longint;s:string);
var hhText,i:integer;
    fontChanged:boolean;
procedure ChangeFont(n:integer);
begin
  fontchanged:=true;
  with canvas do
  begin
    Font.Size:=(n*SText)div 2;
    moveto(Penpos.x,by+(n*HhText)div 2-HhText);
  end;
end;
procedure setstyle(st:TFontStyle);
begin
  with Canvas.Font do
  if st in Style then style:=style-[st] else
  style:=style+[st]
end;
begin
  fontchanged:=false;
 with Canvas do
 begin
  SText:=Font.Size;
  HHtext:=Font.Height;
  MoveTo(bx,by);
  i:=1;
  while i<=length(s) do
  begin
   if s[i]='|' then
   begin
     case upCase(s[i+1]) of
       'B':SetStyle(fsBold);
       'I':SetStyle(fsItalic);
       'U':SetStyle(fsUnderline);
       'S':SetStyle(fsStrikeout);
       '1'..'9':ChangeFont(ord(upCase(s[i+1]))-ord('0'));
     end;
     i:=i+2;
   end else
   begin
    Textout(Penpos.x,Penpos.y,s[i]);
    i:=i+1;
   end;
  end;
  if fontchanged then
  Font.Size:=SText;
 end;
end;
begin
  if CurrentLine+Header.Count+1+3>MaxLines then
  begin
    CurrentLine:=0;
    newpage;
  end;
  if CurrentLine=0 then
  with Canvas do
  begin
    For i:=1 to Header.Count do
    drukregel(30,HText*i,Header[i-1]);
    moveto(0,HText*Header.Count+10);
    lineto(Pagewidth,HText*Header.Count+10);
    str(PageNumber:1,s1);
    Font.Style:=[fsBold];
    Canvas.TextOut((PageWidth div 2)-20,HText*71,'Page ');
    Font.Style:=[];
    Canvas.TextOut(PenPos.x,PenPos.y,s1);
    moveto(0,HText*71-10);
    lineto(Pagewidth,HText*71-10);
  end;
  drukregel(50,HText*(CurrentLine+Header.Count+1),s);
  inc(CurrentLine);
end;

destructor TMyprinter.free;
begin
  header.free;
  inherited free;
end;

procedure TDataBaseDlg.ProgramButtonClick(Sender: TObject);
Var Modal : TPlayList;
    hs,s:string;
    i,code:integer;
    pp:integer;
    hset:set of 1..100;
begin
  hset:=[];
  Modal := TPlayList.Create(Self);
  with Modal do
  try
    i:=1;
    repeat
      s:=Memo1.Values['P'+xstr(i,1,0)];
      s:=copy(s,pos('-',s)+1,255);
      if s<>'' then
      ProgramListBox.Items.add(s);
      inc(i);
    until s='';
    s:=Memo1.Values['Program'];
    s:=copy(s,pos('-',s)+1,255);
    for i:=1 to length(s) div 2 do
    begin
      hs:=copy(s,(i-1)*2+1,2);
      if hs<>'  ' then
      begin
        val(hs,pp,code);
        hset:=hset+[pp];
        if pp<=TrackCount(memo1) then
          Modal.DstList.Items.Add(hs+' '+TrackName(memo1,pp))
        else
        begin
          Modal.DstList.Items.Add(hs+' '+
          ExtraTrackTrackName(memo1,pp-TrackCount(memo1)));
        end;
      end;
    end;
    for i:=1 to TrackCount(memo1)+ExtraTrackCount(memo1) do
    begin
      if i<=TrackCount(memo1) then
      Modal.TimeArr[i]:=calctime(TrackTime(memo1,i)) else
      Modal.TimeArr[i]:=calctime(ExtraTrackEndTime(memo1,i-TrackCount(memo1)))-
                         calctime(ExtraTrackStartTime(memo1,i-TrackCount(memo1)));
      if not (i in hset) then
      begin
        if i<=TrackCount(memo1) then
          s:=TrackName(memo1,i) else
          s:=ExtraTrackTrackName(memo1,i-TrackCount(memo1));
        Modal.SrcList.Items.Add(xstr(i,2,0)+' '+s)
      end;
    end;
    SetButtons;
    ShowModal;
    if Modal.result=mrok then
    Begin
      table1.edit;
      for i:=Memo1.count-1 downto 0 do
      if copy(Memo1[i],1,1)='P' then
      Memo1.delete(i);
      for i:=0 to ProgramListBox.Items.Count-1 do
      Memo1.add('P'+xstr(i+1,1,0)+'=-'+ProgramListBox.Items[i]);
      s:='-';
      for i:=1 to DstList.Items.count do
      s:=s+copy(DstList.Items[i-1],1,2);
      Memo1.add('Program='+s);
      DoubleSave;
    end;
    Modal.free;
  finally
  end;
end;

procedure TDataBaseDlg.Table1AfterPost(DataSet: TDataset);
begin
  redisplay:=true;
end;

procedure TDataBaseDlg.DoubleSave;
{I don't know why, but my meo-field is only saved}
{when I save it once, and try again. Don't ask me why}
{but it works!}
begin
      Table1.FieldByName('DATA').Assign(Memo1);
      Table1.FieldByName('STYLE').asstring:=xstr(StyleBox.ItemIndex,1,0);
      if Table1.state=dsEdit then Table1.post;
      SetMemo;
      Table1.Edit;
      Table1.FieldByName('DATA').Assign(Memo1);
      Table1.post;
end;

procedure TDataBaseDlg.DefineEditTrack(Var Modal : TEditTrack);
var p:integer;
begin
    EditNamesStringList:=Memo1;
    p:=pos(':',CDNameEdit.Text);
    Modal.Artist.Text := trim(ltrim(copy(CDNameEdit.Text,1,p-1)));
    Modal.CdName.Text := trim(ltrim(copy(CDNameEdit.Text,p+1,255)));
    SetStyles(Modal.Style);
    Modal.year.Text := yearEdit.Text;
    Modal.Style.ItemIndex := StyleBox.ItemIndex;
    Modal.FillEditTrack(memo1);
end;

procedure TDataBaseDlg.ReturnEditTrack(Var Modal : TEditTrack);
begin
      Table1.Edit;
      CDNameEdit.Text:=trim(ltrim(Modal.Artist.Text))+':'+
      trim(ltrim(Modal.CdName.Text));
      yearEdit.Text:=Modal.year.Text;
      StyleBox.ItemIndex:=Modal.Style.ItemIndex;
      Modal.ReturnEditTrack(memo1);
      DoubleSave;
end;

procedure TDataBaseDlg.EditButtonClick(Sender: TObject);
Var Modal : TEditTrack;
begin
  Modal := TEditTrack.Create(Self);
  try
    DefineEditTrack(Modal);
    if (Modal.ShowModal = mrOk) then
    begin
      ReturnEditTrack(Modal);
    end;
    Modal.Free
  Finally
  end;
end;

procedure TDataBaseDlg.Duplicates1Click(Sender: TObject);
begin
  Duplicates1.checked:=not Duplicates1.checked;
end;

procedure TDataBaseDlg.SearchEditKeyPress(Sender: TObject; var Key: Char);
begin
  if key=chr(vk_return) then
  if SearchResults.checked then Global1Click(sender)
  else GotoButtonClick(Sender);
end;

procedure TDataBaseDlg.SearchResultsClick(Sender: TObject);
begin
  SearchResults.checked:=true;
  GotoSearch.checked:=false;
  ScanDataBase(false);
end;

procedure TDataBaseDlg.GotoSearchClick(Sender: TObject);
begin
  GotoSearch.checked:=true;
  SearchResults.checked:=false;
  GotoButtonClick(Sender);
end;

procedure TDataBaseDlg.ImportIt(AppendIt:boolean);
var wdir:array[0..40] of char;
    HIndex:string;
    infile:textfile;
    hs,CDUniqueCode,title,artist,s:string;
    style:string;
    WriteFileBool,modified:boolean;
    sl:TStringList;
    i,p,nt,code,j:integer;
    UpdatedNum:longint;
function start(w,s:string):boolean;
var b:boolean;
begin
  b:=copy(s,1,length(w))=w;
  start:=b;
  if b then modified:=true;
end;
procedure checkstart(w,s:string;var uit:string);
begin
  if start(w,s) then
    uit:=copy(s,length(w)+1,length(s));
end;
procedure WriteToFile;
begin
  redisplay:=true;
  if WriteFileBool and modified then
  begin
    UpdatedNum:=UpdatedNum+1;
    SShowDlg.Caption:='Updated '+xstr(UpdatedNum,1,0)+' records';
    with Table1 do
    begin
      if AppendIt then
      append else edit;
      FieldByName('CDID').AsString := CDUniqueCode;
      FieldByName('Style').AsString := style;
      FieldByName('CDName').AsString := Artist+':'+title;
      FieldByName('DATA').Assign(sl);
      FieldByName('STYLE').asstring:=xstr(StyleBox.ItemIndex,1,0);
      post;
    end;
    WriteFileBool:=false;
    modified:=false;
  end;
end;
 var SearchRec: TSearchRec;
     FSize:longint;
     CSize:longint;
begin
  GetWindowsDirectory(wdir,40);
  ImportDialog.InitialDir:=strpas(wdir);
  if ImportDialog.Execute then
  begin
    FindFirst(ImportDialog.FileName,faAnyFile,SearchRec);
    FSize:=Searchrec.size;
    dbnavigator1.enabled:=false;
    DataSource1.Enabled:=false;
    HIndex:=Table1.IndexName;
    Table1.IndexName:='CDID';
    assignfile(infile,ImportDialog.FileName);
    reset(infile);
    modified:=false;
    sl:=TStringList.create;
    WriteFileBool:=false;
    UpdatedNum:=0;
    SShowDlg.Caption:='Import from '+ImportDialog.FileName;
    SShowDlg.Show;
    SShowDlg.Gauge1.MaxValue:=FSize;
    SShowDlg.Gauge1.Progress:=0;
    CSize:=0;
    while not eof(infile) and not SShowDlg.docancel do
    begin
      readln(infile,s);
      CSize:=CSize+length(s)+2;
      SShowDlg.Gauge1.Progress:=CSize;
      checkstart('artist=',s,artist);
      checkstart('title=',s,title);
      if start('numtracks=',s) then
      if AppendIt then
      begin
         sl.clear;
         val(copy(s,11,2),nt,code);
         for i:=1 to nt do
         sl.add('T'+xstr(i,1,0)+'=Track '+xstr(i,1,0)+'|');
         modified:=true;
      end;
      if s[1]='[' then
      begin
        WriteToFile;
        artist:='';title:='';
        style:='0';
        style:='0';
        CDUniqueCode:=copy(s,2,pos(']',s)-2);
        WriteFileBool:=(AppendIt and not Table1.FindKey([CDUniqueCode])) or
                         (not AppendIt and Table1.FindKey([CDUniqueCode]));
        if not AppendIt then
        with Table1 do
        begin
          sl.assign(FieldByName('DATA'));
          style:=FieldByName('Style').AsString;
          artist:=FieldByName('CDName').AsString;
          p:=pos(':',artist);
          if p>0 then
          begin
            title:=copy(artist,p+1,length(artist));
            artist:=copy(artist,1,p-1);
          end;
        end;
      end;
      for i:=0 to 50 do
      if start(xstr(i,1,0)+'=',s) then
      begin
        modified:=true;
        hs:='T'+xstr(i+1,1,0)+'=';
        for j:= 0 to sl.count-1 do
        if copy(sl[j],1,length(hs))=hs then
        begin
          p:=pos('|',sl[j]);
          if p>0 then
          begin
            sl[j]:='T'+xstr(i+1,1,0)+'='+copy(s,3+(i div 10),length(s))+'|'
              +copy(sl[j],p+1,length(sl[j]));
          end else
          sl[j]:='T'+xstr(i+1,1,0)+'='+copy(s,3+(i div 10),length(s))+'|';
        end;
      end;
    end;
    WriteToFile;
    sl.free;
    SShowDlg.Hide;
    closefile(infile);
    Table1.IndexName:=hIndex;
    dbnavigator1.enabled:=true;
    DataSource1.Enabled:=true;
    if AppendIt then
    showmessage('Appended '+xstr(UpdatedNum,1,0)+' records') else
    showmessage('Updated '+xstr(UpdatedNum,1,0)+' records');
  end;
end;

procedure TDataBaseDlg.Export1Click(Sender: TObject);
var wdir:array[0..40] of char;
    outfile:textfile;
    HIndex:string;
    UpdatedNum:longint;
procedure ReadAndWrite;
var Mylist:TStringList;
    DiskId,CDId,CDName,year:string;
    Style:integer;
    p:integer;
    s:string;
    i,NumTracks:integer;
begin
  mylist:=TStringlist.create;
  Mylist.clear;
  GetRecord(Table1,DiskId,CDName,year,Style,Mylist);
  CDid := Table1.FieldByName('CDID').asstring;
  CDid:=trim(CDid);
  if length(cdid)<10 then
  begin
    UpdatedNum:=UpdatedNum+1;
    SShowDlg.Caption:='Exported '+xstr(UpdatedNum,1,0)+' records';
    writeln(outfile,'['+trim(cdid)+']');
    writeln(outfile,'EntryType=1');
    p:=pos(':',CDName);
    writeln(outfile,'artist='+copy(CDName,1,p-1));
    writeln(outfile,'title='+copy(CDName,p+1,length(CDName)));
    NumTracks:=0;
    for i:=1 to 50 do
    begin
      s:=MyList.Values['T'+xstr(i,1,0)];
      if s<>'' then inc(NumTracks);
    end;
    writeln(Outfile,'numtracks='+xstr(NumTracks,1,0));
    for i:=1 to 50 do
    begin
      s:=MyList.Values['T'+xstr(i,1,0)];
      if s<>'' then
      begin
        p:=pos('|',s);
        s:=copy(s,1,p-1);
        writeln(OutFile,xstr(i-1,1,0)+'='+s);
      end;
    end;
    writeln(outfile,'numplay=0');
  end;
  keepwindowsalive;
end;
begin
  GetWindowsDirectory(wdir,40);
  ExportDialog.InitialDir:=strpas(wdir);
  if ExportDialog.Execute then
  begin
    dbnavigator1.enabled:=false;
    DataSource1.Enabled:=false;
    HIndex:=Table1.IndexName;
    Table1.IndexName:='';
    assignfile(outfile,ExportDialog.FileName);
    if fileexists(ExportDialog.FileName) then
    begin
      if Application.MessageBox('OK to overwrite file?',
      'Export to INI-file', mb_YesNo)= idYes then rewrite(outfile) else
      append(outfile);
    end else rewrite(outfile);
    SShowDlg.Caption:='Export database to '+ExportDialog.FileName;
    SShowDlg.Show;
    SShowDlg.Gauge1.MaxValue:=Table1.RecordCount;
    SShowDlg.Gauge1.Progress:=0;
    Table1.first;
    UpdatedNum:=0;
    while not Table1.eof and not SShowDlg.docancel do
    begin
      SShowDlg.Gauge1.Progress:=SShowDlg.Gauge1.Progress+1;
      ReadAndWrite;
      Table1.next;
    end;
    closefile(outfile);
    SShowDlg.Hide;
    showmessage('Exported '+xstr(UpdatedNum,1,0)+' records');
    Table1.IndexName:=hIndex;
    dbnavigator1.enabled:=true;
    DataSource1.Enabled:=true;
  end;
end;

procedure TDataBaseDlg.Append1Click(Sender: TObject);
begin
  ImportIt(true);
end;

procedure TDataBaseDlg.Update1Click(Sender: TObject);
begin
  ImportIt(false);
end;

procedure TDataBaseDlg.FieldNames1Click(Sender: TObject);
begin
  EditFieldNames.showmodal;
end;

procedure TDataBaseDlg.DisplaySettings1Click(Sender: TObject);
var bTrackInfo:boolean;
    DestPrintFileChecked:integer;
    OutputFilename:string;
    MyReportHeaderMemo:TStringList;
    selection:string;
    SortExpression:string;
begin
  MyReportHeaderMemo:=TStringList.create;
  GetPrintInfo(MyTrackMemo,MyCDHeaderMemo,MyReportHeaderMemo,
    bTrackInfo,DestPrintFileChecked,OutputFilename,false,false,false,selection,SortExpression);
  MyReportHeaderMemo.free;
  SetMemo;
end;

procedure TDataBaseDlg.Copy1Click(Sender: TObject);
Var Modal : TEditTrack;
begin
  Modal := TEditTrack.Create(Self);
  try
    DefineEditTrack(Modal);
    Modal.CopyButtonClick(Self);
    Modal.Free
  Finally
  end;
end;

procedure TDataBaseDlg.Paste1Click(Sender: TObject);
Var Modal : TEditTrack;
begin
  Modal := TEditTrack.Create(Self);
  try
    DefineEditTrack(Modal);
    Modal.PasteButtonClick(Self);
    ReturnEditTrack(Modal);
    Modal.Free
  Finally
  end;
end;

procedure TDataBaseDlg.Browse1Click(Sender: TObject);
var Modal : TBrowseFile;
begin
  Try
    Modal := TBrowseFile.Create(Self);
    Modal.Table1.ReadOnly:=false;
    Modal.Table1.Exclusive:=false;
    Modal.Table1.DataBaseName:=Table1.DataBaseName;
    Modal.Table1.TableName:=Table1.TableName;
    Modal.Table1.Active:=true;
    Modal.Table1.IndexName:=Table1.IndexName;
    Modal.Table1.GotoCurrent(Table1);
    Table1.cancel;
      Modal.ShowModal;
      Table1.GotoCurrent(Modal.Table1);
      Table1.refresh;
      Modal.free;
  finally
  end;
end;

procedure TDataBaseDlg.Styles1Click(Sender: TObject);
var i:integer;
begin
 try
  EditStyles:= TEditStyles.create(self);
  with EditStyles do
  begin
    StylesMemo.lines.clear;
    for i:=1 to Styles.count do
    StylesMemo.lines.add(Styles[i-1]);
    if showmodal=idOk then
    begin
      Styles.clear;
      for i:=1 to StylesMemo.lines.count do
      Styles.add(StylesMemo.lines[i-1]);
    end;
    free;
  end;
 finally
 end;
end;

procedure TDataBaseDlg.BarreResize1NewPosition(Sender: TObject);
procedure ListTracks;
var i:integer;
    hId:array[0..255] of char;
    f:textfile;
    MyReportHeaderMemo:TStringList;
    empty:TStringList;
    hsize,half:integer;
    hh:integer;
begin
  MyReportHeaderMemo:=TStringList.create;
  with DBText1 do
  GetTextBuf(hId,GetTextLen+1);
  DispOnScreen:=true;
  empty:=TStringList.create;
  TracksMemo2.visible:=false;
  TracksMemo2.Lines.Clear;
  TracksMemo3.visible:=false;
  TracksMemo3.Lines.Clear;
  ScreenStringList.clear;
  with DBText1 do
  GetTextBuf(hId,GetTextLen+1);
  hsize:=abs(TracksMemo2.font.height)+3;
  DisplayRecord(Table1,CDNameEdit.Text,strpas(hId),YearEdit.Text,
    StyleBox.ItemIndex,Memo1,
    f,MyTrackMemo,empty,MyReportHeaderMemo,true);
  hh:=Panel4.Height div hsize;
  if ScreenStringList.count>hh then
  begin
    half:=hh;
    TracksMemo2.width:=BarreResize2.left;
    BarreResize2.visible:=true;
    BarreResize2.height:=Panel4.height;
  end else
  begin
    half:=ScreenStringList.count;
    TracksMemo2.width:=TracksMemo.width;
    BarreResize2.visible:=false;
  end;
  for i:=0 to half-1 do
  TracksMemo2.Lines.add(ScreenStringList[i]);
  for i:=half to ScreenStringList.count-1 do
  TracksMemo3.Lines.add(ScreenStringList[i]);
  DispOnScreen:=faLse;
  empty.free;
  TracksMemo2.visible:=true;
  TracksMemo3.visible:=true;
  MyReportHeaderMemo.free;
end;

var y,bott:integer;
begin
  y:=BarreResize1.Top;
  bott:=Panel4.Top+Panel4.Height;
  if (y<Panel3.top+MinSize) or (y>bott-MinSize) then
  begin
    BarreResize1.Top:=Panel3.height;
    exit;
  end;
  Panel3.height:=y-Panel3.Top;
  Panel4.Top:=y+BarreResize1.Height;
  Panel4.Height:=bott-Panel4.Top;
  ListTracks;
end;

procedure TDataBaseDlg.BarreResize2NewPosition(Sender: TObject);
var right,x:integer;
begin
  x:=BarreResize2.Left;
  right:=TracksMemo3.Left+TracksMemo3.Width;
  if (x<TracksMemo2.left+MinSize) or (x>right-MinSize) then
  begin
    BarreResize2.Left:=TracksMemo2.width;
    exit;
  end;
  TracksMemo2.width:=x+2;
end;

procedure TDataBaseDlg.FontSpeedButtonClick(Sender: TObject);
begin
  with FontDialog1 do
  begin
    font:=TracksMemo.font;
    if Execute then
    begin
      TracksMemo.font:=font;
      TracksMemo2.font:=font;
      TracksMemo3.font:=font;
      FontName:=font.name;
      FontSize:=font.size;
      FontColor:=font.color;
    end;
  end;
end;

end.
