{ Form Template - Source and Destination Choices Lists }
unit Cdprogr;

interface

uses WinTypes, WinProcs, Classes, Dialogs, Graphics, Forms, Controls, Buttons,
  StdCtrls;

type
  TPlayList = class(TForm)
    SrcList: TListBox;
    DstList: TListBox;
    SrcLabel: TLabel;
    DstLabel: TLabel;
    IncludeBtn: TSpeedButton;
    IncAllBtn: TSpeedButton;
    ExcludeBtn: TSpeedButton;
    ExAllBtn: TSpeedButton;
    ProgramListBox: TListBox;
    AddProgramSpeedButton: TSpeedButton;
    UseProgramSpeedButton: TSpeedButton;
    DelProgramSpeedButton: TSpeedButton;
    ProgramLabel: TLabel;
    NameProgramEdit: TEdit;
    ProgramIdLabel: TLabel;
    SpeedButton1: TSpeedButton;
    SortSpeedButton: TSpeedButton;
    TotalTimeEdit: TEdit;
    SwapBtn: TSpeedButton;
    Label1: TLabel;
    Help: TBitBtn;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    function CalcTotalTime:string;
    procedure CalcTotal;
    procedure CalcNewTotal;
    procedure IncludeBtnClick(Sender: TObject);
    procedure ExcludeBtnClick(Sender: TObject);
    procedure IncAllBtnClick(Sender: TObject);
    procedure ExcAllBtnClick(Sender: TObject);
    procedure MoveSelected(List: TCustomListBox; var ToList: TListBox);
    procedure SetItem(List: TListBox; Index: Integer);
    function GetFirstSelection(List: TCustomListBox): Integer;
    procedure SetProgramIndex(index:integer);
    procedure SetButtons;
    procedure DelProgramSpeedButtonClick(Sender: TObject);
    procedure AddProgramSpeedButtonClick(Sender: TObject);
    procedure UseProgramSpeedButtonClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure DstListMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure DstListMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure DstListMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure SortSpeedButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure TotalTimeEditExit(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure SwapBtnClick(Sender: TObject);
    procedure ProgramListBoxKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ProgramListBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    mousedown:boolean;
    posidrag:integer;
    TimeArr:array[1..50] of longint;
    result:integer;
    { Public declarations }
  end;

implementation

uses utils;

{$R *.DFM}

procedure TPlayList.CalcTotal;
begin
  TotalTimeEdit.Text:=CalcTotalTime;
end;

function TPlayList.CalcTotalTime:string;
var i:integer;
    total:longint;
    tr,h:integer;
begin
  total:=0;
  for i:=0 to DstList.Items.Count-1 do
  begin
    val(copy(DstList.Items[i],1,2),tr,h);
    total:=total+TimeArr[tr];
  end;
  CalcTotalTime:=StrTime(total);
end;

procedure TPlayList.IncludeBtnClick(Sender: TObject);
var
  Index: Integer;
begin
  Index := GetFirstSelection(SrcList);
  MoveSelected(SrcList, DstList);
  SetItem(SrcList, Index);
  CalcTotal;
end;

procedure TPlayList.ExcludeBtnClick(Sender: TObject);
var
  Index: Integer;
begin
  Index := GetFirstSelection(DstList);
  MoveSelected(DstList, SrcList);
  SetItem(DstList, Index);
  CalcTotal;
end;

procedure TPlayList.IncAllBtnClick(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to SrcList.Items.Count - 1 do
    DstList.Items.AddObject(SrcList.Items[I],
      SrcList.Items.Objects[I]);
  SrcList.Items.Clear;
  SetItem(SrcList, 0);
  CalcTotal;
end;

procedure TPlayList.ExcAllBtnClick(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to DstList.Items.Count - 1 do
    SrcList.Items.AddObject(DstList.Items[I], DstList.Items.Objects[I]);
  DstList.Items.Clear;
  SetItem(DstList, 0);
  CalcTotal;
end;

procedure TPlayList.MoveSelected(List: TCustomListBox; var ToList: TListBox);
var
  I,j,Pl: Integer;
begin
  for I := List.Items.Count - 1 downto 0 do
    if List.Selected[I] then
    with ToList do
    begin
      pl:=itemindex;
      if items.count=0 then
      begin
        Items.Add{Object}(List.Items[I]);
        pl:=0;
      end else
      if pl=items.count-1 then
      begin
        Items.Add{Object}(List.Items[I]);
        pl:=items.count-1;
      end else
      begin
        inc(pl);
        Items.Insert(pl,List.Items[i]);
{        itemindex:=pl;}
      end;
      for j:=0 to tolist.items.count-1 do
      begin
        tolist.selected[j]:=false;
      end;
      tolist.selected[pl]:=true;
      tolist.itemindex:=pl;
      List.Items.Delete(I);
    end;
end;

procedure TPlayList.SetButtons;
var
  SrcEmpty, DstEmpty, ProgEmpty: Boolean;
begin
  SrcEmpty := SrcList.Items.Count = 0;
  DstEmpty := DstList.Items.Count = 0;
  ProgEmpty:=ProgramListBox.Items.Count = 0;
  IncludeBtn.Enabled := not SrcEmpty;
  IncAllBtn.Enabled := not SrcEmpty;
  ExcludeBtn.Enabled := not DstEmpty;
  ExAllBtn.Enabled := not DstEmpty;
  SwapBtn.Enabled:= not DstEmpty;
  SortSpeedButton.Enabled:= not DstEmpty;
  DelProgramSpeedButton.Enabled:= not ProgEmpty;
  AddProgramSpeedButton.Enabled:= not DstEmpty;
  UseProgramSpeedButton.Enabled:= not ProgEmpty;
  SpeedButton1.Enabled:= not ProgEmpty;
{  OkBtn.Enabled := not DstEmpty;}
end;

function TPlayList.GetFirstSelection(List: TCustomListBox): Integer;
begin
  for Result := 0 to List.Items.Count - 1 do
    if List.Selected[Result] then Exit;
  Result := LB_ERR;
end;

procedure TPlayList.SetItem(List: TListBox; Index: Integer);
var
  MaxIndex: Integer;
begin
  with List do
  begin
    SetFocus;
    MaxIndex := List.Items.Count - 1;
    if Index = LB_ERR then Index := 0
    else if Index > MaxIndex then Index := MaxIndex;
    Selected[Index] := True;
  end;
  SetButtons;
end;

procedure TPlayList.DelProgramSpeedButtonClick(Sender: TObject);
var hi:integer;
begin                {tlistbox}
  with ProgramListBox do
  if ItemIndex>=0 then
  begin
    hi:=ItemIndex;
    Items.delete(hi);
    if hi<Items.count then
    SetProgramIndex(hi)
    else SetProgramIndex(hi-1);
  end;
  SetButtons;
end;

procedure TPlayList.AddProgramSpeedButtonClick(Sender: TObject);
var i:integer;
    s:string;
begin
  with DstList do
  if Items.count>0 then
  begin
    s:=copy(NameProgramEdit.text,1,6);
    for i:=length(s)+1 to 6 do s:=s+' ';
    for i:=0 to items.count-1 do
    s:=s+copy(DstList.Items[i],1,2);
    ProgramListBox.Items.add(s);
  end;
  SetProgramIndex(ProgramListBox.Items.count-1);
  SetButtons;
end;

procedure TPlayList.UseProgramSpeedButtonClick(Sender: TObject);
var i,j:integer;
    s,hs:string;
begin
  if ProgramListBox.Itemindex=-1 then exit;
  With DstList do
  for i:=Items.count-1 downto 0 do
  begin
    SrcList.Items.add(DstList.Items[i]);
    Items.delete(i);
  end;
  with ProgramListBox do
  s:=Items[ItemIndex];
  s:=copy(s,7,length(s));
  while s[length(s)]=' ' do s:=copy(s,1,length(s)-1);
  for i:=1 to length(s) div 2 do
  begin
    hs:=copy(s,2*(i-1)+1,2);
    for j:=SrcList.Items.count-1 downto 0 do
    if copy(SrcList.Items[j],1,2)=hs then
    begin
      DstList.Items.Add(SrcList.Items[j]);
      SrcList.Items.delete(j);
    end;
  end;
  CalcTotal;
end;

procedure TPlayList.SpeedButton1Click(Sender: TObject);
var s:string;
    i:integer;
    index:integer;
begin
  index:=ProgramListBox.ItemIndex;
  with ProgramListBox do
  if itemindex>=0 then
  begin
    s:=Items[ItemIndex];
    for i:=1 to 6 do
    if i<=length(NameProgramEdit.text) then
    s[i]:=NameProgramEdit.text[i] else
    s[i]:=' ';
    Items[ItemIndex]:=s;
    SetProgramIndex(index);
  end;
end;

procedure TPlayList.DstListMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  mousedown:=true;
    with Sender as TlistBox do
    begin
      posidrag:=ItemAtPos(Point(X, Y), True);
      setcapture(DstList.handle);
    end;
end;

procedure TPlayList.DstListMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var s:string;
    i,hp:integer;
begin
  with Sender as TlistBox do
  if mousedown then
  if posidrag<>ItemAtPos(Point(X, Y), True) then
  begin
    if posidrag>=items.count then exit;
    s:=items[posidrag];
    hp:=ItemAtPos(Point(X, Y), True);
    if hp>=0 then
    begin
      items.delete(posidrag);
      items.insert(hp,s);
      posidrag:=hp;
      for i:=0 to DstList.Items.count-1 do
      DstList.selected[i]:=false;
      DstList.selected[hp]:=true;
    end;
  end;
end;

procedure TPlayList.DstListMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  mousedown:=false;
  releasecapture;
end;

procedure TPlayList.FormCreate(Sender: TObject);
begin
  mousedown:=false;
end;

procedure TPlayList.SortSpeedButtonClick(Sender: TObject);
var s:string;
    h,p,hp,hi,i,j,index:integer;
begin
  index:=GetFirstSelection(DstList);
  with DstList do
  for i:=Items.count-1 downto 0 do
  begin
    {search smallest}
    h:=99;
    p:=0;
    for j:=0 to i do
    begin
      val(copy(Items[j],1,2),hp,hi);
      if hp<h then
      begin
        h:=hp;
        p:=j;
      end;
    end;
    {swap item p}
    s:=Items[p];
    Items.delete(p);
    Items.add(s);
  end;
  setitem(DstList,index);
end;
procedure TPlayList.SetProgramIndex(index:integer);
begin
  ProgramListBox.ItemIndex:=index;
  if ProgramListBox.Items.Count>0 then
  begin
    NameProgramEdit.text:=copy(ProgramListBox.Items[Index],1,6);
  end;
end;
procedure TPlayList.FormActivate(Sender: TObject);
begin
  CalcTotal;
  SetProgramIndex(0);
  Setitem(DstList,0);
  Setitem(SrcList,0);
end;

procedure TPlayList.CalcNewTotal;
var j,i:integer;
    harr:array[1..50] of longint;
    harrs:array[1..50] of byte;
    h1,h2:byte;
    hi:integer;
    htime,currtotal,TotalNow:longint;
    maxs,s:set of byte;
    hstring:string;
begin
  if CalcTotalTime<>TotalTimeEdit.text then
  begin
    with TotalTimeEdit do
    begin
      i:=pos(':',text);
      if i>0 then
      begin
        val(copy(text,1,i-1),h1,hi);
        if hi<>0 then exit;
        val(copy(text,i+1,length(text)),h2,hi);
        if hi<>0 then exit;
        htime:=h1*60+h2;
      end else
      begin
        val(text,h1,hi);
        if hi=0 then
        htime:=60*h1 else exit;
      end;
    end;
    TotalNow:=0;
    maxs:=[];
    randomize;
    j:=1;
    while (j<= 100) and (TotalNow<>htime) do
    begin
      s:=[];
      currtotal:=0;
      for i:=1 to DstList.Items.count do
      begin
        val(copy(DstList.Items[i-1],1,2),h1,hi);
        harr[i]:=TimeArr[h1];
        currtotal:=harr[i]+CurrTotal;
        harrs[i]:=i;
      end;
      i:=DstList.Items.count;
      while currtotal>htime do
      begin
        h2:=random(i)+1;
        s:=s+[harrs[h2]];
        currtotal:=currtotal-harr[h2];
        for h1:=h2 to i-1 do
        begin
          harr[h1]:=harr[h1+1];
          harrs[h1]:=harrs[h1+1];
        end;
        dec(i);
      end;
      if currtotal>totalnow then
      begin
        maxs:=s;
        TotalNow:=CurrTotal;
      end;
      inc(j);
    end;
    for i:=DstList.Items.count downto 1 do
    if i in maxs then
    begin
      hstring:=DstList.Items[i-1];
      DstList.Items.delete(i-1);
      SrcList.Items.add(hstring);
    end;
    calctotal;
    SetItem(SrcList,0);
    SetItem(DstList,0);
  end;
end;

procedure TPlayList.TotalTimeEditExit(Sender: TObject);
begin
  CalcNewTotal;
end;

procedure TPlayList.OKButtonClick(Sender: TObject);
begin      {tedit}
  if activecontrol=TotalTimeEdit then
  CalcNewTotal else
  if activecontrol=NameProgramEdit then
  SpeedButton1Click(Self) else
  begin
    result:=mrok;
    close;
  end;
end;

procedure TPlayList.SwapBtnClick(Sender: TObject);
var number,i:integer;
begin
  number:=DstList.Items.count;
  {include all items from SrcList to DstList}
  IncAllBtnClick(Self);
  {select all items in DstList that were not in SrcList}
  for i:=0 to DstList.Items.count-1 do
  DstList.selected[i]:=false;
  for i:=0 to number-1 do
  DstList.selected[i]:=true;
  {move these selected items to SrcList}
  ExcludeBtnClick(Self)
end;

procedure TPlayList.ProgramListBoxKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  SetProgramIndex(ProgramListBox.Itemindex);
end;

procedure TPlayList.ProgramListBoxMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  SetProgramIndex(ProgramListBox.Itemindex);
end;

procedure TPlayList.BitBtn2Click(Sender: TObject);
begin
  showmessage('here');
end;

end.
