unit Captdisp;

interface

uses WinTypes, WinProcs, Classes, Dialogs, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Menus, PrintFrm, Clipbrd;

const NumButtons=5;
      NumCaptionOptions=9;
      CaptionDefine:string='%A:%C, %T';
      BottomLine1:string='';
      BottomLine2:string='';
      ComboLines:array[0..NumCaptionOptions]of string=
        ('<not selected>','Album Title',
        'Total Time Album','Running Time',
        'Playing Track','Time Track',
        'TrackNumber',
        'Program Number','Number Tracks','ProgramCount');


type
  TCaptionDisplayDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Help: TBitBtn;
    CaptionEdit: TEdit;
    Label1: TLabel;
    BottomLineEdit1: TEdit;
    BottomLineEdit2: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    PopupMenu1: TPopupMenu;
    DisplayItems: TGroupBox;
    SliderRadioButton: TRadioButton;
    AutoRadioButton: TRadioButton;
    TextRadioButton: TRadioButton;
    Label5: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DoAction1Click(Sender: TObject);
    procedure CaptionEditEnter(Sender: TObject);
    procedure CaptionEditMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BottomLineEdit1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure BottomLineEdit1Click(Sender: TObject);
    procedure BottomLineEdit2Click(Sender: TObject);
    procedure BottomLineEdit2MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SliderRadioButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AutoRadioButtonClick(Sender: TObject);
    procedure TextRadioButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CaptionDisplayDlg: TCaptionDisplayDlg;
  CurrEdit:TEdit;

implementation

{$R *.DFM}

procedure TCaptionDisplayDlg.FormCreate(Sender: TObject);
var i:integer;
begin
  CaptionEdit.text:=CaptionDefine;
  BottomLineEdit1.text:=BottomLine1;
  BottomLineEdit2.text:=BottomLine2;
  SetPopup(PopupMenu1,false);
  for i:=1 to PopupMenu1.Items.count do
  PopupMenu1.Items[i-1].onclick:=DoAction1Click;
  CurrEdit:=CaptionEdit;
end;

procedure TCaptionDisplayDlg.FormDestroy(Sender: TObject);
begin
  CaptionDefine:=CaptionEdit.text;
  BottomLine1:=BottomLineEdit1.text;
  BottomLine2:=BottomLineEdit2.text;
end;

procedure TCaptionDisplayDlg.DoAction1Click(Sender: TObject);
var s:string;
    p:integer;
begin
  with sender as TMenuItem do
  begin
    s:=PopupMenu1.Items[tag].caption;
    s:=copy(s,1,pos('=',s)-1);
    with CurrEdit do
    begin               
      p:=selstart;
      text:=copy(text,1,selstart)+s+copy(text,selstart+1,256);
      setfocus;
      selstart:=p+length(s);
      sellength:=0;
    end;
  end;
end;

procedure TCaptionDisplayDlg.CaptionEditEnter(Sender: TObject);
begin
  CurrEdit:=CaptionEdit;
end;

procedure TCaptionDisplayDlg.CaptionEditMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  CaptionEditEnter(Self);
end;

procedure TCaptionDisplayDlg.BottomLineEdit1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  BottomLineEdit1Click(sender);
end;

procedure TCaptionDisplayDlg.BottomLineEdit1Click(Sender: TObject);
begin
  CurrEdit:=BottomLineEdit1;
end;

procedure TCaptionDisplayDlg.BottomLineEdit2Click(Sender: TObject);
begin
  CurrEdit:=BottomLineEdit2;
end;

procedure TCaptionDisplayDlg.BottomLineEdit2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  BottomLineEdit2Click(sender);
end;

procedure TCaptionDisplayDlg.SliderRadioButtonClick(Sender: TObject);
begin
  if SliderRadioButton.checked then
  begin
    BottomLineEdit1.enabled:=false;
    BottomLineEdit2.enabled:=false;
  end else
  begin
    BottomLineEdit1.enabled:=true;
    BottomLineEdit2.enabled:=true;
  end;
end;

procedure TCaptionDisplayDlg.FormActivate(Sender: TObject);
begin
  SliderRadioButtonClick(Self);
end;

procedure TCaptionDisplayDlg.AutoRadioButtonClick(Sender: TObject);
begin
  SliderRadioButtonClick(Self);
end;

procedure TCaptionDisplayDlg.TextRadioButtonClick(Sender: TObject);
begin
  SliderRadioButtonClick(Self);
end;

end.
