unit Brwsunit;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, DB, DBTables, ExtCtrls, DBCtrls, Grids, DBGrids, Mask,
  Utils, Dialogs;

type
  TBrowseFile = class(TForm)
    OKBtn: TBitBtn;
    Bevel1: TBevel;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Table1: TTable;
    DataSource1: TDataSource;
    cdid: TDBEdit;
    CDName: TDBEdit;
    Year: TDBEdit;
    Data: TDBMemo;
    Browse: TButton;
    StyleCalc: TComboBox;
    Help: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BrowseClick(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure StyleCalcChange(Sender: TObject);
  private
    { Private declarations }
    browsing:boolean;
    procedure SetBrowse(NewBrowse:boolean);
  public
    { Public declarations }
  end;

var
  BrowseFile: TBrowseFile;

implementation

{$R *.DFM}

procedure TBrowseFile.FormActivate(Sender: TObject);
begin 
    DBGrid1.Fields[0].DisplayWidth:=7;
    DBGrid1.Fields[1].DisplayWidth:=38;
    DBGrid1.Fields[2].DisplayWidth:=1;
    DBGrid1.Fields[2].ReadOnly:=true;
    DBGrid1.Fields[3].DisplayWidth:=4;
    DBGrid1.Fields[4].visible:=false;
  SetBrowse(true);
end;

procedure TBrowseFile.FormCreate(Sender: TObject);
begin
  with DBGrid1 do
  begin
    top:=24;
    width:=481;
    height:=268;
    left:=24;
  end;
  browsing:=true;
  SetStyles(StyleCalc);
end;

procedure TBrowseFile.BrowseClick(Sender: TObject);
begin
  SetBrowse(not browsing);
end;

procedure TBrowseFile.SetBrowse(NewBrowse:boolean);
begin
  browsing:=NewBrowse;
  DBGrid1.visible:=browsing;
  CDId.visible:=not browsing;
  CDName.visible:=not browsing;
  year.visible:=not browsing;
  StyleCalc.visible:=not browsing;
  Data.visible:=not browsing;
  if browsing
  then Browse.Caption:='&Display'
  else Browse.Caption:='&Browse';
end;

procedure TBrowseFile.DataSource1DataChange(Sender: TObject;
  Field: TField);
begin
   StyleCalc.ItemIndex:=Table1.FieldByName('STYLE').asinteger;
end;

procedure TBrowseFile.StyleCalcChange(Sender: TObject);
var h:string;
begin
  h:=xstr(StyleCalc.ItemIndex,1,0);
  Table1.edit;
  Table1.FieldByName('STYLE').asstring:=h;
end;

end.
