{ -----------------------------------------------------
  cdbedit.pas

  Copyright (c) 1999, Antony Pranata
  (http://www.sharedev.com/valley/antonypr)

  TClassicDBEdit Component v1.0,
  descendant of TDBEdit which allows you to use DOS
  editing key.

  More Delphi Components? Please visit
    http://www.sharedev.com/valley/antonypr/delphi.html
  ----------------------------------------------------- }
unit cdbedit;

interface

uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Mask, DBCtrls, Db;

type
  TClassicDBEdit = class(TDBEdit)
  private
    parentHwnd: HWND;
  protected
    procedure WMKeyDown (var Msg: TMessage); message WM_KEYDOWN;
  public
    constructor Create (AOwner: TComponent); override;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Antony', [TClassicDBEdit]);
end;

constructor TClassicDBEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  parentHwnd := (AOwner as TForm).Handle;
end;

procedure TClassicDBEdit.WMKeyDown (var Msg: TMessage);
var
  VirtKey: integer;
begin
  inherited;

  VirtKey := Msg.wParam;

  with (DataSource.DataSet) do
  begin
    if (VirtKey = VK_RETURN) or (VirtKey = VK_DOWN) then
    begin
      if (State = dsEdit) or (State = dsInsert) then
        Post;
      PostMessage (parentHwnd, WM_NEXTDLGCTL, 0, 0);
    end

    else if (VirtKey = VK_UP) then
    begin
      if (State = dsEdit) or (State = dsInsert) then
        Post;
      PostMessage (parentHwnd, WM_NEXTDLGCTL, 1, 0);
    end

    else if (VirtKey = VK_NEXT) then
    begin
      if (GetKeyState (VK_CONTROL) < 0) then
        Last
      else
      begin
        Next;
        if (EOF) then
        begin
          Insert;
        end;
      end
    end

    else if (VirtKey = VK_PRIOR) then
    begin
      if (GetKeyState (VK_CONTROL) < 0) then
        First
      else
      begin
        if (State = dsInsert) then
          Last
        else
          Prior;
      end;
    end
  end;
end;

end.
