library CompDate;
{ -------------------------------------------------------------------
                             CompDate
  -------------------------------------------------------------------
  Usage  : A "fake" Delphi 1.0 and 2.0 Expert. It's not giving Delphi
           any extra ways of creating forms or other projects.
           It gives a unit which have a constant containing the
           date of compilation (or rather the date when the Delphi
           enviroment last were started) which can be used as a TDateTime
           date.
  Date   : 4 Febuary 1997
  By     : Martin Djerns
  Legal  : This libary (and source code) is copyright  1996-97 by
           Martin Djerns, but may be copied and distributed if you do
           not get any income by it.
           The package may not be modified or in other form altered
           without contacting the author first.
  Setup  : Under Delphi 1.0 run the Build16.bat file - notice that the
           \Delphi\Bin directory must be in the path. In the Delphi.INI file,
           which is placed in you Windows directory, you install a expert by
           adding a line like "CompDate=C:\Delphi\CompDate.dll" in the section
           "[EXPERTS]".
           Under Delphi 2.0 run the Build32.bat file - notice that the
           \Delphi 2.0\Bin directory must be in the path. Whith the registration
           editor (REGEDIT.EXE), find the location
           "HKEY_CURRENT_USER\Software\Borland\Delphi\2.0\Experts" and add a
           string value called "CompDate" and assign the path to is.
  16-bit : Create a ini file in the same directory as this DLL file,
           with the same name.
           Add a section "[CompDate]" and to items "UnitName=" and "Path="
           UnitName is a way of giving the unit another name.
           Path is a way of placeing it someware else that your
           \Delphi\Lib dirictory.
  32-bit : Go to the key HKEY_CURRENT_USER\Software, and make make a key
           called MDData and under this key you make a key called CompDate.
           Under the CompDate key you can create the string value "UnitName"
           which specifies a name for the unit created by the expert (default
           is CompDate). The string value "Path" can also be created, and
           specify a location for the CompDate unit (if nothing is speciefied
           the file is placed in you \Delphi 2.0\Lib dirictory).

  Files  : CompDate.DPR - This module
           Ver16.RES    - Version information resource (16-bit)
           Ver32.RES    - Version information resource (32-bit)
           Snip.TXT     - Data to the generated unit
           Snip.RC      - To import the Snip.TXT into a RES file
           Build16.BAT  - A batch file which builds a 16 bit version of the
                          DLL file
           Build32.BAT  - A batch file which builds a 32 bit version of the
                          DLL file
           File_ID.DIZ  - Short description
  e-mail : djernaes@einstein.ot.dk
 -------------------------------------------------------------MDD96-- }

Uses
  ExptIntf,
  ToolIntf,
  VirtIntf,
  SysUtils,
{$IFDEF WIN32}
  Windows,
  Registry,
{$ELSE}
  WinTypes,
  WinProcs,
  IniFiles,
{$ENDIF}
  Classes;


{$IFDEF WIN32}
{$R Ver32.res}
{$R Snip32.res}
{$ELSE}
{$R Ver16.res}
{$R Snip16.res}
{$ENDIF}

{-- Procedures used to create the new unit ---------------------------}

{ Take the Snip from the resource and copies it to a text file
  placed in the dirictory specified in the INI file which have the
  same name and location as this DLL file.
  If this INI file does not exists the first path specified by the
  Delphi.INI file will be used as location and CompDate will be used
  as the unit name/file name.                                         }
Procedure Snip;
Var
  SnipResource : THandle;
  SnipSource,
  Buffer       : PChar;
  CompDateFile : TFileStream;
{$IFDEF WIN32}
  Ini          : TRegIniFile;
{$ELSE}
  Ini          : TIniFile;
{$ENDIF}
  Path,
  UnitName     : String;
  APos         : Byte;
  Day,
  Month,
  Year         : Word;
Begin
{$IFDEF WIN32}
  { Assign the base path in the REG-database }
  Ini := TRegIniFile.Create('Software\MDData');
{$ELSE}
  { Open the CompDate.INI file }
  Ini := TIniFile.Create(ChangeFileExt(ParamStr(0),'.INI'));
{$ENDIF}
  Try
    { Get unit name - dafault is CompDate }
    UnitName := Ini.ReadString('CompDate','UnitName','CompDate');
    { Get the SearchPath loacation }
    Path := Ini.ReadString('CompDate','Path','');
  finally
    { Release the CompDate.INI file }
    Ini.Free;
  end;

  { If no path were specified }
  If Path = '' Then
  Begin
{$IFDEF WIN32}
    { Go to the base path in the REG-database for Delphi 2.0 }
    Ini := TRegIniFile.Create('Software\Borland\Delphi\2.0');
{$ELSE}
    { Open the Delphi.INI file }
    Ini := TIniFile.Create('Delphi.INI');
{$ENDIF}
    Try
      { Get the full list of search pathes }
      Path := Ini.ReadString('Library','SearchPath','');
    finally
      { Release the Delphi.INI file / REG access }
      Ini.Free;
    end;

    { Find the first time a semicolon is in the search path }
    APos := Pos(';',Path);
    If APos > 0 Then { If there were a semicolon...}
      { Get the text before the semicolon }
      Path := Copy(Path,1,APos-1);

    { If still no path were specified }
    If Path = '' Then
      Exit { Do not do more... }

  end;

  { If the last char not is backslack add an backslach }
  If Path[Length(Path)] <> '\' Then
    Path := Path + '\';

  { Get the date }
  DecodeDate(Date,Year,Month,Day);

  { Load the Snip from the resource }
  SnipResource := LoadResource(HInstance,
    FindResource(HInstance, 'SNIP', RT_RCDATA));
  { Lock a pointer on the resource }
  SnipSource := LockResource(SnipResource);
  { Get a 1K buffer }
  Buffer := StrAlloc(1024);
  { Clear the buffer }
  FillChar(Buffer^,1024,#0);
  { Create the output file }
  CompDateFile :=
    TFileStream.Create(Path+UnitName+'.PAS', fmCreate);
  Try
    { Format the Ship and copy it over in the buffer - se Snip.TXT
      for format string }
    StrFmt(Buffer,SnipSource,
      [UnitName,
       UnitName,
       DateToStr(Date),
       ExtractFileName(ParamStr(0)),
       Trunc(Date)] );
    { Write the formattet Snip }
    CompDateFile.Write(Buffer^, StrLen(Buffer));
  Finally
    CompDateFile.Free;            { Free file }
    UnlockResource(SnipResource); { Release the pointer to the resource }
    FreeResource(SnipResource);   { Free the resource }
    StrDispose(Buffer);           { Free the buffer }
  end;
end;

{-- Procedures which are needed for Delphi til se the "fake" expert ---}

{ Register the expert so Delphi will accept loading it when Delphi
  are being started                                                }
Function InitExpert(    ToolServices: TIToolServices;
                        RegisterProc: TExpertRegisterProc;
                    var Terminate: TExpertTerminateProc): Boolean;
                                                               Export;
Begin
  Snip;
  Result := True;  { Say the registration vere success full }
End;

{$IFNDEF WIN32}
{ I don't know why, but this is not included in the Delphi 2.0 examples
  for making experts. Therefore it is also excluded here }

{ The way of handling faults in this module }
Function FaultHandler(FaultID: Word; faultAddr: Pointer): TFaultResponse; export;
Begin
  DefaultExceptHandler(FaultId, faultAddr);  { Use default }
End;
{$ENDIF}

{ Export functions so Delphi can find them }
Exports
  InitExpert Name ExpertEntryPoint Resident
{$IFNDEF WIN32}
  , { Excluded : See above }
  FaultHandler Name FaultHandlerSignature Resident
{$ENDIF}
;

Begin
end.

