{ ****************************************************************** }
{                                                                    }
{   VCL component TCheckBoxList                                      }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\program files\component create\cblist.cd }
{   on 28 Feb 1999 at 12:29                                          }
{                                                                    }
{   Copyright  1999 by GStorm                                       }
{                                                                    }
{ ****************************************************************** }

unit CBList;

interface

uses Messages, SysUtils, Classes, Controls, Forms, Graphics, 
     Stdctrls, Windows;

type
  TMyCheckBoxEvent = procedure (Sender : TObject ; Index : Longint) of Object;

  TCheckBoxList = class(TListBox)
    private
      { Private fields of TCheckBoxList }
	FOnCheck : TMyCheckBoxEvent;
	FOnUnCheck : TMyCheckBoxEvent;
	FAuthor : String;

      { Private methods of TCheckBoxList }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
	procedure SetAuthor (value : string);
    protected
      { Protected fields of TCheckBoxList }

      { Protected methods of TCheckBoxList }
        procedure Click; override;
        procedure KeyPress(var Key : Char); override;
        procedure DrawItem (Index : Integer ; Rect : TRect ; State : TOwnerDrawState); override;
        procedure Loaded; override;
	procedure CheckEvent (index : longint) ; virtual;
	procedure UnCheckEvent (index : longint) ; virtual;
    public
      { Public fields and properties of TCheckBoxList }

      { Public methods of TCheckBoxList }
        procedure CheckAll (AChecked : Boolean);
        procedure CheckItem (Index : Longint ; ACheck : Boolean);
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        function IsActive (Index : Longint) : boolean;
        function IsChecked (Index : Longint) : boolean;
        procedure KeyDown (var Key: Word; Shift: TShiftState); override;
        procedure MouseDown (Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
        procedure SetActive (Index : Longint ; AActive : boolean);
	function ReadData (Index : Longint) : Longint;
	procedure WriteData (Index : Longint ; Data : Longint);
	property Checked [Index : Longint] : boolean read IsChecked write CheckItem;
	property Active [Index : Longint] : boolean read IsActive write SetActive;
	property Data [Index : Longint] : longint read ReadData write WriteData;
    published
      { Published properties of TCheckBoxList }
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnEnter;
        property OnExit;
        property OnKeyDown;
        property OnKeyPress;
        property OnKeyUp;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
	property OnCheck : TMyCheckBoxEvent read FOnCheck write FOnCheck;
	property OnUnCheck : TMyCheckBoxEvent read FOnUnCheck write FOnUnCheck;
	property Author : String read FAuthor write SetAuthor;
        property Items;
        property Style;
  end;

procedure Register;

implementation

type
  TMyCheckBox = class (TObject)
    Checked : boolean;
    Data : longint;
    Active : boolean;
    constructor Create;
  end;

constructor TMyCheckBox.Create;
begin
     inherited Create;
     Checked := false;
     Active := true;
end;

procedure Register;
begin
     { Register TCheckBoxList with Standard as its
       default page on the Delphi component palette }
     RegisterComponents('Standard', [TCheckBoxList]);
end;

{ Method to set variable and property values and create objects }
procedure TCheckBoxList.AutoInitialize;
begin
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TCheckBoxList.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Override OnClick handler from TListBox }
procedure TCheckBoxList.Click;
begin
     { Call method of parent class }
     inherited Click;
end;

{ Override OnKeyPress handler from TListBox }
procedure TCheckBoxList.KeyPress(var Key : Char);
begin
     { Call method of parent class }
     inherited KeyPress(Key);
end;

procedure TCheckBoxList.CheckItem (Index : Longint ; ACheck : Boolean);
var rect : trect;
begin
     if Items.Objects [Index] = nil then
       Items.Objects [Index] := TMyCheckBox.Create;

     with Items do
       if ACheck <> (Objects[Index] as TMyCheckBox).Checked then
       begin
            (Objects[Index] as TMyCheckBox).Checked := ACheck;
{            rect := ItemRect (Index);
            DrawItem (Index, rect, [odSelected, odFocused] );}
            RePaint;

            if ACheck then 
               CheckEvent (Index) else
               UnCheckEvent (Index);
       end;
end;

constructor TCheckBoxList.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     Style := lbOwnerDrawFixed;
     ItemHeight := 20;
     FAuthor := 'Carmi Grushko';

     { Code to perform other tasks when the component is created }

end;

destructor TCheckBoxList.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TCheckBoxList.DrawItem (Index : Integer ; Rect : TRect ; State : TOwnerDrawState);
var
  Bitmap: TBitmap; { temporary variable for the item's bitmap }
  Offset: Integer; { text offset width }
  rect1 : trect;
begin
  with Canvas do { draw on the control canvas, not on the form }
  begin
    FillRect(Rect); { clear the rectangle }
    Offset := 2; { provide default offset }

    rect1.left := rect.left + 1;
    rect1.top := rect.top + 2;
    rect1.right := rect1.left + 15;
    rect1.bottom := rect1.top + 15;

    with Items do
    begin
         if IsActive (Index) = true then
           if (IsChecked (Index)) then
            DrawFrameControl (canvas.handle, rect1, DFC_BUTTON, DFCS_BUTTONCHECK + DFCS_Checked) else
            DrawFrameControl (canvas.handle, rect1, DFC_BUTTON, DFCS_BUTTONCHECK);
    end;

    Offset := rect1.right - rect1.left + 6;  {add four pixels between bitmap and text}

    TextOut(Rect.Left + Offset, Rect.Top, Items[Index]) { display the text }
  end;
end;

function TCheckBoxList.IsActive (Index : Longint) : boolean;
begin
     if Items.Objects [Index] = nil then
       Result := true
     else
       with Items.Objects[Index] as TMyCheckBox do Result := Active;
end;

function TCheckBoxList.IsChecked (Index : Longint) : boolean;
begin
     if Items.Objects [Index] = nil then
       Result := false
     else
       with Items.Objects[Index] as TMyCheckBox do Result := Checked;

end;

procedure TCheckBoxList.KeyDown (var Key: Word; Shift: TShiftState);
  procedure SwitchState (index : longint);
  begin
       with Items do
         CheckItem (index, not IsChecked (index) );
  end;
var rect, rect1 : trect;
    pos : longint;
    pt : tpoint;
begin
     pos := itemindex;
     if Key <> 32 then exit;
     if pos = -1 then exit;
     rect := ItemRect (pos);

     rect1.left := rect.left + 1;
     rect1.top := rect.top + 2;
     rect1.right := rect1.left + 15;
     rect1.bottom := rect1.top + 15;

     SwitchState (pos);
end;

procedure TCheckBoxList.Loaded;
var i : integer;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }

end;

procedure TCheckBoxList.MouseDown (Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  procedure SwitchState (index : longint);
  begin
       with Items do
         CheckItem (index, not IsChecked(Index) );
  end;

var rect, rect1 : trect;
    pos : longint;
    pt : tpoint;
begin
     if Button <> mbLeft then exit;

     pos := ItemAtPos ( point (x,y ) , true);
     if pos = -1 then exit;
     rect := ItemRect (pos);

     rect1.left := rect.left + 1;
     rect1.top := rect.top + 2;
     rect1.right := rect1.left + 15;
     rect1.bottom := rect1.top + 15;

     pt :=  point (x,y);

     if PtInRect (rect1, pt ) then
      SwitchState (pos);
end;

procedure TCheckBoxList.SetActive (Index : Longint ; AActive : boolean);
var rect : trect;
begin
     if Items.Objects [Index] = nil then
       Items.Objects [Index] := TMyCheckBox.Create;

     with Items do
       if AActive <> (Objects[Index] as TMyCheckBox).Active then
       begin
            (Objects[Index] as TMyCheckBox).Active := AActive;
{            rect := ItemRect (Index);
            DrawItem (Index, rect, [] );}
	    RePaint;
       end;
end;

function TCheckBoxList.ReadData (index : longint) : longint;
begin
     if Items.Objects [Index] = nil then
       Result := 0
     else
       with Items.Objects[Index] as TMyCheckBox do Result := Data;
end;

procedure TCheckBoxList.WriteData (index : longint ; data : longint);
begin
     if Items.Objects [Index] = nil then
       Items.Objects [Index] := TMyCheckBox.Create;

     with Items do
       if Data <> (Objects[Index] as TMyCheckBox).Data then
       begin
            (Objects[Index] as TMyCheckBox).Data := Data;
       end;
end;

procedure TCheckBoxList.CheckEvent( Index : Longint );
begin
	if ( Assigned( FOnCheck ) ) then
 	OnCheck( Self , Index );
end;

procedure TCheckBoxList.UnCheckEvent( Index : Longint );
begin
	if ( Assigned( FOnUncheck ) ) then
 	OnUnCheck( Self , Index );
end;

procedure TCheckBoxList.CheckAll (AChecked : Boolean);
var i : integer;
begin
     for i := 0 to Items.Count - 1 do
       CheckItem (i, AChecked);
end;

procedure TCheckBoxList.SetAuthor (Value : string);
begin
{ Hey, Hey, Hey ! I have a joke for you ! I just don't remember it right now ! }
end;

end.
