unit Fltexm1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Fltcback, Grids, DBGrids, ExtCtrls, DBCtrls, DB, DBTables,
  StdCtrls;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    FilterCallback1: TFilterCallback;
    Button1: TButton;
    RadioGroup1: TRadioGroup;
    Panel1: TPanel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure DescSystem(FilterRec: TFilterRecord; var Allow: Boolean);
    procedure OnHandGT12(FilterRec: TFilterRecord; var Allow: Boolean);
    procedure OnOrderEQ1(FilterRec: TFilterRecord; var Allow: Boolean);
    procedure DescStartsWithS(FilterRec: TFilterRecord; var Allow: Boolean);
    procedure VendorEQ7382(FilterRec: TFilterRecord; var Allow: Boolean);
    procedure PartNoEnds4(FilterRec: TFilterRecord; var Allow: Boolean);
    procedure OnHandGT10etc(FilterRec: TFilterRecord; var Allow: Boolean);
    procedure OnOrderGT4etc(FilterRec: TFilterRecord; var Allow: Boolean);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DescSystem(FilterRec: TFilterRecord;
  var Allow: Boolean);
begin
  Allow := False;
  with FilterRec do
  begin
    Allow := Pos('System', GetFieldData('Description').AsString) <> 0;
  end;
end;
procedure TForm1.OnHandGT12(FilterRec: TFilterRecord;
  var Allow: Boolean);
begin
  Allow := False;
  with FilterRec do
  begin
    if IsValidField('OnHand') then
      Allow := (GetFieldData('OnHand').AsFloat > 12.0);
  end;
end;
procedure TForm1.OnOrderEQ1(FilterRec: TFilterRecord;
  var Allow: Boolean);
begin
  Allow := False;
  with FilterRec do
  begin
    if IsValidField('OnOrder') then
      Allow := (GetFieldData('OnOrder').AsFloat = 1.0);
  end;
end;
procedure TForm1.DescStartsWithS(FilterRec: TFilterRecord;
  var Allow: Boolean);
begin
  Allow := False;
  with FilterRec do
  begin
    if IsValidField('Description') then
      Allow := (Copy(GetFieldData('Description').AsString, 1, 1) = 'S');
  end;
end;
procedure TForm1.VendorEQ7382(FilterRec: TFilterRecord;
  var Allow: Boolean);
begin
  Allow := False;
  with FilterRec do
  begin
    if IsValidField('VendorNo') then
      Allow := (GetFieldData('VendorNo').AsFloat = 7382.0);
  end;
end;
procedure TForm1.PartNoEnds4(FilterRec: TFilterRecord;
  var Allow: Boolean);
var
  WorkString: string;
begin
  Allow := False;
  with FilterRec do
  begin
    if IsValidField('PartNo') then
    begin
      WorkString := Format('%0.n', [GetFieldData('PartNo').AsFloat]);
      Allow := (Copy(WorkString, Length(WorkString), 1) = '4');
    end;
  end;
end;
procedure TForm1.OnHandGT10etc(FilterRec: TFilterRecord;
  var Allow: Boolean);
var
  OH,
  OO: Double;
begin
  Allow := False;
  with FilterRec do
  begin
    if IsValidField('OnHand') and IsValidField('OnOrder') then
    begin
      OH  := GetFieldData('OnHand').AsFloat;
      OO  := GetFieldData('OnOrder').AsFloat;
      Allow := (OH > 12.0) AND (OO <40.0);
    end;
  end;
end;
procedure TForm1.OnOrderGT4etc(FilterRec: TFilterRecord;
  var Allow: Boolean);
var
  VN,
  OO: Double;
begin
  Allow := False;
  with FilterRec do
  begin
    if IsValidField('OnHand') and IsValidField('OnOrder') then
    begin;
      VN  := GetFieldData('VendorNo').AsFloat;
      OO  := GetFieldData('OnOrder').AsFloat;
      Allow := (00 > 4.0) OR (VN > 5000.0);
    end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);

  procedure SetOnFilterHandler(Index: byte);
  begin
    case Index of
      0:
        FilterCallback1.OnFilter := DescSystem;
      1:
        FilterCallback1.OnFilter := OnHandGT12;
      2:
        FilterCallback1.OnFilter := OnOrderEQ1;
      3:
        FilterCallback1.OnFilter := DescStartsWithS;
      4:
        FilterCallback1.OnFilter := VendorEQ7382;
      5:
        FilterCallback1.OnFilter := PartNoEnds4;
      6:
        FilterCallback1.OnFilter := OnHandGT10etc;
      7:
        FilterCallback1.OnFilter := OnOrderGT4etc;
      else
        FilterCallback1.OnFilter := nil;
    end;
  end;

begin
  if FilterCallback1.Active then
  begin
    Button1.Caption := '&Apply';
    FilterCallBack1.EndFilter;
    RadioGroup1.Enabled := True;
    FilterCallback1.OnFilter := nil;
  end else
  begin
    Button1.Caption := '&Remove';
    SetOnFilterHandler(RadioGroup1.ItemIndex);  { Set BEFORE call to start }
    FilterCallBack1.StartFilter;
    RadioGroup1.Enabled := False;
  end;
end;

end.
