unit Userpar;

{ This file is containing all the code that needs to be modified to create
a new postcard.

Before doing so you will have to understand the basic object hierarchy that this
package provides to you:

- A Tanim is a list of TScreen. Each screen will be run in the sequence they have
been created via the addscreen command. It will run for a fixed duration or
until the user press a key. An animation is activated via its RunAnim command.

- A TScreen consist of:
            - A midi file that is played during the screen either once or continuously
            - A background bitmap loaded when the  screen starts
            - A graph manager which contains all the animated part of the screen

- A TGraphMng is a list of Tgraph. It  provides fast and flicker free
animation by performing all bitmap update in a buffer and blitting to the screen
only the part of the buffer which have been modified.

- A Tgraph is either a sprite which is an animated bitamp or a Text which is a
scrolling text window to display any specific message. A Tgraph has
the ability to  be hidden for period defines in its non valid list expressed in msecond.
The time reference will be the beginning of the active screen.

- A Tsprite is a descendant from TGraph and  provides  movement , animation
speed, a bouncing facility


}

interface

uses Winprocs,Wintypes,Usprite,Uscroll,Uscreen;

type
TEventClass=class
  public
    procedure BorderEvent(Sender:Tobject);
              (* Event fired  when sprite moves out of the window or bounces  *)
    procedure EndValidEvent(Sender:Tobject);
              (* event fired  when a graph exits a non valid period *)
    procedure BeginValidEvent(Sender:Tobject);
              (* event fired  when a graph enters a non valid period *)
    procedure ScreenEnds(Sender:Tobject);
              (* event fires when a screen ends *)
    procedure EventRect(Sender:Tobject);
  end;

const AppName = 'CardEng';               (* Window Title *)
      WndTitle = '                                  >>>>>>>   Press a Key for more';     (* Window Title *)
      XWindowPos=100;          (* Window position on screen *)
      YWindowPos=0;

var   Anim:Tanim;
      EventClass:TEventClass;

procedure Createparams(hdc:Thandle);
procedure FreeAll;

implementation

uses Ucardut,Uerror,UcardMsg,mmsystem,umidi;

const Mycount:byte=0;


var  Screen1,Screen2,Screen3:Tscreen;
     catsing,catbrown,moto:Tsprite;
     cateyes1,cateyes2,cateyes3,cateyes4:Tsprite;
     cake:Tsprite;
     Text1an,Textfrom:TScroll;
     catdanc1,catdanc2,catdanc3,catandm:Tsprite;

procedure TEventClass.BorderEvent(Sender:Tobject);
begin
  with sender as Tsprite do begin
  end;
end;

procedure TEventClass.EndValidEvent(Sender:Tobject);
begin
  with sender as TGraph do;
end;

procedure TEventClass.BeginValidEvent(Sender:TObject);
begin
  with sender as TGraph do;
end;

procedure TEventClass.ScreenEnds(Sender:Tobject);
begin
  with sender as Tscreen do ;
end;

procedure TEventClass.EventRect;
begin
  with sender as TSprite do
    with tsprite(sender) do begin
    speedx:=0;
    speedy:=0;
    inc(Mycount);
    with Twave.create do begin
      WavRes:='CLICK';
      play;
    end;
  if Mycount=4 then begin
    cake.Nonvalid.delete(0);
    Text1an.Nonvalid.delete(0);
  end;
  end;
end;


procedure Createparams(hdc:Thandle);
var ARect:Trect;
begin
  Anim.AutoRepeat:=true;                (* Restart the animation to screen 0 when finished *)
  EventClass:=TeventClass.create;       (* Create the event Handler objest as an event*)
                                         (*          need to be object's methods      *)



 (******* screen 1 **************)

 Screen1:=TScreen.create('HAPPYBGD','SAINTS',true,0);

 Catdanc1:=Tsprite.CreateFmRes('CATDANC',transparent,Compressed,7,hdc);
  with catdanc1 do begin
    posx:=10;
    posy:=10;
    ImageRefresh:=3;
  end;

 Catdanc2:=Tsprite.CreateFmRes('CATDANC',transparent,Compressed,7,hdc);
  with catdanc2 do begin
    posx:=260;
    posy:=10;
    ImageRefresh:=3;
  end;

 Catdanc3:=Tsprite.CreateFmRes('CATDANC',transparent,Compressed,7,hdc);
  with catdanc3 do begin
    posx:=260;
    posy:=440;
    ImageRefresh:=3;
  end;

   Catandm:=Tsprite.CreateFmRes('CATANDM',transparent,Compressed,5,hdc);
  with catandm do begin
    posx:=140;
    posy:=180;
    ImageRefresh:=3;
  end;

  Screen1.GraphMng.AddGraph(catdanc1);
  Screen1.GraphMng.AddGraph(catdanc2);
  Screen1.GraphMng.AddGraph(catdanc3);
  Screen1.GraphMng.AddGraph(catandm);
  Anim.AddScreen(Screen1,hdc);

  (******* screen 2 **************)

  Screen2:=TScreen.create('BACKCURT','BIRTHDAY',true,0);
  with Screen2.GraphMng do begin
    OnEventRect:=EventClass.EventRect;
    OnBorderEvent:=EventClass.BorderEvent;
  end;

Text1an:=TScroll.create(hdc,'Times New Roman',60,rgb($FF,$CE,$63),220,120,250,50);
 with text1an do begin
    NonValid.add(Tnonvalidperiod.create(0,100000));
    Scroll:=0;
    strings.add(' 1 AN dj ');
  end;


 Cake:=Tsprite.CreateFmRes('CAKE',transparent,Compressed,3,hdc);
  with cake do begin
    NonValid.add(Tnonvalidperiod.create(0,100000));
    posx:=250;
    posy:=180;
    ImageRefresh:=3;
  end;

 Cateyes1:=Tsprite.CreateFmRes('CATEYES',transparent,Compressed,3,hdc);
  with cateyes1 do begin
    bounce:=true;
    posx:=300;
    posy:=200;
    speedx:=19;
    speedy:=20;
    ImageRefresh:=3;
    SetRect(Arect,0,0,200,100);
    EventRect:=Arect;
  end;

 Cateyes2:=Tsprite.CreateFmRes('CATEYES',transparent,Compressed,3,hdc);
  with cateyes2 do begin
    bounce:=true;
    posx:=300;
    posy:=200;
    speedx:=-19;
    speedy:=13;
    ImageRefresh:=3;
    SetRect(Arect,440,0,640,100);
    EventRect:=Arect;
  end;

 Cateyes3:=Tsprite.CreateFmRes('CATEYES',transparent,Compressed,3,hdc);
  with cateyes3 do begin
    bounce:=true;
    posx:=300;
    posy:=200;
    speedx:=9;
    speedy:=-10;
    ImageRefresh:=3;
    SetRect(Arect,440,386,640,486);
    EventRect:=Arect;
  end;

 Cateyes4:=Tsprite.CreateFmRes('CATEYES',transparent,Compressed,3,hdc);
  with cateyes4 do begin
    bounce:=true;
    posx:=300;
    posy:=200;
    speedx:=-9;
    speedy:=-10;
    ImageRefresh:=3;
    SetRect(Arect,0,386,200,486);
    EventRect:=Arect;
  end;

  Screen2.GraphMng.AddGraph(cake);
  Screen2.GraphMng.AddGraph(Text1an);
  Screen2.GraphMng.AddGraph(cateyes1);
  Screen2.GraphMng.AddGraph(cateyes2);
  Screen2.GraphMng.AddGraph(cateyes3);
  Screen2.GraphMng.AddGraph(cateyes4);
  Anim.AddScreen(Screen2,hdc);

 (******* screen 3 **************)

  Screen3:=TScreen.create('BACK1','DISNEY',true,0);

  Catsing:=Tsprite.CreateFmRes('CATSING',transparent,Compressed,1,hdc);
  with catsing do begin
    posx:=20;
    posy:=70;
    ImageRefresh:=3;
  end;

  Catbrown:=Tsprite.CreateFmRes('CATBROWN',transparent,Compressed,1,hdc);
  with catbrown do begin
    posx:=500;
    posy:=70;
    ImageRefresh:=10;
  end;

Textfrom:=TScroll.create(hdc,'Times New Roman',38,rgb($FF,$CE,$63),170,70,350,120);
 with textfrom do begin
    Scroll:=-2;
    strings.add('');
    strings.add('');
    strings.add('');
    strings.add('Joyeux Anniversaire ');
    strings.add('Maud');
    strings.add('De la part de: ');
    strings.add('Papa');
    strings.add('Maman');
    strings.add('Nama');
    strings.add('Teddy');
    strings.add('Juju');
  end;

  Screen3.GraphMng.AddGraph(CatSing);
  Screen3.GraphMng.AddGraph(CatBrown);
  Screen3.GraphMng.AddGraph(Textfrom);
  Anim.AddScreen(Screen3,hdc);
end;


procedure FreeAll;
begin
  EventClass.free;
end;

end.
