program Cardmaud;

(*

CARDENG: A post card engine as a freeware ..............
         releases 1.0
         By Paul-henri FERME
         paul_henri@compuserve.com


Overview:
---------

This engine will help in compiling a nice electronic postcard that you can sent over the
internet with animated bitmap(s) and background sound(s). It contains a set of object that
will enable you to:
       - Load and use bitmap,midi and wav file directly from resource
       - Perform simple bimap animation
       - Display text as a rolling Banner

I also include in the package a software to convert a GIF to a bitmap.

Please run the demo to see good examples and check for the readme.txt section
in param.pas if you want to build your own card yourself.


You need to be familiar with delphi to use it as there is no visual interface for those objects
.In a way this has an advantage. As there is no component to be added to the delphi component
library. This will save you a lot of time!!!

All you need is  basic delphi knowledge and a little object programming understanding to
use the object although the example will guide you.

UnitsList
---------

Cardengr.dpr   Main program
Param.pas      User definition script  { this is the only file to be modified }
Uscreen.pas    Anim and Screen objects
Ucardut.pas    Routines to create a bitmap from a file or from ressource
Ucardmsg.pas   Error code number
Ucardmasg.rc   Error strings
Uerror.pas     Error routines
Umidi.pas      Midi routines
Usprite.pas    Sprite objects
UScroll        Scrolling text object
LZRW1KH.PAS    Compression algorythm
Ucompstr.pas   Compression object
CardRes.rc     resource file with compressed bitmaps, midi and wave files
CardEng.ico     Icon for this program
readme.txt     Quick starter

Additional software
-------------------

compr.exe      Program will call LZRW1KH and produce a compressed file
               with extension zzz. This files must then  be compiled into the ressource
               file Cardres with BRCC. The cardeng engine will use them automatically.
               The LZW1KH routine are free, very fast and do not need any DLL as they are
               witten in native Turbo pascal.
TesGIF.exe     Excellent Freeware available from Reiner SterKenburg that will read a GIF
               file. I just add a command to save the gif file as a bitmap. This will create
               a file in a format that CardEngg can use. The format is simple: put all
               succesive image from the animated GIF to the right of the bitmap.
               Therefore if you GIF is 100x80 pixels with 5 animation you will get a
               composite bitmap of  500x80 that CardEng can use.


Note on Animation Speed
-----------------------

If compiled with the DISPLAY option you will see on the screen the time between 2 succesive
call to the timer. Windows timers are limited to 55ms period and if you PC is fast enough  and
you are not trying to move too large bitmap that what's you should see. Otherwise the animation
will  slow down. Good new is that this is pretty harmless: if you run the post card on a very
slow machine you will have very slow animation. That's all...

Some Restrictions:
-----------------

Bitmaps are limited to 1,4 or 16 bits per color. 24 bits bitmaps are not supported.
   Neither is the OS2 special bitmmap format, but who cares about that one any more...

Background color for all sprites is determined by the lower left corner pixel corner.

All position are in pixels with reference to the upper left corner of the screen.
Speed are expessed in pixels between 2 timer call.


Way of distribution:
--------------------

This code has been written and distributed as freeware as my contribution to the delphi
software community which helps me tremendously in getting up to speed with delphi
and windows API without any previous exposure to window prgramming.
 God!! when I see some of the messages I sent a year ago these guys have been
 really patient in answering my questions...

With special thanks to the following individual:

Ray Konopka for his book "Developping Custome Delphi components" which is a "must
read "

Charles Calvert for his book "Delphi2 unleashed" as it provides some good and easy
to unterstand examples of direct windows API call from delphi.

Charles Petzold "Windows 3.1 programming" which will take you smoothly through
the nigthmare of API programming.

And also Rick Rogers and Peter Below for their patient and consistent  support
via Borland delphi Forum...


Cardeng Key features:
--------------------

1) Very compact code achieved by not using any VCL graphic objects and direct call
windows API instead and also using fast LZH compression algorithm for all mid and bmp
files.

2) Single contained exe with no additional files required: Just click and go.

3) Easy to use Non-visual object to handle all tasks.


By the way you need to try write software without the VCL to understand how
valuable is the VCL in hiding all this nasty Device Context creation and release.
These guys from Microsoft really made this complex...

Way of distribution
-------------------

You are free to use and distribute this software or part of this software as long
as this is  for non commercial use. However there is no garantee whatsoever regarding
its functionality and indeed it probably contains some bugs.

I will only ask you to send me a copy of any post card generated using cardeng
via email to paul_henri@compuserve.com. I include some example together with that code.

Debug
-----

As Delphi integrated debugger can be rather disruptive if you are dealing with time
driven software of if you try to debug a WM_PAINT message I included a small Debug tool
activated by the DEBUG conditional compile variable. It enables you to send string to
a debug window in a "not too disruptive" way. Make sure you recompile you all application
if you change this parameter.

example of call:
{$IFDEF  DEBUG}
    with TDebug.create do begin
       displaystring('selectobject:  '+inttostr(lastObj2));
       free;
     end;
{$ENDIF}

Alternatively you can stop the timer as explained  in WM_TIMER. This will allow
you to use the integrated debugger in the timer message and resume the software.

Some additional documentation about the object library  is included
in the file param.pas together with the key property. For the rest you will
have to refer to the object declaration.

I will provide support to the best of my time availability. Do not hesitate to send me
an Email if you have questions or found a bug.

Have fun....
Feb 1998
Paul-henri FERME

Revision history
----------------

1.0 original release to Delphi Super Page server  March 1998

Further enhancements:
--------------------

More capability to size and position the  window or have a window with a  size
different from the background bitmap...

*)

{$R CARDRES.RES}

uses
  Winprocs,
  Wintypes,
  Messages,
  SysUtils,
  UCardMsg in 'UCARDMSG.PAS',
  Ucardut in 'UCARDUT.PAS',
  Uerror in 'UERROR.PAS',
  Umidi in 'UMIDI.PAS',
  Usprite in 'USPRITE.PAS',
  classes,
  LZRW1KH in 'LZRW1KH.PAS',
  mmsystem,
  Uscreen in 'USCREEN.PAS',
  Uscroll in 'USCROLL.PAS' {$IFDEF  STRESS},
  Stress in 'STRESS.PAS' {$ENDIF},
  Userpar in 'USERPAR.PAS';

var
  AMessage: TMsg;
  Hdcmain: Thandle;
  i:integer;
  htimer:word;
  ps:Tpaintstruct;
{$IFDEF  DEBUG}
  Arect:Trect;
{$ENDIF}




function WindowProc(Window: HWnd; AMessage, WParam:integer;
                    LParam: Longint): Longint; export;

var   hdc1,hdc2:Thandle;
      hdcpaint:Thandle;

begin
  WindowProc := 0;

  case AMessage of

    WM_CREATE: begin
    end;  (* WM_CREATE *)

    WM_DESTROY: begin
      KillTimer(hwindow,ID_TIMER);
      PostQuitMessage(0);
      Exit;
    end; (* WM_DESTROY *)

    WM_PAINT: begin        (* copy active background to the screen *)
     hdc1:=BeginPaint(window,ps);
     hdcpaint:=CreateCompatibleDC(hdc1);
     SelectObject(hdcpaint,Tscreen(anim.list[anim.active]).BitmapWindow);
     bitblt(hdc1,0,0,bs.bmwidth,bs.bmheight,hdcpaint,0,0,SRCCOPY);
     deleteDC(hdcpaint);
     EndPaint(window,ps);
    end;  (* WM_PAINT *)

    WM_KEYDOWN: begin
      Anim.KeyPressed:=true;
    end;

    MM_MCINOTIFY: begin
      if TScreen(Anim.List[Anim.Active]).MidiRepeat  and  (wparam =MCI_NOTIFY_SUCCESSFUL )
             then TScreen(Anim.List[Anim.Active]).Midi.play(DontCare,DontCare);
    end;

   WM_TIMER:
    begin

     Hdc2:=GetDc(window);
{$IFDEF  DISPLAY}
     with Tdebug.create do displayframe(Hdc2);
{$ENDIF}
     HdcScreen:=CreateCompatibleDC(hdc2);
     Lastobj1:=SelectObject(HdcScreen,TScreen(Anim.List[Anim.Active]).BitmapWindow);
     hdcBgdRef:=CreateCompatibleDC(hdc2);
     LastObj2:=SelectObject(hdcBgdRef,TScreen(Anim.List[Anim.Active]).BitmapWindowBgd);
     (* killtimer(hwindow,id_timer);      to use the integrated delphi debugger  *)
     Anim.RunAnimation(hdc2);
     (*SetTimer(hwindow,ID_TIMER,TimerPeriod*20,nil); *)

     deleteDC(HdcScreen);
     deleteDC(hdcBgdRef);
     ReleaseDC(window,hdc2);
     end; (* WM_TIMER *)
  end; (* case *)

  WindowProc := DefWindowProc(Window, AMessage, WParam, LParam);
end;

{ Register the Window Class }
function WinRegister: Boolean;
var
  WindowClass: TWndClass;
  A: array [0..23] of char;
begin
  WindowClass.Style := cs_hRedraw or cs_vRedraw;
  WindowClass.lpfnWndProc := @WindowProc;
  WindowClass.cbClsExtra := 0;
  WindowClass.cbWndExtra := 0;
  WindowClass.hInstance := HInstance;
(*  WindowClass.hIcon := LoadIcon(0, idi_Application);  default window icon*)
  WindowClass.hIcon := LoadIcon(hinstance, 'myicon');
  WindowClass.hCursor := LoadCursor(0, idc_Arrow);
  WindowClass.hbrBackground := getstockobject(WHITE_BRUSH);
  WindowClass.lpszMenuName := nil;
  WindowClass.lpszClassName := AppName;

  Result := winprocs.RegisterClass(WindowClass);
end;

{ Create the Window Class }
function WinCreate: HWnd;
var
  hWindow: HWnd;

begin
  hWindow := CreateWindow(AppName,WndTitle,
              ws_overlapped or ws_sysmenu or ws_thickframe,cw_UseDefault, cw_UseDefault,
              cw_UseDefault, cw_UseDefault, 0, 0, HInstance, nil);


  Result := hWindow;
end;

begin
  (*showmemory;*)
  if not Winregister then FatalError(SCWinRegister);
  hwindow:=WinCreate;
  if Hwindow=0 then FatalError(SCWinCreate);

{$IFDEF  DEBUG}
  hwdebug := CreateWindow(AppName,'debug',
              ws_overlappedwindow, 0, 200,
              500, 300, 0, 0, HInstance, nil);
  ShowWindow(hwdebug, CmdShow);
  getclientrect(hwdebug,arect);


 with arect do hwndlist:= createwindow('LISTBOX',nil,
               WS_CHILD or WS_VISIBLE or WS_VSCROLL,
               0,0,right,bottom,
               hwdebug,1,
               hinstance,nil);
 setfocus( hwindow);
{$ENDIF}


  hdcmain:=GetDc(hwindow);

{$IFDEF  STRESS}
(* stress testing *)
  (*if not AllocGDImem(1000) then error(100);*)
  if not AllocMem(500000) then Error(100);
  (*if not AllocUserMem(2000) then Error(100);*)
{$ENDIF}

(* params initialization *)

  Anim:=TAnim.create;                         (* Main animation object*)
  CreateParams(hdcmain);
  Anim.OnScreenEnds:=EventClass.ScreenEnds;

(* Windows init *)

 if SetTimer(hwindow,ID_TIMER,TimerPeriod,nil)=0 then Error(SCCreateTimer); 


  UpdateWindow(hwindow);
  releaseDC(hwindow,hdcmain);

(* initialisation ends here *)

(* Main window loop *)

  while GetMessage(AMessage, 0, 0, 0) do begin
    TranslateMessage(AMessage);
    DispatchMessage(AMessage);
  end;

(* final clean-up *)
  KillTimer(hwindow,ID_TIMER);
  Anim.free;
  FreeAll;
{$IFDEF  STRESS}
  (*FreeAllGDIMem;*)
  FreeAllMem;
  (*FreeAllUserMem;*)
{$ENDIF}
  (*showmemory;*)
  Halt(AMessage.wParam);
end.


