unit Usprite;

(* sprite implementation.*)

interface

uses wintypes,winprocs,classes;

(*************************************************)
(*   Global variables and constants for CardEng  *)
(*************************************************)

const
  ID_TIMER = 1;
  DontCare = 0;
  TimerPeriod = 1000 div 18;   (* 18 frames per second . limited by 55ms window
                                  timer resolution*)


var  hWindow,hwdebug: HWnd; (* windows handle *)
     HdcScreen:Thandle;    (* memory device with copy of the screen *)
     HdcBgdRef:Thandle;  (* memory device with copy of bgd bitmap *)
     Bs:TBitmap;         (* main bitmap structure *)
     StartTickCount:longint;      (* Time when program starts *)
     LastObj1,LastObj2:integer;    (* peviously selected bitmap in hdc*)

(***********************************************)
(*   Global variables and constants end here   *)
(***********************************************)


type

Ttransparent=(Opaque,Transparent);
TCompressed=(NonCompressed,Compressed);

Tgraph=class;   (* Common ancestor for Tsprite and Tscroll *)
TSprite=class;


TGraphMng= class
private
 FList:Tlist;   (* list of sprites object *)
 FRecList:TList;  (* List of modified rect on HdcBgdRef *)
 FFirstDraw:Boolean;
 FOnBeginValidEvent:TNotifyEvent;
 FOnEndValidEvent:TNotifyEvent;
 FOnBorderEvent:TNotifyEvent;
 FOnEventRect:TNotifyEvent;
 function GetGraph(const Idx:integer):TGraph;
 function GetCount:integer;
 function ValidGraph(Agraph:TGraph):boolean;
 procedure BorderEvent(Sender:Tobject);
 procedure EventRect(Sender:Tobject);
public
 constructor create;
 destructor destroy;override;
 procedure AddGraph(AGraph:TGraph);
 procedure RedrawScreen(hdc:Thandle);   (* main procedure called by timer *)
 property Count:integer read GetCount;
 property OnBeginValidEvent:TNotifyEvent read FOnBeginValidEvent write FOnBeginValidEvent;
 property OnEndValidEvent:TNotifyEvent read FOnEndValidEvent write FOnEndValidEvent;
 property OnBorderEvent:TNotifyEvent read FOnBorderEvent write FOnBorderEvent;
 property OnEventRect:TNotifyEvent read FOnEventRect write FOnEventRect;
end;

TNonValidPeriod=class
  Fstart:longint;
  Fends:longint;
public
  property Start:longint read FStart write FStart;
  property ends:longint read Fends write Fends;
  constructor create(AStart,Aends:longint);
end;

Tgraph = class
private
  Fposx,Fposy:integer;
  FWidth,FHeight:integer;
  FNonValid:Tlist;  (* no display if time in that interval *)
  FNonVisible:boolean;   (* Internal Flag used to detect that the sprite just
                            becomes non visible
                            and needs to be blanked on the screen *)
  FDisplayed:boolean;
  FCountUse:integer;
protected
  property CountUse:integer read FCountUse write FCountuse;
public
  constructor create;
  destructor destroy;override;
  property Width:integer read FWidth write FWidth;
  property Height:integer read FHeight write FHeight;
  property posx:integer read FPosx write FPosx;
  property posy:integer read FPosy write FPosy;
  property NonValid:Tlist read FNonValid write FNonValid;
  property Displayed:boolean read FDisplayed write FDisplayed;
  function DrawGraph(hdc:Thandle):Trect; virtual; abstract;
end;

Tsprite = class(Tgraph)
private
  FReversed: boolean;
  FBounce:boolean;
  FSpriteRect,FClipREct:Trect;
  FTransparent:boolean;
  FCompressed:boolean;
  Fimages:byte;  (* starts with 0 *)
  Fspeedx,Fspeedy:integer;
  Flastposx,Flastposy:integer;
  Fbitmap,FBitmapTemp,FBitmapBgd,FBitmapMask:HBITMAP;
  FimageCount:byte;
  FFirstDisplay:boolean;
  FLastSpriteInPartial:boolean;
  FimageRef:byte;
  FCountTick:Longint;
  FOnBorderEvent:TNotifyEvent;
  FEventTrigger:Boolean;  (* this prevent the event from firing again *)
  FEventRect:TRect;
  FOnEventRect:TNotifyEvent;
  FFirstEventRect:boolean;
  Procedure InitVariables(Transparent:TTransparent;
                               Compressed:TCompressed;Images:byte);
  procedure SetEventRect(const Arect:Trect);
protected
  property OnBorderEvent:TNotifyEvent read FOnBorderEvent write FOnBorderEvent;
  property OnEventrect:TNotifyEvent read FOnEventRect write FOnEventRect;
public
  constructor CreateFmRes(RessourceName:string; Transparent:TTransparent;
                Compressed:TCompressed;Images:byte;hdc:Thandle);
  constructor CreateFmBmp(BitmapFile:string;Transparent:TTransparent;
                Compressed:TCompressed;Images:byte;hdc:Thandle);
  destructor  destroy;override;
  function DrawGraph(hdc:Thandle):Trect;override; (* will return the modified rectangle *)
  procedure DrawBitmap(hdc:Thandle);  (* for debug purpose only *)
  property speedx:integer read  FSpeedx write FSpeedx;
  property speedy:integer read  FSpeedy write FSpeedy;
  property ImageRefresh:byte read FImageRef write FImageref default 1;
  property Bounce:boolean read Fbounce write Fbounce;
  property Reversed:boolean read Freversed write Freversed;
           (* will mirror bitmap when speed x is negative. It is assumed that the initial bitmap
           is for positive speed ie left to right. This can be slow especialy if you have a large
           bitmap in transparent mode*)
  property  EventRect:TRect read FEventrect write SetEventrect;
            (* As soon as the sprite is completely in this user defined rectangle,
               an OnEventRect event will be fired *)
end;


implementation

uses sysutils,Ucardut,Uerror,UcardMsg,Userpar;

const minpixel=0;

{ TNonValidPeriod }

constructor  TNonValidPeriod.create(AStart,Aends:longint);
begin
  inherited create;
  FStart:=AStart;
  Fends:=Aends;
end;

{ TGraph }

constructor TGraph.create;
begin
  inherited create;
  FNonValid:=Tlist.create;
  Fdisplayed:=true;
end;

destructor Tgraph.destroy;
var i:integer;
begin
  with FnonValid do for i:=0 to count-1 do TNonValidPeriod(items[i]).free;
  FNonValid.free;
end;

{ TGraphMng }

 constructor TGraphMng.create;
 begin
   inherited create;
   FList:=Tlist.create;
   FRecList:=Tlist.create;
   FFirstDraw:=true;
 end;

 destructor TGraphMng.destroy;
 var i:integer;
 begin
   for i:=0 to Flist.count-1 do
     with TGraph(Flist[i]) do
       if countuse<=1 then free else countuse:=countuse-1;
   Flist.free;
   for i:=0 to FRecList.count-1 do TTrect(FRecList[i]).free;
   FRecList.free;
 end;

 procedure TGraphMng.BorderEvent(Sender:Tobject);
 begin
   if assigned(FOnBorderEvent) then FOnBorderEvent(Sender);
 end;

 procedure TGraphMng.EventRect(Sender:Tobject);
 begin
   if assigned(FOnEventRect) then FOnEventRect(Sender);
 end;

 function TGraphMng.GetGraph(const Idx:integer):TGraph;
 begin
   result:=TGraph(Flist[Idx]);
 end;

 procedure TGraphMng.AddGraph(AGraph:TGraph);
 begin
   Flist.add(AGraph);
   Agraph.CountUse:=Agraph.CountUse+1;
   if Agraph is Tsprite then begin
      TSprite(Agraph).OnBorderEvent:=BorderEvent;
      TSprite(Agraph).OnEventRect:=EventRect;
   end;
 end;

 function TGraphMng.Getcount:integer;
 begin
   result:=Flist.count;
 end;

function TGraphMng.ValidGraph(Agraph:TGraph):boolean;
var i:integer;
begin
 result:=true;
 for i:=0 to Agraph.NonValid.count-1 do
 if ((GetTickCount-StartTickCount)>=TNonValidPeriod(AGraph.NonValid[i]).start) and
              ((GetTickCount-StartTickCount)<=TNonValidPeriod(AGraph.NonValid[i]).ends)
                then result:=false;
 if not Agraph.Fdisplayed then result:=false;
end;

procedure  TGraphMng.RedrawScreen(hdc:Thandle);
var i:integer;
    Arect:TTrect;
    rr:boolean;

begin
(* we first recreate HdcScreen from HdcBgdRef *)
   if FFirstDraw then bitblt(HdcScreen,0,0,bs.bmwidth,bs.bmheight,HdcBgdRef,0,0,SRCCOPY)
     else with Freclist do for i:=0 to count-1 do
         with TTrect(FReclist[i]) do
            bitblt(HdcScreen,left,top,right-left,bottom-top,HdcBgdRef,left,top,SRCCOPY);
   FFirstDraw:=false;

(* we now generate a list of all modified rectangle *)

     for i:=0 to FRecList.count-1 do TTrect(FReclist[i]).free;
     FRecList.clear;

     with Flist do for i:=0 to count-1 do
        if ValidGraph(TGraph(Flist[i])) then  begin
          with TGraph(Flist[i]).DrawGraph(hdc) do begin  (* virtual  proc *)
            Arect:=TTrect.create;
            Arect.left:=left;
            Arect.right:=right;
            Arect.top:=top;
            Arect.bottom:=bottom;
            FReclist.add(Arect);
          end; (* with *)
          if TGraph(Flist[i]).FNonVisible and assigned(FOnBeginValidEvent)
                     then FOnBeginValidEvent(TGraph(Flist[i]));
          TGraph(Flist[i]).FNonVisible:=false;
        end else with TGraph(Flist[i]) do begin
            if not FNonvisible then begin
     (* this will erase background once when sprite is disabled *)
              Arect:=TTrect.create;
              Arect.left:=posx;
              Arect.right:=posx+width;
              Arect.top:=posy;
              Arect.bottom:=posy+height;
              FReclist.add(Arect);
              if assigned(FOnEndValidEvent) then FOnEndValidEvent(TGraph(Flist[i]));
            end;
            FNonVisible:=true;
        end;

 (* then we move hdcscreen to the screen in one go and as fast as possible*)
    with Freclist do for i:=0 to count-1 do
       with TTrect(FReclist[i]) do  begin
          rr:=bitblt(hdc,left,top,right-left,bottom-top,HdcScreen,left,top,SRCCOPY);
       end;
end;

{ TSprite }

  destructor TSprite.destroy;
  begin
      Deleteobject(FBitmap);
      if Ftransparent then begin
        DeleteObject(FBitmapTemp);
        DeleteObject(FbitmapBgd);
        DeleteObject(FBitmapMask);
      end;
      inherited destroy;
  end;

 procedure Tsprite.SetEventRect(const Arect:Trect);
 begin
  FFirstEventRect:=true;
  FEventRect:=Arect;
 end;

  procedure TSprite.drawbitmap(hdc:thandle);
  var hdcmem1:thandle;
  begin
     hdcmem1:=CreateCompatibleDC(hdc);
     SelectObject(hdcmem1,FBitmapmask);
     bitblt(Hdc,0,0,width,height,hdcmem1,0,0,SRCCOPY);
     deleteDC(hdcmem1);
  end;


  Procedure TSprite.InitVariables(Transparent:TTransparent;
                Compressed:TCompressed;Images:byte);
  begin
    FTransparent:=boolean(Transparent);
    Fcompressed:=boolean(Compressed);
    FImages:=Images;
    FFirstDisplay:=true;
    FLastSpriteInPartial:=true;
    FImageRef:=1;
    FEventtrigger:=true;
    FBounce:=False;
  end;


  constructor TSprite.CreateFmRes(RessourceName:string; Transparent:TTransparent;
                Compressed:TCompressed;Images:byte;hdc:Thandle);

  var Bstruct1:wintypes.TBITMAP;

  begin
    inherited create;
    InitVariables(Transparent,Compressed,Images);
    with TSimpleMmedia.create(hdc) do begin
      if Ftransparent then Fbitmap:=CreateBitmapRes(RessourceName,Blackbgd)
           else  Fbitmap:=CreateBitmapRes(RessourceName,normal);
      free;
    end;
    GetObject(FBitmap,sizeof(TBITMAP),@Bstruct1);
    FWidth:=bstruct1.bmwidth div (images+1);
    FHeight:=bstruct1.bmheight;
    if (Fbitmap=0) then FmtError(SCBitmapCreate,[RessourceName]);

    FbitmapBgd:=CreateCompatibleBitmap(hdc,Fwidth,FHeight);
    if (FbitmapBgd=0) then FmtError (SCBitmapCreate,[RessourceName]);

    if FTransparent then begin
      with TSimpleMmedia.create(hdc) do begin
        FbitmapMask:=CreateBitmapRes(RessourceName,mask);
        free;
      end;
      FbitmapTemp:=CreateCompatibleBitmap(hdc,Fwidth,FHeight);
      if (FbitmapMask=0) or (FbitmapTemp=0) then
                FmtError (SCBitmapCreate,[RessourceName]);
    end;
    SetRect(FSpriteRect,Fposx,Fposy,Fposx+Fwidth,FPosy+FHeight);
  end;

  constructor Tsprite.CreateFmBmp(BitmapFile:string;Transparent:TTransparent;
                Compressed:TCompressed;Images:byte;hdc:Thandle);

  var Bstruct1:wintypes.TBITMAP;

  begin
    inherited create;
    InitVariables(Transparent,Compressed,Images);
    with TSimpleMmedia.create(hdc) do begin
      if Ftransparent then Fbitmap:=CreateBitmapFile(BitmapFile,BlackBgd)
           else  Fbitmap:=CreateBitmapFile(BitmapFile,normal);
      free;
    end;
    GetObject(FBitmap,sizeof(TBITMAP),@Bstruct1);
    FWidth:=bstruct1.bmwidth div (images+1);
    FHeight:=bstruct1.bmheight;
    if (Fbitmap=0) then FmtError(SCBitmapCreate,[BitmapFile]);

    FbitmapBgd:=CreateCompatibleBitmap(hdc,Fwidth,FHeight);
    if (FbitmapBgd=0) then FmtError (SCBitmapCreate,[BitmapFile]);

    if FTransparent then begin
      with TSimpleMmedia.create(hdc) do begin
        FbitmapMask:=CreateBitmapFile(BitmapFile,mask);
        free;
      end;
      FbitmapTemp:=CreateCompatibleBitmap(hdc,Fwidth,FHeight);
      if (FbitmapMask=0) or (FbitmapTemp=0) then
                FmtError (SCBitmapCreate,[BitmapFile]);
    end;
    SetRect(FSpriteRect,Fposx,Fposy,Fposx+Fwidth,FPosy+FHeight);
 end;

 function TSprite.DrawGraph(hdc:Thandle):Trect;

  var hdcmem1,hdcmem3,hdcmem4: Thandle;
      DisplayRect,BufRect:Trect;
      BitBltRect,BitBltRect1,BitBltRect2:Trect;
      SpriteInPartial,SpriteInTotal:boolean;
      Arect:trect;
      Dtop,Dleft,Dright,Dbottom:boolean;
      Brush:Hbrush;

  begin
    GetClipBox(hdc,FClipRect);
    FPosx:=FPosx+FSpeedx;
    FPosy:=FPosy+FSpeedy;
    SetRect(FSpriteRect,Fposx,Fposy,Fposx+Fwidth,FPosy+FHeight);
    SpriteInPArtial:=(IntersectRect(DisplayRect,FClipRect,FSpriteRect)<>0);
    SpriteInTotal:=EqualRect(displayRect,FSpriterect);
    if SpriteInTotal then FEventTrigger:=true;
                           (* if sprite entirely in cliprect,then enable event *)

    if (FLastSpriteInPartial or SpriteInPartial)  then begin
      if not FTransparent then begin
        hdcmem1:=CreateCompatibleDC(hdc);
        SelectObject(hdcmem1,Fbitmap);      (* Main bitmap*)
        if (hdcmem1=0)  then error(SCMemDIBCreate);

        if not FFirstDisplay then Setrect(BitBltRect1,Flastposx,Flastposy,
                                      Flastposx+Fwidth,Flastposy+Fheight)
                            else Setrect(BitBltRect1,0,0,0,0);
        FFirstDisplay:=false;
        FLastposx:=Fposx;
        FLastposy:=Fposy;

(* finally we blit the bitmap to the buffer*)
       if reversed and (Fspeedx<0)then
          bitblt(HdcScreen,Fposx,Fposy,Fwidth,Fheight,hdcmem1,FImageCount*Fwidth,0,SRCCOPY)
       else
          stretchblt(HdcScreen,Fposx+Fwidth,Fposy,-Fwidth,Fheight,
                  hdcmem1,FImageCount*Fwidth,0,Fwidth,Fheight,SRCCOPY);
(* then we returned rect to be redrawn *)
        setrect(BitbltRect2,Fposx,Fposy,Fposx+Fwidth,Fposy+Fheight);
        UnionRect(BitbltRect,BitbltRect1,BitbltRect2);
        result:=BitbltRect;

        DeleteDC(hdcmem1);
      end else begin
        hdcmem1:=CreateCompatibleDC(hdc);
        SelectObject(hdcmem1,Fbitmap);      (* Main bitmap*)
        hdcmem3:=CreateCompatibleDC(hdc);
        SelectObject(hdcmem3,FbitmapTemp);   (* Intermediate buffer *)
        hdcmem4:=CreateCompatibleDC(hdc);
        SelectObject(hdcmem4,FbitmapMask);   (* mask *)

        if (hdcmem1=0) or (hdcmem3=0) or (hdcmem4=0) then error(SCMemDIBCreate);

       if not FFirstDisplay then Setrect(BitBltRect1,Flastposx,Flastposy,
                                      Flastposx+Fwidth,Flastposy+Fheight)
                            else  Setrect(BitBltRect1,0,0,0,0);
        FFirstDisplay:=false;
        FLastposx:=Fposx;
        FLastposy:=Fposy;
{$IFDEF  DEBUG}
        Brush:=selectobject(hdc,getStockObject(NULL_BRUSH));
        with DisplayRect do rectangle(hdc,left,top,right,bottom);
        SelectObject(hdc,Brush); 
{$ENDIF}
(* blit bitmap through the mask to screen buffer*)
        bitblt(hdcmem3,0,0,Fwidth,Fheight,HdcScreen,Fposx,Fposy,SRCCOPY);
        if reversed and (Fspeedx<0)then begin
          stretchblt(hdcmem3,Fwidth,0,-Fwidth,Fheight,
                           hdcmem4,FImageCount*Fwidth,0,Fwidth,Fheight,SRCAND);
          stretchblt(hdcmem3,Fwidth,0,-Fwidth,Fheight,
                           hdcmem1,FImageCount*Fwidth,0,Fwidth,Fheight,SRCPAINT);
          bitblt(HdcScreen,Fposx,Fposy,Fwidth,Fheight,hdcmem3,0,0,SRCCOPY);
        end else begin
          bitblt(hdcmem3,0,0,Fwidth,Fheight,hdcmem4,FImageCount*Fwidth,0,SRCAND);
          bitblt(hdcmem3,0,0,Fwidth,Fheight,hdcmem1,FImageCount*Fwidth,0,SRCPAINT);
          bitblt(HdcScreen,Fposx,Fposy,Fwidth,Fheight,hdcmem3,0,0,SRCCOPY);
        end;

(* then we move the modified part of the buffer to the screen *)
        setrect(BitbltRect2,Fposx,Fposy,Fposx+Fwidth,Fposy+Fheight);
        UnionRect(BitbltRect,BitbltRect1,BitbltRect2);
        result:=BitbltRect;

(* final cleanup *)
        DeleteDC(hdcmem1);
        DeleteDC(hdcmem3);
        DeleteDC(hdcmem4);
      end;   (* If transparent *)
     if (FCountTick mod FImageRef)=0 then begin
       inc(FimageCount);
       if FimageCount>Fimages then FimageCount:=0;
     end;
   end;   (* If mod =0 *)

   inc(FCountTick);

   case bounce of
     true: begin
           Dtop:= abs(DisplayRect.top-FClipRect.top)<=MinPixel;
           Dleft:= abs(DisplayRect.left-FClipRect.left)<=MinPixel;
           Dright:= abs(DisplayRect.right-FClipRect.right)<=MinPixel;
           Dbottom:=abs(DisplayRect.bottom-FClipRect.bottom)<=MinPixel;
           if Dtop then Fspeedy:=-Fspeedy;
           if Dleft then Fspeedx:=-Fspeedx;
           if Dright then Fspeedx:=-Fspeedx;
           if Dbottom then Fspeedy:=-Fspeedy;
           if (Dtop or Dleft or Dright or Dbottom)
                  and assigned(FOnBorderEvent) and FEventTrigger then begin
             FOnBorderEvent(self);
             FEventTrigger:=false; (* no more event until sprite is in cliprect again...*)
           end;
         end;
     false: if (not SpriteInPartial) and assigned(FOnBorderEvent) and FEventTrigger
         then begin
           FOnBorderEvent(self);
           FEventTrigger:=false; (* no more event until sprite is in cliprect again...*)
         end;
   end;   (*case *)
   if assigned (FOnEventRect) and FFirstEventRect then begin
     IntersectRect(BufRect,FEventRect,FSpriteRect);
     if equalrect(BufRect,FspriteRect) then begin
        FOnEventRect(self);
        FFirstEventRect:=false;
     end;
   end;
   FLastSpriteInPartial:=SpriteInPartial;
  end;

end.
