unit Umidi;


interface

uses
  Winprocs,wintypes,mmsystem,sysutils,ucompstr;

type
  TMidi = class(TCompressStream)
  private
    { Private declarations }
    DeviceId:integer;
    FTempFile:string;
    FResName: string;
    FAutoRepeat:boolean;
    procedure SetResName(const ResName:String);
  public
    { Public declarations }
    function Open:longint;
    function Play(fff,ttt:Longint):longint;
    function Close:longint;
    function ErrStr(i:integer):String;
    property MidiFile: string read FTempFile;
    property MidiRes: string read FResName write SetResName;
    destructor destroy;override;
    property AutoRepeat:boolean read FAutoRepeat write FAutoRepeat;
  end;

  Twave=class(TCompressstream)
    FResName:string;
    FTempFile: string;
    procedure SetResName(const ResName:String);
  public
    destructor destroy;override;
    procedure Play;
    property WavFile: string read FTempFile;
    property WavRes: string read FResName write SetResName;
  end;

implementation

  uses classes,usprite;

{ Tmidi }

destructor Tmidi.destroy;
begin
  if FTempFile<>'' then deletefile(FTempFile);
end;

procedure Tmidi.SetResName(const ResName:String);
var
  Mstream:TmemoryStream;
  Fstream:TFileStream;
  Temp: array[0..64] of char;

begin
  Mstream:=ResToStream(ResName);
  GetTempFileName('c','CardEng',0, Temp);
  FTempFile:=strpas(temp);   (* change default extension 'tmp' not accepted by midi player *)
  deletefile(FTempFile);
  FTempFile:= copy(FTempFile,0,length(FTempFile)-4)+'.mid';
  Fstream:=TfileStream.create(FTempFile,fmcreate);
  Mstream.position:=0;
  Fstream.copyfrom(Mstream,Mstream.size); (* create the file *)
  Fstream.free;
  Mstream.free;
end;


function Tmidi.Open:longint;
var
open_s:TMCI_OPEN_PARMS;
set_s:TMCI_SEQ_SET_PARMS;
a,b:array[0..128] of char;
begin
with open_s do
   begin
(*   lpstrDeviceType:=LPCSTR(MCI_DEVTYPE_SEQUENCER);
   lpstrDeviceType:=pchar(MCI_DEVTYPE_SEQUENCER); *)
   lpstrDeviceType:=strPcopy(b,'Sequencer');
   lpstrElementName:=StrPCopy(a,FTempFile);
   end;
with set_s do
   begin
   dwTimeFormat:=MCI_FORMAT_MILLISECONDS;
   end;
result:=mciSendCommand(0,MCI_OPEN,
                       MCI_OPEN_ELEMENT ,
                       longint(@open_s));   (* dword *)
(*                       MCI_OPEN_TYPE or MCI_OPEN_TYPE_ID or MCI_OPEN_ELEMENT, *)
DeviceId:=open_s.wDeviceId;
if result<>0 then begin
  MessageBox(0, 'MCI_OPEN failed', nil, mb_Ok);
  exit;
  end;
result:=mciSendCommand(DeviceId,MCI_SET,
                       MCI_SET_TIME_FORMAT,
                       longint(@set_s));   (* dword *)

if result<>0 then begin
    MessageBox(0, 'MCI_SET failed', nil, mb_Ok);
    self.close;
    end;
end;

function Tmidi.Play(fff,ttt:longint):longint;
var
play_s:TMCI_PLAY_PARMS;
begin
with play_s do
   begin
   dwFrom:=fff;
   dwTo:=ttt;
   dwcallback:=hwindow;
   end;
if FautoRepeat then result:=mciSendCommand( DeviceID,MCI_PLAY,MCI_FROM or MCI_NOTIFY ,
                        longint(@play_s))   (* dword *)
         else result:=mciSendCommand( DeviceID,MCI_PLAY,MCI_FROM,
                        longint(@play_s));   (* dword *)
end;

function Tmidi.Close:longint;
var
close_s:TMCI_GENERIC_PARMS;
begin
result:=mciSendCommand(DeviceId,MCI_CLOSE,
                       0,
                       longint(@close_s));     (* dword *)
end;

function Tmidi.ErrStr(i:integer):string;
var s:array [0..256] of char;
begin
if mciGetErrorString(i,s,256)=false then
   result:='Undefined error code'
else
   result:=strpas(s);
end;

{ Twave }

destructor Twave.destroy;
begin
  if FTempFile<>'' then deletefile(FTempFile);
end;

procedure Twave.SetResName(const ResName:String);
var
  Mstream:TmemoryStream;
  Fstream:TFileStream;
  Temp: array[0..64] of char;

begin
  Mstream:=ResToStream(ResName);
  GetTempFileName('c','CardEng',0, Temp);
  FTempFile:=strpas(temp);   (* change default extension 'tmp' to 'wav'*)
  deletefile(FTempFile);
  FTempFile:= copy(FTempFile,0,length(FTempFile)-4)+'.wav';
  Fstream:=TfileStream.create(FTempFile,fmcreate);
  Mstream.position:=0;
  Fstream.copyfrom(Mstream,Mstream.size); (* create the file *)
  Fstream.free;
  Mstream.free;
end;

procedure Twave.Play;
var
  Temp: array[0..64] of char;
begin
  SndPlaySound(strPcopy(Temp,FTempFile),SND_ASYNC);
end;

end.
