unit Ucompstr;

(* basic object to compress/decompress a file *)

interface

uses classes,winprocs,wintypes;

type
  TCompressStream = class(TObject)
  private
    FSignature: array[0..5] of Char;
  protected
    function ResToStream(ResName:string):TmemoryStream;
  public
    constructor Create; 
    procedure Compress(InStream, OutStream: TStream; InSize: LongInt);
    procedure DeCompress(InStream, OutStream: TStream);
  end;



implementation

uses
  LZRW1KH,sysutils,uerror,ucardmsg;

var InBuffer, OutBuffer: BufferArray;

{ TCompressStream }

constructor TCompressStream.Create;
begin
  FSignature := 'PHFX10';
end;

function TCompressStream.ResToStream(ResName:string):TmemoryStream;
var
   Rstream,Mstream:Tmemorystream;
   pc:array[0..20] of char;
   h:Thandle;
   p:pointer;
   fs:longint;

begin
  h:=findresource(hinstance,strPcopy(pc,resname),'ZZZ');
  if h=0 then FmtError(SCResMiss,[resname]);
  fs:=sizeofresource(hinstance,h);
  h:=loadresource(hinstance,h);
  p:=lockresource(h);
  Mstream:=Tmemorystream.create;
  try
    Mstream.writebuffer(p^,fs);
    Mstream.position:=0;
    Rstream:=Tmemorystream.create;
    DeCompress(Mstream, RStream);
    freeresource(h);
  finally
    Mstream.free;
  end;
  Result:=Rstream;
end;

procedure TCompressStream.Compress(InStream, OutStream: TStream; InSize: LongInt);

var CompressedSize, BytesRead, FinalPos, SizePos, TotalSize: LongInt;

begin
  TotalSize := 0;
  OutStream.WriteBuffer(FSignature, SizeOf(FSignature));
  SizePos := OutStream.Position;
  OutStream.WriteBuffer(TotalSize, SizeOf(TotalSize));
  while InSize > 0 do
  begin
    BytesRead := InStream.Read(InBuffer, SizeOf(InBuffer));
    CompressedSize := Compression(@InBuffer, @OutBuffer, BytesRead);
    OutStream.WriteBuffer(CompressedSize, SizeOf(CompressedSize));
    OutStream.WriteBuffer(OutBuffer, CompressedSize);
    TotalSize := TotalSize + CompressedSize + SizeOf(CompressedSize);
    InSize := InSize - BytesRead;
  end;
  FinalPos := OutStream.Position;
  OutStream.Position := SizePos;
  OutStream.WriteBuffer(TotalSize, SizeOf(TotalSize));
  OutStream.Position := FinalPos;
end;

procedure TCompressStream.DeCompress(InStream, OutStream: TStream);
var    CompressedSize, UnCompressedSize, InSize: LongInt;
       Sig: array[0..5] of Char;
begin
  InStream.ReadBuffer(Sig, SizeOf(FSignature));
  if Sig <> FSignature then begin
     messagebox(0,'Wrong file type',nil,MB_OK);
     halt;
  end;
  InStream.ReadBuffer(InSize, SizeOf(InSize));
  while InSize > 0 do
  begin
    InStream.ReadBuffer(CompressedSize, SizeOf(CompressedSize));
    InStream.ReadBuffer(InBuffer, CompressedSize);
    UnCompressedSize := DeCompression(@InBuffer, @OutBuffer, CompressedSize);
    OutStream.WriteBuffer(OutBuffer, UnCompressedSize);
    InSize := InSize - CompressedSize - SizeOf(CompressedSize);
  end;
end;


end.
