unit Ucardut;

interface

uses winprocs,wintypes,messages,classes,ucompstr,usprite;

type
  TBitmapType=(Normal,Mask,BlackBgd);
  TSimpleMmedia = class(TCompressStream)
    private
     Fhdc:Thandle;
     function ReadStreamDIB(Image: TMemoryStream;BitmapType:TbitmapType):Hbitmap;
    public
     constructor create(hdc:Thandle);
     function CreateBitmapRes(Resname:string;BitmapType:TbitmapType):hbitmap;
     function CreateBitmapFile(Filename:string;BitmapType:TbitmapType):hbitmap;
    end;

  TTrect=class
  public
    left: Integer;
    top: Integer;
    right: Integer;
    bottom: Integer;
  end;

{$IFDEF DEBUG}
const DebugOut:boolean=true;
{$ENDIF}

type
  TDebug=class
{$IFDEF DEBUG}
     procedure DisplayString(s:string);
     procedure DisplayInfo(Asprite:Tsprite);
{$ENDIF}
{$IFDEF DISPLAY}
     procedure DisplayFrame(hdc:thandle);
{$ENDIF}
  end;



var hwndlist: HWnd;


implementation

uses sysutils,Uerror,UcardMsg;

var      BufTickCount:Longint;


{ TUtil }



{ TDebug }

{$IFDEF DEBUG}
procedure TDebug.DisplayString(s:string);
var    zb:array[0..254] of char;
       Pzb:pchar;
       n:word;
begin
if Debugout then begin
  pzb:=strpcopy(zb,s);
  sendmessage(hwndlist,LB_ADDSTRING,0,longint(pzb)) ;
  n:=sendmessage(hwndlist,LB_GETCOUNT,0,0);
  if n>100 then n:=sendmessage(hwndlist,LB_DELETESTRING,0,0);
  sendmessage(hwndlist,LB_SETCURSEL,n-1,0);
end;
end;

procedure TDebug.DisplayInfo(Asprite:Tsprite);
var   s:string;
begin
if Debugout then begin
  try
   s:= 'left: '+inttostr(Asprite.posx)
               +' top: '+inttostr(Asprite.posy)
               +' right: '+inttostr(Asprite.posx+Asprite.width)
               +' bottom: '+inttostr(Asprite.posy+Asprite.height)
               +' sx: '+inttostr(Asprite.speedx)
               +' sy: '+inttostr(Asprite.speedy)+'        ';
  except
    on Einterror do s:='XXX';
  end;
  DisplayString(s);
 end;
end;
{$ENDIF}

{$IFDEF DISPLAY}
procedure TDebug.DisplayFrame(hdc:thandle);
var s:array[0..48] of char;
ps:pchar;
begin
  ps:=strpcopy(s,inttostr(GetTickCount-BufTickCount)+'ms          ');
  BufTickCount:=GetTickCount;
  textout(hdc,0,0,ps,strlen(ps));
end;
{$ENDIF}

{ TSimpleMmedia }

constructor TSimpleMmedia.create(hdc:Thandle);
begin
  inherited create;
  Fhdc:=hdc;
end;



function Tsimplemmedia.ReadStreamDIB(Image: TMemoryStream;
                                            BitmapType:TbitmapType):Hbitmap;
               (* this routine is from delphi Graphics unit. However this VCL unit add
                  so much overhead to your exe I could not use it *)
type PRGBQuad = ^TRGBQUAd;

var
  BC: TBitmapCoreHeader;
  BI: TBitmapInfoHeader;
  PBI: Pbitmapinfo;
  IWidth, IHeight: Integer;
  IMonochrome: Boolean;
  IDIBHeader, IDIBBits, IDIBrgbQuad: Pointer;
  Size: Integer;
  x:integer;
  hdcmem1:THandle;
  MaskColor:TColorRef;
  BytePix:byte;

     function GetDInColors(BitCount: Word): Integer;
       begin
         case BitCount of
           1, 4, 8: Result := 1 shl BitCount;
         else
           Result := 0;
         end;
       end;

     procedure CreateMaskRGB(IDBRGBquad:pointer;Nbr:Integer;MaskColor:TColorRef);
     var i:integer;
       begin
         for i:=0 to nbr-1 do
           with PRGBQuad(Longint(IDBRGBQuad)+i*sizeof(TrgbQuad))^ do
              if RGB(rgbRed,rgbGreen,rgbBlue)= MaskColor then begin
                rgbRed:=$FF;
                rgbGreen:=$FF;
                rgbBlue:=$FF
              end else begin
                rgbRed:=0;
                rgbGreen:=0;
                rgbBlue:=0;
              end;
       end;

     procedure CreateBgdRGB(IDBRGBquad:pointer;Nbr:Integer;MaskColor:TColorRef);
     var i:integer;
       begin
         for i:=0 to nbr-1 do
           with PRGBQuad(Longint(IDBRGBQuad)+i*sizeof(TrgbQuad))^ do
              if RGB(rgbRed,rgbGreen,rgbBlue)= MaskColor then begin
                rgbRed:=0;
                rgbGreen:=0;
                rgbBlue:=0;
              end;
       end;


begin
  result:=0;
  IDIBHeader := Image.Memory;
  Image.Read(Size, SizeOf(Size));
  Image.Seek(-SizeOf(Size), 1);
  if Size = SizeOf(BC) then
  begin        (* this is the OS/2 format  *)
    Image.Read(BC, SizeOf(BC));
    IHeight := BC.bcHeight;
    IWidth := BC.bcWidth;
    IMonochrome := (BC.bcPlanes = 1) and (BC.bcBitCount = 1);
    IDIBBits := Pointer(Longint(IDIBHeader) + Sizeof(BC) +
      GetDInColors(BC.bcBitCount) * SizeOf(TRGBTriple));
  end
  else if Size = SizeOf(BI) then
  begin
    Image.Read(BI, SizeOf(BI));
    IHeight := BI.biHeight;
    IWidth := BI.biWidth;
    IMonochrome := (BI.biPlanes = 1) and (BI.biBitCount = 1);
    if BI.biClrUsed = 0 then
           BI.biClrUsed := GetDInColors(BI.biBitCount);
    IDIBBits := Pointer(Longint(IDIBHeader) + sizeof(BI) +
           BI.biClrUsed * SizeOf(TRgbQuad));
    IDIBrgbQuad := Pointer(Longint(IDIBHeader) + sizeof(BI) );

  (* we look for lower left corner pixel color and we  assume this is
     the background color. We then build a mask by changing it to white. All
     other color entry are changed to black *)

       BytePix:=PByte(IDIBBits)^;         (* read a byte *)
       case BI.BiBitCount of               (* get to the first pixel *)
         1: BytePix:= BytePix shr 7;
         4: BytePix:= BytePix shr 4;
         8: ;
       end;
      with PrgbQuad(Longint(IDIBrgbQuad)+ BytePix*sizeof(TRgbQuad))^ do
             MaskColor:=rgb(rgbred,rgbgreen,rgbblue);
    case BitmapType of
       mask: CreateMaskRGB(IDIBrgbQuad,BI.biClrUsed,MaskColor);
       Blackbgd: CreateBgdRGB(IDIBrgbQuad,BI.biClrUsed,MaskColor);
    end;
  end
  else exit;
  result:=CreateDIBitmap(Fhdc,Pbitmapinfoheader(IDIBheader)^,CBM_INIT,
                Idibbits,Pbitmapinfo(IDIBheader)^,DIB_RGB_COLORS);
end;



function Tsimplemmedia.CreateBitmapRes(ResName:string;BitmapType:TbitmapType):hbitmap;
var
   bmfh:TBITMAPFILEHEADER;
   dwdibsize,dwoffset,dwheadersize:longint;
   wdibread:word;
   Rstream:Tmemorystream;
   Mstream:Tmemorystream;
   pc:array[0..20] of char;

   h:Thandle;
   p:pointer;
   fs:integer;


begin
  result:=0;
  try
    Rstream:=ResToStream(Resname);   (* decompress resource and transfer to a stream *)
    Rstream.position:=0;
    if Rstream.read(bmfh,sizeof(Tbitmapfileheader))<>sizeof(Tbitmapfileheader) then
                                        (* read the header *)                     exit;
    if bmfh.bftype<>$4D42 then exit;
    dwdibsize:=bmfh.bfsize-sizeof(Tbitmapfileheader);

    Mstream:=Tmemorystream.create;  (* copy the bitmap itself to a new stream *)
    try
      if Mstream.copyfrom(Rstream,dwdibsize)<>dwdibsize then exit;

      Mstream.position:=0;
      result:=readstreamDIB(Mstream,BitmapType);  (* generate a window bitmap *)
    finally
      Mstream.free;
    end;
  finally
    Rstream.free;
  end;
end;

function Tsimplemmedia.CreateBitmapFile(Filename:string;BitmapType:TbitmapType):hbitmap;
var
   bmfh:TBITMAPFILEHEADER;
   dwdibsize,dwoffset,dwheadersize:longint;
   wdibread:word;
   Rstream:Tfilestream;
   Mstream:Tmemorystream;
   pc:array[0..20] of char;

   h:Thandle;
   p:pointer;
   fs:integer;


begin
  result:=0;
  try
    Rstream:=TfileStream.create(FileName, FmopenRead);
    Rstream.position:=0;
    if Rstream.read(bmfh,sizeof(Tbitmapfileheader))<>sizeof(Tbitmapfileheader) then
                                        (* read the header *)                     exit;
    if bmfh.bftype<>$4D42 then exit;
    dwdibsize:=bmfh.bfsize-sizeof(Tbitmapfileheader);

    Mstream:=Tmemorystream.create;  (* copy the bitmap itself to a new stream *)
    try
      if Mstream.copyfrom(Rstream,dwdibsize)<>dwdibsize then exit;

      Mstream.position:=0;
      result:=readstreamDIB(Mstream,BitmapType);  (* generate a window bitmap *)
    finally
      Mstream.free;
    end;
  finally
    Rstream.free;
  end;
end;



end.
