unit userpar;

{ This file is containing all the code that needs to be modified to create
a new postcard.


}

interface

uses Winprocs,Wintypes,Usprite,Uscroll,Uscreen;

type
TEventClass=class
  public
    procedure BorderEvent(Sender:Tobject);
              (* Event fired  when sprite moves out of the window or bounces  *)
    procedure EndValidEvent(Sender:Tobject);
              (* event fired  when a graph exits a non valid period *)
    procedure BeginValidEvent(Sender:Tobject);
              (* event fired  when a graph enters a non valid period *)
    procedure ScreenEnds(Sender:Tobject);
              (* event fires when a screen ends *)
    procedure EventRect(Sender:Tobject);
  end;

const AppName = 'CardEng';               (* Window Title *)
      WndTitle = '            >>>>>>> Press a key';     (* Window Title *)
      XWindowPos=200;          (* Window position on screen *)
      YWindowPos=0;

var   Anim:Tanim;
      EventClass:TEventClass;

procedure Createparams(hdc:Thandle);
procedure FreeAll;

implementation

uses Ucardut,Uerror,UcardMsg,mmsystem,umidi;

var  Screen1,Screen2,screen3:Tscreen;
     cat31,cat32,cat33,cat13,cat2,cat22,catpaws:Tsprite;
     Text1:TScroll;
     Wave1:TWave;



procedure TEventClass.BorderEvent(Sender:Tobject);

(* Event fires  when sprite moves out of the window or bounces*)

begin
  with sender as Tsprite do begin
    wave1.play;
  end;
end;

procedure TEventClass.EndValidEvent(Sender:Tobject);
begin
  with sender as TGraph do;
end;

procedure TEventClass.BeginValidEvent(Sender:TObject);
begin
  with sender as TGraph do;
end;

procedure TEventClass.ScreenEnds(Sender:Tobject);
begin
  with sender as Tscreen do ;
end;

procedure TEventClass.EventRect;
begin
end;

procedure Createparams(hdc:Thandle);
begin
  Anim.AutoRepeat:=true;                (* Restart the animation when finished *)
  EventClass:=TeventClass.create;       (* Create the event Handler objest as an event*)
                                         (*          need to be object's methods      *)

  Wave1:=TWave.create;
  wave1.WavRes:='BLIP';


Screen1:=TScreen.create('BACK1','BIRTHDAY',false,0);
  with Screen1.GraphMng do begin
    OnBeginValidEvent:=EventClass.BeginValidEvent;
    OnEndValidEvent:=EventClass.EndValidEvent;
    OnborderEvent:=EventClass.BorderEvent;
  end;

 Screen2:=TScreen.create('BACK2','BOHEMIAN',false,0);
  with Screen2.GraphMng do begin
    OnBeginValidEvent:=EventClass.BeginValidEvent;
    OnEndValidEvent:=EventClass.EndValidEvent;
    OnborderEvent:=EventClass.BorderEvent;
  end;

 Screen3:=TScreen.create('BACK1','BIRTHDAY',false,0);
  with Screen3.GraphMng do begin
    OnBeginValidEvent:=EventClass.BeginValidEvent;
    OnEndValidEvent:=EventClass.EndValidEvent;
    OnborderEvent:=EventClass.BorderEvent;
  end;


  Cat31:=Tsprite.CreateFmRes('CAT31',transparent,Compressed,7,hdc);
  with cat31 do begin
    bounce:=true;
    posx:=10;
    posy:=50;
    speedx:=10;
    speedy:=10;
    ImageRefresh:=3;
  end;

  Cat32:=Tsprite.CreateFmRes('CAT31',transparent,Compressed,7,hdc);
  with cat32 do begin
    posx:=100;
    posy:=50;
    ImageRefresh:=3;
  end;

  Cat33:=Tsprite.CreateFmRes('CAT31',transparent,Compressed,7,hdc);
  with cat33 do begin
    posx:=200;
    posy:=50;
    ImageRefresh:=3;
  end;

   Text1:=TScroll.create(hdc,'Times New Roman',38,rgb(0,0,$FF),50,200,300,150);
 with text1 do begin
    Scroll:=-2;
    strings.add('');
    strings.add('');
    strings.add('');
    strings.add('Joyeux Anniversaire ');
    strings.add('Michle');
    strings.add('De la part de: ');
    strings.add('Paul-henri');
    strings.add('Et');
    strings.add('Maud');
  end;


  Screen3.GraphMng.AddGraph(cat33);
  Screen3.GraphMng.AddGraph(cat31);
  Screen2.GraphMng.AddGraph(text1);
  Screen1.GraphMng.AddGraph(Cat31);

  Anim.AddScreen(Screen1,hdc);
  Anim.AddScreen(Screen2,hdc);
  Anim.AddScreen(Screen3,hdc);

 { Cat2:=Tsprite.CreateFmRes('CATPAWS',transparent,Compressed,23,hdc);
  Screen2.GraphMng.AddGraph(Cat2);
  with cat2 do begin
    Nonvalid.add(TNonValidPeriod.create(time1,1000000));
    posx:=0;
    posy:=300;
    ImageRefresh:=5;
  end;

  Cat13:=Tsprite.CreateFmRes('CAT13',transparent,Compressed,1,hdc);
  Screen2.GraphMng.AddGraph(Cat13);
  with cat13 do begin
    bounce:=true;
    speedx:=10;
    speedy:=10;
    posx:=120;
    posy:=200;
    ImageRefresh:=50;
  end;


  Cat22:=Tsprite.CreateFmRes('CAT22',transparent,Compressed,1,hdc);
  Screen3.GraphMng.AddGraph(Cat22);
  with cat22 do begin
    (*Nonvalid.add(TNonValidPeriod.create(time1,1000000));*)
    posx:=330;
    posy:=450;
    ImageRefresh:=5;
  end;

  {Star2:=Tsprite.CreateFmRes('STAR',transparent,Compressed,1,hdc);
  Screen3.GraphMng.AddGraph(Star2);
  with Star2 do begin
    bounce:=true;
    posx:=300;
    posy:=300;
    Speedx:=-10;
    speedy:=-10;
    ImageRefresh:=1;
  end;

  Star3:=Tsprite.CreateFmRes('STAR',transparent,Compressed,1,hdc);
  Screen3.GraphMng.AddGraph(Star3);
  with  Star3 do begin
    bounce:=true;
    posx:=500;
    posy:=400;
    Speedx:=-10;
    speedy:=-5;
    ImageRefresh:=1;
  end;

  Star4:=Tsprite.CreateFmRes('STAR',transparent,Compressed,1,hdc);
  Screen3.GraphMng.AddGraph(Star4);
  with Star4 do begin
    bounce:=true;
    posx:=300;
    posy:=300;
    Speedx:=10;
    speedy:=-5;
    ImageRefresh:=1;
  end;

 SpriteWolf:=Tsprite.CreateFmRes('WOLF',transparent,Compressed,6,hdc);
 Star1.GraphMng.AddGraph(SpriteWolf);
  with  SpriteWolf do begin
    bounce:=false;
    reversed:=true;
    posx:=0;
    posy:=50;
    Speedx:=10;
    Speedy:=0;
    ImageRefresh:=2;
  end;

  SpriteSanta:=Tsprite.CreateFmRes('SCLAUS',transparent,Compressed,9,hdc);
  Screen1.GraphMng.AddGraph(SpriteSanta);
  with SpriteSanta do begin
   (* Nonvalid.add(TNonValidPeriod.create(10000,13000));
    Nonvalid.add(TNonValidPeriod.create(20000,1000000)); *)
    reversed:=true;
    bounce:=true;
    posx:=100;
    posy:=0;
    Speedx:=-10;
    speedy:=10;
    ImageRefresh:=2;
  end;
 Mouse:=Tsprite.CreateFmRes('MOUSE',transparent,Compressed,20,hdc);
 GraphMng.AddGraph(Mouse);
  with  Mouse do begin
    bounce:=true;
    reversed:=true;
    posx:=0;
    posy:=340;
    Speedx:=5;
    Speedy:=0;
    ImageRefresh:=1;
  end;
 Worker:=Tsprite.CreateFmRes('WORKER',transparent,Compressed,10,hdc);
 GraphMng.AddGraph(Worker);
  with Worker do begin
    Displayed:=false;
    (*NonValid.add(TNonValidPeriod.create(5000,10000));
    NonValid.add(TNonValidPeriod.create(15000,20000));
    NonValid.add(TNonValidPeriod.create(25000,1000000));*)
    posx:=300;
    posy:=200;
    ImageRefresh:=1;
  end; }
end;

procedure FreeAll;
begin
  EventClass.free;
  wave1.free;
end;

end.
