unit Uscroll;

interface

(* An object to scroll text*)
uses wintypes,winprocs,classes,usprite;

type

TScroll=class(TGraph)
private
  FScroll:integer;   (* scroll speed in pixels per frame *)
  Fstrings:Tstringlist;
  FFont:Thandle;
  FCychar:integer;
  Ftextrect:Trect;
  FFontColor:Tcolorref;
  FDrawy:integer;
  procedure TextOutEnd(hdc:thandle;iniy:integer);
public
  constructor Create(hdc:Thandle;FontName:string;FontSize:integer;FontColor:TColorref;
                            left,top,RectWidth,RectHeight:integer);
  destructor destroy; override;
  function DrawGraph(hdc:Thandle):Trect; override;
  property Scroll:integer read FScroll write FScroll;
  property Strings:Tstringlist read Fstrings write Fstrings;
end;



implementation

uses sysutils;

{ TScroll }

constructor TScroll.Create(hdc:Thandle;FontName:string;FontSize:integer;FontColor:TColorref;
                            left,top,RectWidth,RectHeight:integer);
var   tm:TTextMetric;
      s:array[0..128] of char;

begin
  inherited create;
  posx:=left;
  posy:=top;
  FDrawy:=posy;
  width:=RectWidth;
  Height:= RectHeight;
  SetRect(Ftextrect,left,top,left+RectWidth,top+RectHeight);
  Fstrings:=Tstringlist.create;
  Ffont:=createfont(FontSize,0,0,0,FW_THIN,1,0,0,0,0,0,0,0,strPcopy(s,FontName));
  selectObject(hdc,Ffont);
  GetTextMetrics(hdc,tm);
  Fcychar:=tm.tmheight+tm.tmexternalleading;
  FFontColor:=FontColor;
end;

destructor TScroll.destroy;
begin
    FStrings.free;
    deleteObject(Ffont)
end;

function TScroll.DrawGraph(hdc:Thandle):Trect;
var k:integer;
    inc:integer;
begin
  SetTextColor(hdcscreen,FFontColor);  (* set text color *)
  Setbkmode(hdcscreen,wintypes.TRANSPARENT);  (* transparent bckgnd *)
  SetTextAlign(hdcscreen,TA_CENTER);     (* centers text *)
  selectObject(hdcscreen,Ffont);
  Fdrawy:=Fdrawy+scroll;
  inc:=Fcychar*FStrings.count;
  with FtextRect do begin
    if FDrawy+inc<top then  FDrawy:= FDrawy+inc;
    if FDrawy>bottom then FDrawy:= FDrawy-inc;
  end;
  k:=FDrawy;
  while k<FTextRect.bottom do begin
    TextOutEnd(hdcscreen,k);
    k:=k+inc;
  end;
  k:=FDrawy-inc;
  while k+inc>FTextRect.top do begin
    TextOutEnd(hdcscreen,k);
    k:=k-inc;
  end;
  result:=FtextRect;
end;

procedure TScroll.TextOutEnd(hdc:thandle;iniy:integer);
var i: integer;
    a: array[0..254] of char;
begin
        for i:=0 to FStrings.count-1 do begin
          strPcopy(a,Fstrings[i]);
          with Ftextrect do
             ExtTextOut(hdc,(left+right)div 2,iniy+Fcychar*(i),ETO_CLIPPED,@Ftextrect,a,strlen(A),nil);
        end;
end;

end.
