unit Uscreen;
                           
interface

uses  classes,wintypes,winprocs,Umidi,Usprite,messages;

Type

TScreen=class
private
  FBackgroundRes: String;
  FMidiRes:string;
  Fmidirepeat:boolean;  (* if true midi files will repeat until sceen ends *)
  FBitmapWindow: hbitmap;
  FBitmapWindowBgd: hbitmap;
  Fmidi:Tmidi;
  FGraphMng:TGraphMng;
  FDuration:longint;    (* screen duration in ms, if O wait for  key pressed *)
protected
  procedure Open(hdc:Thandle);
  procedure Close;
  procedure Redrawscreen(hdc:Thandle);
public
  constructor create(Backgroundres,Midires:string; Midirepeat:boolean;Duration:Longint);
  destructor destroy;override;
  property BitmapWindow:Hbitmap read FBitmapWindow;
  property BitmapWindowBgd:Hbitmap read FBitmapWindowBgd;
  property Duration:longint read FDuration;
  property GraphMng:TgraphMng read FGraphMng write FGraphMng;
  property Midi:Tmidi read Fmidi;
  property MidiRepeat:boolean read FMidiRepeat;
end;

TAnim=class
private
  FFirstOpen:boolean;
  FOnScreenEnds:TNotifyEvent;
  FAutorepeat,FKeyPressed:boolean;
  FList:Tlist;   (* A list of all screens *)
  FActive:integer;
  function GetKeyPressed:boolean;
protected
  procedure NextActive(hdc:Thandle);
  procedure FirstActive(hdc:Thandle);
public
  constructor create;
  procedure RunAnimation(hdc:Thandle);
  procedure AddScreen(Ascreen:TScreen;hdc:Thandle);
  destructor destroy;override;
  property Autorepeat:boolean read FAutorepeat write FAutorepeat;
      (* if true animation will start again with screen otherwise 0 it will stay with
         the last screen forever *)
  property OnScreenEnds:TNotifyEvent read FonScreenEnds write FonScreenEnds;
  property List:Tlist read FList;
  property Active:integer read Factive;
  property KeyPressed:boolean read GetKeyPressed write FKeyPressed;
end;


implementation

uses sysutils,Uerror,UcardMsg,UCardut,Userpar;

const   DontCare = 0;


{ TAnim }

constructor TAnim.create;
begin
  Flist:=Tlist.create;
  FActive:=0;
  FKeyPRessed:=false;
  FFirstOpen:=true;
end;

function TAnim.GetKeyPressed:boolean;
begin
  result:=FKeyPressed;
  FKeyPressed:=false;
end;

procedure TAnim.NextActive(hdc:Thandle);
begin
  Tscreen(Flist[FActive]).Close;
  FActive:=FActive+1;
  Tscreen(Flist[FActive]).Open(hdc);
end;

procedure TAnim.FirstActive(hdc:Thandle);
begin
  Tscreen(Flist[FActive]).Close;
  FActive:=0;
  Tscreen(Flist[0]).Open(hdc);
end;


procedure TAnim.RunAnimation(hdc:Thandle);
var i:integer;
begin
  with TScreen(FList[Factive]) do begin
    redrawscreen(hdc);
    if (KeyPressed and (duration=0)) or
       (((GetTickCount-StartTickCount)>duration) and (duration<>0)) then begin
      if assigned(FOnScreenEnds) then FOnScreenEnds(TScreen(FList[Factive]));
      if Factive+1>FList.count-1 then  begin
           if FAutorepeat then FirstActive(hdc);
           StartTickCount:=GetTickCount;
      end else NextActive(hdc);
    end;
  end;
end;

procedure TAnim.AddScreen(Ascreen:TScreen;hdc:Thandle);
begin
  Flist.add(Ascreen);
  if Flist.count=1 then AScreen.open(hdc);
end;

destructor TAnim.destroy;
var i:integer;
begin
  Tscreen(Flist[FActive]).close;  (* close active Tscreen *)
  with Flist do for i:=0 to count-1 do TScreen(FList[i]).free;
  FList.free;
end;

{ TScreen }

constructor TScreen.create(BackgroundRes,MidiRes:string; Midirepeat:boolean;Duration:Longint);
begin
  FDuration:=Duration;
  FGraphMng:=TGraphMng.create;
  FBackgroundRes:=BackgroundRes;
  FMidiRes:=MidiRes;
  FBitmapWindow:=1;
  FmidiRepeat:=MidiRepeat;
end;

procedure TScreen.Redrawscreen(hdc:Thandle);
begin
 FGraphMng.RedrawScreen(hdc);
end;


procedure TScreen.Open(hdc:Thandle);
var  ClientRect:Trect;
     rr:integer;
begin;

  (* Midi inialization *)
  if FMidiRes<>'' then begin
    FMidi:=Tmidi.create;
    FMidi.autorepeat:=FMidiRepeat;
    FMidi.MidiRes:=FmidiRes;;
    rr:=FMidi.open;
    if rr<>0 then FmtError(SCMidiOpen,[FMidi.errstr(rr)]);
    rr:=FMidi.play(1,DontCare);
    if rr<>0 then FmtError(SCMidiOpen,[FMidi.errstr(rr)]);
  end;

   (* Background inialization *)
  StartTickCount:=GetTickCount;
  with TsimpleMmedia.create(hdc) do begin
    FBitmapWindow:=CreateBitmapRes(FBackGroundRes,normal);
    FBitmapWindowBgd:=CreateBitmapRes(FBackGroundRes,normal);
    free;
  end;
{$IFDEF  DEBUG}
     with TDebug.create do begin
       displaystring('create hdc:  '+inttostr(hdc));
       displaystring('create bitmap:  '+inttostr(FBitmapWindow));
       displaystring('create bitmap bgd:  '+inttostr(FBitmapWindowBgd));
       free;
     end;
{$ENDIF}

    (* resizewindow according to background *)

  getobject(FBitmapWindow,sizeof(TBITMAP),@Bs);
  clientrect:=classes.rect(50,50,50+bs.bmwidth,50+bs.bmheight);
  AdjustWindowRect(clientrect,ws_OverlappedWindow,false);
  with ClientRect do MoveWindow(hWindow,XWindowPos,YWindowPos,right-left,bottom-top,true);
  if Anim.FFirstOpen then begin
    ShowWindow(hWindow, CmdShow);
    Anim.FFirstOpen:=false;
  end else begin
    invalidaterect(hwindow,nil,true);  (* this will place a wm_paint message in the queue *)
  end;
end;

procedure TScreen.Close;
begin
  SelectObject(HdcScreen,LastObj1);   (* mandatory for win31 *)
  SelectObject(hdcBgdRef,LastObj2);
  DeleteObject(FBitmapWindow);
  DeleteObject(FBitmapWindowBgd);
  Fmidi.close;
  Fmidi.free;
end;

(*function TScreen.GetMidiRepeat:boolean;
begin
  if Fmidi<>nil then Result:=Fmidi.autorepeat;
end;    *)

destructor Tscreen.destroy;
begin
 FGraphMng.free;
end;

end.
