unit Uerror;


interface

procedure Error(ErrorCode:longint);
procedure FatalError(ErrorCode:longint);
procedure FmtError(ErrorCode:longint;const Args: array of const);
procedure FmtFatalError(ErrorCode:longint;const Args: array of const);
procedure Showmemory;

implementation

uses winprocs,wintypes,sysutils;

const SErrorLen=64;

procedure Showmemory;
var   s:array[0..127] of char;
begin
  strPcopy(s,'free glopal space: '+inttostr(getfreespace(0))+' bytes'#13
              +'free system resources: '+
                 inttostr(Getfreesystemresources(GFSR_SYSTEMRESOURCES))+'%'#13
              +'free user resources: '+
                 inttostr(Getfreesystemresources(GFSR_GDIRESOURCES))+'%'#13
              +'free GDI resources: '+
                 inttostr(Getfreesystemresources(GFSR_USERRESOURCES))+'%');
  MessageBox(0,s,'Info', mb_Ok);
end;


procedure Error(ErrorCode:longint);
var s:array[0..SErrorLen] of char;
begin
  if LoadString(hinstance,ErrorCode,s,SErrorLen)=0 then
                       strPcopy(s,'Error: '+inttostr(ErrorCode));
  MessageBox(0,s,'CardEng Error', mb_Ok);
end;

procedure FatalError(ErrorCode:longint);
begin
  Error(ErrorCode);
  halt;
end;

procedure FmtError(ErrorCode:longint;const Args: array of const);
var s:array[0..SErrorLen] of char;
begin
  if LoadString(hinstance,ErrorCode,s,SErrorLen)=0 then
            strPcopy(s,'Error: '+inttostr(ErrorCode))
            else strPcopy(s,FmtLoadStr(ErrorCode,Args));
  MessageBox(0,s,'CardEng Error', mb_Ok);
end;

procedure FmtFatalError(ErrorCode:longint;const Args: array of const);
begin
  FmtError(ErrorCode,Args);
  halt;
end;

end.
