program Cardeng;

(*

*)

{$R CARDRES.RES}

uses
  Winprocs,
  Wintypes,
  Messages,
  SysUtils,
  UCardMsg in 'UCARDMSG.PAS',
  Ucardut in 'UCARDUT.PAS',
  Uerror in 'UERROR.PAS',
  Umidi in 'UMIDI.PAS',
  Usprite in 'USPRITE.PAS',
  classes,
  LZRW1KH in 'LZRW1KH.PAS',
  mmsystem,
  Uscreen in 'USCREEN.PAS',
  Uscroll in 'USCROLL.PAS' {$IFDEF  STRESS},
  Stress in 'STRESS.PAS' {$ENDIF},
  Userpar in 'USERPAR.PAS';

var
  AMessage: TMsg;
  Hdcmain: Thandle;
  i:integer;
  htimer:word;
  ps:Tpaintstruct;
{$IFDEF  DEBUG}
  Arect:Trect;
{$ENDIF}




function WindowProc(Window: HWnd; AMessage, WParam:integer;
                    LParam: Longint): Longint; export;

var   hdc1,hdc2:Thandle;
      hdcpaint:Thandle;

begin
  WindowProc := 0;

  case AMessage of

    WM_CREATE: begin
    end;  (* WM_CREATE *)

    WM_DESTROY: begin
      KillTimer(hwindow,ID_TIMER);
      PostQuitMessage(0);
      Exit;
    end; (* WM_DESTROY *)

    WM_PAINT: begin        (* copy active background to the screen *)
     hdc1:=BeginPaint(window,ps);
     hdcpaint:=CreateCompatibleDC(hdc1);
     SelectObject(hdcpaint,Tscreen(anim.list[anim.active]).BitmapWindow);
     bitblt(hdc1,0,0,bs.bmwidth,bs.bmheight,hdcpaint,0,0,SRCCOPY);
     deleteDC(hdcpaint);
     EndPaint(window,ps);
    end;  (* WM_PAINT *)

    WM_KEYDOWN: begin
      Anim.KeyPressed:=true;
    end;

    MM_MCINOTIFY: begin
      if TScreen(Anim.List[Anim.Active]).MidiRepeat  and  (wparam =MCI_NOTIFY_SUCCESSFUL )
             then TScreen(Anim.List[Anim.Active]).Midi.play(DontCare,DontCare);
    end;

   WM_TIMER:
    begin

     Hdc2:=GetDc(window);
{$IFDEF  DISPLAY}
     with Tdebug.create do displayframe(Hdc2);
{$ENDIF}
     HdcScreen:=CreateCompatibleDC(hdc2);
     Lastobj1:=SelectObject(HdcScreen,TScreen(Anim.List[Anim.Active]).BitmapWindow);
     hdcBgdRef:=CreateCompatibleDC(hdc2);
     LastObj2:=SelectObject(hdcBgdRef,TScreen(Anim.List[Anim.Active]).BitmapWindowBgd);
     (* killtimer(hwindow,id_timer);      to use the integrated delphi debugger  *)
     Anim.RunAnimation(hdc2);
     (*SetTimer(hwindow,ID_TIMER,TimerPeriod*20,nil); *)

     deleteDC(HdcScreen);
     deleteDC(hdcBgdRef);
     ReleaseDC(window,hdc2);
     end; (* WM_TIMER *)
  end; (* case *)

  WindowProc := DefWindowProc(Window, AMessage, WParam, LParam);
end;

{ Register the Window Class }
function WinRegister: Boolean;
var
  WindowClass: TWndClass;
  A: array [0..23] of char;
begin
  WindowClass.Style := cs_hRedraw or cs_vRedraw;
  WindowClass.lpfnWndProc := @WindowProc;
  WindowClass.cbClsExtra := 0;
  WindowClass.cbWndExtra := 0;
  WindowClass.hInstance := HInstance;
(*  WindowClass.hIcon := LoadIcon(0, idi_Application);  default window icon*)
  WindowClass.hIcon := LoadIcon(hinstance, 'myicon');
  WindowClass.hCursor := LoadCursor(0, idc_Arrow);
  WindowClass.hbrBackground := getstockobject(WHITE_BRUSH);
  WindowClass.lpszMenuName := nil;
  WindowClass.lpszClassName := AppName;

  Result := winprocs.RegisterClass(WindowClass);
end;

{ Create the Window Class }
function WinCreate: HWnd;
var
  hWindow: HWnd;

begin
  hWindow := CreateWindow(AppName,WndTitle,
              ws_overlapped or ws_sysmenu or ws_thickframe,cw_UseDefault, cw_UseDefault,
              cw_UseDefault, cw_UseDefault, 0, 0, HInstance, nil);


  Result := hWindow;
end;

begin
  (*showmemory;*)
  if not Winregister then FatalError(SCWinRegister);
  hwindow:=WinCreate;
  if Hwindow=0 then FatalError(SCWinCreate);

{$IFDEF  DEBUG}
  hwdebug := CreateWindow(AppName,'debug',
              ws_overlappedwindow, 0, 200,
              500, 300, 0, 0, HInstance, nil);
  ShowWindow(hwdebug, CmdShow);
  getclientrect(hwdebug,arect);


 with arect do hwndlist:= createwindow('LISTBOX',nil,
               WS_CHILD or WS_VISIBLE or WS_VSCROLL,
               0,0,right,bottom,
               hwdebug,1,
               hinstance,nil);
 setfocus( hwindow);
{$ENDIF}


  hdcmain:=GetDc(hwindow);

{$IFDEF  STRESS}
(* stress testing *)
  (*if not AllocGDImem(1000) then error(100);*)
  if not AllocMem(500000) then Error(100);
  (*if not AllocUserMem(2000) then Error(100);*)
{$ENDIF}

(* params initialization *)

  Anim:=TAnim.create;                         (* Main animation object*)
  CreateParams(hdcmain);
  Anim.OnScreenEnds:=EventClass.ScreenEnds;

(* Windows init *)

 if SetTimer(hwindow,ID_TIMER,TimerPeriod,nil)=0 then Error(SCCreateTimer); 


  UpdateWindow(hwindow);
  releaseDC(hwindow,hdcmain);

(* initialisation ends here *)

(* Main window loop *)

  while GetMessage(AMessage, 0, 0, 0) do begin
    TranslateMessage(AMessage);
    DispatchMessage(AMessage);
  end;

(* final clean-up *)
  KillTimer(hwindow,ID_TIMER);
  Anim.free;
  FreeAll;
{$IFDEF  STRESS}
  (*FreeAllGDIMem;*)
  FreeAllMem;
  (*FreeAllUserMem;*)
{$ENDIF}
  (*showmemory;*)
  Halt(AMessage.wParam);
end.


