unit dbbxlbl;

// This code is provided as is with no warranty.  I will make additions
// and corrections as time permits.  Feel free to drop me a line if
// you want something added.

// New versions will be posted on the web at the
// Tangent Technologies, Inc WEB page at
// www.mindspring.com/~tti

// Have Fun!
// Nick Hustak
// President, Tangent Technologies, Inc
// TTI@mindspring.com
// www.mindspring.com/~tti
// 770-427-2118
// CSERVE: 72134,123
// President, Atlanta Delphi Developers Group
// www.mindspring.com/~addg

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  BoxLabl, DB, DBTables;

type
  TDBBoxLabel = class(TCustomBoxLabel)
  private
    { Private declarations }
    FDataLink: TFieldDatalink;
    procedure DataChange(Sender: TObject);
    function GetDataField: string;
    function GetDataSource: TDataSource;
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
  protected
    { Protected declarations }
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
    function GetLabelText: String; override;
  public
    { Public declarations }
  published
    { Published declarations }
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    constructor Create( AOwner:TComponent ); override;
    destructor Destroy; override;

    property Alignment;
    property HorizontalAlign;
    property TextBorder;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property Align;
    property Enabled;
    property Font;
    property Color;
    property DragCursor;
    property DragMode;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property PopUpMenu;
    property ParentFont;
    property ParentShowHint;
    property ParentColor;
    property Width;
    property Height;
    property WordWrap;
    property BorderStyle;
    property Decimals;
  end;

procedure Register;

implementation

constructor TDBBoxLabel.Create( AOwner:TComponent );
begin
inherited Create( AOwner );
FDatalink := TFieldDatalink.Create;
FDataLink.OnDataChange := DataChange;
FDataLink.ReadOnly := True;
end;

destructor TDBBoxLabel.Destroy; 
begin
FDataLink.Free;
FDataLink := nil;
inherited Destroy;
end;

procedure TDBBoxLabel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;

function TDBBoxLabel.GetDataField: string;
begin
Result := FDataLink.FieldName;
end;

procedure TDBBoxLabel.SetDataField(const Value: string);
begin
FDataLink.FieldName := Value;
end;

function TDBBoxLabel.GetDataSource: TDataSource;
begin
Result := FDataLink.DataSource;
end;

procedure TDBBoxLabel.SetDataSource(Value: TDataSource);
begin
FDataLink.DataSource := Value;
end;

procedure TDBBoxLabel.DataChange(Sender: TObject);
begin
Invalidate;
end;

function TDBBoxLabel.GetLabelText: string;
begin
if FDataLink.Field <> nil then
  Result := FDataLink.Field.DisplayText
else
  begin
  if ( csDesigning in ComponentState ) then
    Result := Name
  else
    Result := '';
  end;
end;

//***********************************************************************

procedure Register;
begin
  RegisterComponents('TTI', [TDBBoxLabel]);
end;

end.
