unit BoxLabl;

// This code is provided as is with no warranty.  I will make additions
// and corrections as time permits.  Feel free to drop me a line if
// you want something added.

// New versions will be posted on the web at the
// Tangent Technologies, Inc WEB page at
// www.mindspring.com/~tti

// Have Fun!
// Nick Hustak
// President, Tangent Technologies, Inc
// TTI@mindspring.com
// www.mindspring.com/~tti
// 770-427-2118
// CSERVE: 72134,123
// President, Atlanta Delphi Developers Group
// www.mindspring.com/~addg

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus;

type
  THorizontalAlignment = ( haTop, haCenter, haBottom );
  TBorderStyle = ( bsSingle, bsNone );
  TBevelStyle = ( bvRaised, bvNone, bvLowered );

  TCustomBoxLabel = class(TGraphicControl)
  private
    { Private declarations }
    FAlignment: TAlignment;
    FHoriAlign: THorizontalAlignment;
    FTextBorder: Integer;
    FWordWrap: Boolean;
    FBorderStyle: TBorderStyle;
    FDecimals: shortint;
    FValue: Double;
    FBevelInner: TBevelStyle;
    FBevelOuter: TBevelStyle;
    FBevelWidth: Integer;
    FFormatString: String;
    property Canvas;
    procedure SetAlignment(Value: TAlignment);
    procedure SetHAlignment(Value: THorizontalAlignment);
    procedure SetBorderStyle( Value: TBorderStyle );
    procedure SetTextBorder( Value: Integer );
    procedure SetWordWrap(Value: Boolean);
    procedure SetDouble( Value: Double );
    function  GetDouble: Double;
    procedure SetInteger( Value: Integer );
    function  GetInteger: Integer;
    procedure SetBevelInner( Value: TBevelStyle );
    procedure SetBevelOuter( Value: TBevelStyle );
    procedure SetBevelWidth( Value: Integer );
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
  protected
    { Protected declarations }
    procedure Paint; override;
    function  GetLabelText:String;virtual;
    procedure SetLabelText( Value: String );virtual;
  public
    { Public declarations }
    property AsInteger: Integer read GetInteger write SetInteger;
    property AsFloat:   Double read GetDouble write SetDouble;
    { Published declarations }
    property Alignment: TAlignment read FAlignment write SetAlignment
      default taCenter;
    property HorizontalAlign: THorizontalAlignment read FHoriAlign
      write SetHAlignment default haCenter;
    property TextBorder: Integer read FTextBorder write SetTextBorder default 5;
    property BevelInner: TBevelStyle read FBevelInner write SetBevelInner default bvLowered;
    property BevelOuter: TBevelStyle read FBevelOuter write SetBevelOuter default bvRaised;
    property BevelWidth: Integer read FBevelWidth write SetBevelWidth default 1;
    property FormatString: String read FFormatString write FFormatString;    
    property Align;
    property Enabled;
    property Font;
    property Color;
    property DragCursor;
    property DragMode;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property PopUpMenu;
    property ParentFont;
    property ParentShowHint;
    property ParentColor;
    property Visible;    
    property Width default 70;
    property Height default 20;
    property WordWrap: Boolean read FWordWrap write SetWordWrap default False;
    property BorderStyle: TBorderStyle read FBorderStyle write SetBorderStyle
       default bsNone;
    property Decimals: shortint read FDecimals write FDecimals default 0;
    published
    constructor Create( AOwner:TComponent ); override;
  end;

  TBoxLabel = class(TCustomBoxLabel)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    property Alignment;
    property HorizontalAlign;
    property Caption;
    property TextBorder;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property Align;
    property Enabled;
    property Font;
    property FormatString;
    property Color;
    property DragCursor;
    property DragMode;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property PopUpMenu;
    property ParentFont;
    property ParentShowHint;
    property ParentColor;
    property Width;
    property Height;
    property WordWrap;
    property BorderStyle;
    property Decimals;
    property Visible;
  end;

procedure Register;

implementation

constructor TCustomBoxLabel.Create( AOwner:TComponent );
begin
inherited Create( AOwner );
FFormatString := '';
Width := 70;
Height := 20;
FTextBorder := 2;
FAlignment := taCenter;
FHorialign := haCenter;
FBorderStyle := bsNone;
FBevelInner := bvLowered;
FBevelOuter := bvRaised;
FBevelWidth := 1;
FDecimals := 0;
Color := clBtnFace;
SetLabelText( Name );
end;

function TCustomBoxLabel.GetLabelText: string;
begin
Result := Caption;
end;

procedure TCustomBoxLabel.SetLabelText( Value: string );
begin
Caption := Value;
end;

procedure TCustomBoxLabel.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
  WordWraps: array[Boolean] of Word = (0, DT_WORDBREAK);
var
  Text: array[0..255] of Char;
  Area: TRect;
  SaveColor, Pen1, Pen2: TColor;
  SaveStyle: TBrushStyle;
  Cnt: Integer;
  Offset: Integer;
  Inset: Integer;
begin
Inset := 0;
Area := Rect( 0, 0, ClientWidth, ClientHeight );
Canvas.Brush.Color := Color;
Canvas.FillRect( Rect( 0, 0, Width, Height ) );

case FBevelOuter of
  bvRaised:
     begin
     Pen1 := clWhite;
     Pen2 := clBtnShadow;
     Inc( Inset, FBevelWidth );
     end;
  bvLowered:
     begin
     Pen1 := clBtnShadow;
     Pen2 := clWhite;
     Inc( Inset, FBevelWidth );
     end;
  else
    begin
    Pen1 := clWhite;
    Pen2 := clBtnShadow;
    end;
  end;

Offset := 0;
if FBevelOuter in [ bvRaised, bvLowered ] then
  begin
  for Cnt := 0 to FBevelWidth - 1 do
    begin
    SaveColor := Canvas.Pen.Color;
    Canvas.Pen.Color := Pen1;
    Canvas.MoveTo( Width - 1 - Cnt, 0 + Cnt );
    Canvas.LineTo( 0 + Cnt, 0 + Cnt );
    Canvas.LineTo( 0 + Cnt, Height - Cnt );
    Canvas.Pen.Color := Pen2;
    Canvas.MoveTo( Width - 1 - Cnt, 0 + Cnt );
    Canvas.LineTo( Width - 1 - Cnt, Height - 1 - Cnt );
    Canvas.LineTo( 0 + Cnt, Height - 1 - Cnt );
    Canvas.Brush.Color := Color;
    Canvas.Pen.Color := SaveColor;
    end;
  Offset := FBevelWidth;
  end;

case FBorderStyle of
  bsSingle:
     begin
     Canvas.Rectangle( Offset, Offset, Width - Offset, Height - Offset );
     Inc( Offset, 1 );
     Inc( Inset, 1 );
     end;
  bsNone:
     begin
     end;
  end;

case FBevelInner of
  bvRaised:
     begin
     Pen1 := clWhite;
     Pen2 := clBtnShadow;
     Inc( Inset, FBevelWidth );
     end;
  bvLowered:
     begin
     Pen1 := clBtnShadow;
     Pen2 := clWhite;
     Inc( Inset, FBevelWidth );
     end;
  end;

if FBevelInner in [ bvRaised, bvLowered ] then
  begin
  for Cnt := 0 to FBevelWidth - 1 do
    begin
    SaveColor := Canvas.Pen.Color;
    Canvas.Pen.Color := Pen1;
    Canvas.MoveTo( Width - 1 - Cnt - Offset, 0 + Cnt + Offset );
    Canvas.LineTo( 0 + Cnt + Offset, 0 + Cnt + Offset );
    Canvas.LineTo( 0 + Cnt + Offset, Height - Cnt - Offset );
    Canvas.Pen.Color := Pen2;
    Canvas.MoveTo( Width - 1 - Cnt - Offset, 0 + Cnt + Offset );
    Canvas.LineTo( Width - 1 - Cnt - Offset, Height - 1 - Cnt - Offset );
    Canvas.LineTo( 0 + Cnt + Offset, Height - 1 - Cnt - Offset );
    Canvas.Brush.Color := Color;
    Canvas.Pen.Color := SaveColor;
    end;
  Inc( Offset, FBevelWidth );
  end;
StrPCopy( Text, GetLabelText );
Canvas.Font := Font;
DrawText(Canvas.Handle, Text, StrLen(Text), Area, DT_CALCRECT or WordWraps[FWordWrap] );
case FHoriAlign of
  haTop:
     begin
     Inc( Area.Top, Offset );
     Inc( Area.Bottom, Offset );
     end;
  haCenter:
     begin
     Area.Top := Round( ClientRect.Bottom / 2 - Area.Bottom / 2 );
     Area.Bottom := Area.Bottom + Round( ClientRect.Bottom / 2 - Area.Bottom / 2 );
     end;
  haBottom:
     begin
     Area.Top := ClientRect.Bottom - Area.Bottom - Offset;
     Area.Bottom := ClientRect.Bottom - Offset;
     end;
  end;

case FAlignment of
  taLeftJustify:
     begin
     Inc( Area.Left, Offset + Inset );
     Inc( Area.Right, Offset + Inset );
     end;
  taCenter:
     begin
     Area.Left := ClientRect.Left + Offset;
     Area.Right := ClientRect.Right - Offset;
     end;
  taRightJustify:
     begin
     Area.Left := ClientRect.Right - Area.Right - Offset - Inset - 1;
     Area.Right := ClientRect.Right - Offset - Inset - 1;
     end;
  end;

if Area.Left < Inset then
  Area.Left := Inset;
if Area.Top < Inset then
  Area.Top := Inset;
if Area.Right > ClientWidth - Inset then
  Area.Right := ClientWidth - Inset;
if Area.Bottom > ClientHeight - Inset then
  Area.Bottom := ClientHeight - Inset;

if Enabled then
  DrawText(Canvas.Handle, Text, StrLen(Text), Area,
    0 or Alignments[FAlignment] or WordWraps[FWordWrap] )
else
  begin
  SaveColor := Canvas.Font.Color;
  Canvas.Font.Color := clWhite;
  Area.Left := Area.Left + 1;
  Area.Top := Area.Top + 1;
  DrawText(Canvas.Handle, Text, StrLen(Text), Area,
    0 or Alignments[FAlignment] or WordWraps[FWordWrap] );
  Area.Left := Area.Left - 1;
  Area.Top := Area.Top - 1;
  Canvas.Font.Color := clGray;
  SaveStyle := Canvas.Brush.Style;
  Canvas.Brush.Style := bsClear;
  DrawText(Canvas.Handle, Text, StrLen(Text), Area,
    0 or Alignments[FAlignment] or WordWraps[FWordWrap] );
  Canvas.Font.Color := SaveColor;
  Canvas.Brush.Style := SaveStyle;
  end
end;

procedure TCustomBoxLabel.SetAlignment(Value: TAlignment);
begin
if FAlignment <> Value then
  begin
  FAlignment := Value;
  Invalidate;
  end;
end;

procedure TCustomBoxLabel.SetTextBorder( Value:Integer );
begin
if FTextBorder <> Value then
  begin
  FTextBorder := Value;
  Invalidate;
  end;
end;

procedure TCustomBoxLabel.SetBorderStyle( Value:TBorderStyle );
begin
if FBorderStyle <> Value then
  begin
  FBorderStyle := Value;
  Invalidate;
  end;
end;

procedure TCustomBoxLabel.SetHAlignment(Value: THorizontalAlignment);
begin
if FHoriAlign <> Value then
  begin
  FHoriAlign := Value;
  Invalidate;
  end;
end;

procedure TCustomBoxLabel.SetWordWrap(Value: Boolean);
begin
if FWordWrap <> Value then
  begin
  FWordWrap := Value;
  Invalidate;
  end;
end;

procedure TCustomBoxLabel.SetDouble( Value: Double );
var
  Temp: String;
begin
FValue := Value;
if Length( FFormatString ) = 0 then
  begin
  Str( FValue:10:FDecimals, Temp );
  Temp := Trim( Temp );
  SetLabelText( Temp );
  end
else
  begin
  try
  SetLabelText( Format( FFormatString, [ Value ] ) );
  except
  SetLabelText( 'Format Error' );  
  end;
  end;
// Invalidate;
end;

function TCustomBoxLabel.GetDouble: Double;
var
  Error: Integer;
begin
Val( GetLabelText, Result, Error );
end;

procedure TCustomBoxLabel.SetInteger( Value: Integer );
var
  Temp: String[ 20 ];
begin
FValue := Value;
if Length( FFormatString ) = 0 then
  begin
  Str( FValue:10:FDecimals, Temp );
  Temp := Trim( Temp );
  SetLabelText( Temp );
  end
else
  begin
  try
  SetLabelText( Format( FFormatString, [ Value ] ) );
  except
  SetLabelText( 'Format Error' );
  end;
  end;
end;

function TCustomBoxLabel.GetInteger: Integer;
var
  Error: Integer;
begin
Val( GetLabelText, Result, Error );
end;

procedure TCustomBoxLabel.CMTextChanged(var Message: TMessage);
begin
Invalidate;
end;

procedure TCustomBoxLabel.CMFontChanged(var Message: TMessage);
begin
Invalidate;
end;

procedure TCustomBoxLabel.SetBevelInner( Value: TBevelStyle );
begin
if FBevelInner <> Value then
  begin
  FBevelInner := Value;
  Invalidate;
  end;
end;

procedure TCustomBoxLabel.SetBevelOuter( Value: TBevelStyle );
begin
if FBevelOuter <> Value then
  begin
  FBevelOuter := Value;
  Invalidate;
  end;
end;

procedure TCustomBoxLabel.SetBevelWidth( Value: Integer );
begin
if FBevelWidth <> Value then
  begin
  FBevelWidth := Value;
  Invalidate;
  end;
end;

procedure Register;
begin
  RegisterComponents('TTI', [TBoxLabel]);
end;

end.
