unit BoxCap;

// This code is provided as is with no warranty.  I will make additions
// and corrections as time permits.  Feel free to drop me a line if
// you want something added.

// New versions will be posted on the web at the
// Tangent Technologies, Inc WEB page at
// www.mindspring.com/~tti

// Have Fun!
// Nick Hustak
// President, Tangent Technologies, Inc
// TTI@mindspring.com
// www.mindspring.com/~tti
// 770-427-2118
// CSERVE: 72134,123
// President, Atlanta Delphi Developers Group
// www.mindspring.com/~addg

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, BoxLabl, StdCtrls;

type
  TAlignLabel = ( alNone, alTop, alLeft, alRight, alBottom );

  TBoxCaption = class( TBoxLabel )
  private
    { Private declarations }
    FAttachTo: TAlignLabel;
    FHook: TControl;
    OldFontColor: TColor;
    procedure SetAttach( Value: TAlignLabel );
    procedure SetHook( Control: TControl );
    procedure CMEnabledChanged(var Message: TMessage); message CM_ENABLEDCHANGED;
  protected
    { Protected declarations }
    procedure Paint; override;
  public
    { Public declarations }
    procedure Notification( AComp: TComponent; Operation: TOperation );override;
    procedure ShiftLabel;
  published
    { Published declarations }
    property AttachTo: TAlignLabel read FAttachTo write SetAttach default alNone;
    property Hook: TControl read FHook write SetHook;
    constructor Create( AOwner:TComponent ); override;
  end;

procedure Register;

implementation

constructor TBoxCaption.Create( AOwner:TComponent );
begin
inherited Create( AOwner );
FHook := Nil;
FAttachTo := alNone;
end;

procedure TBoxCaption.Paint;
begin
inherited Paint;
ShiftLabel;
end;

procedure TBoxCaption.ShiftLabel;
begin
if ( FHook <> nil ) and ( AttachTo <> alNone ) then
  begin
  case AttachTo of
    alTop:
      begin
      if Top <> TControl( FHook ).Top - Height then
        Top := TControl( FHook ).Top - Height;
      if Left <> TControl( FHook ).Left then
        Left := TControl( FHook ).Left;
      if Width <> TControl( FHook ).Width then
        Width := TControl( FHook ).Width;
      end;
    alLeft:
      begin
      if Top <> TControl( FHook ).Top then
        Top := TControl( FHook ).Top;
      if Left <> TControl( FHook ).Left - Width then
        Left := TControl( FHook ).Left - Width;
      if Height <> TControl( FHook ).Height then
        Height := TControl( FHook ).Height;
      end;
    alRight:
      begin
      if Top <> TControl( FHook ).Top then
        Top := TControl( FHook ).Top;
      if Left <> TControl( FHook ).Left + TControl( FHook ).Width then
        Left := TControl( FHook ).Left + TControl( FHook ).Width;
      if Height <> TControl( FHook ).Height then
        Height := TControl( FHook ).Height;
      end;
    alBottom:
      begin
      if Top <> TControl( FHook ).Top + TControl( FHook ).Height then
        Top := TControl( FHook ).Top + TControl( FHook ).Height;
      if Left <> TControl( FHook ).Left then
        Left := TControl( FHook ).Left;
      if Width <> TControl( FHook ).Width then
        Width := TControl( FHook ).Width;
      end;
    end;
  end;
end;

procedure TBoxCaption.SetAttach( Value: TAlignLabel );
begin
if Value <> FAttachTo then
  begin
  FAttachTo := Value;
  Invalidate;
  end;
end;

procedure TBoxCaption.SetHook( Control: TControl );
begin
if ( Control <> FHook ) and ( Control <> self ) then
  begin
  FHook := Control;
  Invalidate;
  end;
end;

procedure TBoxCaption.Notification( AComp: TComponent; Operation: TOperation );
begin
if ( Operation = opRemove ) and ( AComp = FHook ) then
  FHook := nil;
end;

procedure TBoxCaption.CMEnabledChanged(var Message: TMessage);
begin
Invalidate;
if FHook <> Nil then
  FHook.Enabled := Enabled;
end;

procedure Register;
begin
  RegisterComponents('TTI', [TBoxCaption]);
end;

end.
