unit Calunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Buttons, ExtCtrls, Grids, Calendar;

type
  TForm1 = class(TForm)
    BitBtnPrevMnth: TBitBtn;
    Calendar1: TCalendar;
    PanelMnth: TPanel;
    BitBtnNextMnth: TBitBtn;
    BitBtnChgStrtDay: TBitBtn;
    ButtonPrevYr: TButton;
    ButtonNextYr: TButton;
    ExpandBtn: TButton;
    ShrinkBtn: TButton;
    btntoday: TButton;
    BtnOneLine: TButton;
    procedure Calendar1Change(Sender: TObject);
    procedure BitBtnNextMnthClick(Sender: TObject);
    procedure BitBtnPrevMnthClick(Sender: TObject);
    procedure BitBtnChgStrtDayClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonPrevYrClick(Sender: TObject);
    procedure ButtonNextYrClick(Sender: TObject);
    procedure ExpandBtnClick(Sender: TObject);
    procedure ShrinkBtnClick(Sender: TObject);
    procedure btntodayClick(Sender: TObject);
    procedure BtnOneLineClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Const
  MonthNames : array[1..12] of string =
   ('January','February','March','April','May','June',
    'July','August','September','October','November','December');

procedure TForm1.FormCreate(Sender: TObject);
begin
  panelMnth.caption := MonthNames[calendar1.month] + ' ' +
                       inttostr(calendar1.day) + ', ' +
                       inttostr(calendar1.year);
end;

procedure TForm1.Calendar1Change(Sender: TObject);
begin
  panelMnth.caption := MonthNames[calendar1.month] + ' ' +
                       inttostr(calendar1.day) + ', ' +
                       inttostr(calendar1.year);
   if calendar1.calendardate = date
     then btntoday.enabled := false
     else btntoday.enabled := true;
end;

procedure TForm1.BitBtnNextMnthClick(Sender: TObject);
begin
  calendar1.nextmonth;
end;

procedure TForm1.BitBtnPrevMnthClick(Sender: TObject);
begin
  calendar1.prevmonth;
end;

procedure TForm1.BitBtnChgStrtDayClick(Sender: TObject);
begin
  calendar1.startofweek := succ(calendar1.startofweek);
  if calendar1.startofweek >= 7 then
     calendar1.startofweek := 0;
end;

procedure TForm1.ButtonPrevYrClick(Sender: TObject);
begin
  calendar1.prevyear;
  if ((calendar1.month = 2) and (calendar1.day = 29)) then
       calendar1.day := 28;
end;

procedure TForm1.ButtonNextYrClick(Sender: TObject);
begin
  calendar1.nextyear;
  if ((calendar1.month = 2) and (calendar1.day = 29)) then
       calendar1.day := 28;
end;

procedure TForm1.ExpandBtnClick(Sender: TObject);
begin
  form1.height:=267
  ;
  form1.width := 345;
  expandbtn.visible := false;
  shrinkbtn.visible := true;
end;

procedure TForm1.ShrinkBtnClick(Sender: TObject);
begin
  form1.height := 193;
  form1.width := 360;
  expandbtn.visible := true;
  shrinkbtn.visible := false;
end;

procedure TForm1.BtnOneLineClick(Sender: TObject);
begin
  form1.height := 67;
  form1.width := 360;
  expandbtn.visible := true;
  shrinkbtn.visible := false;
end;

procedure TForm1.btntodayClick(Sender: TObject);
begin
  calendar1.calendardate := date;
end;

end.
