Program Cs2Delphi;
{$APPTYPE CONSOLE}
{an example loading and executing a script}
Uses Cs2, Cs2_Var;

Var
  Cs : TCs2PascalScript;
  p : PChar;
  l : Word;
  f : File;
Function MyProc (ID : Pointer; Const ProcName : String; Params : PVariableManager; res : PCajVariant) : TCS2Error; Far;
Var
  p : PCajVariant;
Begin
  MyProc := ENoError;
  If ProcName = 'WRITELN' Then Begin
    p := GetVarLink (VM_Get (Params, 0) );
    If Assigned (p) Then Begin
      WriteLn (p^. Cv_Str);
    End;
  End Else If procName = 'READLN' Then Begin
    p := GetVarLink (VM_Get (Params, 0) );
    ReadLn (p^. CV_Str);
  End;
End;

Function callProc : Boolean;
Var
  v : PVariableManager;
  p : PCajVariant;
Begin
  CallProc := False;
  v := VM_Create (Nil);
  VM_Add (V, CreateInteger (202), 'a');
  p := Cs. RunScriptProc ('Test2', v);
  If Cs. ErrorCode <> ENoError Then WriteLn ('No test2 function call!:', Cs. ErrorCode) Else Begin
    WriteLn ('CallProc: ', p^. CV_SInt32);
    CallProc := True;
  End;
  VM_Destroy (v);
  DestroycajVariant (p);
End;

Function OnUses (Id : Pointer; Sender : PCs2PascalScript; Name : String) : TCs2Error; Far;
Begin
  if Name = 'SYSTEM' then begin
    RegisterStdLib(@Cs);
    PM_Add (Cs. Procedures, '0 WRITELN S 8', @myproc); {Procedure Writeln(S : String)}
    PM_Add (Cs. Procedures, '0 READLN !S 8', @myproc); {Procedure Readln(var S : String)}
    OnUses:=ENoError;
  end else OnUses:=EUnknownIdentifier;
End;

Begin
  Assign (f, ParamStr (1) );
  {$i-}
  Reset (f, 1);
  {$i+}
  If IOResult <> 0 Then Begin
    WriteLn ('File not found: ' + ParamStr (1) );
    Exit;
  End;
  l := FileSize (f);
  GetMem (p, l + 1);
  BlockRead (f, p [0], l);
  p [l] := #0;
  Close (f);
  cs:=TCs2PascalScript.Create(nil);
  Cs. OnUses := OnUses;
  Cs. SetText (p);
  Cs. RunScript;
    If cs. ErrorCode <> ENoError Then Begin
      WriteLn ('Error: ', ErrorToString(Cs.ErrorCode));
    End;
  If callProc Then
    If cs. ErrorCode <> ENoError Then Begin
      WriteLn ('Error: ', ErrorToString(Cs. ErrorCode));
    End;
  FreeMem(p, l+1);
  Cs.Free;
End.