{
*********************************************************************
CajScript
Created By InnerFuse                   http://www.weyert.nl/innerfuse/
Bugreport: ckok.1@hccnet.nl or mailling list
*********************************************************************
Copyright (C) 2000 by InnerFuse

This software is provided 'as-is', without any expressed or implied
warranty. In no event will the author be held liable for any damages
arising from the use of this software.
Permission is granted to anyone to use this software for any kind of
application, and to alter it and redistribute it freely, subject to
the following restrictions:
1. The origin of this software must not be misrepresented, you must
   not claim that you wrote the original software.
2. Altered source versions must be plainly marked as such, and must
   not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source
  distribution.
4. You must have a visible line in your programs aboutbox or
  documentation that it is made using CajScript.

Please register by joining the mailling list at http://www.weyert.nl/innerfuse/.
}
Unit CS2_PRC;
{$IFDEF VER130}{D5}{$DEFINE DELPHI}{$DEFINE P32}{$ENDIF}
{$IFDEF VER120}{D4}{$DEFINE DELPHI}{$DEFINE P32}{$ENDIF}
{$IFDEF VER100}{D3}{$DEFINE DELPHI}{$DEFINE P32}{$ENDIF}
{$IFDEF VER90}{D2}{$DEFINE DELPHI}{$DEFINE P32}{$ENDIF}
{$IFDEF VER80}{D1}{$DEFINE DELPHI}{$DEFINE P16}{$ENDIF}
{$IFDEF VER125}{C4}{$DEFINE CBUILDER}{$DEFINE P32}{$ENDIF}
{$IFDEF VER110}{C3}{$DEFINE CBUILDER}{$DEFINE P32}{$ENDIF}
{$IFDEF VER93}{C1}{$DEFINE CBUILDER}{$DEFINE P32}{$ENDIF}
{$IFDEF VER70}{BP7}{$B-}{$N+}{$DEFINE BP}{$DEFINE P16}{$ENDIF}
{$IFDEF FPC}{FPC}{$DEFINE P32}{$ENDIF}
{$IFDEF DELPHI}{$B-}{$DEFINE EXTUNIT}{$DEFINE CLASS}{$ENDIF}
{$IFDEF CBUILDER}{$B-}{$DEFINE EXTUNIT}{$DEFINE CLASS}{$ENDIF}
Interface

Function ConvertProc(S: String) : String;
{
Converts a function header to a CajScript function header:
'Function test(S : String) : Boolean;' => '14 TEST S 8'
}

Implementation

Uses Cs2_UTL, CS2_Var;

Function IntToStr (I : LongInt) : String;
Var
  s : String;
Begin
  Str ( i, s);
  IntToStr := s;
End;

Function GetType ( Const s : String ) : Word;
Begin
  If S = 'BYTE' Then GetType := CSV_UByte Else
    If S = 'SHORTINT' Then GetType := CSV_SByte Else
      If S = 'CHAR' Then GetType := CSV_Char Else
        If S = 'WORD' Then GetType := CSV_UInt16 Else
          If S = 'SMALLINT' Then GetType := CSV_SInt16 Else
            If S = 'CARDINAL' Then GetType := CSV_UInt32 Else
              If (S = 'LONGINT') Or (S = 'INTEGER') Then GetType := CSV_SInt32 Else
                If S = 'STRING' Then GetType := CSV_String Else
                  If S = 'REAL' Then GetType := CSV_Real Else
                    If S = 'SINGLE' Then GetType := CSV_Single Else
                      If S = 'DOUBLE' Then GetType := CSV_Double Else
                        If S = 'EXTENDED' Then GetType := CSV_Extended Else
                          If S = 'COMP' Then GetType := CSV_Comp Else
                            If S = 'BOOLEAN' Then GetType := CSV_Bool Else Begin
                            GetType := 0;
                          End;
End;

Function ConvertProc(S: String) : String;
var
  Parser : PCS2PascalParser;
  CurrVar : String;
  FuncName,
  FuncParam : String;
  FuncRes,
  CurrType : Word;
Begin
  s:=s+#0;
  New(Parser);
  Parser^.CurrTokenPos:=0;
  Parser^.text:=@s[1];
  ParseToken(Parser);
  If Parser^. CurrTokenId = CSTII_Procedure Then
    FuncRes := 0
  Else
    FuncRes := 1;
  NextNoJunk (Parser);
  FuncName := FastUppercase (GetToken (Parser) );
  FuncParam := FuncName;
  CurrVar := '';
  NextNoJunk (Parser);
  If parser^. CurrTokenId = CSTI_OpenRound Then Begin
    While True Do Begin
      NextNoJunk (Parser);
      If Parser^. CurrTokenId = CSTII_Var Then Begin
        CurrVar := '!';
        NextNoJunk (Parser);
      End; {if}
      While True Do Begin
        CurrVar := CurrVar + fastuppercase (GetToken (Parser) ) + '|';
        NextNoJunk (parser);
        If Parser^. CurrTokenId = CSTI_Colon Then Break;
        NextNoJunk (Parser);
      End; {while}
      NextNoJunk (Parser);
      CurrType := GetType (FastUppercase (GetToken (Parser) ) );
      If Pos ('!', CurrVar) = 1 Then Begin
        Delete (currVar, 1, 1);
        While Pos ('|', CurrVar) > 0 Do Begin
          FuncParam := FuncParam + ' !' + Copy (CurrVar, 1, Pos ('|', CurrVar) - 1) + ' ' + IntToStr (CurrType);
          Delete (CurrVar, 1, Pos ('|', CurrVar) );
        End; {while}
      End Else Begin
        While Pos ('|', CurrVar) > 0 Do Begin
          FuncParam := FuncParam + ' ' + Copy (CurrVar, 1, Pos ('|', CurrVar) - 1) + ' ' + IntToStr (CurrType);
          Delete (CurrVar, 1, Pos ('|', CurrVar) );
        End; {while}
      End; {if}
      NextNoJunk (Parser);
      If Parser^. CurrTokenId = CSTI_CloseRound Then Begin
        NextNoJunk (Parser);
        Break;
      End; {if}
      NextNoJunk (Parser);
    End;
  End;
  If FuncRes = 1 Then Begin
    NextNoJunk (Parser);
    FuncRes :=  GetType (FastUppercase (GetToken (Parser) ) );
  End;
  FuncParam := InttoStr (FuncRes) + ' ' + FuncParam;
  Dispose(Parser);
  ConvertProc:=FuncParam;
end;

End.