unit DBBubble;
{
 Author : Stphane VANDENBUSSCHE at IDEO Conseil
 Copyright : Stphane VANDENBUSSCHE (c) 1998
 Use at Your own risk - No garantee what-so-ever
 NOT TO BE SOLD OR DISTRIBUTED WITHOUT PERMISSION.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Bubble, DB, DBCtrls;

type
  TDBBubble = class(TBubble)
  private
    { Dclarations prives }
    FDataLink: TFieldDataLink;
    procedure DataChange(Sender: TObject);
    function GetDataField: string;
    function GetDataSource: TDataSource;
    function GetField: TField;
    function GetFieldText: string;
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
    procedure CMGetDataLink(var Message: TMessage); message CM_GETDATALINK;

  protected
    { Dclarations protges }
    function GetLabelText: string;
    procedure Loaded; override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;

  public
    { Dclarations publiques }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Field: TField read GetField;

  published
    { Dclarations publies }
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
  end;

procedure Register;

implementation

{==============================================================================}

procedure Register;
begin
  RegisterComponents('Files', [TDBBubble]);
end;

{==============================================================================}

constructor TDBBubble.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csReplicatable];
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
end;

{==============================================================================}

destructor TDBBubble.Destroy;
begin
  FDataLink.Free;
  FDataLink := nil;
  inherited Destroy;
end;

{==============================================================================}

procedure TDBBubble.Loaded;
begin
  inherited Loaded;
  if (csDesigning in ComponentState) then DataChange(Self);
end;

{==============================================================================}

procedure TDBBubble.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;

{==============================================================================}

function TDBBubble.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

{==============================================================================}

procedure TDBBubble.SetDataSource(Value: TDataSource);
begin
  FDataLink.DataSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

{==============================================================================}

function TDBBubble.GetDataField: string;
begin
  Result := FDataLink.FieldName;
end;

{==============================================================================}

procedure TDBBubble.SetDataField(const Value: string);
begin
  FDataLink.FieldName := Value;
end;

{==============================================================================}

function TDBBubble.GetField: TField;
begin
  Result := FDataLink.Field;
end;

{==============================================================================}

function TDBBubble.GetFieldText: string;
begin
  if FDataLink.Field <> nil then
    Result := FDataLink.Field.DisplayText
  else
    if csDesigning in ComponentState then Result := Name else Result := '';
end;

{==============================================================================}

procedure TDBBubble.DataChange(Sender: TObject);
begin
  Caption := GetFieldText;
end;

{==============================================================================}

function TDBBubble.GetLabelText: string;
begin
  if csPaintCopy in ControlState then
    Result := GetFieldText else
    Result := Caption;
end;

{==============================================================================}

procedure TDBBubble.CMGetDataLink(var Message: TMessage);
begin
  Message.Result := Integer(FDataLink);
end;

{==============================================================================}

end.
