unit Bubble;
{
 Author : Stphane VANDENBUSSCHE at IDEO Conseil
 Copyright : Stphane VANDENBUSSCHE (c) 1998
 Use at Your own risk - No garantee what-so-ever
 NOT TO BE SOLD OR DISTRIBUTED WITHOUT PERMISSION.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, DsgnIntf;

type
  { On fabrique un type limit ------------------------------------------------}
  TPointAt    = (paRight, paLeft, paUp, paDown);
  TShapesType = (stRoundRect, stRectangle);
  TAlignType  = (UnderRight, UnderMiddle, UnderLeft, RightUpper, RightMiddle,
                 RightLower, LeftUpper, LeftMiddle, LeftLower);

  { Boite About ---------------------------------------------------------------}
  TAbout = Class(TPropertyEditor)
  Public
    Procedure Edit; Override;
    Function GetAttributes: TPropertyAttributes; Override;
    Function GetValue: String; Override;
  End;

  TBubble = class(TPaintBox)
  private
    { Dclarations prives }
     FCaption : TCaption;
     FWords, FStrings : TStringList;
     FImageListe : TImageList;
     FWidthIsSet : Boolean;
     FFixedFont : TFont;
     FAbout : TAbout;
     FColor : TColor;
     FShape : TShapesType;
     TH : Integer;
     { Position crochet -------------------------------------------------------}
     FAlignType: TAlignType;
     FPointAt: TPointAt;
     FBorderLimit: Integer;
     { Position dessin bulle + texte ------------------------------------------}
     DrawMargeBas, DrawMargeLeft, DrawMargeRight : Integer;

     Procedure SetCaption(Value: TCaption);
     Procedure SetColor(Value: TColor);
     Procedure WriteCaption;
     Procedure ReadWords;
     Procedure SetShape(Value: TShapesType);
     Procedure SetDimension;
     Procedure DrawBubble;

     Procedure SetAlignType(Value: TAlignType);
     Procedure SetPointAt(Value: TPointAt);
     Procedure SetBorderLimit(Value: Integer);
     { Position crochet -------------------------------------------------------}
     Procedure DrawArrow;
     Procedure PosArrowRight(BPosX, BPosY : Integer);
     Procedure PosArrowLeft(BPosX, BPosY : Integer);
     Procedure PosArrowUnder(BPosX, BPosY : Integer);

  protected
    { Dclarations protges }
     Procedure Paint; Override;

  public
    { Dclarations publiques }
     Constructor Create(AOwner: TComponent); Override;
     Destructor Destroy; Override;

  published
    { Dclarations publies }
     Property About: TAbout read FAbout write FAbout;
     Property Caption: TCaption Read FCaption Write SetCaption;
     Property Color: TColor Read FColor Write SetColor;
     Property Shape: TShapesType Read FShape Write SetShape;

     Property ArrowAlign: TAlignType Read FAlignType Write SetAlignType;
     Property ArrowPointAt: TPointAt Read FPointAt Write SetPointAt;
     Property BorderLimit: Integer Read FBorderLimit Write SetBorderLimit;

     Property DragCursor;
     Property DragMode;
     Property Height;
     Property Parentfont;
     Property Visible;
     Property Width;
     Property OnClick;
     Property OnDblClick;
     Property OnDragDrop;
     Property OnDragOver;
     Property OnEndDrag;
     Property OnMouseDown;
     Property OnMouseMove;
     Property OnMouseUp;
     Property OnStartDrag;
  end;

Const
     Marge : Byte = 10;
     Hooksize : Byte = 26; // Valeur de la taille en pix de cot du bmp crochet

procedure Register;

implementation
{$R Bubbles.res}

{==============================================================================}

procedure Register;
begin
  RegisterComponents('X-Files', [TBubble]);
  RegisterPropertyEditor(TypeInfo(TAbout), TBubble, 'ABOUT', TAbout);
end;

{==============================================================================}
{ Mthode crateur de l'objet -------------------------------------------------}

Constructor TBubble.Create(AOwner: TComponent);
Begin
     Inherited Create(AOwner);
     FCaption := 'Hello world !';
     FColor := clWhite;
     FBorderLimit := 10;

     Height := 69;
     Width := 166;
     ParentFont := True;

     DrawMargeLeft  := 0;
     DrawMargeRight := 0;
     DrawMargeBas := Hooksize-1;
     FWidthIsSet := True;

     FFixedFont := TFont.Create;
     FFixedFont := Font;

     FWords := TStringList.Create;
     FStrings := TStringList.Create;

     FImageListe := TImageList.CreateSize(Hooksize, Hooksize);
     FImageListe.DrawingStyle := dsTransparent;
     FImageListe.Masked := True;
     FImageListe.ResourceLoad(rtBitmap, 'BAS_SE', clSilver);
     FImageListe.ResourceLoad(rtBitmap, 'BAS_SO', clSilver);
     FImageListe.ResourceLoad(rtBitmap, 'GCH_NO', clSilver);
     FImageListe.ResourceLoad(rtBitmap, 'GCH_SO', clSilver);
     FImageListe.ResourceLoad(rtBitmap, 'DRT_SE', clSilver);
     FImageListe.ResourceLoad(rtBitmap, 'DRT_NE', clSilver);

     Canvas.Font := FFixedFont;
End;

{==============================================================================}
{ Mthode destructeur de l'objet ----------------------------------------------}
Destructor TBubble.Destroy;
Begin
     FWords.Free;
     FStrings.Free;
     FImageListe.Free;
     Inherited Destroy;
End;

{==============================================================================}
{ Gestion de l'venement PAINT ------------------------------------------------}

Procedure TBubble.Paint;
Begin
     TH := Canvas.TextHeight(FCaption);
     Canvas.Brush.Color := FColor;
     { Analyse du caption }
     ReadWords;
     { Dessin crochet }
     DrawArrow;
     { Dessin Bulle + Texte }
     WriteCaption;
End;

{==============================================================================}
{ Gestion de la modification de la proprit : BorderLimit --------------------}

Procedure TBubble.SetBorderLimit(Value: Integer);
Begin
     If Value = FBorderLimit Then Exit; // car mme valeur
     FBorderLimit := Value;
     Invalidate;
End;

{==============================================================================}
{ Fonction de dessin du rectangle de la bulle ---------------------------------}

Procedure TBubble.DrawBubble;
Begin
  If FShape = stRoundRect Then
     Canvas.RoundRect(DrawMargeLeft, 0, Width-DrawMargeRight,
                      Height-DrawMargeBas, 16, 16)
  Else
     Canvas.Rectangle(DrawMargeLeft, 0, Width-DrawMargeRight,
                      Height-DrawMargeBas);
End;

{==============================================================================}
{ Fonction dimensionnement de la taille de l'objet ----------------------------}

Procedure TBubble.SetDimension;
Begin
     Height := (FStrings.Count * TH) + (Marge * 2) + DrawMargeBas;
     If (DrawMargeBas = 0) And (Not FWidthIsSet) Then Begin
        Width := DrawMargeLeft + Width + DrawMargeRight;
        FWidthIsSet := True;
     End;
     If (DrawMargeBas > 0) And (Not FWidthIsSet) Then Begin
        Width := Width - DrawMargeLeft - DrawMargeRight;
        FWidthIsSet := True;
     End;
     { Dessin bordure }
     DrawBubble;
End;

{==============================================================================}
{ Positionnement du crochet ---------------------------------------------------}
{ Dessous ---------------------------------------------------------------------}

Procedure TBubble.PosArrowUnder(BPosX, BPosY : Integer);
Begin
     DrawMargeLeft  := 0;
     DrawMargeRight := 0;
     DrawMargeBas := Hooksize-1;

     SetDimension;

     Case FPointAt Of
          paRight : FImageListe.Draw(Canvas, BPosX, BPosY, 0);
          paLeft :  FImageListe.Draw(Canvas, BPosX, BPosY, 1);
     End;

     Canvas.FloodFill(BPosX + 16, BPosY + 16, clWhite, fsSurface);
End;

{==============================================================================}
{ Gauche ----------------------------------------------------------------------}

Procedure TBubble.PosArrowLeft(BPosX, BPosY : Integer);
Begin
     DrawMargeLeft  := Hooksize-1;
     DrawMargeRight := 0;
     DrawMargeBas := 0;

     SetDimension;

     Case FPointAt Of
          paUp :    FImageListe.Draw(Canvas, BPosX, BPosY, 2);
          paDown :  FImageListe.Draw(Canvas, BPosX, BPosY, 3);
     End;

     Canvas.FloodFill(BPosX + 16, BPosY + 16, clWhite, fsSurface);
End;

{==============================================================================}
{ Droite ----------------------------------------------------------------------}

Procedure TBubble.PosArrowRight(BPosX, BPosY : Integer);
Begin
     DrawMargeLeft  := 0;
     DrawMargeRight := Hooksize-1;
     DrawMargeBas := 0;

     SetDimension;

     Case FPointAt Of
          paUp :    FImageListe.Draw(Canvas, BPosX, BPosY, 5);
          paDown :  FImageListe.Draw(Canvas, BPosX, BPosY, 4);
     End;

     Canvas.FloodFill(BPosX + 16, BPosY + 16, clWhite, fsSurface);
End;


{==============================================================================}
{ Dtermination de la position du crochet -------------------------------------}

Procedure TBubble.DrawArrow;
Begin

  Case FAlignType Of
    UnderRight :  PosArrowUnder(ClientWidth-FBorderLimit-Hooksize, ClientHeight-Hooksize);
    UnderMiddle : PosArrowUnder((ClientWidth Div 2)-(Hooksize Div 2), ClientHeight-Hooksize);
    UnderLeft :   PosArrowUnder(FBorderLimit, ClientHeight-Hooksize);

    RightUpper :  PosArrowRight(ClientWidth-Hooksize, FBorderLimit);
    RightMiddle : PosArrowRight(ClientWidth-Hooksize, (ClientHeight Div 2)-(Hooksize Div 2));
    RightLower :  PosArrowRight(ClientWidth-Hooksize, ClientHeight-FBorderLimit-Hooksize);

    LeftUpper :   PosArrowLeft(0, FBorderLimit);
    LeftMiddle :  PosArrowLeft(0, (ClientHeight Div 2)-(Hooksize Div 2));
    LeftLower :   PosArrowLeft(0, ClientHeight-FBorderLimit-Hooksize);
  End;

End;

{==============================================================================}
{ Gestion de la modification de la proprit : ArrowAlign ---------------------}

Procedure TBubble.SetAlignType(Value: TAlignType);
Begin
  If Value = FAlignType Then Exit; // car mme valeur

  { Vrifier s'il est ncssaire de laisser rajuster la taille }
  Case FAlignType Of
    UnderRight, UnderMiddle, UnderLeft : If (FPointAt<>paRight)
                                         And (FPointAt<>paLeft)
                                         Then FWidthIsSet := False;
  Else
      If (FPointAt<>paUp) And (FPointAt<>paDown) Then FWidthIsSet := False;
  End;

  FAlignType := Value;

  Case FAlignType Of
    UnderRight :  FPointAt := paRight;
    UnderMiddle : FPointAt := paRight;
    UnderLeft :   FPointAt := paLeft;

    LeftUpper, RightUpper :  FPointAt := paUp;
    LeftMiddle, RightMiddle : FPointAt := paDown;
    LeftLower, RightLower :  FPointAt := paDown;
  End;

  Invalidate;
End;

{==============================================================================}
{ Gestion de la modification de la proprit : ArrowPointAt -------------------}

Procedure TBubble.SetPointAt(Value: TPointAt);
Begin
  If Value = FPointAt Then Exit; // car mme valeur
  FPointAt := Value;
  FWidthIsSet := True;

  Case FAlignType Of
    UnderRight, UnderMiddle :  If (FPointAt<>paRight)
                               And (FPointAt<>paLeft)
                               Then FPointAt:=paRight;
    UnderLeft : If (FPointAt<>paRight)
                And (FPointAt<>paLeft)
                Then FPointAt:=paLeft;

    LeftUpper, RightUpper : If (FPointAt<>paUp)
                            And (FPointAt<>paDown)
                            Then FPointAt:=paUp;
    LeftLower, RightLower, LeftMiddle, RightMiddle : If (FPointAt<>paUp)
                                                     And (FPointAt<>paDown)
                                                     Then FPointAt:=paDown;
  End;

  Invalidate;
End;

{==============================================================================}
{ Gestion de la modification de la proprit : Shape --------------------------}

Procedure TBubble.SetShape(Value: TShapesType);
Begin
     If Value = FShape Then Exit; // car mme valeur
     FShape := Value;
     Invalidate;
End;

{==============================================================================}
{ Gestion de la modification de la proprit : Color --------------------------}

Procedure TBubble.SetColor(Value: TColor);
Begin
     If Value = FColor Then Exit; // car mme valeur
     FColor := Value;
     Canvas.Brush.Color := FColor;
     Invalidate;
End;

{==============================================================================}
{ Gestion de la modification de la proprit : Caption ------------------------}

Procedure TBubble.SetCaption(Value: TCaption);
Begin
     If Value = FCaption Then Exit; // car mme valeur
     FCaption := Value;
     Invalidate;
End;

{==============================================================================}
{ Fonction d'analyse du texte et dcoupage des mots ---------------------------}

Procedure TBubble.ReadWords;
Var
   AffCh, MaCh : String;
   LargeMax, i : Integer;
Begin
     LargeMax := ClientWidth - (Marge * 2) - DrawMargeLeft - DrawMargeRight;
     MaCh := Trim(FCaption) + ' ';
     FWords.Clear;
     FStrings.Clear;

     While Pos(' ', MaCh) > 0 Do Begin
           FWords.Add(Copy(MaCh,1,Pos(' ', MaCh)));
           Delete(MaCh,1,Pos(' ', MaCh));
     End;

     AffCh := '';
     Canvas.Font := Font;

     For i := 0 To FWords.Count-1 Do Begin
         If Canvas.TextWidth(AffCh + FWords[i]) < LargeMax Then
            Begin
                 AffCh := AffCh + FWords[i];
                 If i = FWords.Count-1 Then FStrings.Add(AffCh);
            End
         Else
             Begin
                  FStrings.Add(AffCh);
                  AffCh := FWords[i];
                  If i = FWords.Count-1 Then FStrings.Add(AffCh);
             End;
     End; // For

End;

{==============================================================================}
{ Fonction d'affichage du texte -----------------------------------------------}

Procedure TBubble.WriteCaption;
Var
   i : Integer;
Begin
     Canvas.Font := Font;

     With Canvas Do Begin
          Brush.Color := FColor;
          For i := 0 To FStrings.Count-1 Do
              TextOut(DrawMargeLeft+Marge , (Marge + (TH * i)), FStrings[i]);
     End;

End;

{==============================================================================}
{ Fonctions d'affichage de la bote de dialogue About -------------------------}

procedure TAbout.Edit;
begin
  Application.MessageBox('TBubble v1.0 for Delphi'+
                         #10+'(c) 1998 Stphane VANDENBUSSCHE.'+
                         #10+#10+'This component is FreeWare and CardWare.'+
                         #10+#10+'NOT TO BE SOLD OR DISTRIBUTED WITHOUT PERMISSION.',
                         'About TBubble Component', MB_OK + MB_ICONINFORMATION);
end;

function TAbout.GetAttributes: TPropertyAttributes;
begin
  Result:= [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout.GetValue: string;
begin
  Result:= '(About)';
end;

{==============================================================================}

end.

