{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,Q-,R-,S-,T-,V+,W-,X+,Y+}
{$M 16384,8192}
{*****************************************************************************}
{                                                                             }
{ TBMScroll - a VCL component that is provides a scrolling bitmap with        }
{   optional looping sound - perfect for your products About Box.             }
{   The cool thing is that you can preview the scrolling bitmap and the       }
{   accompanying looping sound at design time...                              }
{                                                                             }
{   This component is TRAVELWARE. Should you find it useful, please send      }
{   me enough of your local currency to buy a drink or two in your country    }
{   (but no coins please). When I get enough cash, I plan to embark on a      }
{   world tour. Don't worry about sending cash in the mail, just fold it into }
{   a sheet of paper so that you can't see that the money through the         }
{   envelope - a few disgruntled post office workers may steal an envelope or }
{   two, but hey, your conscience will be clear and I'll never know the       }
{   difference.                                                               }
{                                                                             }
{   Subject to your sending me some money for drinks, you are free to use     }
{   these components in any commercial or non-commercial product, as long as  }
{   that product is not a just a collection of components. However, you may   }
{   redistribute this components as long as:                                  }
{     a) This message appears, along with complete source code                }
{     b) There is only a nominal charge (under $5) for distribution only      }
{                                                                             }
{   Full source code is included with this component. This means that if      }
{   you find a problem, you should try to fix it yourself! Seriously, if      }
{   you find a problem, please contact me through Compu-Serve. If you have a  }
{   bug fix, I'll revise my code and post a new version along with an         }
{   acknowledgement of your contribution. If you can't fix the problem, I'll  }
{   make a note of it on my to-do list and I'll fix it eventually.            }
{                                                                             }
{                                                                             }
{  Author: Cameron D. Peters                                                  }
{          Suite 303, 908 - 17th Avenue S.W.                                  }
{          Calgary, Alberta CANADA                                            }
{          CIS: 72561,3146                                                    }
{          Phone: 403-228-9991                                                }
{          Fax: 403-228-0202                                                  }
{                                                                             }
{  Revision History:                                                          }
{    1.00  CDP  951118  Created                                               }
{                                                                             }
{  Installation                                                               }
{    Use Tools|Install Components to add this to your VCL. TBMScroll will     }
{    be added to the additional page of your component palette.               }
{                                                                             }
{  Properties                                                                 }
{    I haven't created an on-line help file for this component, because I     }
{    don't really have the time, or possibly because I am just lazy. Perhaps  }
{    I'll create one if enough people download this file as it is! Anyways,   }
{    here are my notes on the properties which were not inherited (in no      }
{    particular order):                                                       }
{                                                                             }
{  AutoScroll                                                                 }
{    When AutoScroll is set to TRUE, scrolling will begin as soon as the      }
{    window appears on the screen.                                            }
{  Bitmap                                                                     }
{    This is the scrolling bitmap. Create any kind of bitmap that you want -  }
{    I'm doing something that looks kind of like movie credits, but hopefully }
{    you'll be more creative. Put everything you want on one LONG bitmap.     }
{    Mine is 240 x 1000! The window I create for this control is 240 x 200.   }
{    The height of the control MUST BE LESS than the height of the bitmap,    }
{    otherwise things probably won't look very good - I haven't put in any    }
{    error checking to avoid this situation. As well, you should try and keep }
{    the control size in mind when you create the bitmap, because you'll      }
{    probably want it to look good even when it's not scrolling.              }
{  ScrollIt                                                                   }
{    Set it to TRUE when you want the bitmap to scroll and play music, FALSE  }
{    otherwise. Works at design time!                                         }
{  ScrollStep                                                                 }
{    The number of pixels the bitmap scrolls up each interval.                }
{  ScrollTime                                                                 }
{    The length of time between scrolling (in milliseconds). ScrollTime must  }
{    be between 10 and 5000 milliseconds.                                     }
{  ScrollLoops                                                                }
{    The number of times the bitmap should be scrolled through.               }
{    0 is infinite. Sound will stop when the scrolling stops.                 }
{  SoundFile                                                                  }
{    The wav file which will be looped while scrolling is going on.           }
{  SoundLoop                                                                  }
{    When set to true, the sound will continue to loop until the scrolling is }
{    finished. When false, the sound will play through once or until the      }
{    scrolling is complete, whichever comes first.                            }
{                                                                             }
{*****************************************************************************}

unit Bmscroll;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DsgnIntf, MMSystem;

type
  TBMScroll = class(TCustomControl)
  private
    { Private declarations }
    FAutoScroll: Boolean;
    FBitmap: TBitmap;
    FBorderStyle: TBorderStyle;
    FClickScroll: Boolean;
    FLoopLeft: Integer;
    FScrolling: Boolean;
    FScrollLoops: Integer;
    FScrollStep: Integer;
    FScrollTime: Longint;
    FSoundFile: PString;
    FSoundLoop: Boolean;
    FYOffset: Integer;
  protected
    { Protected declarations }
    procedure CreateParams(var Params: TCreateParams); override;
    procedure DestroyWnd; override;
    procedure Click; override;
    function GetSoundFile: String;
    procedure Loaded; override;
    procedure Paint; override;
    procedure SetBitmap(V: TBitmap);
    procedure SetBorderStyle(V: TBorderStyle);
    procedure SetScrolling(V: Boolean);
    procedure SetScrollTime(V: longint);
    procedure SetSoundFile(const V: String);
    procedure WMTimer(var Msg: TWMTimer); message WM_Timer;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Scrolling: Boolean read FScrolling write SetScrolling;
  published
    { Published declarations }
    property Align;
    property AutoScroll: Boolean read FAutoScroll write FAutoScroll default TRUE;
    property Bitmap: TBitmap read FBitmap write SetBitmap;
    property BorderStyle: TBorderStyle read FBorderStyle write SetBorderStyle default bsSingle;
    property ClickScroll: Boolean read FClickScroll write FClickScroll;
    property Enabled;
    property Hint;
    property Height default 80;
    property ScrollIt: Boolean read FScrolling write SetScrolling default FALSE;
    property ScrollLoops: Integer read FScrollLoops write FScrollLoops default 0;
    property ScrollStep: Integer read FScrollStep write FScrollStep default 1;
    property ScrollTime: Longint read FScrollTime write SetScrollTime default 50;
    property ShowHint;
    property SoundFile: String read GetSoundFile write SetSoundFile;
    property SoundLoop: Boolean read FSoundLoop write FSoundLoop default TRUE;
    property Visible;
    property Width default 80;
  end;

  TSoundFileProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Additional', [TBMScroll]);
  RegisterPropertyEditor(TypeInfo(String), TBMScroll, 'SoundFile', TSoundFileProperty);
end;


procedure PlaySound(const FileName: String; uFlags: word);

var
  SName: array[0..128] of char;

begin
  if (length(FileName) > 0)
    then begin
           StrPCopy(SName,FileName);
           sndPlaySound(SName,uFlags);
         end
    else sndPlaySound(NIL,0);
end;


constructor TBMScroll.Create(AOwner: TComponent);

begin
  inherited Create(AOwner);
  FBitmap := TBitmap.Create;
  ControlStyle := ControlStyle + [csOpaque];
  FAutoScroll := TRUE;
  FBorderStyle := bsSingle;
  FScrollStep := 1;
  FScrollTime := 50;
  FSoundLoop := TRUE;
  SetBounds(0,0,80,80);
end;

const
  BorderStyles: array[TBorderStyle] of Longint = (0, WS_BORDER);

procedure TBMScroll.CreateParams(var Params: TCreateParams);

begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or BorderStyles[FBorderStyle];
end;


destructor TBMScroll.Destroy;

begin
  FBitmap.Free;
  inherited Destroy;
end;


procedure TBMScroll.DestroyWnd;

begin
  ScrollIt := FALSE;
  inherited DestroyWnd;
end;


procedure TBMScroll.Click;

begin
  if (FClickScroll)
    then ScrollIt := not(ScrollIt);
  inherited Click;
end;


function TBMScroll.GetSoundFile: String;

begin
  if (FSoundFile <> NIL)
    then Result := FSoundFile^
    else Result := '';
end;


procedure TBMScroll.Loaded;

begin
  {Get things rolling...}
  if (FScrolling) or (FAutoScroll)
    then begin
           FScrolling := FALSE;
           ScrollIt := TRUE;
         end;
end;


procedure TBMScroll.Paint;

var
  DestRect, SourceRect: TRect;
  FirstHeight: Integer;


  function IntFindPos(X: Integer): Integer;

  begin
    if (X > 0)
      then Result := X
      else Result := 0;
  end;


begin
  inherited Paint;
  if not(FBitmap.Empty)
    then begin
           Canvas.CopyMode := cmSrcCopy;
           FirstHeight := Height-IntFindPos(Height+FYOffset-FBitmap.Height);
           DestRect := Rect(0,0,Width,FirstHeight);
           SourceRect := Rect(0,FYOffset,Width,FYOffset+FirstHeight);
           Canvas.CopyRect(DestRect,FBitmap.Canvas,SourceRect);

           if (DestRect.Bottom < Height)
             then begin
                    DestRect := Rect(0,FirstHeight,Width,Height);
                    SourceRect := Rect(0,0,Width,Height-FirstHeight);
                    Canvas.CopyRect(DestRect,FBitmap.Canvas,SourceRect);
                  end;
         end;
end;


procedure TBMScroll.SetBitmap(V: TBitmap);

begin
  FBitmap.Assign(V);
end;


procedure TBMScroll.SetBorderStyle(V: TBorderStyle);

begin
  if (V <> FBorderStyle)
    then begin
           FBorderStyle := V;
           RecreateWnd;
         end;
end;


procedure TBMScroll.SetScrolling(V: Boolean);

var
  Param: word;

begin
  if (V <> FScrolling)
    then begin
           FScrolling := V;
           if (FScrolling)
             then begin
                    if (csReading in ComponentState)
                      then exit;

                    SetTimer(Handle,1,FScrollTime,NIL);
                    FLoopLeft := FScrollLoops;
                    if (SoundFile > '') and not(csDesigning in ComponentState)
                      then begin
                             Param := snd_Async+snd_nodefault;
                             if (FSoundLoop)
                               then Param := Param + snd_loop;
                             PlaySound(Soundfile,Param);
                           end;
                  end
             else begin
                    KillTimer(Handle,1);
                    PlaySound('',0);
                    if (FYOffset <> 0) and (csDesigning in ComponentState)
                      then begin
                             FYOffset := 0;
                             Repaint;
                           end;
                  end;
         end;
end;


procedure TBMScroll.SetScrollTime(V: Longint);

begin
  if (V < 10) or (V > 5000)
    then exit;

  if (V <> FScrollTime)
    then begin
           FScrollTime := V;
           if (FScrolling)
             then begin
                    KillTimer(Handle,1);
                    SetTImer(Handle,1,FScrollTime,NIL);
                  end;
         end;
end;


procedure TBMScroll.SetSoundFile(const V: String);

var
  Param: word;

begin
  AssignStr(FSoundFile,V);
  if (FScrolling)
    then begin
           PlaySound('',0);
           if (length(SoundFile) > 0) and not(csDesigning in ComponentState)
             then begin
                    Param := snd_Async+snd_NoDefault;
                    if (FSoundLoop)
                      then Param := Param + snd_Loop;
                    PlaySound(Soundfile,Param);
                  end;
         end;
end;


procedure TBMScroll.WMTimer(var Msg: TWMTimer);

begin
  FYOffset := ((FYOffset+FScrollStep) mod FBitmap.Height);
  if (FYOffset < FScrollStep) and (FScrollLoops > 0) and not(csDesigning in ComponentState)
    then Dec(FLoopLeft);

  if (FScrollLoops > 0) and (FLoopLeft <= 0)
    then begin
           FYOffset := 0;
           Repaint;
           ScrollIt := FALSE;
         end
    else begin
           if (csDesigning in ComponentState)
             then Repaint
             else begin
                    ScrollWindow(Handle,0,-FScrollStep,NIL,NIL);
                    UpdateWindow(Handle);
                  end;
         end;
end;



procedure TSoundFileProperty.Edit;
var
  MPFileOpen: TOpenDialog;
begin
  MPFileOpen := TOpenDialog.Create(Application);
  MPFileOpen.Filename := GetValue;
  MPFileOpen.Filter := 'Sound File (*.wav)|*.wav';
  MPFileOpen.Options := MPFileOpen.Options + [ofPathMustExist,
    ofFileMustExist];
  try
    if MPFileOpen.Execute then SetValue(MPFileOpen.Filename);
  finally
    MPFileOpen.Free;
  end;
end;

function TSoundFileProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

end.