unit BmFDlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExplBtn, ExtCtrls,
  BmAssMsc;

type
  TFormDialog = class(TForm)
    MemoText: TMemo;
    Image: TImage;
    TipHeader: TLabel;
    ShowAtstart: TCheckBox;
    TipHelp: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Dclarations private }
    NumTip : Word;
    procedure WMNCHitTest(var Msg : TWMNCHitTest ); message wm_NCHitTest;
    procedure UpdateRoundForm;
  public
    { Dclarations public }
    aParent : tWinControl;
    aDialogMode : DialogMode; {message ou astuces?}
    Tips : TStringList;
    FButtons : array[TMsgDlgBtn] of tExplorerButton;
    RoundCorners,
    NbButtonFlags,
    ButtonHeight,
    ButtonWidth,
    VertSpace,
    HorzSpace : Integer;
    procedure ButtonClick(Sender: TObject);
    Procedure CreateButtons (Flags : tMsgDlgButtons);
    Procedure CreateTipsBtn;
    procedure AdjustMemo;
    Procedure PositButtons (aTop : Integer);
    Procedure PositDialog;
    Procedure SetImage (aType : tMsgDlgType);
    procedure NextTips;
    function ShowDialog (wParent : tWinControl; const Msg: string;
                         AType: TMsgDlgType; AButtons: TMsgDlgButtons;
                         HelpCtx: Longint): Word;
    function ShowTips (wParent : tWinControl; aTips : tStringList) : Word;
  end;

var
  FormDialog: TFormDialog;

implementation

{$IFNDEF WIN32}
  {$R *.R16}
{$ELSE}
  {$R *.R32}
{$ENDIF}

{$R *.DFM}

procedure TFormDialog.WMNCHitTest(var Msg : TWMNCHitTest);
begin
  inherited;
  { fool windows by telling it that it's in our caption area
    although it's in our client area }
  if (htClient = Msg.Result)
    then Msg.Result := htCaption;
end;

procedure TFormDialog.UpdateRoundForm;
var
  FormRgn : hRgn;
begin
{$IFDEF WIN32}
  FormRgn := 0;
  {Create a rounded form}
  Canvas.Brush.Style := bsClear;
  GetWindowRgn (Handle, FormRgn);
  DeleteObject (FormRgn);
  FormRgn := CreateRoundRectRgn (0, 0, ClientWidth, ClientHeight,
                                 RoundCorners, RoundCorners);
  SetWindowRgn (Handle, FormRgn, TRUE);
{$ENDIF}
end;

procedure TFormDialog.FormCreate(Sender: TObject);
var
  aButton : TMsgDlgBtn;
begin
  RoundCorners := 40;
  ButtonHeight := 20;
  ButtonWidth := 70;
  VertSpace := 4;
  HorzSpace := 0;
  for aButton := low(TMsgDlgBtn) to high(TMsgDlgBtn) do
    FButtons[aButton]:=nil;
  Tips := TStringList.Create;
  Color := $00CCFFFF; {change color for DialogBox}
  MemoText.Color := Color;
  {$IFNDEF WIN32}
  MemoText.BorderStyle := bsNone;
  {$ENDIF}
  UpdateRoundForm;
end;

procedure TFormDialog.FormDestroy(Sender: TObject);
var
  aButton : TMsgDlgBtn;
begin
  for aButton := low(TMsgDlgBtn) to high(TMsgDlgBtn) do
    if Assigned(FButtons[aButton])
      then FButtons[aButton].Free;
  Tips.Free;
end;

procedure TFormDialog.ButtonClick(Sender: TObject);
var
  FButton : tMsgDlgBtn;
begin
  FButton := tMsgDlgBtn((Sender as tExplorerButton).Tag);
  Case aDialogMode of
    dmMessage :
      begin
        modalResult := ButtonResult[FButton];
      end;
    dmTips :
      begin
        Case FButton of
          mbOk : ModalResult := ButtonResult[FButton];
          mbRetry : NextTips;
        end;
      end;
  end;
end;

procedure TFormDialog.FormPaint(Sender: TObject);
begin
  Canvas.Brush.Style := bsClear;
  Canvas.Pen.Color := clBlack;
  Canvas.RoundRect (0, 0, ClientWidth-1, ClientHeight-1,
                    RoundCorners, RoundCorners);
end;

{****************************************************************************}

Procedure TFormDialog.CreateButtons (Flags : tMsgDlgButtons);
var
  aButton : TMsgDlgBtn;
begin
  {cration des boutons}
  NbButtonFlags := 0;
  for aButton := low(TMsgDlgBtn) to high(TMsgDlgBtn) do
    if aButton in Flags
    then begin
      inc (NbButtonFlags, 1); 
      If not Assigned (FButtons[aButton])
      then begin
        FButtons[aButton]:= tExplorerButton.Create(Self);
        DeleteObject (FButtons[aButton].Bitmap.Handle);
        FButtons[aButton].Bitmap.ReleaseHandle;
        FButtons[aButton].Bitmap.Handle := LoadBitmap(HInstance, 'ABTN_ON');
        DeleteObject (FButtons[aButton].NoFocusBitmap.Handle);
        FButtons[aButton].NoFocusBitmap.ReleaseHandle;
        FButtons[aButton].NoFocusBitmap.Handle := LoadBitmap(HInstance, 'ABTN_OFF');
        FButtons[aButton].Layout := blBitmapLeft;
        FButtons[aButton].Options := [boMonoDisplay];
        FButtons[aButton].UnselectedFontColor := clGrayText;
        FButtons[aButton].Parent := Self;
      end;
      FButtons[aButton].Width := ButtonWidth;
      FButtons[aButton].Height := ButtonHeight;
      FButtons[aButton].Font := Font;
      FButtons[aButton].OnClick := ButtonClick;
      FButtons[aButton].Caption := ButtonCaption[aButton];
      FButtons[aButton].Tag := ord(aButton);
    end
    else begin
      if Assigned (FButtons[aButton])
      then begin
        FButtons[aButton].Free;
        FButtons[aButton] := nil;
      end;
    end;
end;

Procedure TFormDialog.CreateTipsBtn;
begin
  createButtons ([mbOk, mbRetry]);
  FButtons[mbRetry].Caption := ButtonNextTips;
end;

procedure TFormDialog.AdjustMemo;
const
  TextMargin = 3;
var
  NbLines : Integer;
begin
  MemoText.SelStart := 0;
  NbLines := MemoText.Lines.Count;
  if NbLines<3
    then NbLines := 3;
  MemoText.Height := TextMargin*2+
                     NbLines*(Canvas.TextHeight('M'));
  MemoText.Refresh;
end;

Procedure TFormDialog.PositButtons (aTop : Integer);
var
  aButton : TMsgDlgBtn;
  NbButtonLine,
  StartLeft,
  ButtonLeft,
  ButtonTop,
  ButtonHeight : integer;
begin
  {positionnement des boutons}
  ButtonTop := aTop+VertSpace;
  ButtonHeight := Self.ButtonHeight;
  NbButtonLine := Width div (ButtonWidth+HorzSpace);
  if NbButtonFlags < NbButtonLine
    then NbButtonLine := NbButtonFlags;
  StartLeft := (Width-NbButtonLine*(ButtonWidth+HorzSpace)) div 2;
  ButtonLeft := StartLeft;
  for aButton := low(TMsgDlgBtn) to high(TMsgDlgBtn) do
    if Assigned (FButtons[aButton])
    then begin
      If ButtonLeft+ButtonWidth>Width
      then begin
        ButtonLeft := StartLeft;
        Inc(ButtonTop, ButtonHeight+VertSpace);
      end;
      FButtons[aButton].Left := ButtonLeft;
      FButtons[aButton].Top := ButtonTop;
      ButtonHeight := FButtons[aButton].Height;
      Inc (ButtonLeft, ButtonWidth+HorzSpace);
    end;
  ClientHeight := ButtonTop+ButtonHeight+VertSpace;
  UpdateRoundForm;
  Invalidate;
end;

Procedure TFormDialog.PositDialog;
begin
  Left := aParent.Left-Width;
  If Left<0
  then begin
    Left:=0;
    aParent.Left:=Left+Width;
  end;
  Top := aParent.Top;
  If Top<0
  then begin
    Top:=0;
    aParent.Top:=Top;
  end;
  If Top+Height>Screen.Height
    then Top:=Screen.Height-Height;
end;

Procedure TFormDialog.SetImage (aType : tMsgDlgType);
begin
  DeleteObject (Image.Picture.Icon.Handle);
  Image.Picture.Icon.ReleaseHandle;
  Case aType of
    mtWarning       : Image.Picture.Icon.Handle := LoadIcon(0, idi_exclamation);
    mtError         : Image.Picture.Icon.Handle := LoadIcon(0, idi_hand);
    mtInformation   : Image.Picture.Icon.Handle := LoadIcon(0, idi_asterisk);
    mtConfirmation  : Image.Picture.Icon.Handle := LoadIcon(0, idi_question);
    mtCustom        : Image.Picture.Icon.Handle := LoadIcon(0, idi_application);
  end;
end;

function TFormDialog.ShowDialog (wParent : tWinControl; const Msg: string;
                                 AType: TMsgDlgType; AButtons: TMsgDlgButtons;
                                 HelpCtx: Longint): Word;
begin
  aDialogMode := dmMessage;
  aParent := wParent;
  CreateButtons(aButtons);

  TipHelp.Visible := false;
  ShowAtStart.Visible := false;
  MemoText.Top := TipHeader.Top+TipHeader.Height+4;

  MemoText.Lines.Clear;
  MemoText.Lines.Add (Msg);
  AdjustMemo;
  PositButtons (MemoText.Top+MemoText.Height);
  PositDialog;

  SetImage(aType);
  Result := ShowModal;
end;

procedure TFormDialog.NextTips;
begin
  NumTip := Random(Tips.Count);
  MemoText.Lines.Clear;
  MemoText.Lines.Add (Tips.Strings[NumTip]);
  AdjustMemo;
  ShowAtStart.Top := MemoText.Top+MemoText.Height+VertSpace;
  PositButtons (ShowAtStart.Top+ShowAtStart.Height);
  PositDialog;
end;

function TFormDialog.ShowTips (wParent : tWinControl; aTips : tStringList) : word;
begin
  aDialogMode := dmTips;
  aParent := wParent;
  CreateTipsBtn;

  TipHelp.Visible := true;
  ShowAtStart.Visible := true;
  MemoText.Top := TipHelp.Top+TipHelp.Height+VertSpace;

  if Assigned(aTips)
    then Tips.Assign (aTips);
  If Tips.Count = 0 Then
     Tips.Add(IdsNoTips);

  If Tips.Count = 1 Then
     FButtons[mbRetry].Enabled := False;
  Invalidate;

  Randomize;
  NextTips;

  SetImage(mtCustom);
  Result := ShowModal;
end;

end.

