unit BmFAss;

interface

uses
  mmSystem, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, Menus, SysUtils,
  BmBmp, BmFDlg, BmAnim, BmAssDLL, BmAssMsc;

type
  TFormAssist = class(TForm)
    Popup: TPopupMenu;
    TimerIdle: TTimer;
    TimerMove: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormdDblClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TimerIdleTimer(Sender: TObject);
    procedure AnimatedChangeFrame(Sender: TObject);
    procedure TimerMoveTimer(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    FDialog   : tFormDialog;
    MinIdle,
    MaxIdle   : Integer;
    SoundStream : tMemoryStream;
    SoundFrame  : Integer;
{$IFDEF WIN32}
    Transparent : boolean;
{$ENDIF}
    ToggleHitTest : boolean;
    PtDestination : tPoint;
    procedure WMNCHitTest(var Msg : TWMNCHitTest ); message wm_NCHitTest;
    procedure UpdateForm;
    {IsPlaying return true if animation is playing}
    Function IsPlaying (Wait : boolean): boolean;
    {Is occupied return true when dialog box is displayed}
    Function IsOccupied : boolean;
  public
    Animated : tBmAnimated;
    AssistDLL : tAssistDLL;
    AssHeader : string;
    AssTipHelp : string;
    AssTitle : string;
    CustomName : String;
    EnableIdle : boolean;
    MoveStep : integer;
    Tips : tStringList;
    TipsAtStart : boolean;
    UseSound : boolean;
{$IFDEF WIN32}
    procedure SetTransparent (value : boolean);
    function GetTransparent : boolean;
{$ENDIF}
    procedure AboutComp(Sender: TObject);
    procedure AboutAnims(Sender: TObject);
    function GetAnimList : pChar;
    function GetAnimsVersion : tVersion;
    procedure LoadAssistLib;
    procedure MoveTo (x, y : integer);
    procedure SetPosition (x, y : integer);
    procedure SetCustom (AnimName : pChar);
    procedure AnimPlay (AnimName : pChar; isReverse : boolean);
    procedure AnimBack;
    procedure StartProcessing;
    procedure StopProcessing;
    procedure Idle;
    procedure SetEnableIdle (value : boolean);
    function Dialog (const Msg: string; AType: TMsgDlgType;
                     AButtons: TMsgDlgButtons; HelpCtx: Longint): Word;
    function ShowTips : Word;
    procedure ShowAssist(Fast : boolean);
    procedure HideAssist(Fast : boolean);
  end;

implementation

{$R *.DFM}

procedure TFormAssist.WMNCHitTest(var Msg : TWMNCHitTest);
begin
  inherited;
  { fool windows by telling it that it's in our caption area
    although it's in our client area }
  ToggleHitTest := not ToggleHitTest;
  if ToggleHitTest
  then begin
    if (Msg.Result = htClient)
      then Msg.Result := htCaption;
  end;
end;

procedure TFormAssist.UpdateForm;
var
  FormRgn,
  FormRgn2 : hRgn;
begin
{$IFDEF WIN32}
  if Animated.Bitmap.Width<>0 then
  begin
    FormRgn2 := 0;
    {Create a rounded form}
    Canvas.Brush.Style := bsClear;
    GetWindowRgn (Handle, FormRgn2);
    FormRgn := CreateRgnFromBmp (Animated.CurrentFrame,
                                 Animated.CurrentFrame.Canvas.Pixels[0, 0]);

    SetWindowRgn (Handle, FormRgn, TRUE);
    DeleteObject (FormRgn2);
  end;
{$ENDIF}
end;

Function TFormAssist.IsPlaying (Wait : boolean): boolean;
begin
  Result := Animated.Play = true;
  if Result and Wait
  then begin
    Repeat
      Application.ProcessMessages;
    until Animated.Play = false;
    Result := Animated.Play = true;
  end;
end;

Function TFormAssist.IsOccupied : boolean;
begin
  Result := False;
  Result := FDialog.Visible = true;
end;

{$IFDEF WIN32}
procedure TFormAssist.SetTransparent (value : boolean);
begin
  Transparent := value;
  if not Transparent then
  begin
    BorderStyle := bsToolWindow;
    Brush.Style := bsSolid;
  end
  else begin
    BorderStyle := bsNone;
    Brush.Style := bsClear;
  end;
  ClientWidth := Animated.Width;
  ClientHeight := Animated.Height;
//  Update;
  if Assigned (Animated.OnChangeFrame)
    then Animated.OnChangeFrame(Self);
end;

function TFormAssist.GetTransparent : boolean;
begin
  result := Transparent;
end;
{$ENDIF}

procedure TFormAssist.AboutComp(Sender: TObject);
begin
  Dialog(AboutStr, mtInformation, [mbOk], 0);
end;

procedure TFormAssist.AboutAnims(Sender: TObject);
begin
  if Assigned (AssistDLL.GetCopyright)
    then Dialog(AssistDLL.GetCopyright, mtInformation, [mbOk], 0);
end;

var
  LongBuf : array[0..512] of char;

function ProcEnumResName (hModule : tHandle;
                          lpszType : LPCTSTR;
                          lpszName : LPTSTR;
                          lParam : LongInt) : boolean; far;
begin
  if StrLen(LongBuf)<>0 then
    StrCat (LongBuf, ';');
  StrCat (LongBuf, lpszName);
  Result := true;
end;

function TFormAssist.GetAnimList : pChar;
begin
  if Assigned (AssistDLL.GetAnimList)
    then result := AssistDLL.GetAnimList
    else result := '';
end;

function TFormAssist.GetAnimsVersion : tVersion;
var
  Buf : array[0..255] of char;
  InfoSize : dWord;
  Data : Pointer;
  aHandle : tHandle;
  FileInfo : PVSFixedFileInfo;
  FileinfoSize : uint;
begin 
  Result.Major := 0;
  Result.Minor := 0;
  Result.Release := 0;
  Result.Build := 0;
  StrPCopy (Buf, AssistDLL.LibraryName);
  aHandle := 0;
  InfoSize := GetFileVersionInfoSize (Buf, aHandle);
  GetMem (Data, InfoSize);
  try
    if GetFileVersionInfo (Buf, 0, InfoSize, Data)
    then begin
      VerQueryValue (Data, '\', Pointer(Fileinfo), FileInfoSize);
      Result.Major := HiWord(FileInfo^.dwFileVersionMS);
      Result.Minor := LoWord(FileInfo^.dwFileVersionMS);
      Result.Release := HiWord(FileInfo^.dwFileVersionLS);
      Result.Build := LoWord(FileInfo^.dwFileVersionLS);
    end;
  finally
    FreeMem(Data);
  end;
end;

procedure TFormAssist.LoadAssistLib;
begin
  AssistDLL.LoadDLL;
end;

procedure TFormAssist.MoveTo (X, Y : integer);
var
  DeltaX,
  DeltaY : Integer;
  Buf : array [0..255] of char;
begin
  PtDestination := Point(X, Y);
  DeltaX := PtDestination.X-Left; // negative when going right
  DeltaY := PtDestination.Y-Top; // negative when going bottom
  if abs(DeltaX) > abs(DeltaY) then // moving horizontally
  begin
    if DeltaX<0 then
      StrCopy(Buf, AssistDLL.GetOrientedName(onMove, toRight))
    else
      StrCopy(Buf, AssistDLL.GetOrientedName(onMove, toLeft));
  end
  else begin// moving vertically
    if DeltaY>0 then
      StrCopy(Buf, AssistDLL.GetOrientedName(onMove, toDown))
    else
      StrCopy(Buf, AssistDLL.GetOrientedName(onMove, toUp));
  end;
  AnimPlay (Buf, false);
  IsPlaying (true); // wait until end of animation...
  TimerMove.Interval := 2;
  TimerMove.Enabled := true;
end;

procedure TFormAssist.SetPosition (X, Y : integer);
begin
  SetBounds(X, Y, Width, Height);
end;

procedure TFormAssist.SetCustom (AnimName : pChar);
begin
  CustomName := strPas(AnimName);
end;

procedure TFormAssist.AnimPlay (AnimName : pChar; isReverse : boolean);
var
  FrameBounds : tPoint;
begin
  if AssistDLL.InstanceLoaded
  and not IsPlaying (True)
  and (StrLen(AnimName)<>0)
  then begin
    SetCustom(AnimName);
    if Assigned (AssistDLL.LoadAnim)
    then begin
      DeleteObject (Animated.Bitmap.Handle);
      Animated.Bitmap.ReleaseHandle;
      Animated.Bitmap.Handle := AssistDLL.LoadAnim (AnimName);
      Animated.TransparentColor := Animated.Bitmap.Canvas.Pixels[0,0];
      if Assigned (SoundStream)
      then begin
        sndPlaySound (nil, 0); {stop playing sounds}
        SoundStream.Free;
        SoundStream := nil;
      end;
      if Assigned (AssistDLL.LoadSound)
        then SoundStream := AssistDLL.LoadSound (AnimName);
      if Assigned (AssistDLL.GetSoundFrame)
        then SoundFrame := AssistDLL.GetSoundFrame (AnimName);

      if Assigned (AssistDLL.GetBounds)
        then FrameBounds := AssistDLL.GetBounds;
      Animated.Width := FrameBounds.X;
      Animated.Height := FrameBounds.Y;
      Animated.FrameCount := Animated.Bitmap.Width div FrameBounds.X;
//      ClientWidth := Animated.Width+8;
//      ClientHeight := Animated.Height+8;
      ClientWidth := Animated.Width;
      ClientHeight := Animated.Height;
      if Assigned (AssistDLL.GetAnimSpeed)
        then Animated.Interval := AssistDLL.GetAnimSpeed (AnimName);
      if Animated.FrameCount>0 then
        Animated.Frame := 0;
      if Assigned (Animated.OnChangeFrame)
        then Animated.OnChangeFrame(Self);

//      Update;
      Animated.Reverse := isReverse;
      if Animated.FrameCount>0 then
        Animated.Play := True;
    end;
  end;
end;

procedure TFormAssist.AnimBack;
var
  ReturnName,
  Buf : Array[0..255] of char;
begin
  if not IsPlaying (True)
  then begin
    ReturnName := '';
    {if return animation doesn't exists, return rest_pose animation}
    if Assigned (AssistDLL.GetReturnName) then
    begin
      StrPCopy (Buf, CustomName);
      StrCopy (ReturnName, AssistDLL.GetReturnName(Buf));
    end;
    AnimPlay (ReturnName, false);
  end;
end;

procedure TFormAssist.StartProcessing;
var
  ProcessingName : Array[0..255] of char;
begin
  if Assigned (AssistDLL.GetProcessingName) then
    StrCopy(ProcessingName, AssistDLL.GetProcessingName);
  if Assigned (AssistDLL.GetStartName)
    then AnimPlay (AssistDLL.GetStartName(ProcessingName), false);
  AnimPlay (ProcessingName, false);
  Animated.Loop := True;
end;

procedure TFormAssist.StopProcessing;
begin
  Animated.Loop := False;
  AnimBack;
end;

procedure TFormAssist.SetEnableIdle (value : boolean);
begin
  if Value<>EnableIdle
  then begin
    EnableIdle := value;
    TimerIdle.Enabled := EnableIdle;
  end;
end;

procedure TFormAssist.Idle;
var
{  ReturnName,}
  IdleName : Array[0..255] of char;
begin
  if not IsPlaying (True)
  then begin
    if Assigned (AssistDLL.GetIdleName) then
      StrCopy (IdleName, AssistDLL.GetIdleName);
    AnimPlay(IdleName, false);
{    if Assigned (AssistDLL.GetReturnName)
      then ReturnName := AssistDLL.GetReturnName(IdleName);
    if length(ReturnName)<>0
    then begin
      AnimPlay (ReturnName, false);
    end;}
  end;
end;

{******************************************************************************}
procedure TFormAssist.FormCreate(Sender: TObject);
var
  NewItem : TMenuItem;
begin
  FDialog := tFormDialog.Create (Application);
  Left := 1;
  Top := 1;
  MoveStep := 8;
  CustomName := '';
  Tips := tStringList.Create;

  SoundStream := nil;

  MinIdle := 2000;  {2 secondes mini}
  MaxIdle := 10000; {10 secondes maxi}
  Randomize;
  TimerIdle.Interval := MinIdle+Random(MaxIdle-MinIdle);
  TimerIdle.Enabled := False;
  EnableIdle := True;
  UseSound := True;
  TimerMove.Enabled := false;
  PtDestination := Point(-1, -1);

  AssistDLL := tAssistDLL.Create (Application);

  NewItem := TMenuItem.Create(Popup);
  NewItem.Caption := IdsPopupName;
  Popup.Items.Add(NewItem);

  NewItem := TMenuItem.Create(Popup);
  NewItem.Caption := '-';
  Popup.Items.Add(NewItem);

  NewItem := TMenuItem.Create(Popup);
  NewItem.Caption := IdsAboutComp;
  NewItem.OnClick := AboutComp;
  Popup.Items.Add(NewItem);

  NewItem := TMenuItem.Create(Popup);
  NewItem.Caption := IdsAboutAnims;
  NewItem.OnClick := AboutAnims;
  Popup.Items.Add(NewItem);

  Animated := tBmAnimated.Create (Self);
  Animated.OnDblClick := FormdDblClick;
  Animated.OnChangeFrame := AnimatedChangeFrame;
  Animated.Loop := false;

{$IFDEF WIN32}
  SetTransparent (true);
{$ENDIF}
  if Transparent then
    UpdateForm;
end;

procedure TFormAssist.FormDestroy(Sender: TObject);
begin
  sndPlaySound (nil, 0); {stop playing sounds}
(*  if Assigned (SoundStream) then
  begin
    SoundStream.Free;
    SoundStream := nil;
  end;*)
  Tips.Free;
  Tips := nil;
{  AssistDLL.Free;} {Done automatically by application}
{  FDialog.Free; } {Done automatically by application}
end;

function TFormAssist.Dialog (const Msg: string; AType: TMsgDlgType;
                             AButtons: TMsgDlgButtons;
                             HelpCtx: Longint): Word;
var
  buf : Array[0..255] of Char;
begin
  Result := mrNone;
  Show;
  WindowState := wsNormal;
  if not IsPlaying (True)
  then begin
    case aType of
      mtWarning      : if Assigned (AssistDLL.GetWarningName)
                         then AnimPlay (AssistDLL.GetWarningName, false);
      mtError        : if Assigned (AssistDLL.GetErrorName)
                         then AnimPlay (AssistDLL.GetErrorName, false);
      mtInformation  : if Assigned (AssistDLL.GetInformationName)
                         then AnimPlay (AssistDLL.GetInformationName, false);
      mtConfirmation : if Assigned (AssistDLL.GetConfirmationName)
                         then AnimPlay (AssistDLL.GetConfirmationName, false);
      mtCustom       : AnimPlay (StrPCopy(Buf, CustomName), false);
    End;
    FDialog.Caption := DialogType[aType];
    FDialog.TipHeader.Caption := '';
    Result := FDialog.ShowDialog(Self, Msg, aType, aButtons, HelpCtx);
    AnimBack;
  end;
end;

function TFormAssist.ShowTips : word;
begin
  Result := mrNone;
  Show;
  WindowState := wsNormal;
  if not IsPlaying (True)
  then begin
    { Place property values }
    FDialog.TipHeader.Caption := AssHeader;
    FDialog.TipHelp.Caption := AssTipHelp;
    FDialog.ShowAtStart.Checked := TipsAtStart;
    FDialog.Caption := AssTitle;
    if Assigned (AssistDLL.GetTipsName)
      then AnimPlay (AssistDLL.GetTipsName, false);
    Result := FDialog.ShowTips (Self, Tips);
    { Store value from dialog before freeing}
    TipsAtStart := FDialog.ShowAtStart.Checked;
    AnimBack;
  end;
end;

procedure TFormAssist.FormdDblClick(Sender: TObject);
begin
  ShowTips;
end;

procedure TFormAssist.AnimatedChangeFrame(Sender: TObject);
begin
{$IFDEF WIN32}
  if Transparent then
    UpdateForm;
{$ENDIF}
  Canvas.CopyRect (Rect(0, 0, animated.width, animated.height), Animated.CurrentFrame.Canvas, Rect(0, 0, animated.width, animated.height));
//  Canvas.Draw (0, 0, Animated.CurrentFrame);
//  BitBlt (Canvas.Handle, 0, 0, Animated.Width, Animated.Height,
//          Animated.CurrentFrame.Canvas.Handle, 0, 0, SrcCopy);
  if UseSound
  and assigned(SoundStream)
  and (SoundFrame = Animated.Frame)
  then begin
    sndPlaySound (SoundStream.Memory, SND_ASYNC+SND_MEMORY);
  end;
end;

procedure TFormAssist.FormShow(Sender: TObject);
begin
  LoadAssistLib;
end;

procedure TFormAssist.ShowAssist(Fast : boolean);
begin
  if not visible
  then begin
    TimerIdle.Enabled := EnableIdle;
    Show;
    if not IsPlaying (True)
    then begin
      if not Fast
      then begin
        if Assigned (AssistDLL.GetShowName)
          then AnimPlay (AssistDLL.GetShowName, false);
      end
      else begin
        if Assigned (AssistDLL.GetRestName)
          then AnimPlay (AssistDLL.GetRestName, false);
      end;
    end;
  end;
end;

procedure TFormAssist.HideAssist(Fast : boolean);
begin
  if visible
  then begin
    TimerIdle.Enabled := false;
    if not IsPlaying (True)
    then begin
     if not Fast
      then begin
         if Assigned (AssistDLL.GetHideName)
           then AnimPlay (AssistDLL.GetHideName, false);
        Repeat
          Application.ProcessMessages;
        Until Animated.Play=False;
      end;
      Hide;
    end;
  end;
end;

procedure TFormAssist.TimerIdleTimer(Sender: TObject);
begin
  if not IsOccupied and not TimerMove.Enabled
  then begin
    TimerIdle.Enabled := false;
    Idle;
    TimerIdle.Interval := MinIdle+Random(MaxIdle-MinIdle);
    TimerIdle.Enabled := EnableIdle;
  end;
end;

procedure TFormAssist.TimerMoveTimer(Sender: TObject);
var
  DeltaX,
  DeltaY : Integer;
  PtMoveStep : tPoint;
  NewPos : tRect;
begin
  NewPos.BottomRight := Point (Width, Height);
  NewPos.TopLeft := Point (Left, Top);
  PtMoveStep := Point (MoveStep, MoveStep);
  DeltaX := PtDestination.X-Left;
  DeltaY := PtDestination.Y-Top;
  if DeltaX<>0 then
  begin
    if DeltaX>0 then
    begin
      NewPos.Left := Left + PtMoveStep.X;
      if NewPos.Left > PtDestination.X
        then NewPos.Left := PtDestination.X;
    end
    else begin
      NewPos.Left := Left - PtMoveStep.X;
      if NewPos.Left < PtDestination.X
        then NewPos.Left := PtDestination.X;
    end;
  end;
  if DeltaY<>0 then
  begin
    if DeltaY>0 then begin
      NewPos.Top := Top + PtMoveStep.Y;
      if NewPos.Top > PtDestination.Y
        then NewPos.Top := PtDestination.Y;
    end
    else begin
      NewPos.Top := Top - PtMoveStep.Y;
      if NewPos.Top < PtDestination.Y
        then NewPos.Top := PtDestination.Y;
    end;
  end;
  SetBounds (NewPos.Left, NewPos.Top, NewPos.Right, NewPos.Bottom);
  if (PtDestination.X=Left) and (PtDestination.Y=Top) then
  begin
    TimerMove.Enabled := false;
    AnimBack;
  end;
end;

procedure TFormAssist.FormPaint(Sender: TObject);
begin
  if Assigned (Animated.OnChangeFrame)
    then Animated.OnChangeFrame(Self);
end;

end.

