Unit BmBmp;

interface

uses
  WinTypes, WinProcs, Classes, Graphics;

{ Drawing of a bitmap on a canvas, with transparency
  (adapted from code found in the Microsoft Knowledge Base)}

procedure DrawTransparentBitmap (canvas: TCanvas; bmp: TBitmap;
                                 aRect : tRect;
                                 cTransparentColor: LongInt;
                                 Stretched : Boolean);
procedure DrawLine(Canvas: TCanvas; X1, Y1, X2, Y2: integer);
function DrawDisabledText (Canvas : tCanvas; Str: PChar; Count: Integer;
                           var Rect: TRect;  Format: Word): Integer;
function CreateRgnFromBmp (aBitmap : tBitmap; TransparentColor : tColor) : hRgn;
{Thanks to Tomasz Kustra for GetRgnFromBmpLR and associated functions}

implementation

var {used for creating region}
   Step:LongInt = 0;
   FirstScanLine:PByte = nil;
   MaxX:Integer =0;
   MaxY:Integer =0;

{ Drawing of a bitmap on a canvas, with transparency
  (adapted from code found in the Microsoft Knowledge Base)}

{****************** Draw Transparent Bitmap ***************
 ***** This function draws a bitmap with              *****
 *****  a transparent color.                          *****
 **********************************************************}
procedure DrawTransparentBitmap (canvas: TCanvas; bmp: TBitmap;
                                 aRect: tRect;
                                 cTransparentColor: LongInt;
                                 Stretched : Boolean);
var bm: WinTypes.TBitmap;
  cColor: TColorRef;
  bmAndBack, bmAndObject, bmAndMem, bmSave, oldBmp: HBITMAP;
  bmBackOld, bmObjectOld, bmMemOld, bmSaveOld, hBmp: HBITMAP;
  hdcMem, hdcBack, hdcObject, hdcTemp, hdcSave, dc: HDC;
  ptSize: WinTypes.TPoint;
  temp_bitmap: TBitmap;
begin
  temp_bitmap := TBitmap.Create;
  temp_bitmap.Assign(bmp);
  try
    dc := canvas.Handle;
    hBmp := temp_bitmap.Handle;
    hdcTemp := CreateCompatibleDC(dc);
    oldBmp := SelectObject(hdcTemp, hBmp);

    GetObject(hBmp, SizeOf(bm), @bm);
    ptSize.x := bm.bmWidth;
    ptSize.y := bm.bmHeight;

    hdcBack   := CreateCompatibleDC(dc);
    hdcObject := CreateCompatibleDC(dc);
    hdcMem    := CreateCompatibleDC(dc);
    hdcSave   := CreateCompatibleDC(dc);

    bmAndBack   := CreateBitmap(ptSize.x, ptSize.y, 1, 1, nil);

    bmAndObject := CreateBitmap(ptSize.x, ptSize.y, 1, 1, nil);

    bmAndMem    := CreateCompatibleBitmap(dc, ptSize.x, ptSize.y);
    bmSave      := CreateCompatibleBitmap(dc, ptSize.x, ptSize.y);

    bmBackOld   := SelectObject(hdcBack, bmAndBack);
    bmObjectOld := SelectObject(hdcObject, bmAndObject);
    bmMemOld    := SelectObject(hdcMem, bmAndMem);
    bmSaveOld   := SelectObject(hdcSave, bmSave);

    SetMapMode(hdcTemp, GetMapMode(dc));

    BitBlt(hdcSave, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCCOPY);

    cColor := SetBkColor(hdcTemp, cTransparentColor);

    BitBlt(hdcObject, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCCOPY);

    SetBkColor(hdcTemp, cColor);

    BitBlt(hdcBack, 0, 0, ptSize.x, ptSize.y, hdcObject, 0, 0, NOTSRCCOPY);
    If not Stretched
      then BitBlt (hdcMem, 0, 0, ptSize.x, ptSize.y,
                   dc, aRect.Left, aRect.Top, SRCCOPY)
      else StretchBlt (hdcMem, 0, 0, ptSize.x, ptSize.y,
                       dc, aRect.Left, aRect.Top,
                       aRect.Right-aRect.Left, aRect.Bottom-aRect.Top, SRCCOPY);
    BitBlt(hdcMem, 0, 0, ptSize.x, ptSize.y, hdcObject, 0, 0, SRCAND);
    BitBlt(hdcTemp, 0, 0, ptSize.x, ptSize.y, hdcBack, 0, 0, SRCAND);
    BitBlt(hdcMem, 0, 0, ptSize.x, ptSize.y, hdcTemp, 0, 0, SRCPAINT);
    If not Stretched
      then BitBlt (dc, aRect.Left, aRect.Top, ptSize.x, ptSize.y,
                   hdcMem, 0, 0, SRCCOPY)
      else StretchBlt (dc, aRect.Left, aRect.Top,
                       aRect.Right-aRect.Left, aRect.Bottom-aRect.Top,
                       hdcMem, 0, 0, ptSize.x, ptSize.y, SRCCOPY);
    BitBlt(hdcTemp, 0, 0, ptSize.x, ptSize.y, hdcSave, 0, 0, SRCCOPY);

    DeleteObject(SelectObject(hdcBack, bmBackOld));
    DeleteObject(SelectObject(hdcObject, bmObjectOld));
    DeleteObject(SelectObject(hdcMem, bmMemOld));
    DeleteObject(SelectObject(hdcSave, bmSaveOld));

    SelectObject(hdcTemp, oldBmp);

    DeleteDC(hdcMem);
    DeleteDC(hdcBack);
    DeleteDC(hdcObject);
    DeleteDC(hdcSave);
    DeleteDC(hdcTemp);
    finally
      temp_bitmap.Free;
  end;
end;

{********************** Draw Line *************************
 *****  Draw a line from point X1, Y1                 *****
 *****  to point X2, Y2.                              *****
 **********************************************************}
procedure DrawLine(Canvas: TCanvas; X1, Y1, X2, Y2: integer);
begin
  Canvas.MoveTo(X1,Y1);
  Canvas.LineTo(X2,Y2);
end;

{************************ Draw Disabled Text **************
 ***** This function draws text in "disabled" style.  *****
 ***** i.e. the text is grayed .                      *****
 **********************************************************}
function DrawDisabledText (Canvas : tCanvas; Str: PChar; Count: Integer;
                           var Rect: TRect;  Format: Word): Integer;
begin
  SetBkMode(Canvas.Handle, TRANSPARENT);

  OffsetRect(Rect, 1, 1);
  Canvas.Font.color:= ClbtnHighlight;
  DrawText (Canvas.Handle, Str, Count, Rect,Format);

  Canvas.Font.Color:= ClbtnShadow;
  OffsetRect(Rect, -1, -1);
  Result := DrawText (Canvas.Handle, Str, Count, Rect, Format);
end;

{************************ InitBitmap **********************
 ***** internal use....                               *****
 **********************************************************}
procedure InitBitmap (Bitmap : TBitmap);
begin
  Step := LongInt(Bitmap.ScanLine[0])-LongInt(Bitmap.ScanLine[1]);
  FirstScanLine := Bitmap.ScanLine[0];
  MaxX := Bitmap.Width;
  MaxY := Bitmap.Height;
end;

{************************* IsBlackR ***********************
 ***** internal use....                               *****
 **********************************************************}
function IsBlackR (R : TRect) : boolean;
var
  i : integer;
  a, b, c : integer;
begin
  Result := True;
  b := r.Bottom*Step;
  for i := r.Right downto r.Left do
  begin
    a := (i shr 3);
    c := a+LongInt (FirstScanLine);
    a := ((PByte(c-b)^ shl (i-(a shl 3))) and $80);
    if a>0 then
    begin
      Result := False;
      exit;
    end;
  end;
  a := (r.Right shr 3);
  b := r.Right-(a shl 3);
  a := a+LongInt (FirstScanLine);
  for i := r.Bottom downto r.Top do
  begin
    c := ((PByte(a-(i*Step))^ shl b) and $80);
    if c>0 then
    begin
      Result := False;
      exit;
    end;
  end;
end;

{************************ GetRectBRLR *********************
 ***** internal use....                               *****
 **********************************************************}
function GetRectBRLR (r : TRect) : TRect;
var
  i, j : integer;
  x : boolean;
  r1 : TRect;
  a, b, c : integer;
begin
  Result.Left := -1;
  x := false;
  for i := r.Left to MaxX-1 do
  begin
    a := (i shr 3);
    b := i-(a shl 3);
    a := a+LongInt (FirstScanLine);
    for j := 0 to MaxY-1 do
    begin
      c := ((PByte(a-(j*Step))^ shl b) and $80);
      if c=0 then
      begin
        x := True;
        Result.Left := i;
        Result.Top := j;
        Result.Right := i;
        Result.Bottom := j;
        break;
      end;
    end;
    if x
      then break;
  end;
  if x then
  begin
    while IsBlackR (Result) and (Result.Right<MaxX) and (Result.Bottom<MaxY) do
    begin
      Result.Right := Result.Right+1;
      Result.Bottom := Result.Bottom+1;
    end;
    r1 := Result;
    r1.Right := r1.Right-1;
    r1.Bottom := r1.Bottom-1;
    while IsBlackR(R1) and (R1.Right<MaxX) do
      R1.Right := R1.Right+1;
    Result.Right := r1.Right;
    R1.Right := R1.Right-1;
    while IsBlackR(R1) and (R1.Bottom<MaxY) do
      R1.Bottom := R1.Bottom+1;
    Result.Bottom := r1.Bottom;
  end
  else
    Result.Left := -1;
end;

{********************** GetListRrectsLR *******************
 ***** internal use....                               *****
 **********************************************************}
function GetListRrectsLR (Bmp : TBitmap; BackColor : TColor) : TList;
var
  r : TRect;
  pr : PRect;
  fBitmap : TBitmap;
begin
  Result := TList.Create;
  fBitmap := TBitmap.Create;
  fBitmap.Assign (Bmp);
  fBitmap.Mask (BackColor);
  fBitmap.Monochrome := True;
  fBitmap.PixelFormat := pf1bit;
  fBitmap.Canvas.Brush.Color := clWhite;
  InitBitmap (fBitmap);
  r.Left := 0;
  r.Top := 0;
  r := GetRectBRLR (r);
  while r.Left<>-1 do
  begin
    New(pr);
    pr^ := r;
    Result.Add (pr);
    fBitmap.Canvas.FillRect (r);
    r := GetRectBRLR (r);
  end;
  fBitmap.Free;
end;

{********************** GetRgnFromBmpLR *******************
 ***** internal use....                               *****
 **********************************************************}
function GetRgnFromBmpLR (Bmp : TBitmap; BackColor : TColor;
                          OffsetX, OffsetY : integer) : THandle;
var
  j : integer;
  pr : PRect;
  pdr : PRGNDATA;
  Rects : TList;
begin
  Rects := GetListRrectsLR(Bmp, BackColor);
  GetMem (pdr, SizeOf(TRgnDATA)+(Rects.Count*SizeOf(TRect)));
  pdr^.rdh.dwSize := SizeOf(TRgnData);
  pdr^.rdh.iType := RDH_RECTANGLES;
  pdr^.rdh.nCount := Rects.Count;
  pdr^.rdh.nRgnSize := SizeOf(TRect);
  pdr^.rdh.rcBound.Left := 0;
  pdr^.rdh.rcBound.Top := 0;
  pdr^.rdh.rcBound.Right := Bmp.Width;
  pdr^.rdh.rcBound.Bottom := Bmp.Height;
  pr := @pdr^.Buffer;
  for j:=0 to Rects.Count-1 do
  begin
    pr^ := PRect(Rects.Items[j])^;
    pr^.Left := pr^.Left+OffsetX;
    pr^.Right := pr^.Right+OffsetX;
    pr^.Top := pr^.Top+OffsetY;
    pr^.Bottom := pr^.Bottom+OffsetY;
    inc(pr);
  end;
  Result := ExtCreateRegion(nil, SizeOf(TRgnDATA)+(Rects.Count*SizeOf(TRect)), pdr^);
  FreeMem (pdr,SizeOf(TRgnDATA)+(Rects.Count*SizeOf(TRect)));
  while Rects.Count>0 do
  begin
    FreeMem (Rects.First, SizeOf(TRect));
    Rects.Delete(0);
  end;
  Rects.Free;
end;

{********************** ExtGenerateMask *******************
 ***** internal use....                               *****
 **********************************************************}
function ExtGenerateMask (BitMap: TBitmap; transparentcolor: TColor) : hRgn;
var
  x,y          : integer;
  rgn1, rgn2   : hrgn;
  startx, endx : integer;
begin
  // for every line do...
  rgn1 := 0;
  rgn2 := 0;
  for y := 0 to BitMap.Height-1 do
  begin
    // don`t look as if we were locked up
//    Application.ProcessMessages;
    x:=0;
    endx:=x;
    repeat
      // look for the beginning of a stretch of non-transparent pixels
      while (bitmap.canvas.pixels[x,y] = transparentcolor) and (x = BitMap.width) do
      inc(x);
      startx:=x;
      // look for the end of a stretch of non-transparent pixels
      inc(x);
      while (bitmap.canvas.pixels[x,y]<>transparentcolor) and (x<=BitMap.width) do
      inc(x);
      endx:=x;
      // do we have some pixels?
      if startx<>BitMap.Width then
      begin
        if endx= BitMap.Width then dec(endx);
        // do we have a region already?
        if rgn1 = 0 then
        begin
          // Create a region to start with
          rgn1 := createrectrgn(startx+1,y,endx,y+1);
        end else
        begin
          // Add to the existing region
          rgn2 := createrectrgn(startx+1,y,endx,y+1);
          if rgn2<>0 then combinergn(rgn1,rgn1,rgn2,RGN_OR);
          deleteobject(rgn2);
        end;
      end;
    until x>=BitMap.width-1;
  end;
  Result := rgn1;
end;
{***********************************}

{**************** Create Region From Bitmap ***************
 ***** This function creates a region,                *****
 ***** using a bitmap as mask.                        *****
 **********************************************************}
function CreateRgnFromBmp (aBitmap : tBitmap; TransparentColor : tColor) : hRgn;
begin
  Result := GetRgnFromBmpLR(aBitmap,TransparentColor,0,0);
//  Result := ExtGenerateMask (aBitMap, TransparentColor);
end;

end.
